/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.widget.list;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public abstract class AbstractList<E extends AbstractListEntry<E>>
extends FocusableGui
implements IRenderable {
    protected static final int DRAG_OUTSIDE = -2;
    protected final Minecraft minecraft;
    protected final int itemHeight;
    private final List<E> children = new SimpleArrayList();
    protected int width;
    protected int height;
    protected int y0;
    protected int y1;
    protected int x1;
    protected int x0;
    protected boolean centerListVertically = true;
    protected int yDrag = -2;
    private double scrollAmount;
    protected boolean renderSelection = true;
    protected boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;
    private E selected;

    public AbstractList(Minecraft minecraft, int n, int n2, int n3, int n4, int n5) {
        this.minecraft = minecraft;
        this.width = n;
        this.height = n2;
        this.y0 = n3;
        this.y1 = n4;
        this.itemHeight = n5;
        this.x0 = 0;
        this.x1 = n;
    }

    public void setRenderSelection(boolean bl) {
        this.renderSelection = bl;
    }

    protected void setRenderHeader(boolean bl, int n) {
        this.renderHeader = bl;
        this.headerHeight = n;
        if (!bl) {
            this.headerHeight = 0;
        }
    }

    public int getRowWidth() {
        return 220;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E e) {
        this.selected = e;
    }

    @Nullable
    public E getFocused() {
        return (E)((AbstractListEntry)super.getFocused());
    }

    public final List<E> children() {
        return this.children;
    }

    protected final void clearEntries() {
        this.children.clear();
    }

    protected void replaceEntries(Collection<E> collection) {
        this.children.clear();
        this.children.addAll(collection);
    }

    protected E getEntry(int n) {
        return (E)((AbstractListEntry)this.children().get(n));
    }

    protected int addEntry(E e) {
        this.children.add(e);
        return this.children.size() - 1;
    }

    protected int getItemCount() {
        return this.children().size();
    }

    protected boolean isSelectedItem(int n) {
        return Objects.equals(this.getSelected(), this.children().get(n));
    }

    @Nullable
    protected final E getEntryAtPosition(double d, double d2) {
        int n = this.getRowWidth() / 2;
        \u2603 = this.x0 + this.width / 2;
        \u2603 = \u2603 - n;
        \u2603 = \u2603 + n;
        \u2603 = MathHelper.func_76128_c(d2 - (double)this.y0) - this.headerHeight + (int)this.getScrollAmount() - 4;
        \u2603 = \u2603 / this.itemHeight;
        if (d < (double)this.getScrollbarPosition() && d >= (double)\u2603 && d <= (double)\u2603 && \u2603 >= 0 && \u2603 >= 0 && \u2603 < this.getItemCount()) {
            return (E)((AbstractListEntry)this.children().get(\u2603));
        }
        return null;
    }

    public void updateSize(int n, int n2, int n3, int n4) {
        this.width = n;
        this.height = n2;
        this.y0 = n3;
        this.y1 = n4;
        this.x0 = 0;
        this.x1 = n;
    }

    public void setLeftPos(int n) {
        this.x0 = n;
        this.x1 = n + this.width;
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected void clickedHeader(int n, int n2) {
    }

    protected void renderHeader(int n, int n2, Tessellator tessellator) {
    }

    protected void renderBackground() {
    }

    protected void renderDecorations(int n, int n2) {
    }

    @Override
    public void render(int n, int n2, float f) {
        this.renderBackground();
        int n3 = this.getScrollbarPosition();
        \u2603 = n3 + 6;
        GlStateManager.disableLighting();
        GlStateManager.disableFog();
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(AbstractGui.BACKGROUND_LOCATION);
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        float \u26034 = 32.0f;
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        \u26033.func_181662_b(this.x0, this.y1, 0.0).func_187315_a((float)this.x0 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).func_181669_b(32, 32, 32, 255).func_181675_d();
        \u26033.func_181662_b(this.x1, this.y1, 0.0).func_187315_a((float)this.x1 / 32.0f, (float)(this.y1 + (int)this.getScrollAmount()) / 32.0f).func_181669_b(32, 32, 32, 255).func_181675_d();
        \u26033.func_181662_b(this.x1, this.y0, 0.0).func_187315_a((float)this.x1 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).func_181669_b(32, 32, 32, 255).func_181675_d();
        \u26033.func_181662_b(this.x0, this.y0, 0.0).func_187315_a((float)this.x0 / 32.0f, (float)(this.y0 + (int)this.getScrollAmount()) / 32.0f).func_181669_b(32, 32, 32, 255).func_181675_d();
        \u26032.func_78381_a();
        \u2603 = this.getRowLeft();
        \u2603 = this.y0 + 4 - (int)this.getScrollAmount();
        if (this.renderHeader) {
            this.renderHeader(\u2603, \u2603, \u26032);
        }
        this.renderList(\u2603, \u2603, n, n2, f);
        GlStateManager.disableDepthTest();
        this.renderHoleBackground(0, this.y0, 255, 255);
        this.renderHoleBackground(this.y1, this.height, 255, 255);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
        GlStateManager.disableAlphaTest();
        GlStateManager.shadeModel(7425);
        GlStateManager.disableTexture();
        \u2603 = 4;
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        \u26033.func_181662_b(this.x0, this.y0 + 4, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        \u26033.func_181662_b(this.x1, this.y0 + 4, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        \u26033.func_181662_b(this.x1, this.y0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        \u26033.func_181662_b(this.x0, this.y0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        \u26032.func_78381_a();
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        \u26033.func_181662_b(this.x0, this.y1, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        \u26033.func_181662_b(this.x1, this.y1, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        \u26033.func_181662_b(this.x1, this.y1 - 4, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        \u26033.func_181662_b(this.x0, this.y1 - 4, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 0).func_181675_d();
        \u26032.func_78381_a();
        \u2603 = this.getMaxScroll();
        if (\u2603 > 0) {
            \u2603 = (int)((float)((this.y1 - this.y0) * (this.y1 - this.y0)) / (float)this.getMaxPosition());
            \u2603 = MathHelper.func_76125_a(\u2603, 32, this.y1 - this.y0 - 8);
            \u2603 = (int)this.getScrollAmount() * (this.y1 - this.y0 - \u2603) / \u2603 + this.y0;
            if (\u2603 < this.y0) {
                \u2603 = this.y0;
            }
            \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            \u26033.func_181662_b(n3, this.y1, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            \u26033.func_181662_b(\u2603, this.y1, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            \u26033.func_181662_b(\u2603, this.y0, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            \u26033.func_181662_b(n3, this.y0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            \u26032.func_78381_a();
            \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            \u26033.func_181662_b(n3, \u2603 + \u2603, 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            \u26033.func_181662_b(\u2603, \u2603 + \u2603, 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            \u26033.func_181662_b(\u2603, \u2603, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            \u26033.func_181662_b(n3, \u2603, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            \u26032.func_78381_a();
            \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            \u26033.func_181662_b(n3, \u2603 + \u2603 - 1, 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            \u26033.func_181662_b(\u2603 - 1, \u2603 + \u2603 - 1, 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            \u26033.func_181662_b(\u2603 - 1, \u2603, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            \u26033.func_181662_b(n3, \u2603, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            \u26032.func_78381_a();
        }
        this.renderDecorations(n, n2);
        GlStateManager.enableTexture();
        GlStateManager.shadeModel(7424);
        GlStateManager.enableAlphaTest();
        GlStateManager.disableBlend();
    }

    protected void centerScrollOn(E e) {
        this.setScrollAmount(this.children().indexOf(e) * this.itemHeight + this.itemHeight / 2 - (this.y1 - this.y0) / 2);
    }

    protected void ensureVisible(E e) {
        int n = this.getRowTop(this.children().indexOf(e));
        \u2603 = n - this.y0 - 4 - this.itemHeight;
        if (\u2603 < 0) {
            this.scroll(\u2603);
        }
        if ((\u2603 = this.y1 - n - this.itemHeight - this.itemHeight) < 0) {
            this.scroll(-\u2603);
        }
    }

    private void scroll(int n) {
        this.setScrollAmount(this.getScrollAmount() + (double)n);
        this.yDrag = -2;
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double d) {
        this.scrollAmount = MathHelper.func_151237_a(d, 0.0, this.getMaxScroll());
    }

    private int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScrollAmount() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double d, double d2, int n) {
        this.scrolling = n == 0 && d >= (double)this.getScrollbarPosition() && d < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        this.updateScrollingState(d, d2, n);
        if (!this.isMouseOver(d, d2)) {
            return false;
        }
        E e = this.getEntryAtPosition(d, d2);
        if (e != null) {
            if (e.mouseClicked(d, d2, n)) {
                this.setFocused((IGuiEventListener)e);
                this.setDragging(true);
                return true;
            }
        } else if (n == 0) {
            this.clickedHeader((int)(d - (double)(this.x0 + this.width / 2 - this.getRowWidth() / 2)), (int)(d2 - (double)this.y0) + (int)this.getScrollAmount() - 4);
            return true;
        }
        return this.scrolling;
    }

    @Override
    public boolean mouseReleased(double d, double d2, int n) {
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(d, d2, n);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double d, double d2, int n, double d3, double d4) {
        if (super.mouseDragged(d, d2, n, d3, d4)) {
            return true;
        }
        if (n != 0 || !this.scrolling) {
            return false;
        }
        if (d2 < (double)this.y0) {
            this.setScrollAmount(0.0);
        } else if (d2 > (double)this.y1) {
            this.setScrollAmount(this.getMaxScroll());
        } else {
            \u2603 = Math.max(1, this.getMaxScroll());
            int n2 = this.y1 - this.y0;
            \u2603 = MathHelper.func_76125_a((int)((float)(n2 * n2) / (float)this.getMaxPosition()), 32, n2 - 8);
            double \u26032 = Math.max(1.0, \u2603 / (double)(n2 - \u2603));
            this.setScrollAmount(this.getScrollAmount() + d4 * \u26032);
        }
        return true;
    }

    @Override
    public boolean mouseScrolled(double d, double d2, double d3) {
        this.setScrollAmount(this.getScrollAmount() - d3 * (double)this.itemHeight / 2.0);
        return true;
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (super.keyPressed(n, n2, n3)) {
            return true;
        }
        if (n == 264) {
            this.moveSelection(1);
            return true;
        }
        if (n == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int n) {
        if (!this.children().isEmpty()) {
            \u2603 = this.children().indexOf(this.getSelected());
            \u2603 = MathHelper.func_76125_a(\u2603 + n, 0, this.getItemCount() - 1);
            AbstractListEntry abstractListEntry = (AbstractListEntry)this.children().get(\u2603);
            this.setSelected(abstractListEntry);
            this.ensureVisible(abstractListEntry);
        }
    }

    @Override
    public boolean isMouseOver(double d, double d2) {
        return d2 >= (double)this.y0 && d2 <= (double)this.y1 && d >= (double)this.x0 && d <= (double)this.x1;
    }

    protected void renderList(int n, int n2, int n3, int n4, float f) {
        int n5 = this.getItemCount();
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        for (\u2603 = 0; \u2603 < n5; ++\u2603) {
            \u2603 = this.getRowTop(\u2603);
            \u2603 = this.getRowBottom(\u2603);
            if (\u2603 < this.y0 || \u2603 > this.y1) continue;
            \u2603 = n2 + \u2603 * this.itemHeight + this.headerHeight;
            \u2603 = this.itemHeight - 4;
            E e = this.getEntry(\u2603);
            int \u26034 = this.getRowWidth();
            if (this.renderSelection && this.isSelectedItem(\u2603)) {
                int n6 = this.x0 + this.width / 2 - \u26034 / 2;
                \u2603 = this.x0 + this.width / 2 + \u26034 / 2;
                GlStateManager.disableTexture();
                float \u26035 = this.isFocused() ? 1.0f : 0.5f;
                GlStateManager.color4f(\u26035, \u26035, \u26035, 1.0f);
                \u26033.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                \u26033.func_181662_b(n6, \u2603 + \u2603 + 2, 0.0).func_181675_d();
                \u26033.func_181662_b(\u2603, \u2603 + \u2603 + 2, 0.0).func_181675_d();
                \u26033.func_181662_b(\u2603, \u2603 - 2, 0.0).func_181675_d();
                \u26033.func_181662_b(n6, \u2603 - 2, 0.0).func_181675_d();
                \u26032.func_78381_a();
                GlStateManager.color4f(0.0f, 0.0f, 0.0f, 1.0f);
                \u26033.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                \u26033.func_181662_b(n6 + 1, \u2603 + \u2603 + 1, 0.0).func_181675_d();
                \u26033.func_181662_b(\u2603 - 1, \u2603 + \u2603 + 1, 0.0).func_181675_d();
                \u26033.func_181662_b(\u2603 - 1, \u2603 - 1, 0.0).func_181675_d();
                \u26033.func_181662_b(n6 + 1, \u2603 - 1, 0.0).func_181675_d();
                \u26032.func_78381_a();
                GlStateManager.enableTexture();
            }
            n6 = this.getRowLeft();
            ((AbstractListEntry)e).render(\u2603, \u2603, n6, \u26034, \u2603, n3, n4, this.isMouseOver(n3, n4) && Objects.equals(this.getEntryAtPosition(n3, n4), e), f);
        }
    }

    protected int getRowLeft() {
        return this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    protected int getRowTop(int n) {
        return this.y0 + 4 - (int)this.getScrollAmount() + n * this.itemHeight + this.headerHeight;
    }

    private int getRowBottom(int n) {
        return this.getRowTop(n) + this.itemHeight;
    }

    protected boolean isFocused() {
        return false;
    }

    protected void renderHoleBackground(int n, int n2, int n3, int n4) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        this.minecraft.func_110434_K().func_110577_a(AbstractGui.BACKGROUND_LOCATION);
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        float \u26033 = 32.0f;
        \u26032.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        \u26032.func_181662_b(this.x0, n2, 0.0).func_187315_a(0.0, (float)n2 / 32.0f).func_181669_b(64, 64, 64, n4).func_181675_d();
        \u26032.func_181662_b(this.x0 + this.width, n2, 0.0).func_187315_a((float)this.width / 32.0f, (float)n2 / 32.0f).func_181669_b(64, 64, 64, n4).func_181675_d();
        \u26032.func_181662_b(this.x0 + this.width, n, 0.0).func_187315_a((float)this.width / 32.0f, (float)n / 32.0f).func_181669_b(64, 64, 64, n3).func_181675_d();
        \u26032.func_181662_b(this.x0, n, 0.0).func_187315_a(0.0, (float)n / 32.0f).func_181669_b(64, 64, 64, n3).func_181675_d();
        tessellator.func_78381_a();
    }

    protected E remove(int n) {
        AbstractListEntry abstractListEntry = (AbstractListEntry)this.children.get(n);
        if (this.removeEntry((AbstractListEntry)this.children.get(n))) {
            return (E)abstractListEntry;
        }
        return null;
    }

    protected boolean removeEntry(E e) {
        boolean bl = this.children.remove(e);
        if (bl && e == this.getSelected()) {
            this.setSelected(null);
        }
        return bl;
    }

    class SimpleArrayList
    extends java.util.AbstractList<E> {
        private final List<E> field_216871_b = Lists.newArrayList();

        private SimpleArrayList() {
        }

        @Override
        public E get(int n) {
            return (AbstractListEntry)this.field_216871_b.get(n);
        }

        @Override
        public int size() {
            return this.field_216871_b.size();
        }

        @Override
        public E set(int n, E e) {
            AbstractListEntry abstractListEntry = (AbstractListEntry)this.field_216871_b.set(n, e);
            ((AbstractListEntry)e).list = AbstractList.this;
            return abstractListEntry;
        }

        @Override
        public void add(int n, E e) {
            this.field_216871_b.add(n, e);
            ((AbstractListEntry)e).list = AbstractList.this;
        }

        @Override
        public E remove(int n) {
            return (AbstractListEntry)this.field_216871_b.remove(n);
        }

        @Override
        public /* synthetic */ Object remove(int n) {
            return this.remove(n);
        }

        @Override
        public /* synthetic */ void add(int n, Object object) {
            this.add(n, (E)((AbstractListEntry)object));
        }

        @Override
        public /* synthetic */ Object set(int n, Object object) {
            return this.set(n, (E)((AbstractListEntry)object));
        }

        @Override
        public /* synthetic */ Object get(int n) {
            return this.get(n);
        }
    }

    public static abstract class AbstractListEntry<E extends AbstractListEntry<E>>
    implements IGuiEventListener {
        @Deprecated
        AbstractList<E> list;

        public abstract void render(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        @Override
        public boolean isMouseOver(double d, double d2) {
            return Objects.equals(this.list.getEntryAtPosition(d, d2), this);
        }
    }
}

