/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.lighting.WorldLightManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientChunkProvider
extends AbstractChunkProvider {
    private static final Logger field_147436_a = LogManager.getLogger();
    private final Chunk field_73238_a;
    private final WorldLightManager field_217255_c;
    private volatile ChunkArray field_217256_d;
    private final ClientWorld field_73235_d;

    public ClientChunkProvider(ClientWorld clientWorld, int n) {
        this.field_73235_d = clientWorld;
        this.field_73238_a = new EmptyChunk((World)clientWorld, new ChunkPos(0, 0));
        this.field_217255_c = new WorldLightManager(this, true, clientWorld.func_201675_m().func_191066_m());
        this.field_217256_d = new ChunkArray(ClientChunkProvider.func_217254_b(n));
    }

    @Override
    public WorldLightManager func_212863_j_() {
        return this.field_217255_c;
    }

    private static boolean func_217249_a(@Nullable Chunk chunk, int n, int n2) {
        if (chunk == null) {
            return false;
        }
        ChunkPos chunkPos = chunk.func_76632_l();
        return chunkPos.field_77276_a == n && chunkPos.field_77275_b == n2;
    }

    public void func_73234_b(int n, int n2) {
        if (!this.field_217256_d.func_217183_b(n, n2)) {
            return;
        }
        \u2603 = this.field_217256_d.func_217191_a(n, n2);
        Chunk chunk = this.field_217256_d.func_217192_a(\u2603);
        if (ClientChunkProvider.func_217249_a(chunk, n, n2)) {
            this.field_217256_d.func_217190_a(\u2603, chunk, null);
        }
    }

    @Override
    @Nullable
    public Chunk func_212849_a_(int n, int n2, ChunkStatus chunkStatus, boolean bl) {
        if (this.field_217256_d.func_217183_b(n, n2) && ClientChunkProvider.func_217249_a(\u2603 = this.field_217256_d.func_217192_a(this.field_217256_d.func_217191_a(n, n2)), n, n2)) {
            return \u2603;
        }
        if (bl) {
            return this.field_73238_a;
        }
        return null;
    }

    @Override
    public IBlockReader func_212864_k_() {
        return this.field_73235_d;
    }

    @Nullable
    public Chunk func_217250_a(World world, int n, int n2, PacketBuffer packetBuffer, CompoundNBT compoundNBT, int n3, boolean bl) {
        if (!this.field_217256_d.func_217183_b(n, n2)) {
            field_147436_a.warn("Ignoring chunk since it's not in the view range: {}, {}", (Object)n, (Object)n2);
            return null;
        }
        int n4 = this.field_217256_d.func_217191_a(n, n2);
        Chunk \u26032 = (Chunk)this.field_217256_d.field_217195_b.get(n4);
        if (!ClientChunkProvider.func_217249_a(\u26032, n, n2)) {
            if (!bl) {
                field_147436_a.warn("Ignoring chunk since we don't have complete data: {}, {}", (Object)n, (Object)n2);
                return null;
            }
            \u26032 = new Chunk(world, new ChunkPos(n, n2), new Biome[256]);
            \u26032.func_217326_a(packetBuffer, compoundNBT, n3, bl);
            this.field_217256_d.func_217181_a(n4, \u26032);
        } else {
            \u26032.func_217326_a(packetBuffer, compoundNBT, n3, bl);
        }
        ChunkSection[] \u26033 = \u26032.func_76587_i();
        WorldLightManager \u26034 = this.func_212863_j_();
        \u26034.func_215571_a(new ChunkPos(n, n2), true);
        for (\u2603 = 0; \u2603 < \u26033.length; ++\u2603) {
            ChunkSection chunkSection = \u26033[\u2603];
            \u26034.func_215566_a(SectionPos.func_218154_a(n, \u2603, n2), ChunkSection.func_222628_a(chunkSection));
        }
        return \u26032;
    }

    @Override
    public void func_217207_a(BooleanSupplier booleanSupplier) {
    }

    public void func_217251_d(int n, int n2) {
        this.field_217256_d.field_217198_e = n;
        this.field_217256_d.field_217199_f = n2;
    }

    public void func_217248_a(int n) {
        \u2603 = this.field_217256_d.field_217196_c;
        if (\u2603 != (\u2603 = ClientChunkProvider.func_217254_b(n))) {
            ChunkArray chunkArray = new ChunkArray(\u2603);
            chunkArray.field_217198_e = this.field_217256_d.field_217198_e;
            chunkArray.field_217199_f = this.field_217256_d.field_217199_f;
            for (int i = 0; i < this.field_217256_d.field_217195_b.length(); ++i) {
                Chunk chunk = (Chunk)this.field_217256_d.field_217195_b.get(i);
                if (chunk == null) continue;
                ChunkPos \u26032 = chunk.func_76632_l();
                if (!chunkArray.func_217183_b(\u26032.field_77276_a, \u26032.field_77275_b)) continue;
                chunkArray.func_217181_a(chunkArray.func_217191_a(\u26032.field_77276_a, \u26032.field_77275_b), chunk);
            }
            this.field_217256_d = chunkArray;
        }
    }

    private static int func_217254_b(int n) {
        return Math.max(2, n) + 3;
    }

    @Override
    public String func_73148_d() {
        return "Client Chunk Cache: " + this.field_217256_d.field_217195_b.length() + ", " + this.func_217252_g();
    }

    @Override
    public ChunkGenerator<?> func_201711_g() {
        return null;
    }

    public int func_217252_g() {
        return this.field_217256_d.field_217200_g;
    }

    @Override
    public void func_217201_a(LightType lightType, SectionPos sectionPos) {
        Minecraft.func_71410_x().field_71438_f.func_215328_b(sectionPos.func_218149_a(), sectionPos.func_218163_b(), sectionPos.func_218148_c());
    }

    @Override
    public boolean func_222866_a(BlockPos blockPos) {
        return this.func_73149_a(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
    }

    @Override
    public boolean func_222865_a(ChunkPos chunkPos) {
        return this.func_73149_a(chunkPos.field_77276_a, chunkPos.field_77275_b);
    }

    @Override
    public boolean func_217204_a(Entity entity) {
        return this.func_73149_a(MathHelper.func_76128_c(entity.field_70165_t) >> 4, MathHelper.func_76128_c(entity.field_70161_v) >> 4);
    }

    @Override
    @Nullable
    public /* synthetic */ IChunk func_212849_a_(int n, int n2, ChunkStatus chunkStatus, boolean bl) {
        return this.func_212849_a_(n, n2, chunkStatus, bl);
    }

    final class ChunkArray {
        private final AtomicReferenceArray<Chunk> field_217195_b;
        private final int field_217196_c;
        private final int field_217197_d;
        private volatile int field_217198_e;
        private volatile int field_217199_f;
        private int field_217200_g;

        private ChunkArray(int n) {
            this.field_217196_c = n;
            this.field_217197_d = n * 2 + 1;
            this.field_217195_b = new AtomicReferenceArray(this.field_217197_d * this.field_217197_d);
        }

        private int func_217191_a(int n, int n2) {
            return Math.floorMod(n2, this.field_217197_d) * this.field_217197_d + Math.floorMod(n, this.field_217197_d);
        }

        protected void func_217181_a(int n, @Nullable Chunk chunk) {
            \u2603 = this.field_217195_b.getAndSet(n, chunk);
            if (\u2603 != null) {
                --this.field_217200_g;
                ClientChunkProvider.this.field_73235_d.func_217409_a(\u2603);
            }
            if (chunk != null) {
                ++this.field_217200_g;
            }
        }

        protected Chunk func_217190_a(int n, Chunk chunk, @Nullable Chunk chunk2) {
            if (this.field_217195_b.compareAndSet(n, chunk, chunk2) && chunk2 == null) {
                --this.field_217200_g;
            }
            ClientChunkProvider.this.field_73235_d.func_217409_a(chunk);
            return chunk;
        }

        private boolean func_217183_b(int n, int n2) {
            return Math.abs(n - this.field_217198_e) <= this.field_217196_c && Math.abs(n2 - this.field_217199_f) <= this.field_217196_c;
        }

        @Nullable
        protected Chunk func_217192_a(int n) {
            return this.field_217195_b.get(n);
        }
    }
}

