/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.network;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.multiplayer.ServerAddress;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.status.IClientStatusNetHandler;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.handshake.client.CHandshakePacket;
import net.minecraft.network.status.client.CPingPacket;
import net.minecraft.network.status.client.CServerQueryPacket;
import net.minecraft.network.status.server.SPongPacket;
import net.minecraft.network.status.server.SServerInfoPacket;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPinger {
    private static final Splitter field_147230_a = Splitter.on((char)'\u0000').limit(6);
    private static final Logger field_147228_b = LogManager.getLogger();
    private final List<NetworkManager> field_147229_c = Collections.synchronizedList(Lists.newArrayList());

    public void func_147224_a(final ServerData serverData) throws UnknownHostException {
        ServerAddress serverAddress = ServerAddress.func_78860_a(serverData.field_78845_b);
        final NetworkManager \u26032 = NetworkManager.func_181124_a(InetAddress.getByName(serverAddress.func_78861_a()), serverAddress.func_78864_b(), false);
        this.field_147229_c.add(\u26032);
        serverData.field_78843_d = I18n.func_135052_a("multiplayer.status.pinging", new Object[0]);
        serverData.field_78844_e = -1L;
        serverData.field_147412_i = null;
        \u26032.func_150719_a(new IClientStatusNetHandler(){
            private boolean field_147403_d;
            private boolean field_183009_e;
            private long field_175092_e;

            @Override
            public void func_147397_a(SServerInfoPacket sServerInfoPacket) {
                CharSequence charSequence;
                if (this.field_183009_e) {
                    \u26032.func_150718_a(new TranslationTextComponent("multiplayer.status.unrequested", new Object[0]));
                    return;
                }
                this.field_183009_e = true;
                ServerStatusResponse serverStatusResponse = sServerInfoPacket.func_149294_c();
                serverData.field_78843_d = serverStatusResponse.func_151317_a() != null ? serverStatusResponse.func_151317_a().func_150254_d() : "";
                if (serverStatusResponse.func_151322_c() != null) {
                    serverData.field_82822_g = serverStatusResponse.func_151322_c().func_151303_a();
                    serverData.field_82821_f = serverStatusResponse.func_151322_c().func_151304_b();
                } else {
                    serverData.field_82822_g = I18n.func_135052_a("multiplayer.status.old", new Object[0]);
                    serverData.field_82821_f = 0;
                }
                if (serverStatusResponse.func_151318_b() != null) {
                    serverData.field_78846_c = (Object)((Object)TextFormatting.GRAY) + "" + serverStatusResponse.func_151318_b().func_151333_b() + "" + (Object)((Object)TextFormatting.DARK_GRAY) + "/" + (Object)((Object)TextFormatting.GRAY) + serverStatusResponse.func_151318_b().func_151332_a();
                    if (ArrayUtils.isNotEmpty((Object[])serverStatusResponse.func_151318_b().func_151331_c())) {
                        charSequence = new StringBuilder();
                        for (GameProfile gameProfile : serverStatusResponse.func_151318_b().func_151331_c()) {
                            if (((StringBuilder)charSequence).length() > 0) {
                                ((StringBuilder)charSequence).append("\n");
                            }
                            ((StringBuilder)charSequence).append(gameProfile.getName());
                        }
                        if (serverStatusResponse.func_151318_b().func_151331_c().length < serverStatusResponse.func_151318_b().func_151333_b()) {
                            if (((StringBuilder)charSequence).length() > 0) {
                                ((StringBuilder)charSequence).append("\n");
                            }
                            ((StringBuilder)charSequence).append(I18n.func_135052_a("multiplayer.status.and_more", serverStatusResponse.func_151318_b().func_151333_b() - serverStatusResponse.func_151318_b().func_151331_c().length));
                        }
                        serverData.field_147412_i = ((StringBuilder)charSequence).toString();
                    }
                } else {
                    serverData.field_78846_c = (Object)((Object)TextFormatting.DARK_GRAY) + I18n.func_135052_a("multiplayer.status.unknown", new Object[0]);
                }
                if (serverStatusResponse.func_151316_d() != null) {
                    charSequence = serverStatusResponse.func_151316_d();
                    if (((String)charSequence).startsWith("data:image/png;base64,")) {
                        serverData.func_147407_a(((String)charSequence).substring("data:image/png;base64,".length()));
                    } else {
                        field_147228_b.error("Invalid server icon (unknown format)");
                    }
                } else {
                    serverData.func_147407_a(null);
                }
                this.field_175092_e = Util.func_211177_b();
                \u26032.func_179290_a(new CPingPacket(this.field_175092_e));
                this.field_147403_d = true;
            }

            @Override
            public void func_147398_a(SPongPacket sPongPacket) {
                long l = this.field_175092_e;
                \u2603 = Util.func_211177_b();
                serverData.field_78844_e = \u2603 - l;
                \u26032.func_150718_a(new TranslationTextComponent("multiplayer.status.finished", new Object[0]));
            }

            @Override
            public void func_147231_a(ITextComponent iTextComponent) {
                if (!this.field_147403_d) {
                    field_147228_b.error("Can't ping {}: {}", (Object)serverData.field_78845_b, (Object)iTextComponent.getString());
                    serverData.field_78843_d = (Object)((Object)TextFormatting.DARK_RED) + I18n.func_135052_a("multiplayer.status.cannot_connect", new Object[0]);
                    serverData.field_78846_c = "";
                    ServerPinger.this.func_147225_b(serverData);
                }
            }

            @Override
            public NetworkManager func_147298_b() {
                return \u26032;
            }
        });
        try {
            \u26032.func_179290_a(new CHandshakePacket(serverAddress.func_78861_a(), serverAddress.func_78864_b(), ProtocolType.STATUS));
            \u26032.func_179290_a(new CServerQueryPacket());
        }
        catch (Throwable \u26033) {
            field_147228_b.error((Object)\u26033);
        }
    }

    private void func_147225_b(final ServerData serverData) {
        final ServerAddress serverAddress = ServerAddress.func_78860_a(serverData.field_78845_b);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)NetworkManager.field_179295_d.func_179281_c())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                channel.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
                        super.channelActive(channelHandlerContext);
                        ByteBuf byteBuf = Unpooled.buffer();
                        try {
                            byteBuf.writeByte(254);
                            byteBuf.writeByte(1);
                            byteBuf.writeByte(250);
                            char[] \u26032 = "MC|PingHost".toCharArray();
                            byteBuf.writeShort(\u26032.length);
                            for (char c : \u26032) {
                                byteBuf.writeChar((int)c);
                            }
                            byteBuf.writeShort(7 + 2 * serverAddress.func_78861_a().length());
                            byteBuf.writeByte(127);
                            \u26032 = serverAddress.func_78861_a().toCharArray();
                            byteBuf.writeShort(\u26032.length);
                            for (char c : \u26032) {
                                byteBuf.writeChar((int)c);
                            }
                            byteBuf.writeInt(serverAddress.func_78864_b());
                            channelHandlerContext.channel().writeAndFlush((Object)byteBuf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                        }
                        finally {
                            byteBuf.release();
                        }
                    }

                    protected void channelRead0(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Exception {
                        short s = byteBuf.readUnsignedByte();
                        if (s == 255) {
                            String string = new String(byteBuf.readBytes(byteBuf.readShort() * 2).array(), StandardCharsets.UTF_16BE);
                            String[] \u26032 = (String[])Iterables.toArray((Iterable)field_147230_a.split((CharSequence)string), String.class);
                            if ("\u00a71".equals(\u26032[0])) {
                                int n = MathHelper.func_82715_a(\u26032[1], 0);
                                String \u26033 = \u26032[2];
                                String \u26034 = \u26032[3];
                                \u2603 = MathHelper.func_82715_a(\u26032[4], -1);
                                \u2603 = MathHelper.func_82715_a(\u26032[5], -1);
                                serverData.field_82821_f = -1;
                                serverData.field_82822_g = \u26033;
                                serverData.field_78843_d = \u26034;
                                serverData.field_78846_c = (Object)((Object)TextFormatting.GRAY) + "" + \u2603 + "" + (Object)((Object)TextFormatting.DARK_GRAY) + "/" + (Object)((Object)TextFormatting.GRAY) + \u2603;
                            }
                        }
                        channelHandlerContext.close();
                    }

                    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
                        channelHandlerContext.close();
                    }

                    protected /* synthetic */ void channelRead0(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
                        this.channelRead0(channelHandlerContext, (ByteBuf)object);
                    }
                }});
            }
        })).channel(NioSocketChannel.class)).connect(serverAddress.func_78861_a(), serverAddress.func_78864_b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_147223_a() {
        List<NetworkManager> list = this.field_147229_c;
        synchronized (list) {
            Iterator<NetworkManager> iterator = this.field_147229_c.iterator();
            while (iterator.hasNext()) {
                NetworkManager networkManager = iterator.next();
                if (networkManager.func_150724_d()) {
                    networkManager.func_74428_b();
                    continue;
                }
                iterator.remove();
                networkManager.func_179293_l();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_147226_b() {
        List<NetworkManager> list = this.field_147229_c;
        synchronized (list) {
            Iterator<NetworkManager> iterator = this.field_147229_c.iterator();
            while (iterator.hasNext()) {
                NetworkManager networkManager = iterator.next();
                if (!networkManager.func_150724_d()) continue;
                iterator.remove();
                networkManager.func_150718_a(new TranslationTextComponent("multiplayer.status.cancelled", new Object[0]));
            }
        }
    }
}

