/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IEnviromentBlockReader;

public class BlockModelRenderer {
    private final BlockColors field_187499_a;
    private static final ThreadLocal<Cache> field_210267_b = ThreadLocal.withInitial(() -> new Cache());

    public BlockModelRenderer(BlockColors blockColors) {
        this.field_187499_a = blockColors;
    }

    public boolean func_217631_a(IEnviromentBlockReader iEnviromentBlockReader, IBakedModel iBakedModel, BlockState blockState, BlockPos blockPos, BufferBuilder bufferBuilder, boolean bl, Random random, long l) {
        boolean bl2 = Minecraft.func_71379_u() && blockState.func_185906_d() == 0 && iBakedModel.func_177555_b();
        try {
            if (bl2) {
                return this.func_217634_b(iEnviromentBlockReader, iBakedModel, blockState, blockPos, bufferBuilder, bl, random, l);
            }
            return this.func_217635_c(iEnviromentBlockReader, iBakedModel, blockState, blockPos, bufferBuilder, bl, random, l);
        }
        catch (Throwable \u26032) {
            CrashReport crashReport = CrashReport.func_85055_a(\u26032, "Tesselating block model");
            CrashReportCategory \u26033 = crashReport.func_85058_a("Block model being tesselated");
            CrashReportCategory.func_175750_a(\u26033, blockPos, blockState);
            \u26033.func_71507_a("Using AO", bl2);
            throw new ReportedException(crashReport);
        }
    }

    public boolean func_217634_b(IEnviromentBlockReader iEnviromentBlockReader, IBakedModel iBakedModel, BlockState blockState, BlockPos blockPos, BufferBuilder bufferBuilder, boolean bl, Random random, long l) {
        boolean \u26035 = false;
        float[] \u26032 = new float[Direction.values().length * 2];
        BitSet \u26033 = new BitSet(3);
        AmbientOcclusionFace \u26034 = new AmbientOcclusionFace();
        for (Direction direction : Direction.values()) {
            random.setSeed(l);
            List<BakedQuad> list = iBakedModel.func_200117_a(blockState, direction, random);
            if (list.isEmpty() || bl && !Block.func_176225_a(blockState, iEnviromentBlockReader, blockPos, direction)) continue;
            this.func_217630_a(iEnviromentBlockReader, blockState, blockPos, bufferBuilder, list, \u26032, \u26033, \u26034);
            \u26035 = true;
        }
        random.setSeed(l);
        \u2603 = iBakedModel.func_200117_a(blockState, null, random);
        if (!\u2603.isEmpty()) {
            this.func_217630_a(iEnviromentBlockReader, blockState, blockPos, bufferBuilder, \u2603, \u26032, \u26033, \u26034);
            \u26035 = true;
        }
        return \u26035;
    }

    public boolean func_217635_c(IEnviromentBlockReader iEnviromentBlockReader, IBakedModel iBakedModel, BlockState blockState, BlockPos blockPos, BufferBuilder bufferBuilder, boolean bl, Random random, long l) {
        boolean \u26034 = false;
        BitSet \u26032 = new BitSet(3);
        for (Direction direction : Direction.values()) {
            random.setSeed(l);
            List<BakedQuad> list = iBakedModel.func_200117_a(blockState, direction, random);
            if (list.isEmpty() || bl && !Block.func_176225_a(blockState, iEnviromentBlockReader, blockPos, direction)) continue;
            int \u26033 = blockState.func_215684_a(iEnviromentBlockReader, blockPos.func_177972_a(direction));
            this.func_217636_a(iEnviromentBlockReader, blockState, blockPos, \u26033, false, bufferBuilder, list, \u26032);
            \u26034 = true;
        }
        random.setSeed(l);
        \u2603 = iBakedModel.func_200117_a(blockState, null, random);
        if (!\u2603.isEmpty()) {
            this.func_217636_a(iEnviromentBlockReader, blockState, blockPos, -1, true, bufferBuilder, \u2603, \u26032);
            \u26034 = true;
        }
        return \u26034;
    }

    private void func_217630_a(IEnviromentBlockReader iEnviromentBlockReader, BlockState blockState, BlockPos blockPos, BufferBuilder bufferBuilder, List<BakedQuad> list, float[] fArray, BitSet bitSet, AmbientOcclusionFace ambientOcclusionFace) {
        Vec3d vec3d = blockState.func_191059_e(iEnviromentBlockReader, blockPos);
        double \u26032 = (double)blockPos.func_177958_n() + vec3d.field_72450_a;
        double \u26033 = (double)blockPos.func_177956_o() + vec3d.field_72448_b;
        double \u26034 = (double)blockPos.func_177952_p() + vec3d.field_72449_c;
        int \u26035 = list.size();
        for (int i = 0; i < \u26035; ++i) {
            BakedQuad bakedQuad = list.get(i);
            this.func_217633_a(iEnviromentBlockReader, blockState, blockPos, bakedQuad.func_178209_a(), bakedQuad.func_178210_d(), fArray, bitSet);
            ambientOcclusionFace.func_217629_a(iEnviromentBlockReader, blockState, blockPos, bakedQuad.func_178210_d(), fArray, bitSet);
            bufferBuilder.func_178981_a(bakedQuad.func_178209_a());
            bufferBuilder.func_178962_a(ambientOcclusionFace.field_178207_c[0], ambientOcclusionFace.field_178207_c[1], ambientOcclusionFace.field_178207_c[2], ambientOcclusionFace.field_178207_c[3]);
            if (bakedQuad.func_178212_b()) {
                int n = this.field_187499_a.func_216860_a(blockState, iEnviromentBlockReader, blockPos, bakedQuad.func_178211_c());
                float \u26036 = (float)(n >> 16 & 0xFF) / 255.0f;
                float \u26037 = (float)(n >> 8 & 0xFF) / 255.0f;
                float \u26038 = (float)(n & 0xFF) / 255.0f;
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[0] * \u26036, ambientOcclusionFace.field_178206_b[0] * \u26037, ambientOcclusionFace.field_178206_b[0] * \u26038, 4);
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[1] * \u26036, ambientOcclusionFace.field_178206_b[1] * \u26037, ambientOcclusionFace.field_178206_b[1] * \u26038, 3);
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[2] * \u26036, ambientOcclusionFace.field_178206_b[2] * \u26037, ambientOcclusionFace.field_178206_b[2] * \u26038, 2);
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[3] * \u26036, ambientOcclusionFace.field_178206_b[3] * \u26037, ambientOcclusionFace.field_178206_b[3] * \u26038, 1);
            } else {
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[0], ambientOcclusionFace.field_178206_b[0], ambientOcclusionFace.field_178206_b[0], 4);
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[1], ambientOcclusionFace.field_178206_b[1], ambientOcclusionFace.field_178206_b[1], 3);
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[2], ambientOcclusionFace.field_178206_b[2], ambientOcclusionFace.field_178206_b[2], 2);
                bufferBuilder.func_178978_a(ambientOcclusionFace.field_178206_b[3], ambientOcclusionFace.field_178206_b[3], ambientOcclusionFace.field_178206_b[3], 1);
            }
            bufferBuilder.func_178987_a(\u26032, \u26033, \u26034);
        }
    }

    private void func_217633_a(IEnviromentBlockReader iEnviromentBlockReader, BlockState blockState, BlockPos blockPos, int[] nArray, Direction direction, @Nullable float[] fArray2, BitSet bitSet) {
        float[] fArray2;
        int n;
        float f = 32.0f;
        \u2603 = 32.0f;
        \u2603 = 32.0f;
        \u2603 = -32.0f;
        \u2603 = -32.0f;
        \u2603 = -32.0f;
        for (n = 0; n < 4; ++n) {
            float f2 = Float.intBitsToFloat(nArray[n * 7]);
            \u2603 = Float.intBitsToFloat(nArray[n * 7 + 1]);
            \u2603 = Float.intBitsToFloat(nArray[n * 7 + 2]);
            f = Math.min(f, f2);
            \u2603 = Math.min(\u2603, \u2603);
            \u2603 = Math.min(\u2603, \u2603);
            \u2603 = Math.max(\u2603, f2);
            \u2603 = Math.max(\u2603, \u2603);
            \u2603 = Math.max(\u2603, \u2603);
        }
        if (fArray2 != null) {
            fArray2[Direction.WEST.func_176745_a()] = f;
            fArray2[Direction.EAST.func_176745_a()] = \u2603;
            fArray2[Direction.DOWN.func_176745_a()] = \u2603;
            fArray2[Direction.UP.func_176745_a()] = \u2603;
            fArray2[Direction.NORTH.func_176745_a()] = \u2603;
            fArray2[Direction.SOUTH.func_176745_a()] = \u2603;
            n = Direction.values().length;
            fArray2[Direction.WEST.func_176745_a() + n] = 1.0f - f;
            fArray2[Direction.EAST.func_176745_a() + n] = 1.0f - \u2603;
            fArray2[Direction.DOWN.func_176745_a() + n] = 1.0f - \u2603;
            fArray2[Direction.UP.func_176745_a() + n] = 1.0f - \u2603;
            fArray2[Direction.NORTH.func_176745_a() + n] = 1.0f - \u2603;
            fArray2[Direction.SOUTH.func_176745_a() + n] = 1.0f - \u2603;
        }
        float f3 = 1.0E-4f;
        f2 = 0.9999f;
        switch (direction) {
            case DOWN: {
                bitSet.set(1, f >= 1.0E-4f || \u2603 >= 1.0E-4f || \u2603 <= 0.9999f || \u2603 <= 0.9999f);
                bitSet.set(0, \u2603 == \u2603 && (\u2603 < 1.0E-4f || blockState.func_224756_o(iEnviromentBlockReader, blockPos)));
                break;
            }
            case UP: {
                bitSet.set(1, f >= 1.0E-4f || \u2603 >= 1.0E-4f || \u2603 <= 0.9999f || \u2603 <= 0.9999f);
                bitSet.set(0, \u2603 == \u2603 && (\u2603 > 0.9999f || blockState.func_224756_o(iEnviromentBlockReader, blockPos)));
                break;
            }
            case NORTH: {
                bitSet.set(1, f >= 1.0E-4f || \u2603 >= 1.0E-4f || \u2603 <= 0.9999f || \u2603 <= 0.9999f);
                bitSet.set(0, \u2603 == \u2603 && (\u2603 < 1.0E-4f || blockState.func_224756_o(iEnviromentBlockReader, blockPos)));
                break;
            }
            case SOUTH: {
                bitSet.set(1, f >= 1.0E-4f || \u2603 >= 1.0E-4f || \u2603 <= 0.9999f || \u2603 <= 0.9999f);
                bitSet.set(0, \u2603 == \u2603 && (\u2603 > 0.9999f || blockState.func_224756_o(iEnviromentBlockReader, blockPos)));
                break;
            }
            case WEST: {
                bitSet.set(1, \u2603 >= 1.0E-4f || \u2603 >= 1.0E-4f || \u2603 <= 0.9999f || \u2603 <= 0.9999f);
                bitSet.set(0, f == \u2603 && (f < 1.0E-4f || blockState.func_224756_o(iEnviromentBlockReader, blockPos)));
                break;
            }
            case EAST: {
                bitSet.set(1, \u2603 >= 1.0E-4f || \u2603 >= 1.0E-4f || \u2603 <= 0.9999f || \u2603 <= 0.9999f);
                bitSet.set(0, f == \u2603 && (\u2603 > 0.9999f || blockState.func_224756_o(iEnviromentBlockReader, blockPos)));
            }
        }
    }

    private void func_217636_a(IEnviromentBlockReader iEnviromentBlockReader, BlockState blockState, BlockPos blockPos, int \u260362, boolean bl, BufferBuilder bufferBuilder, List<BakedQuad> list, BitSet bitSet) {
        Vec3d vec3d = blockState.func_191059_e(iEnviromentBlockReader, blockPos);
        double \u26032 = (double)blockPos.func_177958_n() + vec3d.field_72450_a;
        double \u26033 = (double)blockPos.func_177956_o() + vec3d.field_72448_b;
        double \u26034 = (double)blockPos.func_177952_p() + vec3d.field_72449_c;
        int \u26035 = list.size();
        for (int i = 0; i < \u26035; ++i) {
            int \u260362;
            BakedQuad bakedQuad = list.get(i);
            if (bl) {
                this.func_217633_a(iEnviromentBlockReader, blockState, blockPos, bakedQuad.func_178209_a(), bakedQuad.func_178210_d(), null, bitSet);
                BlockPos blockPos2 = bitSet.get(0) ? blockPos.func_177972_a(bakedQuad.func_178210_d()) : blockPos;
                \u260362 = blockState.func_215684_a(iEnviromentBlockReader, blockPos2);
            }
            bufferBuilder.func_178981_a(bakedQuad.func_178209_a());
            bufferBuilder.func_178962_a(\u260362, \u260362, \u260362, \u260362);
            if (bakedQuad.func_178212_b()) {
                int \u26037 = this.field_187499_a.func_216860_a(blockState, iEnviromentBlockReader, blockPos, bakedQuad.func_178211_c());
                float \u26038 = (float)(\u26037 >> 16 & 0xFF) / 255.0f;
                float \u26039 = (float)(\u26037 >> 8 & 0xFF) / 255.0f;
                float \u260310 = (float)(\u26037 & 0xFF) / 255.0f;
                bufferBuilder.func_178978_a(\u26038, \u26039, \u260310, 4);
                bufferBuilder.func_178978_a(\u26038, \u26039, \u260310, 3);
                bufferBuilder.func_178978_a(\u26038, \u26039, \u260310, 2);
                bufferBuilder.func_178978_a(\u26038, \u26039, \u260310, 1);
            }
            bufferBuilder.func_178987_a(\u26032, \u26033, \u26034);
        }
    }

    public void func_178262_a(IBakedModel iBakedModel, float f, float f2, float f3, float f4) {
        this.func_187495_a(null, iBakedModel, f, f2, f3, f4);
    }

    public void func_187495_a(@Nullable BlockState blockState, IBakedModel iBakedModel, float f, float f2, float f3, float f4) {
        Random random = new Random();
        long \u26032 = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            this.func_178264_a(f, f2, f3, f4, iBakedModel.func_200117_a(blockState, direction, random));
        }
        random.setSeed(42L);
        this.func_178264_a(f, f2, f3, f4, iBakedModel.func_200117_a(blockState, null, random));
    }

    public void func_178266_a(IBakedModel iBakedModel, BlockState blockState, float f, boolean bl) {
        GlStateManager.rotatef(90.0f, 0.0f, 1.0f, 0.0f);
        int n = this.field_187499_a.func_216860_a(blockState, null, null, 0);
        float \u26032 = (float)(n >> 16 & 0xFF) / 255.0f;
        float \u26033 = (float)(n >> 8 & 0xFF) / 255.0f;
        float \u26034 = (float)(n & 0xFF) / 255.0f;
        if (!bl) {
            GlStateManager.color4f(f, f, f, 1.0f);
        }
        this.func_187495_a(blockState, iBakedModel, f, \u26032, \u26033, \u26034);
    }

    private void func_178264_a(float f, float f2, float f3, float f4, List<BakedQuad> list) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        int \u26033 = list.size();
        for (int i = 0; i < \u26033; ++i) {
            BakedQuad bakedQuad = list.get(i);
            \u26032.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            \u26032.func_178981_a(bakedQuad.func_178209_a());
            if (bakedQuad.func_178212_b()) {
                \u26032.func_178990_f(f2 * f, f3 * f, f4 * f);
            } else {
                \u26032.func_178990_f(f, f, f);
            }
            Vec3i \u26034 = bakedQuad.func_178210_d().func_176730_m();
            \u26032.func_178975_e(\u26034.func_177958_n(), \u26034.func_177956_o(), \u26034.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    public static void func_211847_a() {
        field_210267_b.get().func_222895_a();
    }

    public static void func_210266_a() {
        field_210267_b.get().func_222897_b();
    }

    public static enum NeighborInfo {
        DOWN(new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        private final Direction[] field_178276_g;
        private final boolean field_178289_i;
        private final Orientation[] field_178286_j;
        private final Orientation[] field_178287_k;
        private final Orientation[] field_178284_l;
        private final Orientation[] field_178285_m;
        private static final NeighborInfo[] field_178282_n;

        private NeighborInfo(Direction[] directionArray, float f, boolean bl, Orientation[] orientationArray, Orientation[] orientationArray2, Orientation[] orientationArray3, Orientation[] orientationArray4) {
            this.field_178276_g = directionArray;
            this.field_178289_i = bl;
            this.field_178286_j = orientationArray;
            this.field_178287_k = orientationArray2;
            this.field_178284_l = orientationArray3;
            this.field_178285_m = orientationArray4;
        }

        public static NeighborInfo func_178273_a(Direction direction) {
            return field_178282_n[direction.func_176745_a()];
        }

        static {
            field_178282_n = Util.func_200696_a(new NeighborInfo[6], neighborInfoArray -> {
                neighborInfoArray[Direction.DOWN.func_176745_a()] = DOWN;
                neighborInfoArray[Direction.UP.func_176745_a()] = UP;
                neighborInfoArray[Direction.NORTH.func_176745_a()] = NORTH;
                neighborInfoArray[Direction.SOUTH.func_176745_a()] = SOUTH;
                neighborInfoArray[Direction.WEST.func_176745_a()] = WEST;
                neighborInfoArray[Direction.EAST.func_176745_a()] = EAST;
            });
        }
    }

    public static enum Orientation {
        DOWN(Direction.DOWN, false),
        UP(Direction.UP, false),
        NORTH(Direction.NORTH, false),
        SOUTH(Direction.SOUTH, false),
        WEST(Direction.WEST, false),
        EAST(Direction.EAST, false),
        FLIP_DOWN(Direction.DOWN, true),
        FLIP_UP(Direction.UP, true),
        FLIP_NORTH(Direction.NORTH, true),
        FLIP_SOUTH(Direction.SOUTH, true),
        FLIP_WEST(Direction.WEST, true),
        FLIP_EAST(Direction.EAST, true);

        private final int field_178229_m;

        private Orientation(Direction direction, boolean bl) {
            this.field_178229_m = direction.func_176745_a() + (bl ? Direction.values().length : 0);
        }
    }

    class AmbientOcclusionFace {
        private final float[] field_178206_b = new float[4];
        private final int[] field_178207_c = new int[4];

        public void func_217629_a(IEnviromentBlockReader iEnviromentBlockReader, BlockState blockState, BlockPos blockPos, Direction direction, float[] fArray, BitSet bitSet) {
            int \u260327;
            float \u260326;
            int \u260325;
            float \u260324;
            int \u260323;
            float \u260322;
            int \u260321;
            float \u260320;
            BlockPos blockPos2 = bitSet.get(0) ? blockPos.func_177972_a(direction) : blockPos;
            NeighborInfo \u26032 = NeighborInfo.func_178273_a(direction);
            BlockPos.MutableBlockPos \u26033 = new BlockPos.MutableBlockPos();
            Cache \u26034 = (Cache)field_210267_b.get();
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[0]);
            BlockState \u26035 = iEnviromentBlockReader.func_180495_p(\u26033);
            int \u26036 = \u26034.func_222893_a(\u26035, iEnviromentBlockReader, \u26033);
            float \u26037 = \u26034.func_222896_b(\u26035, iEnviromentBlockReader, \u26033);
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[1]);
            BlockState \u26038 = iEnviromentBlockReader.func_180495_p(\u26033);
            int \u26039 = \u26034.func_222893_a(\u26038, iEnviromentBlockReader, \u26033);
            float \u260310 = \u26034.func_222896_b(\u26038, iEnviromentBlockReader, \u26033);
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[2]);
            BlockState \u260311 = iEnviromentBlockReader.func_180495_p(\u26033);
            int \u260312 = \u26034.func_222893_a(\u260311, iEnviromentBlockReader, \u26033);
            float \u260313 = \u26034.func_222896_b(\u260311, iEnviromentBlockReader, \u26033);
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[3]);
            BlockState \u260314 = iEnviromentBlockReader.func_180495_p(\u26033);
            int \u260315 = \u26034.func_222893_a(\u260314, iEnviromentBlockReader, \u26033);
            float \u260316 = \u26034.func_222896_b(\u260314, iEnviromentBlockReader, \u26033);
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[0]).func_189536_c(direction);
            boolean \u260317 = iEnviromentBlockReader.func_180495_p(\u26033).func_200016_a(iEnviromentBlockReader, \u26033) == 0;
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[1]).func_189536_c(direction);
            boolean \u260318 = iEnviromentBlockReader.func_180495_p(\u26033).func_200016_a(iEnviromentBlockReader, \u26033) == 0;
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[2]).func_189536_c(direction);
            boolean \u260319 = iEnviromentBlockReader.func_180495_p(\u26033).func_200016_a(iEnviromentBlockReader, \u26033) == 0;
            \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[3]).func_189536_c(direction);
            boolean bl = \u2603 = iEnviromentBlockReader.func_180495_p(\u26033).func_200016_a(iEnviromentBlockReader, \u26033) == 0;
            if (\u260319 || \u260317) {
                \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[0]).func_189536_c(\u26032.field_178276_g[2]);
                BlockState blockState2 = iEnviromentBlockReader.func_180495_p(\u26033);
                \u260320 = \u26034.func_222896_b(blockState2, iEnviromentBlockReader, \u26033);
                \u260321 = \u26034.func_222893_a(blockState2, iEnviromentBlockReader, \u26033);
            } else {
                \u260320 = \u26037;
                \u260321 = \u26036;
            }
            if (\u2603 || \u260317) {
                \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[0]).func_189536_c(\u26032.field_178276_g[3]);
                blockState2 = iEnviromentBlockReader.func_180495_p(\u26033);
                \u260322 = \u26034.func_222896_b(blockState2, iEnviromentBlockReader, \u26033);
                \u260323 = \u26034.func_222893_a(blockState2, iEnviromentBlockReader, \u26033);
            } else {
                \u260322 = \u26037;
                \u260323 = \u26036;
            }
            if (\u260319 || \u260318) {
                \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[1]).func_189536_c(\u26032.field_178276_g[2]);
                blockState2 = iEnviromentBlockReader.func_180495_p(\u26033);
                \u260324 = \u26034.func_222896_b(blockState2, iEnviromentBlockReader, \u26033);
                \u260325 = \u26034.func_222893_a(blockState2, iEnviromentBlockReader, \u26033);
            } else {
                \u260324 = \u26037;
                \u260325 = \u26036;
            }
            if (\u2603 || \u260318) {
                \u26033.func_189533_g(blockPos2).func_189536_c(\u26032.field_178276_g[1]).func_189536_c(\u26032.field_178276_g[3]);
                blockState2 = iEnviromentBlockReader.func_180495_p(\u26033);
                \u260326 = \u26034.func_222896_b(blockState2, iEnviromentBlockReader, \u26033);
                \u260327 = \u26034.func_222893_a(blockState2, iEnviromentBlockReader, \u26033);
            } else {
                \u260326 = \u26037;
                \u260327 = \u26036;
            }
            int n = \u26034.func_222893_a(blockState, iEnviromentBlockReader, blockPos);
            \u26033.func_189533_g(blockPos).func_189536_c(direction);
            BlockState \u260328 = iEnviromentBlockReader.func_180495_p(\u26033);
            if (bitSet.get(0) || !\u260328.func_200015_d(iEnviromentBlockReader, \u26033)) {
                n = \u26034.func_222893_a(\u260328, iEnviromentBlockReader, \u26033);
            }
            float \u260329 = bitSet.get(0) ? \u26034.func_222896_b(iEnviromentBlockReader.func_180495_p(blockPos2), iEnviromentBlockReader, blockPos2) : \u26034.func_222896_b(iEnviromentBlockReader.func_180495_p(blockPos), iEnviromentBlockReader, blockPos);
            VertexTranslations \u260330 = VertexTranslations.func_178184_a(direction);
            if (!bitSet.get(1) || !\u26032.field_178289_i) {
                float f = (\u260316 + \u26037 + \u260322 + \u260329) * 0.25f;
                \u2603 = (\u260313 + \u26037 + \u260320 + \u260329) * 0.25f;
                \u2603 = (\u260313 + \u260310 + \u260324 + \u260329) * 0.25f;
                \u2603 = (\u260316 + \u260310 + \u260326 + \u260329) * 0.25f;
                this.field_178207_c[((VertexTranslations)\u260330).field_178191_g] = this.func_147778_a(\u260315, \u26036, \u260323, n);
                this.field_178207_c[((VertexTranslations)\u260330).field_178200_h] = this.func_147778_a(\u260312, \u26036, \u260321, n);
                this.field_178207_c[((VertexTranslations)\u260330).field_178201_i] = this.func_147778_a(\u260312, \u26039, \u260325, n);
                this.field_178207_c[((VertexTranslations)\u260330).field_178198_j] = this.func_147778_a(\u260315, \u26039, \u260327, n);
                this.field_178206_b[((VertexTranslations)\u260330).field_178191_g] = f;
                this.field_178206_b[((VertexTranslations)\u260330).field_178200_h] = \u2603;
                this.field_178206_b[((VertexTranslations)\u260330).field_178201_i] = \u2603;
                this.field_178206_b[((VertexTranslations)\u260330).field_178198_j] = \u2603;
            } else {
                float f = (\u260316 + \u26037 + \u260322 + \u260329) * 0.25f;
                \u2603 = (\u260313 + \u26037 + \u260320 + \u260329) * 0.25f;
                \u2603 = (\u260313 + \u260310 + \u260324 + \u260329) * 0.25f;
                \u2603 = (\u260316 + \u260310 + \u260326 + \u260329) * 0.25f;
                \u2603 = fArray[\u26032.field_178286_j[0].field_178229_m] * fArray[\u26032.field_178286_j[1].field_178229_m];
                \u2603 = fArray[\u26032.field_178286_j[2].field_178229_m] * fArray[\u26032.field_178286_j[3].field_178229_m];
                \u2603 = fArray[\u26032.field_178286_j[4].field_178229_m] * fArray[\u26032.field_178286_j[5].field_178229_m];
                \u2603 = fArray[\u26032.field_178286_j[6].field_178229_m] * fArray[\u26032.field_178286_j[7].field_178229_m];
                \u2603 = fArray[\u26032.field_178287_k[0].field_178229_m] * fArray[\u26032.field_178287_k[1].field_178229_m];
                \u2603 = fArray[\u26032.field_178287_k[2].field_178229_m] * fArray[\u26032.field_178287_k[3].field_178229_m];
                \u2603 = fArray[\u26032.field_178287_k[4].field_178229_m] * fArray[\u26032.field_178287_k[5].field_178229_m];
                \u2603 = fArray[\u26032.field_178287_k[6].field_178229_m] * fArray[\u26032.field_178287_k[7].field_178229_m];
                \u2603 = fArray[\u26032.field_178284_l[0].field_178229_m] * fArray[\u26032.field_178284_l[1].field_178229_m];
                \u2603 = fArray[\u26032.field_178284_l[2].field_178229_m] * fArray[\u26032.field_178284_l[3].field_178229_m];
                \u2603 = fArray[\u26032.field_178284_l[4].field_178229_m] * fArray[\u26032.field_178284_l[5].field_178229_m];
                \u2603 = fArray[\u26032.field_178284_l[6].field_178229_m] * fArray[\u26032.field_178284_l[7].field_178229_m];
                \u2603 = fArray[\u26032.field_178285_m[0].field_178229_m] * fArray[\u26032.field_178285_m[1].field_178229_m];
                \u2603 = fArray[\u26032.field_178285_m[2].field_178229_m] * fArray[\u26032.field_178285_m[3].field_178229_m];
                \u2603 = fArray[\u26032.field_178285_m[4].field_178229_m] * fArray[\u26032.field_178285_m[5].field_178229_m];
                \u2603 = fArray[\u26032.field_178285_m[6].field_178229_m] * fArray[\u26032.field_178285_m[7].field_178229_m];
                this.field_178206_b[((VertexTranslations)\u260330).field_178191_g] = f * \u2603 + \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
                this.field_178206_b[((VertexTranslations)\u260330).field_178200_h] = f * \u2603 + \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
                this.field_178206_b[((VertexTranslations)\u260330).field_178201_i] = f * \u2603 + \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
                this.field_178206_b[((VertexTranslations)\u260330).field_178198_j] = f * \u2603 + \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
                int \u260331 = this.func_147778_a(\u260315, \u26036, \u260323, n);
                int \u260332 = this.func_147778_a(\u260312, \u26036, \u260321, n);
                int \u260333 = this.func_147778_a(\u260312, \u26039, \u260325, n);
                int \u260334 = this.func_147778_a(\u260315, \u26039, \u260327, n);
                this.field_178207_c[((VertexTranslations)\u260330).field_178191_g] = this.func_178203_a(\u260331, \u260332, \u260333, \u260334, \u2603, \u2603, \u2603, \u2603);
                this.field_178207_c[((VertexTranslations)\u260330).field_178200_h] = this.func_178203_a(\u260331, \u260332, \u260333, \u260334, \u2603, \u2603, \u2603, \u2603);
                this.field_178207_c[((VertexTranslations)\u260330).field_178201_i] = this.func_178203_a(\u260331, \u260332, \u260333, \u260334, \u2603, \u2603, \u2603, \u2603);
                this.field_178207_c[((VertexTranslations)\u260330).field_178198_j] = this.func_178203_a(\u260331, \u260332, \u260333, \u260334, \u2603, \u2603, \u2603, \u2603);
            }
        }

        private int func_147778_a(int n, int n2, int n3, int n4) {
            if (n == 0) {
                n = n4;
            }
            if (n2 == 0) {
                n2 = n4;
            }
            if (n3 == 0) {
                n3 = n4;
            }
            return n + n2 + n3 + n4 >> 2 & 0xFF00FF;
        }

        private int func_178203_a(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4) {
            int n5 = (int)((float)(n >> 16 & 0xFF) * f + (float)(n2 >> 16 & 0xFF) * f2 + (float)(n3 >> 16 & 0xFF) * f3 + (float)(n4 >> 16 & 0xFF) * f4) & 0xFF;
            \u2603 = (int)((float)(n & 0xFF) * f + (float)(n2 & 0xFF) * f2 + (float)(n3 & 0xFF) * f3 + (float)(n4 & 0xFF) * f4) & 0xFF;
            return n5 << 16 | \u2603;
        }
    }

    static class Cache {
        private boolean field_222898_a;
        private final Long2IntLinkedOpenHashMap field_222899_b = Util.func_199748_a(() -> {
            Long2IntLinkedOpenHashMap long2IntLinkedOpenHashMap = new Long2IntLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int n) {
                }
            };
            long2IntLinkedOpenHashMap.defaultReturnValue(Integer.MAX_VALUE);
            return long2IntLinkedOpenHashMap;
        });
        private final Long2FloatLinkedOpenHashMap field_222900_c = Util.func_199748_a(() -> {
            Long2FloatLinkedOpenHashMap long2FloatLinkedOpenHashMap = new Long2FloatLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int n) {
                }
            };
            long2FloatLinkedOpenHashMap.defaultReturnValue(Float.NaN);
            return long2FloatLinkedOpenHashMap;
        });

        private Cache() {
        }

        public void func_222895_a() {
            this.field_222898_a = true;
        }

        public void func_222897_b() {
            this.field_222898_a = false;
            this.field_222899_b.clear();
            this.field_222900_c.clear();
        }

        public int func_222893_a(BlockState blockState, IEnviromentBlockReader iEnviromentBlockReader, BlockPos blockPos) {
            long l = blockPos.func_218275_a();
            if (this.field_222898_a && (\u26032 = this.field_222899_b.get(l)) != Integer.MAX_VALUE) {
                return \u26032;
            }
            int \u26032 = blockState.func_215684_a(iEnviromentBlockReader, blockPos);
            if (this.field_222898_a) {
                if (this.field_222899_b.size() == 100) {
                    this.field_222899_b.removeFirstInt();
                }
                this.field_222899_b.put(l, \u26032);
            }
            return \u26032;
        }

        public float func_222896_b(BlockState blockState, IEnviromentBlockReader iEnviromentBlockReader, BlockPos blockPos) {
            long l = blockPos.func_218275_a();
            if (this.field_222898_a && !Float.isNaN(\u26032 = this.field_222900_c.get(l))) {
                return \u26032;
            }
            float \u26032 = blockState.func_215703_d(iEnviromentBlockReader, blockPos);
            if (this.field_222898_a) {
                if (this.field_222900_c.size() == 100) {
                    this.field_222900_c.removeFirstFloat();
                }
                this.field_222900_c.put(l, \u26032);
            }
            return \u26032;
        }
    }

    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int field_178191_g;
        private final int field_178200_h;
        private final int field_178201_i;
        private final int field_178198_j;
        private static final VertexTranslations[] field_178199_k;

        private VertexTranslations(int n2, int n3, int n4, int n5) {
            this.field_178191_g = n2;
            this.field_178200_h = n3;
            this.field_178201_i = n4;
            this.field_178198_j = n5;
        }

        public static VertexTranslations func_178184_a(Direction direction) {
            return field_178199_k[direction.func_176745_a()];
        }

        static {
            field_178199_k = Util.func_200696_a(new VertexTranslations[6], vertexTranslationsArray -> {
                vertexTranslationsArray[Direction.DOWN.func_176745_a()] = DOWN;
                vertexTranslationsArray[Direction.UP.func_176745_a()] = UP;
                vertexTranslationsArray[Direction.NORTH.func_176745_a()] = NORTH;
                vertexTranslationsArray[Direction.SOUTH.func_176745_a()] = SOUTH;
                vertexTranslationsArray[Direction.WEST.func_176745_a()] = WEST;
                vertexTranslationsArray[Direction.EAST.func_176745_a()] = EAST;
            });
        }
    }
}

