/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ChestRenderer;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.IFluidState;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;

public class BlockRendererDispatcher
implements IResourceManagerReloadListener {
    private final BlockModelShapes field_175028_a;
    private final BlockModelRenderer field_175027_c;
    private final ChestRenderer field_175024_d = new ChestRenderer();
    private final FluidBlockRenderer field_175025_e;
    private final Random field_195476_e = new Random();

    public BlockRendererDispatcher(BlockModelShapes blockModelShapes, BlockColors blockColors) {
        this.field_175028_a = blockModelShapes;
        this.field_175027_c = new BlockModelRenderer(blockColors);
        this.field_175025_e = new FluidBlockRenderer();
    }

    public BlockModelShapes func_175023_a() {
        return this.field_175028_a;
    }

    public void func_215329_a(BlockState blockState, BlockPos blockPos, TextureAtlasSprite textureAtlasSprite, IEnviromentBlockReader iEnviromentBlockReader) {
        if (blockState.func_185901_i() != BlockRenderType.MODEL) {
            return;
        }
        IBakedModel iBakedModel = this.field_175028_a.func_178125_b(blockState);
        long \u26032 = blockState.func_209533_a(blockPos);
        \u2603 = new SimpleBakedModel.Builder(blockState, iBakedModel, textureAtlasSprite, this.field_195476_e, \u26032).func_177645_b();
        this.field_175027_c.func_217631_a(iEnviromentBlockReader, \u2603, blockState, blockPos, Tessellator.func_178181_a().func_178180_c(), true, this.field_195476_e, \u26032);
    }

    public boolean func_215330_a(BlockState blockState, BlockPos blockPos, IEnviromentBlockReader iEnviromentBlockReader, BufferBuilder bufferBuilder, Random random) {
        try {
            BlockRenderType blockRenderType = blockState.func_185901_i();
            if (blockRenderType == BlockRenderType.INVISIBLE) {
                return false;
            }
            switch (blockRenderType) {
                case MODEL: {
                    return this.field_175027_c.func_217631_a(iEnviromentBlockReader, this.func_184389_a(blockState), blockState, blockPos, bufferBuilder, true, random, blockState.func_209533_a(blockPos));
                }
                case ENTITYBLOCK_ANIMATED: {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Tesselating block in world");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a(\u26032, blockPos, blockState);
            throw new ReportedException(crashReport);
        }
        return false;
    }

    public boolean func_215331_a(BlockPos blockPos, IEnviromentBlockReader iEnviromentBlockReader, BufferBuilder bufferBuilder, IFluidState iFluidState) {
        try {
            return this.field_175025_e.func_217638_a(iEnviromentBlockReader, blockPos, bufferBuilder, iFluidState);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Tesselating liquid in world");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a(\u26032, blockPos, null);
            throw new ReportedException(crashReport);
        }
    }

    public BlockModelRenderer func_175019_b() {
        return this.field_175027_c;
    }

    public IBakedModel func_184389_a(BlockState blockState) {
        return this.field_175028_a.func_178125_b(blockState);
    }

    public void func_175016_a(BlockState blockState2, float f) {
        BlockRenderType blockRenderType = blockState2.func_185901_i();
        if (blockRenderType == BlockRenderType.INVISIBLE) {
            return;
        }
        switch (blockRenderType) {
            case MODEL: {
                IBakedModel iBakedModel = this.func_184389_a(blockState2);
                this.field_175027_c.func_178266_a(iBakedModel, blockState2, f, true);
                break;
            }
            case ENTITYBLOCK_ANIMATED: {
                BlockState blockState2;
                this.field_175024_d.func_178175_a(blockState2.func_177230_c(), f);
            }
        }
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_175025_e.func_178268_a();
    }
}

