/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.primitives.Floats;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.BitSet;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferBuilder {
    private static final Logger field_187316_a = LogManager.getLogger();
    private ByteBuffer field_179001_a;
    private IntBuffer field_178999_b;
    private ShortBuffer field_181676_c;
    private FloatBuffer field_179000_c;
    private int field_178997_d;
    private VertexFormatElement field_181677_f;
    private int field_181678_g;
    private boolean field_78939_q;
    private int field_179006_k;
    private double field_179004_l;
    private double field_179005_m;
    private double field_179002_n;
    private VertexFormat field_179011_q;
    private boolean field_179010_r;

    public BufferBuilder(int n) {
        this.field_179001_a = GLAllocation.func_74524_c(n * 4);
        this.field_178999_b = this.field_179001_a.asIntBuffer();
        this.field_181676_c = this.field_179001_a.asShortBuffer();
        this.field_179000_c = this.field_179001_a.asFloatBuffer();
    }

    private void func_181670_b(int n) {
        if (this.field_178997_d * this.field_179011_q.func_177338_f() + n <= this.field_179001_a.capacity()) {
            return;
        }
        \u2603 = this.field_179001_a.capacity();
        \u2603 = \u2603 + BufferBuilder.func_216566_c(n);
        field_187316_a.debug("Needed to grow BufferBuilder buffer: Old size {} bytes, new size {} bytes.", (Object)\u2603, (Object)\u2603);
        \u2603 = this.field_178999_b.position();
        ByteBuffer byteBuffer = GLAllocation.func_74524_c(\u2603);
        this.field_179001_a.position(0);
        byteBuffer.put(this.field_179001_a);
        byteBuffer.rewind();
        this.field_179001_a = byteBuffer;
        this.field_179000_c = this.field_179001_a.asFloatBuffer().asReadOnlyBuffer();
        this.field_178999_b = this.field_179001_a.asIntBuffer();
        this.field_178999_b.position(\u2603);
        this.field_181676_c = this.field_179001_a.asShortBuffer();
        this.field_181676_c.position(\u2603 << 1);
    }

    private static int func_216566_c(int n) {
        \u2603 = 0x200000;
        if (n == 0) {
            return \u2603;
        }
        if (n < 0) {
            \u2603 *= -1;
        }
        if ((\u2603 = n % \u2603) == 0) {
            return n;
        }
        return n + \u2603 - \u2603;
    }

    public void func_181674_a(float f, float f2, float f3) {
        int n3 = this.field_178997_d / 4;
        float[] \u26032 = new float[n3];
        for (\u2603 = 0; \u2603 < n3; ++\u2603) {
            \u26032[\u2603] = BufferBuilder.func_181665_a(this.field_179000_c, (float)((double)f + this.field_179004_l), (float)((double)f2 + this.field_179005_m), (float)((double)f3 + this.field_179002_n), this.field_179011_q.func_181719_f(), \u2603 * this.field_179011_q.func_177338_f());
        }
        Integer[] \u26033 = new Integer[n3];
        for (\u2603 = 0; \u2603 < \u26033.length; ++\u2603) {
            \u26033[\u2603] = \u2603;
        }
        Arrays.sort(\u26033, (n, n2) -> Floats.compare((float)\u26032[n2], (float)\u26032[n]));
        BitSet \u26034 = new BitSet();
        \u2603 = this.field_179011_q.func_177338_f();
        int[] \u26035 = new int[\u2603];
        n4 = \u26034.nextClearBit(0);
        while (n4 < \u26033.length) {
            \u2603 = \u26033[n4];
            if (\u2603 != n4) {
                this.field_178999_b.limit(\u2603 * \u2603 + \u2603);
                this.field_178999_b.position(\u2603 * \u2603);
                this.field_178999_b.get(\u26035);
                \u26036 = \u2603;
                \u26037 = \u26033[\u26036];
                while (\u26036 != n4) {
                    this.field_178999_b.limit(\u26037 * \u2603 + \u2603);
                    this.field_178999_b.position(\u26037 * \u2603);
                    IntBuffer intBuffer = this.field_178999_b.slice();
                    this.field_178999_b.limit(\u26036 * \u2603 + \u2603);
                    this.field_178999_b.position(\u26036 * \u2603);
                    this.field_178999_b.put(intBuffer);
                    \u26034.set(\u26036);
                    int \u26036 = \u26037;
                    int \u26037 = \u26033[\u26036];
                }
                this.field_178999_b.limit(n4 * \u2603 + \u2603);
                this.field_178999_b.position(n4 * \u2603);
                this.field_178999_b.put(\u26035);
            }
            \u26034.set(n4);
            int n4 = \u26034.nextClearBit(n4 + 1);
        }
    }

    public State func_181672_a() {
        this.field_178999_b.rewind();
        int n = this.func_181664_j();
        this.field_178999_b.limit(n);
        int[] \u26032 = new int[n];
        this.field_178999_b.get(\u26032);
        this.field_178999_b.limit(this.field_178999_b.capacity());
        this.field_178999_b.position(n);
        return new State(\u26032, new VertexFormat(this.field_179011_q));
    }

    private int func_181664_j() {
        return this.field_178997_d * this.field_179011_q.func_181719_f();
    }

    private static float func_181665_a(FloatBuffer floatBuffer, float f, float f2, float f3, int n, int n2) {
        float f4 = floatBuffer.get(n2 + n * 0 + 0);
        \u2603 = floatBuffer.get(n2 + n * 0 + 1);
        \u2603 = floatBuffer.get(n2 + n * 0 + 2);
        \u2603 = floatBuffer.get(n2 + n * 1 + 0);
        \u2603 = floatBuffer.get(n2 + n * 1 + 1);
        \u2603 = floatBuffer.get(n2 + n * 1 + 2);
        \u2603 = floatBuffer.get(n2 + n * 2 + 0);
        \u2603 = floatBuffer.get(n2 + n * 2 + 1);
        \u2603 = floatBuffer.get(n2 + n * 2 + 2);
        \u2603 = floatBuffer.get(n2 + n * 3 + 0);
        \u2603 = floatBuffer.get(n2 + n * 3 + 1);
        \u2603 = floatBuffer.get(n2 + n * 3 + 2);
        \u2603 = (f4 + \u2603 + \u2603 + \u2603) * 0.25f - f;
        \u2603 = (\u2603 + \u2603 + \u2603 + \u2603) * 0.25f - f2;
        \u2603 = (\u2603 + \u2603 + \u2603 + \u2603) * 0.25f - f3;
        return \u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
    }

    public void func_178993_a(State state) {
        this.field_178999_b.clear();
        this.func_181670_b(state.func_179013_a().length * 4);
        this.field_178999_b.put(state.func_179013_a());
        this.field_178997_d = state.func_179014_c();
        this.field_179011_q = new VertexFormat(state.func_179016_d());
    }

    public void func_178965_a() {
        this.field_178997_d = 0;
        this.field_181677_f = null;
        this.field_181678_g = 0;
    }

    public void func_181668_a(int n, VertexFormat vertexFormat) {
        if (this.field_179010_r) {
            throw new IllegalStateException("Already building!");
        }
        this.field_179010_r = true;
        this.func_178965_a();
        this.field_179006_k = n;
        this.field_179011_q = vertexFormat;
        this.field_181677_f = vertexFormat.func_177348_c(this.field_181678_g);
        this.field_78939_q = false;
        this.field_179001_a.limit(this.field_179001_a.capacity());
    }

    public BufferBuilder func_187315_a(double d, double d2) {
        int n = this.field_178997_d * this.field_179011_q.func_177338_f() + this.field_179011_q.func_181720_d(this.field_181678_g);
        switch (this.field_181677_f.func_177367_b()) {
            case FLOAT: {
                this.field_179001_a.putFloat(n, (float)d);
                this.field_179001_a.putFloat(n + 4, (float)d2);
                break;
            }
            case UINT: 
            case INT: {
                this.field_179001_a.putInt(n, (int)d);
                this.field_179001_a.putInt(n + 4, (int)d2);
                break;
            }
            case USHORT: 
            case SHORT: {
                this.field_179001_a.putShort(n, (short)d2);
                this.field_179001_a.putShort(n + 2, (short)d);
                break;
            }
            case UBYTE: 
            case BYTE: {
                this.field_179001_a.put(n, (byte)d2);
                this.field_179001_a.put(n + 1, (byte)d);
            }
        }
        this.func_181667_k();
        return this;
    }

    public BufferBuilder func_187314_a(int n, int n2) {
        \u2603 = this.field_178997_d * this.field_179011_q.func_177338_f() + this.field_179011_q.func_181720_d(this.field_181678_g);
        switch (this.field_181677_f.func_177367_b()) {
            case FLOAT: {
                this.field_179001_a.putFloat(\u2603, n);
                this.field_179001_a.putFloat(\u2603 + 4, n2);
                break;
            }
            case UINT: 
            case INT: {
                this.field_179001_a.putInt(\u2603, n);
                this.field_179001_a.putInt(\u2603 + 4, n2);
                break;
            }
            case USHORT: 
            case SHORT: {
                this.field_179001_a.putShort(\u2603, (short)n2);
                this.field_179001_a.putShort(\u2603 + 2, (short)n);
                break;
            }
            case UBYTE: 
            case BYTE: {
                this.field_179001_a.put(\u2603, (byte)n2);
                this.field_179001_a.put(\u2603 + 1, (byte)n);
            }
        }
        this.func_181667_k();
        return this;
    }

    public void func_178962_a(int n, int n2, int n3, int n4) {
        \u2603 = (this.field_178997_d - 4) * this.field_179011_q.func_181719_f() + this.field_179011_q.func_177344_b(1) / 4;
        \u2603 = this.field_179011_q.func_177338_f() >> 2;
        this.field_178999_b.put(\u2603, n);
        this.field_178999_b.put(\u2603 + \u2603, n2);
        this.field_178999_b.put(\u2603 + \u2603 * 2, n3);
        this.field_178999_b.put(\u2603 + \u2603 * 3, n4);
    }

    public void func_178987_a(double d, double d2, double d3) {
        int n = this.field_179011_q.func_181719_f();
        \u2603 = (this.field_178997_d - 4) * n;
        for (\u2603 = 0; \u2603 < 4; ++\u2603) {
            \u2603 = \u2603 + \u2603 * n;
            \u2603 = \u2603 + 1;
            \u2603 = \u2603 + 1;
            this.field_178999_b.put(\u2603, Float.floatToRawIntBits((float)(d + this.field_179004_l) + Float.intBitsToFloat(this.field_178999_b.get(\u2603))));
            this.field_178999_b.put(\u2603, Float.floatToRawIntBits((float)(d2 + this.field_179005_m) + Float.intBitsToFloat(this.field_178999_b.get(\u2603))));
            this.field_178999_b.put(\u2603, Float.floatToRawIntBits((float)(d3 + this.field_179002_n) + Float.intBitsToFloat(this.field_178999_b.get(\u2603))));
        }
    }

    private int func_78909_a(int n) {
        return ((this.field_178997_d - n) * this.field_179011_q.func_177338_f() + this.field_179011_q.func_177340_e()) / 4;
    }

    public void func_178978_a(float f, float f2, float f3, int n) {
        \u2603 = this.func_78909_a(n);
        \u2603 = -1;
        if (!this.field_78939_q) {
            \u2603 = this.field_178999_b.get(\u2603);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                \u2603 = (int)((float)(\u2603 & 0xFF) * f);
                \u2603 = (int)((float)(\u2603 >> 8 & 0xFF) * f2);
                \u2603 = (int)((float)(\u2603 >> 16 & 0xFF) * f3);
                \u2603 &= 0xFF000000;
                \u2603 |= \u2603 << 16 | \u2603 << 8 | \u2603;
            } else {
                \u2603 = (int)((float)(\u2603 >> 24 & 0xFF) * f);
                \u2603 = (int)((float)(\u2603 >> 16 & 0xFF) * f2);
                \u2603 = (int)((float)(\u2603 >> 8 & 0xFF) * f3);
                \u2603 &= 0xFF;
                \u2603 |= \u2603 << 24 | \u2603 << 16 | \u2603 << 8;
            }
        }
        this.field_178999_b.put(\u2603, \u2603);
    }

    private void func_192836_a(int n, int n2) {
        \u2603 = this.func_78909_a(n2);
        \u2603 = n >> 16 & 0xFF;
        \u2603 = n >> 8 & 0xFF;
        \u2603 = n & 0xFF;
        this.func_178972_a(\u2603, \u2603, \u2603, \u2603);
    }

    public void func_178994_b(float f, float f2, float f3, int n) {
        \u2603 = this.func_78909_a(n);
        \u2603 = BufferBuilder.func_216567_a((int)(f * 255.0f), 0, 255);
        \u2603 = BufferBuilder.func_216567_a((int)(f2 * 255.0f), 0, 255);
        \u2603 = BufferBuilder.func_216567_a((int)(f3 * 255.0f), 0, 255);
        this.func_178972_a(\u2603, \u2603, \u2603, \u2603);
    }

    private static int func_216567_a(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    private void func_178972_a(int n, int n2, int n3, int n4) {
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.field_178999_b.put(n, 0xFF000000 | n4 << 16 | n3 << 8 | n2);
        } else {
            this.field_178999_b.put(n, n2 << 24 | n3 << 16 | n4 << 8 | 0xFF);
        }
    }

    public void func_78914_f() {
        this.field_78939_q = true;
    }

    public BufferBuilder func_181666_a(float f, float f2, float f3, float f4) {
        return this.func_181669_b((int)(f * 255.0f), (int)(f2 * 255.0f), (int)(f3 * 255.0f), (int)(f4 * 255.0f));
    }

    public BufferBuilder func_181669_b(int n, int n2, int n3, int n4) {
        if (this.field_78939_q) {
            return this;
        }
        \u2603 = this.field_178997_d * this.field_179011_q.func_177338_f() + this.field_179011_q.func_181720_d(this.field_181678_g);
        switch (this.field_181677_f.func_177367_b()) {
            case FLOAT: {
                this.field_179001_a.putFloat(\u2603, (float)n / 255.0f);
                this.field_179001_a.putFloat(\u2603 + 4, (float)n2 / 255.0f);
                this.field_179001_a.putFloat(\u2603 + 8, (float)n3 / 255.0f);
                this.field_179001_a.putFloat(\u2603 + 12, (float)n4 / 255.0f);
                break;
            }
            case UINT: 
            case INT: {
                this.field_179001_a.putFloat(\u2603, n);
                this.field_179001_a.putFloat(\u2603 + 4, n2);
                this.field_179001_a.putFloat(\u2603 + 8, n3);
                this.field_179001_a.putFloat(\u2603 + 12, n4);
                break;
            }
            case USHORT: 
            case SHORT: {
                this.field_179001_a.putShort(\u2603, (short)n);
                this.field_179001_a.putShort(\u2603 + 2, (short)n2);
                this.field_179001_a.putShort(\u2603 + 4, (short)n3);
                this.field_179001_a.putShort(\u2603 + 6, (short)n4);
                break;
            }
            case UBYTE: 
            case BYTE: {
                if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                    this.field_179001_a.put(\u2603, (byte)n);
                    this.field_179001_a.put(\u2603 + 1, (byte)n2);
                    this.field_179001_a.put(\u2603 + 2, (byte)n3);
                    this.field_179001_a.put(\u2603 + 3, (byte)n4);
                    break;
                }
                this.field_179001_a.put(\u2603, (byte)n4);
                this.field_179001_a.put(\u2603 + 1, (byte)n3);
                this.field_179001_a.put(\u2603 + 2, (byte)n2);
                this.field_179001_a.put(\u2603 + 3, (byte)n);
            }
        }
        this.func_181667_k();
        return this;
    }

    public void func_178981_a(int[] nArray) {
        this.func_181670_b(nArray.length * 4 + this.field_179011_q.func_177338_f());
        this.field_178999_b.position(this.func_181664_j());
        this.field_178999_b.put(nArray);
        this.field_178997_d += nArray.length / this.field_179011_q.func_181719_f();
    }

    public void func_181675_d() {
        ++this.field_178997_d;
        this.func_181670_b(this.field_179011_q.func_177338_f());
    }

    public BufferBuilder func_181662_b(double d, double d2, double d3) {
        int n = this.field_178997_d * this.field_179011_q.func_177338_f() + this.field_179011_q.func_181720_d(this.field_181678_g);
        switch (this.field_181677_f.func_177367_b()) {
            case FLOAT: {
                this.field_179001_a.putFloat(n, (float)(d + this.field_179004_l));
                this.field_179001_a.putFloat(n + 4, (float)(d2 + this.field_179005_m));
                this.field_179001_a.putFloat(n + 8, (float)(d3 + this.field_179002_n));
                break;
            }
            case UINT: 
            case INT: {
                this.field_179001_a.putInt(n, Float.floatToRawIntBits((float)(d + this.field_179004_l)));
                this.field_179001_a.putInt(n + 4, Float.floatToRawIntBits((float)(d2 + this.field_179005_m)));
                this.field_179001_a.putInt(n + 8, Float.floatToRawIntBits((float)(d3 + this.field_179002_n)));
                break;
            }
            case USHORT: 
            case SHORT: {
                this.field_179001_a.putShort(n, (short)(d + this.field_179004_l));
                this.field_179001_a.putShort(n + 2, (short)(d2 + this.field_179005_m));
                this.field_179001_a.putShort(n + 4, (short)(d3 + this.field_179002_n));
                break;
            }
            case UBYTE: 
            case BYTE: {
                this.field_179001_a.put(n, (byte)(d + this.field_179004_l));
                this.field_179001_a.put(n + 1, (byte)(d2 + this.field_179005_m));
                this.field_179001_a.put(n + 2, (byte)(d3 + this.field_179002_n));
            }
        }
        this.func_181667_k();
        return this;
    }

    public void func_178975_e(float f, float f2, float f3) {
        int n = (byte)(f * 127.0f) & 0xFF;
        \u2603 = (byte)(f2 * 127.0f) & 0xFF;
        \u2603 = (byte)(f3 * 127.0f) & 0xFF;
        \u2603 = n | \u2603 << 8 | \u2603 << 16;
        \u2603 = this.field_179011_q.func_177338_f() >> 2;
        \u2603 = (this.field_178997_d - 4) * \u2603 + this.field_179011_q.func_177342_c() / 4;
        this.field_178999_b.put(\u2603, \u2603);
        this.field_178999_b.put(\u2603 + \u2603, \u2603);
        this.field_178999_b.put(\u2603 + \u2603 * 2, \u2603);
        this.field_178999_b.put(\u2603 + \u2603 * 3, \u2603);
    }

    private void func_181667_k() {
        ++this.field_181678_g;
        this.field_181678_g %= this.field_179011_q.func_177345_h();
        this.field_181677_f = this.field_179011_q.func_177348_c(this.field_181678_g);
        if (this.field_181677_f.func_177375_c() == VertexFormatElement.Usage.PADDING) {
            this.func_181667_k();
        }
    }

    public BufferBuilder func_181663_c(float f, float f2, float f3) {
        int n = this.field_178997_d * this.field_179011_q.func_177338_f() + this.field_179011_q.func_181720_d(this.field_181678_g);
        switch (this.field_181677_f.func_177367_b()) {
            case FLOAT: {
                this.field_179001_a.putFloat(n, f);
                this.field_179001_a.putFloat(n + 4, f2);
                this.field_179001_a.putFloat(n + 8, f3);
                break;
            }
            case UINT: 
            case INT: {
                this.field_179001_a.putInt(n, (int)f);
                this.field_179001_a.putInt(n + 4, (int)f2);
                this.field_179001_a.putInt(n + 8, (int)f3);
                break;
            }
            case USHORT: 
            case SHORT: {
                this.field_179001_a.putShort(n, (short)((int)f * Short.MAX_VALUE & 0xFFFF));
                this.field_179001_a.putShort(n + 2, (short)((int)f2 * Short.MAX_VALUE & 0xFFFF));
                this.field_179001_a.putShort(n + 4, (short)((int)f3 * Short.MAX_VALUE & 0xFFFF));
                break;
            }
            case UBYTE: 
            case BYTE: {
                this.field_179001_a.put(n, (byte)((int)f * 127 & 0xFF));
                this.field_179001_a.put(n + 1, (byte)((int)f2 * 127 & 0xFF));
                this.field_179001_a.put(n + 2, (byte)((int)f3 * 127 & 0xFF));
            }
        }
        this.func_181667_k();
        return this;
    }

    public void func_178969_c(double d, double d2, double d3) {
        this.field_179004_l = d;
        this.field_179005_m = d2;
        this.field_179002_n = d3;
    }

    public void func_178977_d() {
        if (!this.field_179010_r) {
            throw new IllegalStateException("Not building!");
        }
        this.field_179010_r = false;
        this.field_179001_a.position(0);
        this.field_179001_a.limit(this.func_181664_j() * 4);
    }

    public ByteBuffer func_178966_f() {
        return this.field_179001_a;
    }

    public VertexFormat func_178973_g() {
        return this.field_179011_q;
    }

    public int func_178989_h() {
        return this.field_178997_d;
    }

    public int func_178979_i() {
        return this.field_179006_k;
    }

    public void func_178968_d(int n) {
        for (\u2603 = 0; \u2603 < 4; ++\u2603) {
            this.func_192836_a(n, \u2603 + 1);
        }
    }

    public void func_178990_f(float f, float f2, float f3) {
        for (int i = 0; i < 4; ++i) {
            this.func_178994_b(f, f2, f3, i + 1);
        }
    }

    public class State {
        private final int[] field_179019_b;
        private final VertexFormat field_179018_e;

        public State(int[] nArray, VertexFormat vertexFormat) {
            this.field_179019_b = nArray;
            this.field_179018_e = vertexFormat;
        }

        public int[] func_179013_a() {
            return this.field_179019_b;
        }

        public int func_179014_c() {
            return this.field_179019_b.length / this.field_179018_e.func_181719_f();
        }

        public VertexFormat func_179016_d() {
            return this.field_179018_e;
        }
    }
}

