/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.MapData;

public class FirstPersonRenderer {
    private static final ResourceLocation field_110931_c = new ResourceLocation("textures/map/map_background.png");
    private static final ResourceLocation field_110929_d = new ResourceLocation("textures/misc/underwater.png");
    private final Minecraft field_78455_a;
    private ItemStack field_187467_d = ItemStack.field_190927_a;
    private ItemStack field_187468_e = ItemStack.field_190927_a;
    private float field_187469_f;
    private float field_187470_g;
    private float field_187471_h;
    private float field_187472_i;
    private final EntityRendererManager field_178111_g;
    private final ItemRenderer field_178112_h;

    public FirstPersonRenderer(Minecraft minecraft) {
        this.field_78455_a = minecraft;
        this.field_178111_g = minecraft.func_175598_ae();
        this.field_178112_h = minecraft.func_175599_af();
    }

    public void func_178099_a(LivingEntity livingEntity, ItemStack itemStack, ItemCameraTransforms.TransformType transformType) {
        this.func_187462_a(livingEntity, itemStack, transformType, false);
    }

    public void func_187462_a(LivingEntity livingEntity, ItemStack itemStack, ItemCameraTransforms.TransformType transformType, boolean bl) {
        if (itemStack.func_190926_b()) {
            return;
        }
        Item item = itemStack.func_77973_b();
        Block \u26032 = Block.func_149634_a(item);
        GlStateManager.pushMatrix();
        boolean bl2 = \u2603 = this.field_178112_h.func_175050_a(itemStack) && \u26032.func_180664_k() == BlockRenderLayer.TRANSLUCENT;
        if (\u2603) {
            GlStateManager.depthMask(false);
        }
        this.field_178112_h.func_184392_a(itemStack, livingEntity, transformType, bl);
        if (\u2603) {
            GlStateManager.depthMask(true);
        }
        GlStateManager.popMatrix();
    }

    private void func_178101_a(float f, float f2) {
        GlStateManager.pushMatrix();
        GlStateManager.rotatef(f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotatef(f2, 0.0f, 1.0f, 0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.popMatrix();
    }

    private void func_187464_b() {
        ClientPlayerEntity clientPlayerEntity = this.field_78455_a.field_71439_g;
        int \u26032 = this.field_78455_a.field_71441_e.func_217338_b(new BlockPos(clientPlayerEntity.field_70165_t, clientPlayerEntity.field_70163_u + (double)clientPlayerEntity.func_70047_e(), clientPlayerEntity.field_70161_v), 0);
        float \u26033 = \u26032 & 0xFFFF;
        float \u26034 = \u26032 >> 16;
        GLX.glMultiTexCoord2f(GLX.GL_TEXTURE1, \u26033, \u26034);
    }

    private void func_187458_c(float f) {
        ClientPlayerEntity clientPlayerEntity = this.field_78455_a.field_71439_g;
        float \u26032 = MathHelper.func_219799_g(f, clientPlayerEntity.field_71164_i, clientPlayerEntity.field_71155_g);
        float \u26033 = MathHelper.func_219799_g(f, clientPlayerEntity.field_71163_h, clientPlayerEntity.field_71154_f);
        GlStateManager.rotatef((clientPlayerEntity.func_195050_f(f) - \u26032) * 0.1f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotatef((clientPlayerEntity.func_195046_g(f) - \u26033) * 0.1f, 0.0f, 1.0f, 0.0f);
    }

    private float func_178100_c(float f) {
        \u2603 = 1.0f - f / 45.0f + 0.1f;
        \u2603 = MathHelper.func_76131_a(\u2603, 0.0f, 1.0f);
        \u2603 = -MathHelper.func_76134_b(\u2603 * (float)Math.PI) * 0.5f + 0.5f;
        return \u2603;
    }

    private void func_187466_c() {
        if (this.field_78455_a.field_71439_g.func_82150_aj()) {
            return;
        }
        GlStateManager.disableCull();
        GlStateManager.pushMatrix();
        GlStateManager.rotatef(90.0f, 0.0f, 1.0f, 0.0f);
        this.func_187455_a(HandSide.RIGHT);
        this.func_187455_a(HandSide.LEFT);
        GlStateManager.popMatrix();
        GlStateManager.enableCull();
    }

    private void func_187455_a(HandSide handSide) {
        this.field_78455_a.func_110434_K().func_110577_a(this.field_78455_a.field_71439_g.func_110306_p());
        Object u = this.field_178111_g.func_78713_a(this.field_78455_a.field_71439_g);
        PlayerRenderer \u26032 = (PlayerRenderer)u;
        GlStateManager.pushMatrix();
        float \u26033 = handSide == HandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.rotatef(92.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotatef(45.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotatef(\u26033 * -41.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.translatef(\u26033 * 0.3f, -1.1f, 0.45f);
        if (handSide == HandSide.RIGHT) {
            \u26032.func_177138_b(this.field_78455_a.field_71439_g);
        } else {
            \u26032.func_177139_c(this.field_78455_a.field_71439_g);
        }
        GlStateManager.popMatrix();
    }

    private void func_187465_a(float f, HandSide handSide, float f2, ItemStack itemStack) {
        float f3 = handSide == HandSide.RIGHT ? 1.0f : -1.0f;
        GlStateManager.translatef(f3 * 0.125f, -0.125f, 0.0f);
        if (!this.field_78455_a.field_71439_g.func_82150_aj()) {
            GlStateManager.pushMatrix();
            GlStateManager.rotatef(f3 * 10.0f, 0.0f, 0.0f, 1.0f);
            this.func_187456_a(f, f2, handSide);
            GlStateManager.popMatrix();
        }
        GlStateManager.pushMatrix();
        GlStateManager.translatef(f3 * 0.51f, -0.08f + f * -1.2f, -0.75f);
        \u2603 = MathHelper.func_76129_c(f2);
        \u2603 = MathHelper.func_76126_a(\u2603 * (float)Math.PI);
        \u2603 = -0.5f * \u2603;
        \u2603 = 0.4f * MathHelper.func_76126_a(\u2603 * ((float)Math.PI * 2));
        \u2603 = -0.3f * MathHelper.func_76126_a(f2 * (float)Math.PI);
        GlStateManager.translatef(f3 * \u2603, \u2603 - 0.3f * \u2603, \u2603);
        GlStateManager.rotatef(\u2603 * -45.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotatef(f3 * \u2603 * -30.0f, 0.0f, 1.0f, 0.0f);
        this.func_187461_a(itemStack);
        GlStateManager.popMatrix();
    }

    private void func_187463_a(float f, float f2, float f3) {
        \u2603 = MathHelper.func_76129_c(f3);
        \u2603 = -0.2f * MathHelper.func_76126_a(f3 * (float)Math.PI);
        \u2603 = -0.4f * MathHelper.func_76126_a(\u2603 * (float)Math.PI);
        GlStateManager.translatef(0.0f, -\u2603 / 2.0f, \u2603);
        \u2603 = this.func_178100_c(f);
        GlStateManager.translatef(0.0f, 0.04f + f2 * -1.2f + \u2603 * -0.5f, -0.72f);
        GlStateManager.rotatef(\u2603 * -85.0f, 1.0f, 0.0f, 0.0f);
        this.func_187466_c();
        \u2603 = MathHelper.func_76126_a(\u2603 * (float)Math.PI);
        GlStateManager.rotatef(\u2603 * 20.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.scalef(2.0f, 2.0f, 2.0f);
        this.func_187461_a(this.field_187467_d);
    }

    private void func_187461_a(ItemStack itemStack) {
        GlStateManager.rotatef(180.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotatef(180.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.scalef(0.38f, 0.38f, 0.38f);
        GlStateManager.disableLighting();
        this.field_78455_a.func_110434_K().func_110577_a(field_110931_c);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        GlStateManager.translatef(-0.5f, -0.5f, 0.0f);
        GlStateManager.scalef(0.0078125f, 0.0078125f, 0.0078125f);
        \u26032.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u26032.func_181662_b(-7.0, 135.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        \u26032.func_181662_b(135.0, 135.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        \u26032.func_181662_b(135.0, -7.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        \u26032.func_181662_b(-7.0, -7.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        MapData \u26033 = FilledMapItem.func_195950_a(itemStack, this.field_78455_a.field_71441_e);
        if (\u26033 != null) {
            this.field_78455_a.field_71460_t.func_147701_i().func_148250_a(\u26033, false);
        }
        GlStateManager.enableLighting();
    }

    private void func_187456_a(float f, float f2, HandSide handSide) {
        boolean bl = handSide != HandSide.LEFT;
        float \u26032 = bl ? 1.0f : -1.0f;
        float \u26033 = MathHelper.func_76129_c(f2);
        float \u26034 = -0.3f * MathHelper.func_76126_a(\u26033 * (float)Math.PI);
        float \u26035 = 0.4f * MathHelper.func_76126_a(\u26033 * ((float)Math.PI * 2));
        float \u26036 = -0.4f * MathHelper.func_76126_a(f2 * (float)Math.PI);
        GlStateManager.translatef(\u26032 * (\u26034 + 0.64000005f), \u26035 + -0.6f + f * -0.6f, \u26036 + -0.71999997f);
        GlStateManager.rotatef(\u26032 * 45.0f, 0.0f, 1.0f, 0.0f);
        float \u26037 = MathHelper.func_76126_a(f2 * f2 * (float)Math.PI);
        float \u26038 = MathHelper.func_76126_a(\u26033 * (float)Math.PI);
        GlStateManager.rotatef(\u26032 * \u26038 * 70.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotatef(\u26032 * \u26037 * -20.0f, 0.0f, 0.0f, 1.0f);
        ClientPlayerEntity \u26039 = this.field_78455_a.field_71439_g;
        this.field_78455_a.func_110434_K().func_110577_a(\u26039.func_110306_p());
        GlStateManager.translatef(\u26032 * -1.0f, 3.6f, 3.5f);
        GlStateManager.rotatef(\u26032 * 120.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.rotatef(200.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotatef(\u26032 * -135.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.translatef(\u26032 * 5.6f, 0.0f, 0.0f);
        PlayerRenderer \u260310 = (PlayerRenderer)this.field_178111_g.func_78713_a(\u26039);
        GlStateManager.disableCull();
        if (bl) {
            \u260310.func_177138_b(\u26039);
        } else {
            \u260310.func_177139_c(\u26039);
        }
        GlStateManager.enableCull();
    }

    private void func_187454_a(float f, HandSide handSide, ItemStack itemStack) {
        float f2 = (float)this.field_78455_a.field_71439_g.func_184605_cv() - f + 1.0f;
        \u2603 = f2 / (float)itemStack.func_77988_m();
        if (\u2603 < 0.8f) {
            \u2603 = MathHelper.func_76135_e(MathHelper.func_76134_b(f2 / 4.0f * (float)Math.PI) * 0.1f);
            GlStateManager.translatef(0.0f, \u2603, 0.0f);
        }
        \u2603 = 1.0f - (float)Math.pow(\u2603, 27.0);
        int \u26032 = handSide == HandSide.RIGHT ? 1 : -1;
        GlStateManager.translatef(\u2603 * 0.6f * (float)\u26032, \u2603 * -0.5f, \u2603 * 0.0f);
        GlStateManager.rotatef((float)\u26032 * \u2603 * 90.0f, 0.0f, 1.0f, 0.0f);
        GlStateManager.rotatef(\u2603 * 10.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotatef((float)\u26032 * \u2603 * 30.0f, 0.0f, 0.0f, 1.0f);
    }

    private void func_187453_a(HandSide handSide, float f) {
        int n = handSide == HandSide.RIGHT ? 1 : -1;
        float \u26032 = MathHelper.func_76126_a(f * f * (float)Math.PI);
        GlStateManager.rotatef((float)n * (45.0f + \u26032 * -20.0f), 0.0f, 1.0f, 0.0f);
        float \u26033 = MathHelper.func_76126_a(MathHelper.func_76129_c(f) * (float)Math.PI);
        GlStateManager.rotatef((float)n * \u26033 * -20.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.rotatef(\u26033 * -80.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotatef((float)n * -45.0f, 0.0f, 1.0f, 0.0f);
    }

    private void func_187459_b(HandSide handSide, float f) {
        int n = handSide == HandSide.RIGHT ? 1 : -1;
        GlStateManager.translatef((float)n * 0.56f, -0.52f + f * -0.6f, -0.72f);
    }

    public void func_78440_a(float f) {
        ItemStack \u26038;
        ClientPlayerEntity clientPlayerEntity = this.field_78455_a.field_71439_g;
        float \u26032 = clientPlayerEntity.func_70678_g(f);
        Hand \u26033 = (Hand)((Object)MoreObjects.firstNonNull((Object)((Object)clientPlayerEntity.field_184622_au), (Object)((Object)Hand.MAIN_HAND)));
        float \u26034 = MathHelper.func_219799_g(f, clientPlayerEntity.field_70127_C, clientPlayerEntity.field_70125_A);
        float \u26035 = MathHelper.func_219799_g(f, clientPlayerEntity.field_70126_B, clientPlayerEntity.field_70177_z);
        boolean \u26036 = true;
        boolean \u26037 = true;
        if (((LivingEntity)clientPlayerEntity).func_184587_cr()) {
            \u26038 = clientPlayerEntity.func_184607_cu();
            if (\u26038.func_77973_b() == Items.field_151031_f || \u26038.func_77973_b() == Items.field_222114_py) {
                \u26036 = ((LivingEntity)clientPlayerEntity).func_184600_cs() == Hand.MAIN_HAND;
                boolean bl = \u26037 = !\u26036;
            }
            if ((\u26039 = ((LivingEntity)clientPlayerEntity).func_184600_cs()) == Hand.MAIN_HAND && (\u2603 = clientPlayerEntity.func_184592_cb()).func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d(\u2603)) {
                \u26037 = false;
            }
        } else {
            \u26038 = clientPlayerEntity.func_184614_ca();
            Object \u26039 = clientPlayerEntity.func_184592_cb();
            if (\u26038.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d(\u26038)) {
                boolean bl = \u26037 = !\u26036;
            }
            if (\u26039.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d(\u26039)) {
                \u26036 = !\u26038.func_190926_b();
                \u26037 = !\u26036;
            }
        }
        this.func_178101_a(\u26034, \u26035);
        this.func_187464_b();
        this.func_187458_c(f);
        GlStateManager.enableRescaleNormal();
        if (\u26036) {
            float \u260310 = \u26033 == Hand.MAIN_HAND ? \u26032 : 0.0f;
            float \u260311 = 1.0f - MathHelper.func_219799_g(f, this.field_187470_g, this.field_187469_f);
            this.func_187457_a(clientPlayerEntity, f, \u26034, Hand.MAIN_HAND, \u260310, this.field_187467_d, \u260311);
        }
        if (\u26037) {
            float \u260312 = \u26033 == Hand.OFF_HAND ? \u26032 : 0.0f;
            float \u260313 = 1.0f - MathHelper.func_219799_g(f, this.field_187472_i, this.field_187471_h);
            this.func_187457_a(clientPlayerEntity, f, \u26034, Hand.OFF_HAND, \u260312, this.field_187468_e, \u260313);
        }
        GlStateManager.disableRescaleNormal();
        RenderHelper.func_74518_a();
    }

    public void func_187457_a(AbstractClientPlayerEntity abstractClientPlayerEntity2, float f, float f2, Hand hand, float f32, ItemStack itemStack, float f42) {
        AbstractClientPlayerEntity abstractClientPlayerEntity2;
        float f32;
        boolean bl = hand == Hand.MAIN_HAND;
        HandSide \u26032 = bl ? abstractClientPlayerEntity2.func_184591_cq() : abstractClientPlayerEntity2.func_184591_cq().func_188468_a();
        GlStateManager.pushMatrix();
        if (itemStack.func_190926_b()) {
            if (bl && !abstractClientPlayerEntity2.func_82150_aj()) {
                this.func_187456_a(f42, f32, \u26032);
            }
        } else if (itemStack.func_77973_b() == Items.field_151098_aY) {
            if (bl && this.field_187468_e.func_190926_b()) {
                this.func_187463_a(f2, f42, f32);
            } else {
                this.func_187465_a(f42, \u26032, f32, itemStack);
            }
        } else if (itemStack.func_77973_b() == Items.field_222114_py) {
            \u2603 = CrossbowItem.func_220012_d(itemStack);
            \u2603 = \u26032 == HandSide.RIGHT;
            int n = \u2603 = \u2603 ? 1 : -1;
            if (abstractClientPlayerEntity2.func_184587_cr() && abstractClientPlayerEntity2.func_184605_cv() > 0 && abstractClientPlayerEntity2.func_184600_cs() == hand) {
                this.func_187459_b(\u26032, f42);
                GlStateManager.translatef((float)\u2603 * -0.4785682f, -0.094387f, 0.05731531f);
                GlStateManager.rotatef(-11.935f, 1.0f, 0.0f, 0.0f);
                GlStateManager.rotatef((float)\u2603 * 65.3f, 0.0f, 1.0f, 0.0f);
                GlStateManager.rotatef((float)\u2603 * -9.785f, 0.0f, 0.0f, 1.0f);
                float f5 = (float)itemStack.func_77988_m() - ((float)this.field_78455_a.field_71439_g.func_184605_cv() - f + 1.0f);
                \u2603 = f5 / (float)CrossbowItem.func_220026_e(itemStack);
                if (\u2603 > 1.0f) {
                    \u2603 = 1.0f;
                }
                if (\u2603 > 0.1f) {
                    \u2603 = MathHelper.func_76126_a((f5 - 0.1f) * 1.3f);
                    \u2603 = \u2603 - 0.1f;
                    \u2603 = \u2603 * \u2603;
                    GlStateManager.translatef(\u2603 * 0.0f, \u2603 * 0.004f, \u2603 * 0.0f);
                }
                GlStateManager.translatef(\u2603 * 0.0f, \u2603 * 0.0f, \u2603 * 0.04f);
                GlStateManager.scalef(1.0f, 1.0f, 1.0f + \u2603 * 0.2f);
                GlStateManager.rotatef((float)\u2603 * 45.0f, 0.0f, -1.0f, 0.0f);
            } else {
                \u2603 = -0.4f * MathHelper.func_76126_a(MathHelper.func_76129_c(f32) * (float)Math.PI);
                \u2603 = 0.2f * MathHelper.func_76126_a(MathHelper.func_76129_c(f32) * ((float)Math.PI * 2));
                \u2603 = -0.2f * MathHelper.func_76126_a(f32 * (float)Math.PI);
                GlStateManager.translatef((float)\u2603 * \u2603, \u2603, \u2603);
                this.func_187459_b(\u26032, f42);
                this.func_187453_a(\u26032, f32);
                if (\u2603 && f32 < 0.001f) {
                    GlStateManager.translatef((float)\u2603 * -0.641864f, 0.0f, 0.0f);
                    GlStateManager.rotatef((float)\u2603 * 10.0f, 0.0f, 1.0f, 0.0f);
                }
            }
            this.func_187462_a(abstractClientPlayerEntity2, itemStack, \u2603 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !\u2603);
        } else {
            boolean bl2;
            boolean bl3 = bl2 = \u26032 == HandSide.RIGHT;
            if (abstractClientPlayerEntity2.func_184587_cr() && abstractClientPlayerEntity2.func_184605_cv() > 0 && abstractClientPlayerEntity2.func_184600_cs() == hand) {
                int n = bl2 ? 1 : -1;
                switch (itemStack.func_77975_n()) {
                    case NONE: {
                        this.func_187459_b(\u26032, f42);
                        break;
                    }
                    case EAT: 
                    case DRINK: {
                        this.func_187454_a(f, \u26032, itemStack);
                        this.func_187459_b(\u26032, f42);
                        break;
                    }
                    case BLOCK: {
                        this.func_187459_b(\u26032, f42);
                        break;
                    }
                    case BOW: {
                        this.func_187459_b(\u26032, f42);
                        GlStateManager.translatef((float)n * -0.2785682f, 0.18344387f, 0.15731531f);
                        GlStateManager.rotatef(-13.935f, 1.0f, 0.0f, 0.0f);
                        GlStateManager.rotatef((float)n * 35.3f, 0.0f, 1.0f, 0.0f);
                        GlStateManager.rotatef((float)n * -9.785f, 0.0f, 0.0f, 1.0f);
                        float f6 = (float)itemStack.func_77988_m() - ((float)this.field_78455_a.field_71439_g.func_184605_cv() - f + 1.0f);
                        \u2603 = f6 / 20.0f;
                        \u2603 = (\u2603 * \u2603 + \u2603 * 2.0f) / 3.0f;
                        if (\u2603 > 1.0f) {
                            \u2603 = 1.0f;
                        }
                        if (\u2603 > 0.1f) {
                            \u2603 = MathHelper.func_76126_a((f6 - 0.1f) * 1.3f);
                            \u2603 = \u2603 - 0.1f;
                            \u2603 = \u2603 * \u2603;
                            GlStateManager.translatef(\u2603 * 0.0f, \u2603 * 0.004f, \u2603 * 0.0f);
                        }
                        GlStateManager.translatef(\u2603 * 0.0f, \u2603 * 0.0f, \u2603 * 0.04f);
                        GlStateManager.scalef(1.0f, 1.0f, 1.0f + \u2603 * 0.2f);
                        GlStateManager.rotatef((float)n * 45.0f, 0.0f, -1.0f, 0.0f);
                        break;
                    }
                    case SPEAR: {
                        float f42;
                        this.func_187459_b(\u26032, f42);
                        GlStateManager.translatef((float)n * -0.5f, 0.7f, 0.1f);
                        GlStateManager.rotatef(-55.0f, 1.0f, 0.0f, 0.0f);
                        GlStateManager.rotatef((float)n * 35.3f, 0.0f, 1.0f, 0.0f);
                        GlStateManager.rotatef((float)n * -9.785f, 0.0f, 0.0f, 1.0f);
                        \u2603 = (float)itemStack.func_77988_m() - ((float)this.field_78455_a.field_71439_g.func_184605_cv() - f + 1.0f);
                        \u2603 = \u2603 / 10.0f;
                        if (\u2603 > 1.0f) {
                            \u2603 = 1.0f;
                        }
                        if (\u2603 > 0.1f) {
                            \u2603 = MathHelper.func_76126_a((\u2603 - 0.1f) * 1.3f);
                            \u2603 = \u2603 - 0.1f;
                            \u2603 = \u2603 * \u2603;
                            GlStateManager.translatef(\u2603 * 0.0f, \u2603 * 0.004f, \u2603 * 0.0f);
                        }
                        GlStateManager.translatef(0.0f, 0.0f, \u2603 * 0.2f);
                        GlStateManager.scalef(1.0f, 1.0f, 1.0f + \u2603 * 0.2f);
                        GlStateManager.rotatef((float)n * 45.0f, 0.0f, -1.0f, 0.0f);
                        break;
                    }
                }
            } else if (abstractClientPlayerEntity2.func_204805_cN()) {
                this.func_187459_b(\u26032, f42);
                int n = bl2 ? 1 : -1;
                GlStateManager.translatef((float)n * -0.4f, 0.8f, 0.3f);
                GlStateManager.rotatef((float)n * 65.0f, 0.0f, 1.0f, 0.0f);
                GlStateManager.rotatef((float)n * -85.0f, 0.0f, 0.0f, 1.0f);
            } else {
                \u2603 = -0.4f * MathHelper.func_76126_a(MathHelper.func_76129_c(f32) * (float)Math.PI);
                \u2603 = 0.2f * MathHelper.func_76126_a(MathHelper.func_76129_c(f32) * ((float)Math.PI * 2));
                \u2603 = -0.2f * MathHelper.func_76126_a(f32 * (float)Math.PI);
                int \u26033 = bl2 ? 1 : -1;
                GlStateManager.translatef((float)\u26033 * \u2603, \u2603, \u2603);
                this.func_187459_b(\u26032, f42);
                this.func_187453_a(\u26032, f32);
            }
            this.func_187462_a(abstractClientPlayerEntity2, itemStack, bl2 ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !bl2);
        }
        GlStateManager.popMatrix();
    }

    public void func_78447_b(float f) {
        GlStateManager.disableAlphaTest();
        if (this.field_78455_a.field_71439_g.func_70094_T()) {
            BlockState \u26035 = this.field_78455_a.field_71441_e.func_180495_p(new BlockPos(this.field_78455_a.field_71439_g));
            ClientPlayerEntity \u26032 = this.field_78455_a.field_71439_g;
            for (int i = 0; i < 8; ++i) {
                double d = \u26032.field_70165_t + (double)(((float)((i >> 0) % 2) - 0.5f) * \u26032.func_213311_cf() * 0.8f);
                \u2603 = \u26032.field_70163_u + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
                \u2603 = \u26032.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * \u26032.func_213311_cf() * 0.8f);
                BlockPos \u26033 = new BlockPos(d, \u2603 + (double)\u26032.func_70047_e(), \u2603);
                BlockState \u26034 = this.field_78455_a.field_71441_e.func_180495_p(\u26033);
                if (!\u26034.func_215696_m(this.field_78455_a.field_71441_e, \u26033)) continue;
                \u26035 = \u26034;
            }
            if (\u26035.func_185901_i() != BlockRenderType.INVISIBLE) {
                this.func_178108_a(this.field_78455_a.func_175602_ab().func_175023_a().func_178122_a(\u26035));
            }
        }
        if (!this.field_78455_a.field_71439_g.func_175149_v()) {
            if (this.field_78455_a.field_71439_g.func_208600_a(FluidTags.field_206959_a)) {
                this.func_78448_c(f);
            }
            if (this.field_78455_a.field_71439_g.func_70027_ad()) {
                this.func_78442_d();
            }
        }
        GlStateManager.enableAlphaTest();
    }

    private void func_178108_a(TextureAtlasSprite textureAtlasSprite) {
        this.field_78455_a.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        float \u26033 = 0.1f;
        GlStateManager.color4f(0.1f, 0.1f, 0.1f, 0.5f);
        GlStateManager.pushMatrix();
        float \u26034 = -1.0f;
        float \u26035 = 1.0f;
        float \u26036 = -1.0f;
        float \u26037 = 1.0f;
        float \u26038 = -0.5f;
        float \u26039 = textureAtlasSprite.func_94209_e();
        float \u260310 = textureAtlasSprite.func_94212_f();
        float \u260311 = textureAtlasSprite.func_94206_g();
        float \u260312 = textureAtlasSprite.func_94210_h();
        \u26032.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u26032.func_181662_b(-1.0, -1.0, -0.5).func_187315_a(\u260310, \u260312).func_181675_d();
        \u26032.func_181662_b(1.0, -1.0, -0.5).func_187315_a(\u26039, \u260312).func_181675_d();
        \u26032.func_181662_b(1.0, 1.0, -0.5).func_187315_a(\u26039, \u260311).func_181675_d();
        \u26032.func_181662_b(-1.0, 1.0, -0.5).func_187315_a(\u260310, \u260311).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.popMatrix();
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void func_78448_c(float f) {
        this.field_78455_a.func_110434_K().func_110577_a(field_110929_d);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        float \u26033 = this.field_78455_a.field_71439_g.func_70013_c();
        GlStateManager.color4f(\u26033, \u26033, \u26033, 0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        float \u26034 = 4.0f;
        float \u26035 = -1.0f;
        float \u26036 = 1.0f;
        float \u26037 = -1.0f;
        float \u26038 = 1.0f;
        float \u26039 = -0.5f;
        float \u260310 = -this.field_78455_a.field_71439_g.field_70177_z / 64.0f;
        float \u260311 = this.field_78455_a.field_71439_g.field_70125_A / 64.0f;
        \u26032.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        \u26032.func_181662_b(-1.0, -1.0, -0.5).func_187315_a(4.0f + \u260310, 4.0f + \u260311).func_181675_d();
        \u26032.func_181662_b(1.0, -1.0, -0.5).func_187315_a(0.0f + \u260310, 4.0f + \u260311).func_181675_d();
        \u26032.func_181662_b(1.0, 1.0, -0.5).func_187315_a(0.0f + \u260310, 0.0f + \u260311).func_181675_d();
        \u26032.func_181662_b(-1.0, 1.0, -0.5).func_187315_a(4.0f + \u260310, 0.0f + \u260311).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.popMatrix();
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
    }

    private void func_78442_d() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 0.9f);
        GlStateManager.depthFunc(519);
        GlStateManager.depthMask(false);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        float \u26033 = 1.0f;
        for (int i = 0; i < 2; ++i) {
            GlStateManager.pushMatrix();
            TextureAtlasSprite textureAtlasSprite = this.field_78455_a.func_147117_R().func_195424_a(ModelBakery.field_207764_b);
            this.field_78455_a.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            float \u26034 = textureAtlasSprite.func_94209_e();
            float \u26035 = textureAtlasSprite.func_94212_f();
            float \u26036 = textureAtlasSprite.func_94206_g();
            float \u26037 = textureAtlasSprite.func_94210_h();
            float \u26038 = -0.5f;
            float \u26039 = 0.5f;
            float \u260310 = -0.5f;
            float \u260311 = 0.5f;
            float \u260312 = -0.5f;
            GlStateManager.translatef((float)(-(i * 2 - 1)) * 0.24f, -0.3f, 0.0f);
            GlStateManager.rotatef((float)(i * 2 - 1) * 10.0f, 0.0f, 1.0f, 0.0f);
            \u26032.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            \u26032.func_181662_b(-0.5, -0.5, -0.5).func_187315_a(\u26035, \u26037).func_181675_d();
            \u26032.func_181662_b(0.5, -0.5, -0.5).func_187315_a(\u26034, \u26037).func_181675_d();
            \u26032.func_181662_b(0.5, 0.5, -0.5).func_187315_a(\u26034, \u26036).func_181675_d();
            \u26032.func_181662_b(-0.5, 0.5, -0.5).func_187315_a(\u26035, \u26036).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
        }
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
        GlStateManager.depthMask(true);
        GlStateManager.depthFunc(515);
    }

    public void func_78441_a() {
        this.field_187470_g = this.field_187469_f;
        this.field_187472_i = this.field_187471_h;
        ClientPlayerEntity clientPlayerEntity = this.field_78455_a.field_71439_g;
        ItemStack \u26032 = clientPlayerEntity.func_184614_ca();
        ItemStack \u26033 = clientPlayerEntity.func_184592_cb();
        if (clientPlayerEntity.func_184838_M()) {
            this.field_187469_f = MathHelper.func_76131_a(this.field_187469_f - 0.4f, 0.0f, 1.0f);
            this.field_187471_h = MathHelper.func_76131_a(this.field_187471_h - 0.4f, 0.0f, 1.0f);
        } else {
            float f = clientPlayerEntity.func_184825_o(1.0f);
            this.field_187469_f += MathHelper.func_76131_a((Objects.equals(this.field_187467_d, \u26032) ? f * f * f : 0.0f) - this.field_187469_f, -0.4f, 0.4f);
            this.field_187471_h += MathHelper.func_76131_a((float)(Objects.equals(this.field_187468_e, \u26033) ? 1 : 0) - this.field_187471_h, -0.4f, 0.4f);
        }
        if (this.field_187469_f < 0.1f) {
            this.field_187467_d = \u26032;
        }
        if (this.field_187471_h < 0.1f) {
            this.field_187468_e = \u26033;
        }
    }

    public void func_187460_a(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            this.field_187469_f = 0.0f;
        } else {
            this.field_187471_h = 0.0f;
        }
    }
}

