/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.primitives.Doubles;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.VertexBufferUploader;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.ChunkRenderWorker;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.ListedChunkRender;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.Util;
import net.minecraft.util.math.Vec3d;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkRenderDispatcher {
    private static final Logger field_178523_a = LogManager.getLogger();
    private static final ThreadFactory field_178521_b = new ThreadFactoryBuilder().setNameFormat("Chunk Batcher %d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_178523_a)).build();
    private final int field_188249_c;
    private final List<Thread> field_188250_d = Lists.newArrayList();
    private final List<ChunkRenderWorker> field_178522_c = Lists.newArrayList();
    private final PriorityBlockingQueue<ChunkRenderTask> field_178519_d = Queues.newPriorityBlockingQueue();
    private final BlockingQueue<RegionRenderCacheBuilder> field_178520_e;
    private final WorldVertexBufferUploader field_178517_f = new WorldVertexBufferUploader();
    private final VertexBufferUploader field_178518_g = new VertexBufferUploader();
    private final Queue<PendingUpload> field_178524_h = Queues.newPriorityQueue();
    private final ChunkRenderWorker field_178525_i;
    private Vec3d field_217672_l = Vec3d.field_186680_a;

    public ChunkRenderDispatcher(boolean bl) {
        int n = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / 0xA00000 - 1);
        \u2603 = Runtime.getRuntime().availableProcessors();
        \u2603 = bl ? \u2603 : Math.min(\u2603, 4);
        \u2603 = Math.max(1, Math.min(\u2603 * 2, n));
        this.field_178525_i = new ChunkRenderWorker(this, new RegionRenderCacheBuilder());
        ArrayList \u26032 = Lists.newArrayListWithExpectedSize((int)\u2603);
        try {
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                \u26032.add(new RegionRenderCacheBuilder());
            }
        }
        catch (OutOfMemoryError \u26033) {
            field_178523_a.warn("Allocated only {}/{} buffers", (Object)\u26032.size(), (Object)\u2603);
            \u2603 = \u26032.size() * 2 / 3;
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                \u26032.remove(\u26032.size() - 1);
            }
            System.gc();
        }
        this.field_188249_c = \u26032.size();
        this.field_178520_e = Queues.newArrayBlockingQueue((int)this.field_188249_c);
        this.field_178520_e.addAll(\u26032);
        \u2603 = Math.min(\u2603, this.field_188249_c);
        if (\u2603 > 1) {
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                ChunkRenderWorker chunkRenderWorker = new ChunkRenderWorker(this);
                Thread \u26034 = field_178521_b.newThread(chunkRenderWorker);
                \u26034.start();
                this.field_178522_c.add(chunkRenderWorker);
                this.field_188250_d.add(\u26034);
            }
        }
    }

    public String func_178504_a() {
        if (this.field_188250_d.isEmpty()) {
            return String.format("pC: %03d, single-threaded", this.field_178519_d.size());
        }
        return String.format("pC: %03d, pU: %02d, aB: %02d", this.field_178519_d.size(), this.field_178524_h.size(), this.field_178520_e.size());
    }

    public void func_217669_a(Vec3d vec3d) {
        this.field_217672_l = vec3d;
    }

    public Vec3d func_217671_b() {
        return this.field_217672_l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178516_a(long l) {
        boolean bl = false;
        do {
            bl2 = false;
            if (this.field_188250_d.isEmpty() && (\u2603 = this.field_178519_d.poll()) != null) {
                try {
                    this.field_178525_i.func_178474_a(\u2603);
                    bl2 = true;
                }
                catch (InterruptedException interruptedException) {
                    field_178523_a.warn("Skipped task due to interrupt");
                }
            }
            int n = 0;
            Queue<PendingUpload> queue = this.field_178524_h;
            synchronized (queue) {
                while (n < 10 && (\u2603 = this.field_178524_h.poll()) != null) {
                    if (\u2603.field_188241_b.isDone()) continue;
                    \u2603.field_188241_b.run();
                    boolean bl2 = true;
                    bl = true;
                    ++n;
                }
            }
        } while (l != 0L && bl2 && l >= Util.func_211178_c());
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178507_a(ChunkRender chunkRender) {
        chunkRender.func_178579_c().lock();
        try {
            ChunkRenderTask chunkRenderTask = chunkRender.func_178574_d();
            chunkRenderTask.func_178539_a(() -> this.field_178519_d.remove(chunkRenderTask));
            boolean \u26032 = this.field_178519_d.offer(chunkRenderTask);
            if (!\u26032) {
                chunkRenderTask.func_178542_e();
            }
            boolean bl = \u26032;
            return bl;
        }
        finally {
            chunkRender.func_178579_c().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178505_b(ChunkRender chunkRender2) {
        chunkRender2.func_178579_c().lock();
        try {
            ChunkRenderTask chunkRenderTask = chunkRender2.func_178574_d();
            try {
                this.field_178525_i.func_178474_a(chunkRenderTask);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ChunkRender chunkRender2;
            chunkRender2.func_178579_c().unlock();
        }
    }

    public void func_178514_b() {
        this.func_178513_e();
        ArrayList arrayList = Lists.newArrayList();
        while (arrayList.size() != this.field_188249_c) {
            this.func_178516_a(Long.MAX_VALUE);
            try {
                arrayList.add(this.func_178515_c());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.field_178520_e.addAll(arrayList);
    }

    public void func_178512_a(RegionRenderCacheBuilder regionRenderCacheBuilder) {
        this.field_178520_e.add(regionRenderCacheBuilder);
    }

    public RegionRenderCacheBuilder func_178515_c() throws InterruptedException {
        return this.field_178520_e.take();
    }

    public ChunkRenderTask func_178511_d() throws InterruptedException {
        return this.field_178519_d.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178509_c(ChunkRender chunkRender2) {
        chunkRender2.func_178579_c().lock();
        try {
            ChunkRenderTask chunkRenderTask = chunkRender2.func_178582_e();
            if (chunkRenderTask != null) {
                chunkRenderTask.func_178539_a(() -> this.field_178519_d.remove(chunkRenderTask));
                boolean bl = this.field_178519_d.offer(chunkRenderTask);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            ChunkRender chunkRender2;
            chunkRender2.func_178579_c().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Void> func_188245_a(BlockRenderLayer blockRenderLayer, BufferBuilder bufferBuilder, ChunkRender chunkRender, CompiledChunk compiledChunk, double d) {
        if (Minecraft.func_71410_x().func_213162_bc()) {
            if (GLX.useVbo()) {
                this.func_178506_a(bufferBuilder, chunkRender.func_178565_b(blockRenderLayer.ordinal()));
            } else {
                this.func_217670_a(bufferBuilder, ((ListedChunkRender)chunkRender).func_178600_a(blockRenderLayer, compiledChunk));
            }
            bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
            return Futures.immediateFuture(null);
        }
        ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(() -> this.func_188245_a(blockRenderLayer, bufferBuilder, chunkRender, compiledChunk, d), null);
        Queue<PendingUpload> queue = this.field_178524_h;
        synchronized (queue) {
            this.field_178524_h.add(new PendingUpload((ListenableFutureTask<Void>)listenableFutureTask, d));
        }
        return listenableFutureTask;
    }

    private void func_217670_a(BufferBuilder bufferBuilder, int n) {
        GlStateManager.newList(n, 4864);
        this.field_178517_f.func_181679_a(bufferBuilder);
        GlStateManager.endList();
    }

    private void func_178506_a(BufferBuilder bufferBuilder, VertexBuffer vertexBuffer) {
        this.field_178518_g.func_178178_a(vertexBuffer);
        this.field_178518_g.func_181679_a(bufferBuilder);
    }

    public void func_178513_e() {
        while (!this.field_178519_d.isEmpty()) {
            ChunkRenderTask chunkRenderTask = this.field_178519_d.poll();
            if (chunkRenderTask == null) continue;
            chunkRenderTask.func_178542_e();
        }
    }

    public boolean func_188247_f() {
        return this.field_178519_d.isEmpty() && this.field_178524_h.isEmpty();
    }

    public void func_188244_g() {
        this.func_178513_e();
        for (ChunkRenderWorker chunkRenderWorker : this.field_178522_c) {
            chunkRenderWorker.func_188264_a();
        }
        for (Thread thread : this.field_188250_d) {
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                field_178523_a.warn("Interrupted whilst waiting for worker to die", (Throwable)interruptedException);
            }
        }
        this.field_178520_e.clear();
    }

    class PendingUpload
    implements Comparable<PendingUpload> {
        private final ListenableFutureTask<Void> field_188241_b;
        private final double field_188242_c;

        public PendingUpload(ListenableFutureTask<Void> listenableFutureTask, double d) {
            this.field_188241_b = listenableFutureTask;
            this.field_188242_c = d;
        }

        @Override
        public int compareTo(PendingUpload pendingUpload) {
            return Doubles.compare((double)this.field_188242_c, (double)pendingUpload.field_188242_c);
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.compareTo((PendingUpload)object);
        }
    }
}

