/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.chunk.ChunkRender;
import net.minecraft.client.renderer.chunk.ChunkRenderCache;
import net.minecraft.client.renderer.chunk.CompiledChunk;

public class ChunkRenderTask
implements Comparable<ChunkRenderTask> {
    private final ChunkRender field_178553_a;
    private final ReentrantLock field_178551_b = new ReentrantLock();
    private final List<Runnable> field_178552_c = Lists.newArrayList();
    private final Type field_178549_d;
    private final double field_188229_e;
    @Nullable
    private ChunkRenderCache field_217668_f;
    private RegionRenderCacheBuilder field_178550_e;
    private CompiledChunk field_178547_f;
    private Status field_178548_g = Status.PENDING;
    private boolean field_178554_h;

    public ChunkRenderTask(ChunkRender chunkRender, Type type, double d, @Nullable ChunkRenderCache chunkRenderCache) {
        this.field_178553_a = chunkRender;
        this.field_178549_d = type;
        this.field_188229_e = d;
        this.field_217668_f = chunkRenderCache;
    }

    public Status func_178546_a() {
        return this.field_178548_g;
    }

    public ChunkRender func_178536_b() {
        return this.field_178553_a;
    }

    @Nullable
    public ChunkRenderCache func_217667_c() {
        ChunkRenderCache chunkRenderCache = this.field_217668_f;
        this.field_217668_f = null;
        return chunkRenderCache;
    }

    public CompiledChunk func_178544_c() {
        return this.field_178547_f;
    }

    public void func_178543_a(CompiledChunk compiledChunk) {
        this.field_178547_f = compiledChunk;
    }

    public RegionRenderCacheBuilder func_178545_d() {
        return this.field_178550_e;
    }

    public void func_178541_a(RegionRenderCacheBuilder regionRenderCacheBuilder) {
        this.field_178550_e = regionRenderCacheBuilder;
    }

    public void func_178535_a(Status status) {
        this.field_178551_b.lock();
        try {
            this.field_178548_g = status;
        }
        finally {
            this.field_178551_b.unlock();
        }
    }

    public void func_178542_e() {
        this.field_178551_b.lock();
        try {
            this.field_217668_f = null;
            if (this.field_178549_d == Type.REBUILD_CHUNK && this.field_178548_g != Status.DONE) {
                this.field_178553_a.func_178575_a(false);
            }
            this.field_178554_h = true;
            this.field_178548_g = Status.DONE;
            for (Runnable runnable : this.field_178552_c) {
                runnable.run();
            }
        }
        finally {
            this.field_178551_b.unlock();
        }
    }

    public void func_178539_a(Runnable runnable) {
        this.field_178551_b.lock();
        try {
            this.field_178552_c.add(runnable);
            if (this.field_178554_h) {
                runnable.run();
            }
        }
        finally {
            this.field_178551_b.unlock();
        }
    }

    public ReentrantLock func_178540_f() {
        return this.field_178551_b;
    }

    public Type func_178538_g() {
        return this.field_178549_d;
    }

    public boolean func_178537_h() {
        return this.field_178554_h;
    }

    @Override
    public int compareTo(ChunkRenderTask chunkRenderTask) {
        return Doubles.compare((double)this.field_188229_e, (double)chunkRenderTask.field_188229_e);
    }

    public double func_188228_i() {
        return this.field_188229_e;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((ChunkRenderTask)object);
    }

    public static enum Status {
        PENDING,
        COMPILING,
        UPLOADING,
        DONE;

    }

    public static enum Type {
        REBUILD_CHUNK,
        RESORT_TRANSPARENCY;

    }
}

