/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.Vec3d;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkRenderWorker
implements Runnable {
    private static final Logger field_152478_a = LogManager.getLogger();
    private final ChunkRenderDispatcher field_178477_b;
    private final RegionRenderCacheBuilder field_178478_c;
    private boolean field_188265_d = true;

    public ChunkRenderWorker(ChunkRenderDispatcher chunkRenderDispatcher) {
        this(chunkRenderDispatcher, null);
    }

    public ChunkRenderWorker(ChunkRenderDispatcher chunkRenderDispatcher, @Nullable RegionRenderCacheBuilder regionRenderCacheBuilder) {
        this.field_178477_b = chunkRenderDispatcher;
        this.field_178478_c = regionRenderCacheBuilder;
    }

    @Override
    public void run() {
        while (this.field_188265_d) {
            try {
                this.func_178474_a(this.field_178477_b.func_178511_d());
            }
            catch (InterruptedException interruptedException) {
                field_152478_a.debug("Stopping chunk worker due to interrupt");
                return;
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Batching chunks");
                Minecraft.func_71410_x().func_71404_a(Minecraft.func_71410_x().func_71396_d(crashReport));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void func_178474_a(final ChunkRenderTask chunkRenderTask2) throws InterruptedException {
        chunkRenderTask2.func_178540_f().lock();
        try {
            if (!ChunkRenderWorker.func_223453_b(chunkRenderTask2, ChunkRenderTask.Status.PENDING)) {
                return;
            }
            if (!chunkRenderTask2.func_178536_b().func_217674_b()) {
                chunkRenderTask2.func_178542_e();
                return;
            }
            chunkRenderTask2.func_178535_a(ChunkRenderTask.Status.COMPILING);
        }
        finally {
            chunkRenderTask2.func_178540_f().unlock();
        }
        final RegionRenderCacheBuilder regionRenderCacheBuilder = this.func_178475_b();
        chunkRenderTask2.func_178540_f().lock();
        try {
            if (!ChunkRenderWorker.func_223453_b(chunkRenderTask2, ChunkRenderTask.Status.COMPILING)) {
                this.func_223450_a(regionRenderCacheBuilder);
                return;
            }
        }
        finally {
            chunkRenderTask2.func_178540_f().unlock();
        }
        chunkRenderTask2.func_178541_a(regionRenderCacheBuilder);
        Vec3d \u26032 = this.field_178477_b.func_217671_b();
        float \u26033 = (float)\u26032.field_72450_a;
        float \u26034 = (float)\u26032.field_72448_b;
        float \u26035 = (float)\u26032.field_72449_c;
        ChunkRenderTask.Type \u26036 = chunkRenderTask2.func_178538_g();
        if (\u26036 == ChunkRenderTask.Type.REBUILD_CHUNK) {
            chunkRenderTask2.func_178536_b().func_178581_b(\u26033, \u26034, \u26035, chunkRenderTask2);
        } else if (\u26036 == ChunkRenderTask.Type.RESORT_TRANSPARENCY) {
            chunkRenderTask2.func_178536_b().func_178570_a(\u26033, \u26034, \u26035, chunkRenderTask2);
        }
        chunkRenderTask2.func_178540_f().lock();
        try {
            if (!ChunkRenderWorker.func_223453_b(chunkRenderTask2, ChunkRenderTask.Status.COMPILING)) {
                this.func_223450_a(regionRenderCacheBuilder);
                return;
            }
            chunkRenderTask2.func_178535_a(ChunkRenderTask.Status.UPLOADING);
        }
        finally {
            chunkRenderTask2.func_178540_f().unlock();
        }
        final CompiledChunk \u26037 = chunkRenderTask2.func_178544_c();
        ArrayList \u26038 = Lists.newArrayList();
        if (\u26036 == ChunkRenderTask.Type.REBUILD_CHUNK) {
            for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                if (!\u26037.func_178492_d(blockRenderLayer)) continue;
                \u26038.add(this.field_178477_b.func_188245_a(blockRenderLayer, chunkRenderTask2.func_178545_d().func_179038_a(blockRenderLayer), chunkRenderTask2.func_178536_b(), \u26037, chunkRenderTask2.func_188228_i()));
            }
        } else if (\u26036 == ChunkRenderTask.Type.RESORT_TRANSPARENCY) {
            ChunkRenderTask chunkRenderTask2;
            \u26038.add(this.field_178477_b.func_188245_a(BlockRenderLayer.TRANSLUCENT, chunkRenderTask2.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT), chunkRenderTask2.func_178536_b(), \u26037, chunkRenderTask2.func_188228_i()));
        }
        ListenableFuture listenableFuture = Futures.allAsList((Iterable)\u26038);
        chunkRenderTask2.func_178539_a(() -> listenableFuture.cancel(false));
        Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<List<Void>>(){

            public void onSuccess(@Nullable List<Void> list) {
                ChunkRenderWorker.this.func_223450_a(regionRenderCacheBuilder);
                chunkRenderTask2.func_178540_f().lock();
                try {
                    if (!ChunkRenderWorker.func_223453_b(chunkRenderTask2, ChunkRenderTask.Status.UPLOADING)) {
                        return;
                    }
                    chunkRenderTask2.func_178535_a(ChunkRenderTask.Status.DONE);
                }
                finally {
                    chunkRenderTask2.func_178540_f().unlock();
                }
                chunkRenderTask2.func_178536_b().func_178580_a(\u26037);
            }

            public void onFailure(Throwable throwable) {
                ChunkRenderWorker.this.func_223450_a(regionRenderCacheBuilder);
                if (!(throwable instanceof CancellationException) && !(throwable instanceof InterruptedException)) {
                    Minecraft.func_71410_x().func_71404_a(CrashReport.func_85055_a(throwable, "Rendering chunk"));
                }
            }

            public /* synthetic */ void onSuccess(@Nullable Object object) {
                this.onSuccess((List)object);
            }
        });
    }

    private static boolean func_223453_b(ChunkRenderTask chunkRenderTask, ChunkRenderTask.Status status) {
        if (chunkRenderTask.func_178546_a() != status) {
            if (!chunkRenderTask.func_178537_h()) {
                field_152478_a.warn("Chunk render task was {} when I expected it to be {}; ignoring task", (Object)chunkRenderTask.func_178546_a(), (Object)status);
            }
            return false;
        }
        return true;
    }

    private RegionRenderCacheBuilder func_178475_b() throws InterruptedException {
        return this.field_178478_c != null ? this.field_178478_c : this.field_178477_b.func_178515_c();
    }

    private void func_223450_a(RegionRenderCacheBuilder regionRenderCacheBuilder) {
        if (regionRenderCacheBuilder != this.field_178478_c) {
            this.field_178477_b.func_178512_a(regionRenderCacheBuilder);
        }
    }

    public void func_188264_a() {
        this.field_188265_d = false;
    }
}

