/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class PathfindingDebugRenderer
implements DebugRenderer.IDebugRenderer {
    private final Minecraft field_188290_a;
    private final Map<Integer, Path> field_188291_b = Maps.newHashMap();
    private final Map<Integer, Float> field_188292_c = Maps.newHashMap();
    private final Map<Integer, Long> field_188293_d = Maps.newHashMap();

    public PathfindingDebugRenderer(Minecraft minecraft) {
        this.field_188290_a = minecraft;
    }

    public void func_188289_a(int n, Path path, float f) {
        this.field_188291_b.put(n, path);
        this.field_188293_d.put(n, Util.func_211177_b());
        this.field_188292_c.put(n, Float.valueOf(f));
    }

    @Override
    public void func_217676_a(long l) {
        if (this.field_188291_b.isEmpty()) {
            return;
        }
        \u2603 = Util.func_211177_b();
        for (Integer n : this.field_188291_b.keySet()) {
            Path path = this.field_188291_b.get(n);
            float \u26032 = this.field_188292_c.get(n).floatValue();
            PathfindingDebugRenderer.func_222911_a(this.func_222914_b(), path, \u26032, true, true);
        }
        for (Integer n : this.field_188293_d.keySet().toArray(new Integer[0])) {
            if (\u2603 - this.field_188293_d.get(n) <= 20000L) continue;
            this.field_188291_b.remove(n);
            this.field_188293_d.remove(n);
        }
    }

    public static void func_222911_a(ActiveRenderInfo activeRenderInfo, Path path, float f, boolean bl, boolean bl2) {
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.color4f(0.0f, 1.0f, 0.0f, 0.75f);
        GlStateManager.disableTexture();
        GlStateManager.lineWidth(6.0f);
        PathfindingDebugRenderer.func_222910_b(activeRenderInfo, path, f, bl, bl2);
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    private static void func_222910_b(ActiveRenderInfo activeRenderInfo, Path path, float f, boolean bl, boolean bl2) {
        int n;
        PathfindingDebugRenderer.func_222912_a(activeRenderInfo, path);
        double d = activeRenderInfo.func_216785_c().field_72450_a;
        \u2603 = activeRenderInfo.func_216785_c().field_72448_b;
        \u2603 = activeRenderInfo.func_216785_c().field_72449_c;
        BlockPos \u26032 = path.func_224770_k();
        if (PathfindingDebugRenderer.func_225330_a(activeRenderInfo, \u26032) <= 40.0f) {
            DebugRenderer.func_217730_a(new AxisAlignedBB((float)\u26032.func_177958_n() + 0.25f, (float)\u26032.func_177956_o() + 0.25f, (double)\u26032.func_177952_p() + 0.25, (float)\u26032.func_177958_n() + 0.75f, (float)\u26032.func_177956_o() + 0.75f, (float)\u26032.func_177952_p() + 0.75f).func_72317_d(-d, -\u2603, -\u2603), 0.0f, 1.0f, 0.0f, 0.5f);
            for (n = 0; n < path.func_75874_d(); ++n) {
                PathPoint pathPoint = path.func_75877_a(n);
                if (!(PathfindingDebugRenderer.func_225330_a(activeRenderInfo, pathPoint.func_224759_a()) <= 40.0f)) continue;
                float \u26033 = n == path.func_75873_e() ? 1.0f : 0.0f;
                float \u26034 = n == path.func_75873_e() ? 0.0f : 1.0f;
                DebugRenderer.func_217730_a(new AxisAlignedBB((float)pathPoint.field_75839_a + 0.5f - f, (float)pathPoint.field_75837_b + 0.01f * (float)n, (float)pathPoint.field_75838_c + 0.5f - f, (float)pathPoint.field_75839_a + 0.5f + f, (float)pathPoint.field_75837_b + 0.25f + 0.01f * (float)n, (float)pathPoint.field_75838_c + 0.5f + f).func_72317_d(-d, -\u2603, -\u2603), \u26033, 0.0f, \u26034, 0.5f);
            }
        }
        if (bl) {
            for (PathPoint pathPoint : path.func_189965_h()) {
                if (!(PathfindingDebugRenderer.func_225330_a(activeRenderInfo, pathPoint.func_224759_a()) <= 40.0f)) continue;
                DebugRenderer.func_217732_a(String.format("%s", new Object[]{pathPoint.field_186287_m}), (double)pathPoint.field_75839_a + 0.5, (double)pathPoint.field_75837_b + 0.75, (double)pathPoint.field_75838_c + 0.5, -65536);
                DebugRenderer.func_217732_a(String.format(Locale.ROOT, "%.2f", Float.valueOf(pathPoint.field_186286_l)), (double)pathPoint.field_75839_a + 0.5, (double)pathPoint.field_75837_b + 0.25, (double)pathPoint.field_75838_c + 0.5, -65536);
            }
            for (PathPoint pathPoint : path.func_189966_g()) {
                if (!(PathfindingDebugRenderer.func_225330_a(activeRenderInfo, pathPoint.func_224759_a()) <= 40.0f)) continue;
                DebugRenderer.func_217732_a(String.format("%s", new Object[]{pathPoint.field_186287_m}), (double)pathPoint.field_75839_a + 0.5, (double)pathPoint.field_75837_b + 0.75, (double)pathPoint.field_75838_c + 0.5, -16776961);
                DebugRenderer.func_217732_a(String.format(Locale.ROOT, "%.2f", Float.valueOf(pathPoint.field_186286_l)), (double)pathPoint.field_75839_a + 0.5, (double)pathPoint.field_75837_b + 0.25, (double)pathPoint.field_75838_c + 0.5, -16776961);
            }
        }
        if (bl2) {
            for (n = 0; n < path.func_75874_d(); ++n) {
                PathPoint pathPoint = path.func_75877_a(n);
                if (!(PathfindingDebugRenderer.func_225330_a(activeRenderInfo, pathPoint.func_224759_a()) <= 40.0f)) continue;
                DebugRenderer.func_217732_a(String.format("%s", new Object[]{pathPoint.field_186287_m}), (double)pathPoint.field_75839_a + 0.5, (double)pathPoint.field_75837_b + 0.75, (double)pathPoint.field_75838_c + 0.5, -1);
                DebugRenderer.func_217732_a(String.format(Locale.ROOT, "%.2f", Float.valueOf(pathPoint.field_186286_l)), (double)pathPoint.field_75839_a + 0.5, (double)pathPoint.field_75837_b + 0.25, (double)pathPoint.field_75838_c + 0.5, -1);
            }
        }
    }

    public static void func_222912_a(ActiveRenderInfo activeRenderInfo, Path path) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        double \u26033 = activeRenderInfo.func_216785_c().field_72450_a;
        double \u26034 = activeRenderInfo.func_216785_c().field_72448_b;
        double \u26035 = activeRenderInfo.func_216785_c().field_72449_c;
        \u26032.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < path.func_75874_d(); ++i) {
            PathPoint pathPoint = path.func_75877_a(i);
            if (PathfindingDebugRenderer.func_225330_a(activeRenderInfo, pathPoint.func_224759_a()) > 40.0f) continue;
            float \u26036 = (float)i / (float)path.func_75874_d() * 0.33f;
            int \u26037 = i == 0 ? 0 : MathHelper.func_181758_c(\u26036, 0.9f, 0.9f);
            int \u26038 = \u26037 >> 16 & 0xFF;
            int \u26039 = \u26037 >> 8 & 0xFF;
            int \u260310 = \u26037 & 0xFF;
            \u26032.func_181662_b((double)pathPoint.field_75839_a - \u26033 + 0.5, (double)pathPoint.field_75837_b - \u26034 + 0.5, (double)pathPoint.field_75838_c - \u26035 + 0.5).func_181669_b(\u26038, \u26039, \u260310, 255).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    private static float func_225330_a(ActiveRenderInfo activeRenderInfo, BlockPos blockPos) {
        return (float)(Math.abs((double)blockPos.func_177958_n() - activeRenderInfo.func_216785_c().field_72450_a) + Math.abs((double)blockPos.func_177956_o() - activeRenderInfo.func_216785_c().field_72448_b) + Math.abs((double)blockPos.func_177952_p() - activeRenderInfo.func_216785_c().field_72449_c));
    }

    private ActiveRenderInfo func_222914_b() {
        return this.field_188290_a.field_71460_t.func_215316_n();
    }
}

