/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IWorldReader;

public abstract class EntityRenderer<T extends Entity> {
    private static final ResourceLocation field_110778_a = new ResourceLocation("textures/misc/shadow.png");
    protected final EntityRendererManager field_76990_c;
    protected float field_76989_e;
    protected float field_76987_f = 1.0f;
    protected boolean field_188301_f;

    protected EntityRenderer(EntityRendererManager entityRendererManager) {
        this.field_76990_c = entityRendererManager;
    }

    public void func_188297_a(boolean bl) {
        this.field_188301_f = bl;
    }

    public boolean func_177071_a(T t, ICamera iCamera, double d, double d2, double d3) {
        if (!((Entity)t).func_145770_h(d, d2, d3)) {
            return false;
        }
        if (((Entity)t).field_70158_ak) {
            return true;
        }
        AxisAlignedBB axisAlignedBB = ((Entity)t).func_184177_bl().func_186662_g(0.5);
        if (axisAlignedBB.func_181656_b() || axisAlignedBB.func_72320_b() == 0.0) {
            axisAlignedBB = new AxisAlignedBB(((Entity)t).field_70165_t - 2.0, ((Entity)t).field_70163_u - 2.0, ((Entity)t).field_70161_v - 2.0, ((Entity)t).field_70165_t + 2.0, ((Entity)t).field_70163_u + 2.0, ((Entity)t).field_70161_v + 2.0);
        }
        return iCamera.func_78546_a(axisAlignedBB);
    }

    public void func_76986_a(T t, double d, double d2, double d3, float f, float f2) {
        if (!this.field_188301_f) {
            this.func_177067_a(t, d, d2, d3);
        }
    }

    protected int func_188298_c(T t) {
        ScorePlayerTeam scorePlayerTeam = (ScorePlayerTeam)((Entity)t).func_96124_cp();
        if (scorePlayerTeam != null && scorePlayerTeam.func_178775_l().func_211163_e() != null) {
            return scorePlayerTeam.func_178775_l().func_211163_e();
        }
        return 0xFFFFFF;
    }

    protected void func_177067_a(T t, double d, double d2, double d3) {
        if (!this.func_177070_b(t)) {
            return;
        }
        this.func_147906_a(t, ((Entity)t).func_145748_c_().func_150254_d(), d, d2, d3, 64);
    }

    protected boolean func_177070_b(T t) {
        return ((Entity)t).func_94059_bO() && ((Entity)t).func_145818_k_();
    }

    protected void func_188296_a(T t, double d, double d2, double d3, String string, double d4) {
        this.func_147906_a(t, string, d, d2, d3, 64);
    }

    @Nullable
    protected abstract ResourceLocation func_110775_a(T var1);

    protected boolean func_180548_c(T t) {
        ResourceLocation resourceLocation = this.func_110775_a(t);
        if (resourceLocation == null) {
            return false;
        }
        this.func_110776_a(resourceLocation);
        return true;
    }

    public void func_110776_a(ResourceLocation resourceLocation) {
        this.field_76990_c.field_78724_e.func_110577_a(resourceLocation);
    }

    private void func_76977_a(Entity entity, double d, double d2, double d3, float f) {
        GlStateManager.disableLighting();
        AtlasTexture atlasTexture = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite \u26032 = atlasTexture.func_195424_a(ModelBakery.field_207763_a);
        TextureAtlasSprite \u26033 = atlasTexture.func_195424_a(ModelBakery.field_207764_b);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)d, (float)d2, (float)d3);
        float \u26034 = entity.func_213311_cf() * 1.4f;
        GlStateManager.scalef(\u26034, \u26034, \u26034);
        Tessellator \u26035 = Tessellator.func_178181_a();
        BufferBuilder \u26036 = \u26035.func_178180_c();
        float \u26037 = 0.5f;
        float \u26038 = 0.0f;
        float \u26039 = entity.func_213302_cg() / \u26034;
        float \u260310 = (float)(entity.field_70163_u - entity.func_174813_aQ().field_72338_b);
        GlStateManager.rotatef(-this.field_76990_c.field_78735_i, 0.0f, 1.0f, 0.0f);
        GlStateManager.translatef(0.0f, 0.0f, -0.3f + (float)((int)\u26039) * 0.02f);
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        float \u260311 = 0.0f;
        int \u260312 = 0;
        \u26036.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        while (\u26039 > 0.0f) {
            TextureAtlasSprite textureAtlasSprite = \u260312 % 2 == 0 ? \u26032 : \u26033;
            this.func_110776_a(AtlasTexture.field_110575_b);
            float \u260313 = textureAtlasSprite.func_94209_e();
            float \u260314 = textureAtlasSprite.func_94206_g();
            float \u260315 = textureAtlasSprite.func_94212_f();
            float \u260316 = textureAtlasSprite.func_94210_h();
            if (\u260312 / 2 % 2 == 0) {
                float f2 = \u260315;
                \u260315 = \u260313;
                \u260313 = f2;
            }
            \u26036.func_181662_b(\u26037 - 0.0f, 0.0f - \u260310, \u260311).func_187315_a(\u260315, \u260316).func_181675_d();
            \u26036.func_181662_b(-\u26037 - 0.0f, 0.0f - \u260310, \u260311).func_187315_a(\u260313, \u260316).func_181675_d();
            \u26036.func_181662_b(-\u26037 - 0.0f, 1.4f - \u260310, \u260311).func_187315_a(\u260313, \u260314).func_181675_d();
            \u26036.func_181662_b(\u26037 - 0.0f, 1.4f - \u260310, \u260311).func_187315_a(\u260315, \u260314).func_181675_d();
            \u26039 -= 0.45f;
            \u260310 -= 0.45f;
            \u26037 *= 0.9f;
            \u260311 += 0.03f;
            ++\u260312;
        }
        \u26035.func_78381_a();
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
    }

    private void func_76975_c(Entity entity, double d, double d2, double d3, float f, float f2) {
        GlStateManager.enableBlend();
        GlStateManager.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.field_76990_c.field_78724_e.func_110577_a(field_110778_a);
        IWorldReader iWorldReader = this.func_76982_b();
        GlStateManager.depthMask(false);
        float \u26032 = this.field_76989_e;
        if (entity instanceof MobEntity && (\u2603 = (MobEntity)entity).func_70631_g_()) {
            \u26032 *= 0.5f;
        }
        double \u26033 = MathHelper.func_219803_d(f2, entity.field_70142_S, entity.field_70165_t);
        double \u26034 = MathHelper.func_219803_d(f2, entity.field_70137_T, entity.field_70163_u);
        double \u26035 = MathHelper.func_219803_d(f2, entity.field_70136_U, entity.field_70161_v);
        int \u26036 = MathHelper.func_76128_c(\u26033 - (double)\u26032);
        int \u26037 = MathHelper.func_76128_c(\u26033 + (double)\u26032);
        int \u26038 = MathHelper.func_76128_c(\u26034 - (double)\u26032);
        int \u26039 = MathHelper.func_76128_c(\u26034);
        int \u260310 = MathHelper.func_76128_c(\u26035 - (double)\u26032);
        int \u260311 = MathHelper.func_76128_c(\u26035 + (double)\u26032);
        double \u260312 = d - \u26033;
        double \u260313 = d2 - \u26034;
        double \u260314 = d3 - \u26035;
        Tessellator \u260315 = Tessellator.func_178181_a();
        BufferBuilder \u260316 = \u260315.func_178180_c();
        \u260316.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (BlockPos blockPos : BlockPos.func_218278_a(new BlockPos(\u26036, \u26038, \u260310), new BlockPos(\u26037, \u26039, \u260311))) {
            \u2603 = blockPos.func_177977_b();
            BlockState blockState = iWorldReader.func_180495_p(\u2603);
            if (blockState.func_185901_i() == BlockRenderType.INVISIBLE || iWorldReader.func_201696_r(blockPos) <= 3) continue;
            this.func_217759_a(blockState, iWorldReader, \u2603, d, d2, d3, blockPos, f, \u26032, \u260312, \u260313, \u260314);
        }
        \u260315.func_78381_a();
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
        GlStateManager.depthMask(true);
    }

    private IWorldReader func_76982_b() {
        return this.field_76990_c.field_78722_g;
    }

    private void func_217759_a(BlockState blockState, IWorldReader iWorldReader, BlockPos blockPos, double d, double d2, double d3, BlockPos blockPos2, float f, float f2, double d4, double d5, double d6) {
        if (!blockState.func_224756_o(iWorldReader, blockPos)) {
            return;
        }
        VoxelShape voxelShape = blockState.func_196954_c(this.func_76982_b(), blockPos2.func_177977_b());
        if (voxelShape.func_197766_b()) {
            return;
        }
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        double \u26034 = ((double)f - (d2 - ((double)blockPos2.func_177956_o() + d5)) / 2.0) * 0.5 * (double)this.func_76982_b().func_205052_D(blockPos2);
        if (\u26034 < 0.0) {
            return;
        }
        if (\u26034 > 1.0) {
            \u26034 = 1.0;
        }
        AxisAlignedBB \u26035 = voxelShape.func_197752_a();
        double \u26036 = (double)blockPos2.func_177958_n() + \u26035.field_72340_a + d4;
        double \u26037 = (double)blockPos2.func_177958_n() + \u26035.field_72336_d + d4;
        double \u26038 = (double)blockPos2.func_177956_o() + \u26035.field_72338_b + d5 + 0.015625;
        double \u26039 = (double)blockPos2.func_177952_p() + \u26035.field_72339_c + d6;
        double \u260310 = (double)blockPos2.func_177952_p() + \u26035.field_72334_f + d6;
        float \u260311 = (float)((d - \u26036) / 2.0 / (double)f2 + 0.5);
        float \u260312 = (float)((d - \u26037) / 2.0 / (double)f2 + 0.5);
        float \u260313 = (float)((d3 - \u26039) / 2.0 / (double)f2 + 0.5);
        float \u260314 = (float)((d3 - \u260310) / 2.0 / (double)f2 + 0.5);
        \u26033.func_181662_b(\u26036, \u26038, \u26039).func_187315_a(\u260311, \u260313).func_181666_a(1.0f, 1.0f, 1.0f, (float)\u26034).func_181675_d();
        \u26033.func_181662_b(\u26036, \u26038, \u260310).func_187315_a(\u260311, \u260314).func_181666_a(1.0f, 1.0f, 1.0f, (float)\u26034).func_181675_d();
        \u26033.func_181662_b(\u26037, \u26038, \u260310).func_187315_a(\u260312, \u260314).func_181666_a(1.0f, 1.0f, 1.0f, (float)\u26034).func_181675_d();
        \u26033.func_181662_b(\u26037, \u26038, \u26039).func_187315_a(\u260312, \u260313).func_181666_a(1.0f, 1.0f, 1.0f, (float)\u26034).func_181675_d();
    }

    public static void func_76978_a(AxisAlignedBB axisAlignedBB, double d, double d2, double d3) {
        GlStateManager.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        \u26032.func_178969_c(d, d2, d3);
        \u26032.func_181668_a(7, DefaultVertexFormats.field_181708_h);
        \u26032.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72339_c).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72337_e, axisAlignedBB.field_72334_f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        \u26032.func_181662_b(axisAlignedBB.field_72336_d, axisAlignedBB.field_72338_b, axisAlignedBB.field_72334_f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        \u26032.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.enableTexture();
    }

    public void func_76979_b(Entity entity, double d, double d2, double d3, float f, float f2) {
        if (this.field_76990_c.field_78733_k == null) {
            return;
        }
        if (this.field_76990_c.field_78733_k.field_181151_V && this.field_76989_e > 0.0f && !entity.func_82150_aj() && this.field_76990_c.func_178627_a() && (\u2603 = (float)((1.0 - (\u2603 = this.field_76990_c.func_78714_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)) / 256.0) * (double)this.field_76987_f)) > 0.0f) {
            this.func_76975_c(entity, d, d2, d3, \u2603, f2);
        }
        if (entity.func_90999_ad() && !entity.func_175149_v()) {
            this.func_76977_a(entity, d, d2, d3, f2);
        }
    }

    public FontRenderer func_76983_a() {
        return this.field_76990_c.func_78716_a();
    }

    protected void func_147906_a(T t, String string, double d, double d2, double d3, int n) {
        double d4 = ((Entity)t).func_195048_a(this.field_76990_c.field_217783_c.func_216785_c());
        if (d4 > (double)(n * n)) {
            return;
        }
        boolean \u26032 = ((Entity)t).func_213287_bg();
        float \u26033 = this.field_76990_c.field_78735_i;
        float \u26034 = this.field_76990_c.field_78732_j;
        float \u26035 = ((Entity)t).func_213302_cg() + 0.5f - (\u26032 ? 0.25f : 0.0f);
        int \u26036 = "deadmau5".equals(string) ? -10 : 0;
        GameRenderer.func_215307_a(this.func_76983_a(), string, (float)d, (float)d2 + \u26035, (float)d3, \u26036, \u26033, \u26034, \u26032);
    }

    public EntityRendererManager func_177068_d() {
        return this.field_76990_c;
    }

    public boolean func_188295_H_() {
        return false;
    }

    public void func_188300_b(T t, double d, double d2, double d3, float f, float f2) {
    }

    public void func_217758_e(T t) {
        int n = ((Entity)t).func_70070_b();
        \u2603 = n % 65536;
        \u2603 = n / 65536;
        GLX.glMultiTexCoord2f(GLX.GL_TEXTURE1, \u2603, \u2603);
    }
}

