/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LivingRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements IEntityRenderer<T, M> {
    private static final Logger field_147923_a = LogManager.getLogger();
    private static final DynamicTexture field_177096_e = Util.func_200696_a(new DynamicTexture(16, 16, false), dynamicTexture2 -> {
        DynamicTexture dynamicTexture2;
        dynamicTexture2.func_195414_e().func_195711_f();
        for (int i = 0; i < 16; ++i) {
            for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                dynamicTexture2.func_195414_e().func_195700_a(\u2603, i, -1);
            }
        }
        dynamicTexture2.func_110564_a();
    });
    protected M field_77045_g;
    protected final FloatBuffer field_177095_g = GLAllocation.func_74529_h(4);
    protected final List<LayerRenderer<T, M>> field_177097_h = Lists.newArrayList();
    protected boolean field_188323_j;

    public LivingRenderer(EntityRendererManager entityRendererManager, M m, float f) {
        super(entityRendererManager);
        this.field_77045_g = m;
        this.field_76989_e = f;
    }

    protected final boolean func_177094_a(LayerRenderer<T, M> layerRenderer) {
        return this.field_177097_h.add(layerRenderer);
    }

    @Override
    public M func_217764_d() {
        return this.field_77045_g;
    }

    @Override
    public void func_76986_a(T t2, double d, double d2, double d3, float f, float f2) {
        GlStateManager.pushMatrix();
        GlStateManager.disableCull();
        ((EntityModel)this.field_77045_g).field_217112_c = this.func_77040_d(t2, f2);
        ((EntityModel)this.field_77045_g).field_217113_d = ((Entity)t2).func_184218_aH();
        ((EntityModel)this.field_77045_g).field_217114_e = ((LivingEntity)t2).func_70631_g_();
        try {
            float \u26034;
            float \u26033;
            float \u26032;
            \u26032 = MathHelper.func_219805_h(f2, ((LivingEntity)t2).field_70760_ar, ((LivingEntity)t2).field_70761_aq);
            \u2603 = MathHelper.func_219805_h(f2, ((LivingEntity)t2).field_70758_at, ((LivingEntity)t2).field_70759_as);
            \u26033 = \u2603 - \u26032;
            if (((Entity)t2).func_184218_aH() && ((Entity)t2).func_184187_bx() instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)((Entity)t2).func_184187_bx();
                \u26032 = MathHelper.func_219805_h(f2, livingEntity.field_70760_ar, livingEntity.field_70761_aq);
                \u26033 = \u2603 - \u26032;
                \u26034 = MathHelper.func_76142_g(\u26033);
                if (\u26034 < -85.0f) {
                    \u26034 = -85.0f;
                }
                if (\u26034 >= 85.0f) {
                    \u26034 = 85.0f;
                }
                \u26032 = \u2603 - \u26034;
                if (\u26034 * \u26034 > 2500.0f) {
                    \u26032 += \u26034 * 0.2f;
                }
                \u26033 = \u2603 - \u26032;
            }
            float f3 = MathHelper.func_219799_g(f2, ((LivingEntity)t2).field_70127_C, ((LivingEntity)t2).field_70125_A);
            this.func_77039_a(t2, d, d2, d3);
            \u26034 = this.func_77044_a(t2, f2);
            this.func_77043_a(t2, \u26034, \u26032, f2);
            \u2603 = this.func_188322_c(t2, f2);
            \u2603 = 0.0f;
            \u2603 = 0.0f;
            if (!((Entity)t2).func_184218_aH() && ((LivingEntity)t2).func_70089_S()) {
                \u2603 = MathHelper.func_219799_g(f2, ((LivingEntity)t2).field_184618_aE, ((LivingEntity)t2).field_70721_aZ);
                \u2603 = ((LivingEntity)t2).field_184619_aG - ((LivingEntity)t2).field_70721_aZ * (1.0f - f2);
                if (((LivingEntity)t2).func_70631_g_()) {
                    \u2603 *= 3.0f;
                }
                if (\u2603 > 1.0f) {
                    \u2603 = 1.0f;
                }
            }
            GlStateManager.enableAlphaTest();
            ((EntityModel)this.field_77045_g).func_212843_a_(t2, \u2603, \u2603, f2);
            ((EntityModel)this.field_77045_g).func_212844_a_(t2, \u2603, \u2603, \u26034, \u26033, f3, \u2603);
            if (this.field_188301_f) {
                boolean bl = this.func_177088_c(t2);
                GlStateManager.enableColorMaterial();
                GlStateManager.setupSolidRenderingTextureCombine(this.func_188298_c(t2));
                if (!this.field_188323_j) {
                    this.func_77036_a(t2, \u2603, \u2603, \u26034, \u26033, f3, \u2603);
                }
                if (!((Entity)t2).func_175149_v()) {
                    this.func_177093_a(t2, \u2603, \u2603, f2, \u26034, \u26033, f3, \u2603);
                }
                GlStateManager.tearDownSolidRenderingTextureCombine();
                GlStateManager.disableColorMaterial();
                if (bl) {
                    this.func_180565_e();
                }
            } else {
                T t2;
                boolean \u26035 = this.func_177090_c(t2, f2);
                this.func_77036_a(t2, \u2603, \u2603, \u26034, \u26033, f3, \u2603);
                if (\u26035) {
                    this.func_177091_f();
                }
                GlStateManager.depthMask(true);
                if (!((Entity)t2).func_175149_v()) {
                    this.func_177093_a(t2, \u2603, \u2603, f2, \u26034, \u26033, f3, \u2603);
                }
            }
            GlStateManager.disableRescaleNormal();
        }
        catch (Exception exception) {
            field_147923_a.error("Couldn't render entity", (Throwable)exception);
        }
        GlStateManager.activeTexture(GLX.GL_TEXTURE1);
        GlStateManager.enableTexture();
        GlStateManager.activeTexture(GLX.GL_TEXTURE0);
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
        super.func_76986_a(t2, d, d2, d3, f, f2);
    }

    public float func_188322_c(T t, float f) {
        GlStateManager.enableRescaleNormal();
        GlStateManager.scalef(-1.0f, -1.0f, 1.0f);
        this.func_77041_b(t, f);
        \u2603 = 0.0625f;
        GlStateManager.translatef(0.0f, -1.501f, 0.0f);
        return 0.0625f;
    }

    protected boolean func_177088_c(T t) {
        GlStateManager.disableLighting();
        GlStateManager.activeTexture(GLX.GL_TEXTURE1);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture(GLX.GL_TEXTURE0);
        return true;
    }

    protected void func_180565_e() {
        GlStateManager.enableLighting();
        GlStateManager.activeTexture(GLX.GL_TEXTURE1);
        GlStateManager.enableTexture();
        GlStateManager.activeTexture(GLX.GL_TEXTURE0);
    }

    protected void func_77036_a(T t, float f, float f2, float f3, float f4, float f5, float f6) {
        boolean bl = this.func_193115_c(t);
        boolean bl2 = \u2603 = !bl && !((Entity)t).func_98034_c(Minecraft.func_71410_x().field_71439_g);
        if (bl || \u2603) {
            if (!this.func_180548_c(t)) {
                return;
            }
            if (\u2603) {
                GlStateManager.setProfile(GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            ((EntityModel)this.field_77045_g).func_78088_a(t, f, f2, f3, f4, f5, f6);
            if (\u2603) {
                GlStateManager.unsetProfile(GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    protected boolean func_193115_c(T t) {
        return !((Entity)t).func_82150_aj() || this.field_188301_f;
    }

    protected boolean func_177090_c(T t, float f) {
        return this.func_177092_a(t, f, true);
    }

    protected boolean func_177092_a(T t, float f, boolean bl) {
        float f2 = ((Entity)t).func_70013_c();
        int \u26032 = this.func_77030_a(t, f2, f);
        boolean \u26033 = (\u26032 >> 24 & 0xFF) > 0;
        boolean bl2 = \u2603 = ((LivingEntity)t).field_70737_aN > 0 || ((LivingEntity)t).field_70725_aQ > 0;
        if (\u26033 || \u2603) {
            if (!\u26033 && !bl) {
                return false;
            }
            GlStateManager.activeTexture(GLX.GL_TEXTURE0);
            GlStateManager.enableTexture();
            GlStateManager.texEnv(8960, 8704, GLX.GL_COMBINE);
            GlStateManager.texEnv(8960, GLX.GL_COMBINE_RGB, 8448);
            GlStateManager.texEnv(8960, GLX.GL_SOURCE0_RGB, GLX.GL_TEXTURE0);
            GlStateManager.texEnv(8960, GLX.GL_SOURCE1_RGB, GLX.GL_PRIMARY_COLOR);
            GlStateManager.texEnv(8960, GLX.GL_OPERAND0_RGB, 768);
            GlStateManager.texEnv(8960, GLX.GL_OPERAND1_RGB, 768);
            GlStateManager.texEnv(8960, GLX.GL_COMBINE_ALPHA, 7681);
            GlStateManager.texEnv(8960, GLX.GL_SOURCE0_ALPHA, GLX.GL_TEXTURE0);
            GlStateManager.texEnv(8960, GLX.GL_OPERAND0_ALPHA, 770);
            GlStateManager.activeTexture(GLX.GL_TEXTURE1);
            GlStateManager.enableTexture();
            GlStateManager.texEnv(8960, 8704, GLX.GL_COMBINE);
            GlStateManager.texEnv(8960, GLX.GL_COMBINE_RGB, GLX.GL_INTERPOLATE);
            GlStateManager.texEnv(8960, GLX.GL_SOURCE0_RGB, GLX.GL_CONSTANT);
            GlStateManager.texEnv(8960, GLX.GL_SOURCE1_RGB, GLX.GL_PREVIOUS);
            GlStateManager.texEnv(8960, GLX.GL_SOURCE2_RGB, GLX.GL_CONSTANT);
            GlStateManager.texEnv(8960, GLX.GL_OPERAND0_RGB, 768);
            GlStateManager.texEnv(8960, GLX.GL_OPERAND1_RGB, 768);
            GlStateManager.texEnv(8960, GLX.GL_OPERAND2_RGB, 770);
            GlStateManager.texEnv(8960, GLX.GL_COMBINE_ALPHA, 7681);
            GlStateManager.texEnv(8960, GLX.GL_SOURCE0_ALPHA, GLX.GL_PREVIOUS);
            GlStateManager.texEnv(8960, GLX.GL_OPERAND0_ALPHA, 770);
            this.field_177095_g.position(0);
            if (\u2603) {
                this.field_177095_g.put(1.0f);
                this.field_177095_g.put(0.0f);
                this.field_177095_g.put(0.0f);
                this.field_177095_g.put(0.3f);
            } else {
                \u2603 = (float)(\u26032 >> 24 & 0xFF) / 255.0f;
                \u2603 = (float)(\u26032 >> 16 & 0xFF) / 255.0f;
                \u2603 = (float)(\u26032 >> 8 & 0xFF) / 255.0f;
                \u2603 = (float)(\u26032 & 0xFF) / 255.0f;
                this.field_177095_g.put(\u2603);
                this.field_177095_g.put(\u2603);
                this.field_177095_g.put(\u2603);
                this.field_177095_g.put(1.0f - \u2603);
            }
            this.field_177095_g.flip();
            GlStateManager.texEnv(8960, 8705, this.field_177095_g);
            GlStateManager.activeTexture(GLX.GL_TEXTURE2);
            GlStateManager.enableTexture();
            GlStateManager.bindTexture(field_177096_e.func_110552_b());
            GlStateManager.texEnv(8960, 8704, GLX.GL_COMBINE);
            GlStateManager.texEnv(8960, GLX.GL_COMBINE_RGB, 8448);
            GlStateManager.texEnv(8960, GLX.GL_SOURCE0_RGB, GLX.GL_PREVIOUS);
            GlStateManager.texEnv(8960, GLX.GL_SOURCE1_RGB, GLX.GL_TEXTURE1);
            GlStateManager.texEnv(8960, GLX.GL_OPERAND0_RGB, 768);
            GlStateManager.texEnv(8960, GLX.GL_OPERAND1_RGB, 768);
            GlStateManager.texEnv(8960, GLX.GL_COMBINE_ALPHA, 7681);
            GlStateManager.texEnv(8960, GLX.GL_SOURCE0_ALPHA, GLX.GL_PREVIOUS);
            GlStateManager.texEnv(8960, GLX.GL_OPERAND0_ALPHA, 770);
            GlStateManager.activeTexture(GLX.GL_TEXTURE0);
            return true;
        }
        return false;
    }

    protected void func_177091_f() {
        GlStateManager.activeTexture(GLX.GL_TEXTURE0);
        GlStateManager.enableTexture();
        GlStateManager.texEnv(8960, 8704, GLX.GL_COMBINE);
        GlStateManager.texEnv(8960, GLX.GL_COMBINE_RGB, 8448);
        GlStateManager.texEnv(8960, GLX.GL_SOURCE0_RGB, GLX.GL_TEXTURE0);
        GlStateManager.texEnv(8960, GLX.GL_SOURCE1_RGB, GLX.GL_PRIMARY_COLOR);
        GlStateManager.texEnv(8960, GLX.GL_OPERAND0_RGB, 768);
        GlStateManager.texEnv(8960, GLX.GL_OPERAND1_RGB, 768);
        GlStateManager.texEnv(8960, GLX.GL_COMBINE_ALPHA, 8448);
        GlStateManager.texEnv(8960, GLX.GL_SOURCE0_ALPHA, GLX.GL_TEXTURE0);
        GlStateManager.texEnv(8960, GLX.GL_SOURCE1_ALPHA, GLX.GL_PRIMARY_COLOR);
        GlStateManager.texEnv(8960, GLX.GL_OPERAND0_ALPHA, 770);
        GlStateManager.texEnv(8960, GLX.GL_OPERAND1_ALPHA, 770);
        GlStateManager.activeTexture(GLX.GL_TEXTURE1);
        GlStateManager.texEnv(8960, 8704, GLX.GL_COMBINE);
        GlStateManager.texEnv(8960, GLX.GL_COMBINE_RGB, 8448);
        GlStateManager.texEnv(8960, GLX.GL_OPERAND0_RGB, 768);
        GlStateManager.texEnv(8960, GLX.GL_OPERAND1_RGB, 768);
        GlStateManager.texEnv(8960, GLX.GL_SOURCE0_RGB, 5890);
        GlStateManager.texEnv(8960, GLX.GL_SOURCE1_RGB, GLX.GL_PREVIOUS);
        GlStateManager.texEnv(8960, GLX.GL_COMBINE_ALPHA, 8448);
        GlStateManager.texEnv(8960, GLX.GL_OPERAND0_ALPHA, 770);
        GlStateManager.texEnv(8960, GLX.GL_SOURCE0_ALPHA, 5890);
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.activeTexture(GLX.GL_TEXTURE2);
        GlStateManager.disableTexture();
        GlStateManager.bindTexture(0);
        GlStateManager.texEnv(8960, 8704, GLX.GL_COMBINE);
        GlStateManager.texEnv(8960, GLX.GL_COMBINE_RGB, 8448);
        GlStateManager.texEnv(8960, GLX.GL_OPERAND0_RGB, 768);
        GlStateManager.texEnv(8960, GLX.GL_OPERAND1_RGB, 768);
        GlStateManager.texEnv(8960, GLX.GL_SOURCE0_RGB, 5890);
        GlStateManager.texEnv(8960, GLX.GL_SOURCE1_RGB, GLX.GL_PREVIOUS);
        GlStateManager.texEnv(8960, GLX.GL_COMBINE_ALPHA, 8448);
        GlStateManager.texEnv(8960, GLX.GL_OPERAND0_ALPHA, 770);
        GlStateManager.texEnv(8960, GLX.GL_SOURCE0_ALPHA, 5890);
        GlStateManager.activeTexture(GLX.GL_TEXTURE0);
    }

    protected void func_77039_a(T t, double d4, double d2, double d3) {
        double d4;
        if (((Entity)t).func_213283_Z() == Pose.SLEEPING && (\u2603 = ((LivingEntity)t).func_213376_dz()) != null) {
            float f = ((Entity)t).func_213307_e(Pose.STANDING) - 0.1f;
            GlStateManager.translatef((float)d4 - (float)\u2603.func_82601_c() * f, (float)d2, (float)d3 - (float)\u2603.func_82599_e() * f);
            return;
        }
        GlStateManager.translatef((float)d4, (float)d2, (float)d3);
    }

    private static float func_217765_a(Direction direction) {
        switch (direction) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected void func_77043_a(T t2, float f, float f2, float f3) {
        T t2;
        Pose pose = ((Entity)t2).func_213283_Z();
        if (pose != Pose.SLEEPING) {
            GlStateManager.rotatef(180.0f - f2, 0.0f, 1.0f, 0.0f);
        }
        if (((LivingEntity)t2).field_70725_aQ > 0) {
            float f4 = ((float)((LivingEntity)t2).field_70725_aQ + f3 - 1.0f) / 20.0f * 1.6f;
            if ((f4 = MathHelper.func_76129_c(f4)) > 1.0f) {
                f4 = 1.0f;
            }
            GlStateManager.rotatef(f4 * this.func_77037_a(t2), 0.0f, 0.0f, 1.0f);
        } else if (((LivingEntity)t2).func_204805_cN()) {
            GlStateManager.rotatef(-90.0f - ((LivingEntity)t2).field_70125_A, 1.0f, 0.0f, 0.0f);
            GlStateManager.rotatef(((float)((LivingEntity)t2).field_70173_aa + f3) * -75.0f, 0.0f, 1.0f, 0.0f);
        } else if (pose == Pose.SLEEPING) {
            Direction direction = ((LivingEntity)t2).func_213376_dz();
            GlStateManager.rotatef(direction != null ? LivingRenderer.func_217765_a(direction) : f2, 0.0f, 1.0f, 0.0f);
            GlStateManager.rotatef(this.func_77037_a(t2), 0.0f, 0.0f, 1.0f);
            GlStateManager.rotatef(270.0f, 0.0f, 1.0f, 0.0f);
        } else if ((((Entity)t2).func_145818_k_() || t2 instanceof PlayerEntity) && (\u2603 = TextFormatting.func_110646_a(((Entity)t2).func_200200_C_().getString())) != null && ("Dinnerbone".equals(\u2603) || "Grumm".equals(\u2603)) && (!(t2 instanceof PlayerEntity) || ((PlayerEntity)t2).func_175148_a(PlayerModelPart.CAPE))) {
            GlStateManager.translatef(0.0f, ((Entity)t2).func_213302_cg() + 0.1f, 0.0f);
            GlStateManager.rotatef(180.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    protected float func_77040_d(T t, float f) {
        return ((LivingEntity)t).func_70678_g(f);
    }

    protected float func_77044_a(T t, float f) {
        return (float)((LivingEntity)t).field_70173_aa + f;
    }

    protected void func_177093_a(T t, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        for (LayerRenderer<T, M> layerRenderer : this.field_177097_h) {
            boolean bl = this.func_177092_a(t, f3, layerRenderer.func_177142_b());
            layerRenderer.func_212842_a_(t, f, f2, f3, f4, f5, f6, f7);
            if (!bl) continue;
            this.func_177091_f();
        }
    }

    protected float func_77037_a(T t) {
        return 90.0f;
    }

    protected int func_77030_a(T t, float f, float f2) {
        return 0;
    }

    protected void func_77041_b(T t, float f) {
    }

    @Override
    public void func_177067_a(T t, double d, double d2, double d3) {
        if (!this.func_177070_b(t)) {
            return;
        }
        \u2603 = ((Entity)t).func_195048_a(this.field_76990_c.field_217783_c.func_216785_c());
        float f = \u2603 = ((Entity)t).func_213287_bg() ? 32.0f : 64.0f;
        if (\u2603 >= (double)(\u2603 * \u2603)) {
            return;
        }
        String string = ((Entity)t).func_145748_c_().func_150254_d();
        GlStateManager.alphaFunc(516, 0.1f);
        this.func_188296_a(t, d, d2, d3, string, \u2603);
    }

    @Override
    protected boolean func_177070_b(T t2) {
        T t2;
        ClientPlayerEntity clientPlayerEntity = Minecraft.func_71410_x().field_71439_g;
        boolean bl = \u2603 = !((Entity)t2).func_98034_c(clientPlayerEntity);
        if (t2 != clientPlayerEntity) {
            Team team = ((Entity)t2).func_96124_cp();
            \u2603 = clientPlayerEntity.func_96124_cp();
            if (team != null) {
                Team.Visible visible = team.func_178770_i();
                switch (visible) {
                    case ALWAYS: {
                        return \u2603;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return \u2603 == null ? \u2603 : team.func_142054_a(\u2603) && (team.func_98297_h() || \u2603);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return \u2603 == null ? \u2603 : !team.func_142054_a(\u2603) && \u2603;
                    }
                }
                return true;
            }
        }
        return Minecraft.func_71382_s() && t2 != this.field_76990_c.field_217783_c.func_216773_g() && \u2603 && !((Entity)t2).func_184207_aI();
    }

    @Override
    protected /* synthetic */ boolean func_177070_b(Entity entity) {
        return this.func_177070_b((T)((LivingEntity)entity));
    }

    @Override
    public /* synthetic */ void func_177067_a(Entity entity, double d, double d2, double d3) {
        this.func_177067_a((T)((LivingEntity)entity), d, d2, d3);
    }
}

