/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.PandaHeldItemLayer;
import net.minecraft.client.renderer.entity.model.PandaModel;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;

public class PandaRenderer
extends MobRenderer<PandaEntity, PandaModel<PandaEntity>> {
    private static final Map<PandaEntity.Type, ResourceLocation> field_217777_a = Util.func_200696_a(Maps.newEnumMap(PandaEntity.Type.class), enumMap -> {
        enumMap.put(PandaEntity.Type.NORMAL, new ResourceLocation("textures/entity/panda/panda.png"));
        enumMap.put(PandaEntity.Type.LAZY, new ResourceLocation("textures/entity/panda/lazy_panda.png"));
        enumMap.put(PandaEntity.Type.WORRIED, new ResourceLocation("textures/entity/panda/worried_panda.png"));
        enumMap.put(PandaEntity.Type.PLAYFUL, new ResourceLocation("textures/entity/panda/playful_panda.png"));
        enumMap.put(PandaEntity.Type.BROWN, new ResourceLocation("textures/entity/panda/brown_panda.png"));
        enumMap.put(PandaEntity.Type.WEAK, new ResourceLocation("textures/entity/panda/weak_panda.png"));
        enumMap.put(PandaEntity.Type.AGGRESSIVE, new ResourceLocation("textures/entity/panda/aggressive_panda.png"));
    });

    public PandaRenderer(EntityRendererManager entityRendererManager) {
        super(entityRendererManager, new PandaModel(9, 0.0f), 0.9f);
        this.func_177094_a(new PandaHeldItemLayer(this));
    }

    @Override
    @Nullable
    protected ResourceLocation func_110775_a(PandaEntity pandaEntity) {
        return field_217777_a.getOrDefault((Object)pandaEntity.func_213590_ei(), field_217777_a.get((Object)PandaEntity.Type.NORMAL));
    }

    @Override
    protected void func_77043_a(PandaEntity pandaEntity2, float f, float f2, float f3) {
        float f4;
        PandaEntity pandaEntity2;
        float \u26032;
        super.func_77043_a(pandaEntity2, f, f2, f3);
        if (pandaEntity2.field_213608_bz > 0) {
            int n = pandaEntity2.field_213608_bz;
            \u2603 = n + 1;
            \u26032 = 7.0f;
            float f5 = \u2603 = pandaEntity2.func_70631_g_() ? 0.3f : 0.8f;
            if (n < 8) {
                float f6 = (float)(90 * n) / 7.0f;
                \u2603 = (float)(90 * \u2603) / 7.0f;
                \u2603 = this.func_217775_a(f6, \u2603, \u2603, f3, 8.0f);
                GlStateManager.translatef(0.0f, (\u2603 + 0.2f) * (\u2603 / 90.0f), 0.0f);
                GlStateManager.rotatef(-\u2603, 1.0f, 0.0f, 0.0f);
            } else if (n < 16) {
                float f7 = ((float)n - 8.0f) / 7.0f;
                \u2603 = 90.0f + 90.0f * f7;
                \u2603 = 90.0f + 90.0f * ((float)\u2603 - 8.0f) / 7.0f;
                \u2603 = this.func_217775_a(\u2603, \u2603, \u2603, f3, 16.0f);
                GlStateManager.translatef(0.0f, \u2603 + 0.2f + (\u2603 - 0.2f) * (\u2603 - 90.0f) / 90.0f, 0.0f);
                GlStateManager.rotatef(-\u2603, 1.0f, 0.0f, 0.0f);
            } else if ((float)n < 24.0f) {
                float f8 = ((float)n - 16.0f) / 7.0f;
                \u2603 = 180.0f + 90.0f * f8;
                \u2603 = 180.0f + 90.0f * ((float)\u2603 - 16.0f) / 7.0f;
                \u2603 = this.func_217775_a(\u2603, \u2603, \u2603, f3, 24.0f);
                GlStateManager.translatef(0.0f, \u2603 + \u2603 * (270.0f - \u2603) / 90.0f, 0.0f);
                GlStateManager.rotatef(-\u2603, 1.0f, 0.0f, 0.0f);
            } else if (n < 32) {
                float f9 = ((float)n - 24.0f) / 7.0f;
                \u2603 = 270.0f + 90.0f * f9;
                \u2603 = 270.0f + 90.0f * ((float)\u2603 - 24.0f) / 7.0f;
                \u2603 = this.func_217775_a(\u2603, \u2603, \u2603, f3, 32.0f);
                GlStateManager.translatef(0.0f, \u2603 * ((360.0f - \u2603) / 90.0f), 0.0f);
                GlStateManager.rotatef(-\u2603, 1.0f, 0.0f, 0.0f);
            }
        } else {
            GlStateManager.rotatef(0.0f, 1.0f, 0.0f, 0.0f);
        }
        float \u26033 = pandaEntity2.func_213561_v(f3);
        if (\u26033 > 0.0f) {
            GlStateManager.translatef(0.0f, 0.8f * \u26033, 0.0f);
            GlStateManager.rotatef(MathHelper.func_219799_g(\u26033, pandaEntity2.field_70125_A, pandaEntity2.field_70125_A + 90.0f), 1.0f, 0.0f, 0.0f);
            GlStateManager.translatef(0.0f, -1.0f * \u26033, 0.0f);
            if (pandaEntity2.func_213566_eo()) {
                float f10 = (float)(Math.cos((double)pandaEntity2.field_70173_aa * 1.25) * Math.PI * (double)0.05f);
                GlStateManager.rotatef(f10, 0.0f, 1.0f, 0.0f);
                if (pandaEntity2.func_70631_g_()) {
                    GlStateManager.translatef(0.0f, 0.8f, 0.55f);
                }
            }
        }
        if ((f4 = pandaEntity2.func_213583_w(f3)) > 0.0f) {
            \u26032 = pandaEntity2.func_70631_g_() ? 0.5f : 1.3f;
            GlStateManager.translatef(0.0f, \u26032 * f4, 0.0f);
            GlStateManager.rotatef(MathHelper.func_219799_g(f4, pandaEntity2.field_70125_A, pandaEntity2.field_70125_A + 180.0f), 1.0f, 0.0f, 0.0f);
        }
    }

    private float func_217775_a(float f, float f2, int n, float f3, float f4) {
        if ((float)n < f4) {
            return MathHelper.func_219799_g(f3, f, f2);
        }
        return f;
    }
}

