/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BuiltInModel;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockModel
implements IUnbakedModel {
    private static final Logger field_178313_f = LogManager.getLogger();
    private static final FaceBakery field_217647_g = new FaceBakery();
    @VisibleForTesting
    static final Gson field_178319_a = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new Deserializer()).registerTypeAdapter(BlockPart.class, (Object)new BlockPart.Deserializer()).registerTypeAdapter(BlockPartFace.class, (Object)new BlockPartFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3f.Deserializer()).registerTypeAdapter(ItemCameraTransforms.class, (Object)new ItemCameraTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).create();
    private final List<BlockPart> field_178314_g;
    private final boolean field_178321_h;
    private final boolean field_178322_i;
    private final ItemCameraTransforms field_178320_j;
    private final List<ItemOverride> field_187968_k;
    public String field_178317_b = "";
    @VisibleForTesting
    protected final Map<String, String> field_178318_c;
    @Nullable
    protected BlockModel field_178315_d;
    @Nullable
    protected ResourceLocation field_178316_e;

    public static BlockModel func_178307_a(Reader reader) {
        return JSONUtils.func_193839_a(field_178319_a, reader, BlockModel.class);
    }

    public static BlockModel func_178294_a(String string) {
        return BlockModel.func_178307_a(new StringReader(string));
    }

    public BlockModel(@Nullable ResourceLocation resourceLocation, List<BlockPart> list, Map<String, String> map, boolean bl, boolean bl2, ItemCameraTransforms itemCameraTransforms, List<ItemOverride> list2) {
        this.field_178314_g = list;
        this.field_178322_i = bl;
        this.field_178321_h = bl2;
        this.field_178318_c = map;
        this.field_178316_e = resourceLocation;
        this.field_178320_j = itemCameraTransforms;
        this.field_187968_k = list2;
    }

    public List<BlockPart> func_178298_a() {
        if (this.field_178314_g.isEmpty() && this.field_178315_d != null) {
            return this.field_178315_d.func_178298_a();
        }
        return this.field_178314_g;
    }

    public boolean func_178309_b() {
        if (this.field_178315_d != null) {
            return this.field_178315_d.func_178309_b();
        }
        return this.field_178322_i;
    }

    public boolean func_178311_c() {
        return this.field_178321_h;
    }

    public List<ItemOverride> func_187966_f() {
        return this.field_187968_k;
    }

    private ItemOverrideList func_217646_a(ModelBakery modelBakery, BlockModel blockModel) {
        if (this.field_187968_k.isEmpty()) {
            return ItemOverrideList.field_188022_a;
        }
        return new ItemOverrideList(modelBakery, blockModel, modelBakery::func_209597_a, this.field_187968_k);
    }

    @Override
    public Collection<ResourceLocation> func_187965_e() {
        HashSet hashSet = Sets.newHashSet();
        for (ItemOverride itemOverride : this.field_187968_k) {
            hashSet.add(itemOverride.func_188026_a());
        }
        if (this.field_178316_e != null) {
            hashSet.add(this.field_178316_e);
        }
        return hashSet;
    }

    @Override
    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> function2, Set<String> set) {
        Function<ResourceLocation, IUnbakedModel> function2;
        Object object;
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        BlockModel \u26032 = this;
        while (\u26032.field_178316_e != null && \u26032.field_178315_d == null) {
            linkedHashSet.add(\u26032);
            object = function2.apply(\u26032.field_178316_e);
            if (object == null) {
                field_178313_f.warn("No parent '{}' while loading model '{}'", (Object)this.field_178316_e, (Object)\u26032);
            }
            if (linkedHashSet.contains(object)) {
                field_178313_f.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", (Object)\u26032, (Object)linkedHashSet.stream().map(Object::toString).collect(Collectors.joining(" -> ")), (Object)this.field_178316_e);
                object = null;
            }
            if (object == null) {
                \u26032.field_178316_e = ModelBakery.field_177604_a;
                object = function2.apply(\u26032.field_178316_e);
            }
            if (!(object instanceof BlockModel)) {
                throw new IllegalStateException("BlockModel parent has to be a block model.");
            }
            \u26032.field_178315_d = (BlockModel)object;
            \u26032 = \u26032.field_178315_d;
        }
        object = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation(this.func_178308_c("particle"))});
        for (BlockPart blockPart : this.func_178298_a()) {
            for (BlockPartFace blockPartFace : blockPart.field_178240_c.values()) {
                String string = this.func_178308_c(blockPartFace.field_178242_d);
                if (Objects.equals(string, MissingTextureSprite.func_195675_b().toString())) {
                    set.add(String.format("%s in %s", blockPartFace.field_178242_d, this.field_178317_b));
                }
                object.add(new ResourceLocation(string));
            }
        }
        this.field_187968_k.forEach(arg_0 -> this.func_217643_a(function2, (Set)object, set, arg_0));
        if (this.func_178310_f() == ModelBakery.field_177606_o) {
            ItemModelGenerator.field_178398_a.forEach(arg_0 -> this.func_217642_a((Set)object, arg_0));
        }
        return object;
    }

    @Override
    public IBakedModel func_217641_a(ModelBakery modelBakery, Function<ResourceLocation, TextureAtlasSprite> function, ISprite iSprite) {
        return this.func_217644_a(modelBakery, this, function, iSprite);
    }

    public IBakedModel func_217644_a(ModelBakery modelBakery, BlockModel blockModel, Function<ResourceLocation, TextureAtlasSprite> function, ISprite iSprite) {
        TextureAtlasSprite textureAtlasSprite = function.apply(new ResourceLocation(this.func_178308_c("particle")));
        if (this.func_178310_f() == ModelBakery.field_177616_r) {
            return new BuiltInModel(this.func_181682_g(), this.func_217646_a(modelBakery, blockModel), textureAtlasSprite);
        }
        SimpleBakedModel.Builder \u26032 = new SimpleBakedModel.Builder(this, this.func_217646_a(modelBakery, blockModel)).func_177646_a(textureAtlasSprite);
        for (BlockPart blockPart : this.func_178298_a()) {
            for (Direction direction : blockPart.field_178240_c.keySet()) {
                BlockPartFace blockPartFace = blockPart.field_178240_c.get(direction);
                TextureAtlasSprite \u26033 = function.apply(new ResourceLocation(this.func_178308_c(blockPartFace.field_178242_d)));
                if (blockPartFace.field_178244_b == null) {
                    \u26032.func_177648_a(BlockModel.func_217645_a(blockPart, blockPartFace, \u26033, direction, iSprite));
                    continue;
                }
                \u26032.func_177650_a(iSprite.func_188048_b().func_177523_a(blockPartFace.field_178244_b), BlockModel.func_217645_a(blockPart, blockPartFace, \u26033, direction, iSprite));
            }
        }
        return \u26032.func_177645_b();
    }

    private static BakedQuad func_217645_a(BlockPart blockPart, BlockPartFace blockPartFace, TextureAtlasSprite textureAtlasSprite, Direction direction, ISprite iSprite) {
        return field_217647_g.func_217648_a(blockPart.field_178241_a, blockPart.field_178239_b, blockPartFace, textureAtlasSprite, direction, iSprite, blockPart.field_178237_d, blockPart.field_178238_e);
    }

    public boolean func_178300_b(String string) {
        return !MissingTextureSprite.func_195675_b().toString().equals(this.func_178308_c(string));
    }

    public String func_178308_c(String string) {
        if (!this.func_178304_d(string)) {
            string = '#' + string;
        }
        return this.func_178302_a(string, new Bookkeep(this));
    }

    private String func_178302_a(String string2, Bookkeep bookkeep) {
        String string2;
        if (this.func_178304_d(string2)) {
            if (this == bookkeep.field_178323_b) {
                field_178313_f.warn("Unable to resolve texture due to upward reference: {} in {}", (Object)string2, (Object)this.field_178317_b);
                return MissingTextureSprite.func_195675_b().toString();
            }
            String string3 = this.field_178318_c.get(string2.substring(1));
            if (string3 == null && this.field_178315_d != null) {
                string3 = this.field_178315_d.func_178302_a(string2, bookkeep);
            }
            bookkeep.field_178323_b = this;
            if (string3 != null && this.func_178304_d(string3)) {
                string3 = bookkeep.field_178324_a.func_178302_a(string3, bookkeep);
            }
            if (string3 == null || this.func_178304_d(string3)) {
                return MissingTextureSprite.func_195675_b().toString();
            }
            return string3;
        }
        return string2;
    }

    private boolean func_178304_d(String string) {
        return string.charAt(0) == '#';
    }

    public BlockModel func_178310_f() {
        return this.field_178315_d == null ? this : this.field_178315_d.func_178310_f();
    }

    public ItemCameraTransforms func_181682_g() {
        ItemTransformVec3f itemTransformVec3f = this.func_181681_a(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.HEAD);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.GUI);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.GROUND);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.FIXED);
        return new ItemCameraTransforms(itemTransformVec3f, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603);
    }

    private ItemTransformVec3f func_181681_a(ItemCameraTransforms.TransformType transformType) {
        if (this.field_178315_d != null && !this.field_178320_j.func_181687_c(transformType)) {
            return this.field_178315_d.func_181681_a(transformType);
        }
        return this.field_178320_j.func_181688_b(transformType);
    }

    public String toString() {
        return this.field_178317_b;
    }

    private /* synthetic */ void func_217642_a(Set set, String string) {
        set.add(new ResourceLocation(this.func_178308_c(string)));
    }

    private /* synthetic */ void func_217643_a(Function function, Set set, Set set2, ItemOverride itemOverride) {
        IUnbakedModel iUnbakedModel = (IUnbakedModel)function.apply(itemOverride.func_188026_a());
        if (Objects.equals(iUnbakedModel, this)) {
            return;
        }
        set.addAll(iUnbakedModel.func_209559_a(function, set2));
    }

    public static class Deserializer
    implements JsonDeserializer<BlockModel> {
        public BlockModel deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext2) throws JsonParseException {
            JsonDeserializationContext jsonDeserializationContext2;
            Object \u26037;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            List<BlockPart> \u26032 = this.func_178325_a(jsonDeserializationContext2, jsonObject);
            String \u26033 = this.func_178326_c(jsonObject);
            Map<String, String> \u26034 = this.func_178329_b(jsonObject);
            boolean \u26035 = this.func_178328_a(jsonObject);
            ItemCameraTransforms \u26036 = ItemCameraTransforms.field_178357_a;
            if (jsonObject.has("display")) {
                \u26037 = JSONUtils.func_152754_s(jsonObject, "display");
                \u26036 = (ItemCameraTransforms)jsonDeserializationContext2.deserialize((JsonElement)\u26037, ItemCameraTransforms.class);
            }
            \u26037 = this.func_187964_a(jsonDeserializationContext2, jsonObject);
            ResourceLocation \u26038 = \u26033.isEmpty() ? null : new ResourceLocation(\u26033);
            return new BlockModel(\u26038, \u26032, \u26034, \u26035, true, \u26036, (List<ItemOverride>)\u26037);
        }

        protected List<ItemOverride> func_187964_a(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObject) {
            ArrayList arrayList = Lists.newArrayList();
            if (jsonObject.has("overrides")) {
                JsonArray jsonArray = JSONUtils.func_151214_t(jsonObject, "overrides");
                for (JsonElement jsonElement : jsonArray) {
                    arrayList.add(jsonDeserializationContext.deserialize(jsonElement, ItemOverride.class));
                }
            }
            return arrayList;
        }

        private Map<String, String> func_178329_b(JsonObject jsonObject) {
            HashMap hashMap = Maps.newHashMap();
            if (jsonObject.has("textures")) {
                JsonObject jsonObject2 = JSONUtils.func_152754_s(jsonObject, "textures");
                for (Map.Entry entry : jsonObject2.entrySet()) {
                    hashMap.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
            }
            return hashMap;
        }

        private String func_178326_c(JsonObject jsonObject) {
            return JSONUtils.func_151219_a(jsonObject, "parent", "");
        }

        protected boolean func_178328_a(JsonObject jsonObject) {
            return JSONUtils.func_151209_a(jsonObject, "ambientocclusion", true);
        }

        protected List<BlockPart> func_178325_a(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObject) {
            ArrayList arrayList = Lists.newArrayList();
            if (jsonObject.has("elements")) {
                for (JsonElement jsonElement : JSONUtils.func_151214_t(jsonObject, "elements")) {
                    arrayList.add(jsonDeserializationContext.deserialize(jsonElement, BlockPart.class));
                }
            }
            return arrayList;
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }

    static final class Bookkeep {
        public final BlockModel field_178324_a;
        public BlockModel field_178323_b;

        private Bookkeep(BlockModel blockModel) {
            this.field_178324_a = blockModel;
        }
    }
}

