/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.WallSkullBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.GenericHeadModel;
import net.minecraft.client.renderer.entity.model.HumanoidHeadModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.model.DragonHeadModel;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class SkullTileEntityRenderer
extends TileEntityRenderer<SkullTileEntity> {
    public static SkullTileEntityRenderer field_147536_b;
    private static final Map<SkullBlock.ISkullType, GenericHeadModel> field_199358_e;
    private static final Map<SkullBlock.ISkullType, ResourceLocation> field_199357_d;

    @Override
    public void func_199341_a(SkullTileEntity skullTileEntity, double d, double d2, double d3, float f, int n) {
        float f2 = skullTileEntity.func_184295_a(f);
        BlockState \u26032 = skullTileEntity.func_195044_w();
        boolean \u26033 = \u26032.func_177230_c() instanceof WallSkullBlock;
        Direction \u26034 = \u26033 ? \u26032.func_177229_b(WallSkullBlock.field_196302_a) : null;
        \u2603 = 22.5f * (float)(\u26033 ? (2 + \u26034.func_176736_b()) * 4 : \u26032.func_177229_b(SkullBlock.field_196294_a));
        this.func_199355_a((float)d, (float)d2, (float)d3, \u26034, \u2603, ((AbstractSkullBlock)\u26032.func_177230_c()).func_196292_N_(), skullTileEntity.func_152108_a(), n, f2);
    }

    @Override
    public void func_147497_a(TileEntityRendererDispatcher tileEntityRendererDispatcher) {
        super.func_147497_a(tileEntityRendererDispatcher);
        field_147536_b = this;
    }

    public void func_199355_a(float f, float f2, float f3, @Nullable Direction direction, float f4, SkullBlock.ISkullType iSkullType, @Nullable GameProfile gameProfile, int n, float f5) {
        GenericHeadModel genericHeadModel = field_199358_e.get(iSkullType);
        if (n >= 0) {
            this.func_147499_a(field_178460_a[n]);
            GlStateManager.matrixMode(5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef(4.0f, 2.0f, 1.0f);
            GlStateManager.translatef(0.0625f, 0.0625f, 0.0625f);
            GlStateManager.matrixMode(5888);
        } else {
            this.func_147499_a(this.func_199356_a(iSkullType, gameProfile));
        }
        GlStateManager.pushMatrix();
        GlStateManager.disableCull();
        if (direction == null) {
            GlStateManager.translatef(f + 0.5f, f2, f3 + 0.5f);
        } else {
            switch (direction) {
                case NORTH: {
                    GlStateManager.translatef(f + 0.5f, f2 + 0.25f, f3 + 0.74f);
                    break;
                }
                case SOUTH: {
                    GlStateManager.translatef(f + 0.5f, f2 + 0.25f, f3 + 0.26f);
                    break;
                }
                case WEST: {
                    GlStateManager.translatef(f + 0.74f, f2 + 0.25f, f3 + 0.5f);
                    break;
                }
                default: {
                    GlStateManager.translatef(f + 0.26f, f2 + 0.25f, f3 + 0.5f);
                }
            }
        }
        GlStateManager.enableRescaleNormal();
        GlStateManager.scalef(-1.0f, -1.0f, 1.0f);
        GlStateManager.enableAlphaTest();
        if (iSkullType == SkullBlock.Types.PLAYER) {
            GlStateManager.setProfile(GlStateManager.Profile.PLAYER_SKIN);
        }
        genericHeadModel.func_217104_a(f5, 0.0f, 0.0f, f4, 0.0f, 0.0625f);
        GlStateManager.popMatrix();
        if (n >= 0) {
            GlStateManager.matrixMode(5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode(5888);
        }
    }

    private ResourceLocation func_199356_a(SkullBlock.ISkullType iSkullType, @Nullable GameProfile gameProfile) {
        ResourceLocation \u26033 = field_199357_d.get(iSkullType);
        if (iSkullType == SkullBlock.Types.PLAYER && gameProfile != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> \u26032 = minecraft.func_152342_ad().func_152788_a(gameProfile);
            \u26033 = \u26032.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.func_152342_ad().func_152792_a(\u26032.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.func_177334_a(PlayerEntity.func_146094_a(gameProfile));
        }
        return \u26033;
    }

    static {
        field_199358_e = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
            GenericHeadModel genericHeadModel = new GenericHeadModel(0, 0, 64, 32);
            HumanoidHeadModel \u26032 = new HumanoidHeadModel();
            DragonHeadModel \u26033 = new DragonHeadModel(0.0f);
            hashMap.put(SkullBlock.Types.SKELETON, genericHeadModel);
            hashMap.put(SkullBlock.Types.WITHER_SKELETON, genericHeadModel);
            hashMap.put(SkullBlock.Types.PLAYER, \u26032);
            hashMap.put(SkullBlock.Types.ZOMBIE, \u26032);
            hashMap.put(SkullBlock.Types.CREEPER, genericHeadModel);
            hashMap.put(SkullBlock.Types.DRAGON, \u26033);
        });
        field_199357_d = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
            hashMap.put(SkullBlock.Types.SKELETON, new ResourceLocation("textures/entity/skeleton/skeleton.png"));
            hashMap.put(SkullBlock.Types.WITHER_SKELETON, new ResourceLocation("textures/entity/skeleton/wither_skeleton.png"));
            hashMap.put(SkullBlock.Types.ZOMBIE, new ResourceLocation("textures/entity/zombie/zombie.png"));
            hashMap.put(SkullBlock.Types.CREEPER, new ResourceLocation("textures/entity/creeper/creeper.png"));
            hashMap.put(SkullBlock.Types.DRAGON, new ResourceLocation("textures/entity/enderdragon/dragon.png"));
            hashMap.put(SkullBlock.Types.PLAYER, DefaultPlayerSkin.func_177335_a());
        });
    }
}

