/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.WorkingScreen;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.client.resources.ResourceIndex;
import net.minecraft.client.resources.VirtualAssetsPack;
import net.minecraft.resources.FilePack;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.VanillaPack;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.util.HTTPUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DownloadingPackFinder
implements IPackFinder {
    private static final Logger field_195751_a = LogManager.getLogger();
    private static final Pattern field_195752_b = Pattern.compile("^[a-fA-F0-9]{40}$");
    private final VanillaPack field_195753_c;
    private final File field_195754_d;
    private final ReentrantLock field_195755_e = new ReentrantLock();
    private final ResourceIndex field_217819_f;
    @Nullable
    private CompletableFuture<?> field_195756_f;
    @Nullable
    private ClientResourcePackInfo field_195757_g;

    public DownloadingPackFinder(File file, ResourceIndex resourceIndex) {
        this.field_195754_d = file;
        this.field_217819_f = resourceIndex;
        this.field_195753_c = new VirtualAssetsPack(resourceIndex);
    }

    @Override
    public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> map, ResourcePackInfo.IFactory<T> iFactory) {
        T t = ResourcePackInfo.func_195793_a("vanilla", true, () -> this.field_195753_c, iFactory, ResourcePackInfo.Priority.BOTTOM);
        if (t != null) {
            map.put("vanilla", t);
        }
        if (this.field_195757_g != null) {
            map.put("server", this.field_195757_g);
        }
        if ((\u2603 = this.field_217819_f.func_188547_a(new ResourceLocation("resourcepacks/programmer_art.zip"))) != null && \u2603.isFile() && (\u2603 = ResourcePackInfo.func_195793_a("programer_art", false, () -> new FilePack(\u2603){

            @Override
            public String func_195762_a() {
                return "Programmer Art";
            }
        }, iFactory, ResourcePackInfo.Priority.TOP)) != null) {
            map.put("programer_art", \u2603);
        }
    }

    public VanillaPack func_195746_a() {
        return this.field_195753_c;
    }

    public static Map<String, String> func_195742_b() {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("X-Minecraft-Username", Minecraft.func_71410_x().func_110432_I().func_111285_a());
        hashMap.put("X-Minecraft-UUID", Minecraft.func_71410_x().func_110432_I().func_148255_b());
        hashMap.put("X-Minecraft-Version", SharedConstants.func_215069_a().getName());
        hashMap.put("X-Minecraft-Version-ID", SharedConstants.func_215069_a().getId());
        hashMap.put("X-Minecraft-Pack-Format", String.valueOf(SharedConstants.func_215069_a().getPackVersion()));
        hashMap.put("User-Agent", "Minecraft Java/" + SharedConstants.func_215069_a().getName());
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<?> func_217818_a(String string, String string2) {
        \u2603 = DigestUtils.sha1Hex((String)string);
        \u2603 = field_195752_b.matcher(string2).matches() ? string2 : "";
        this.field_195755_e.lock();
        try {
            CompletableFuture<String> \u26034;
            this.func_195749_c();
            this.func_195747_e();
            File file = new File(this.field_195754_d, \u2603);
            if (file.exists()) {
                \u26034 = CompletableFuture.completedFuture("");
            } else {
                WorkingScreen workingScreen = new WorkingScreen();
                Map<String, String> \u26032 = DownloadingPackFinder.func_195742_b();
                Minecraft \u26033 = Minecraft.func_71410_x();
                \u26033.func_213167_f(() -> \u26033.func_147108_a(workingScreen));
                \u26034 = HTTPUtil.func_180192_a(file, string, \u26032, 0x3200000, workingScreen, \u26033.func_110437_J());
            }
            CompletableFuture<?> completableFuture = this.field_195756_f = ((CompletableFuture)\u26034.thenCompose(object -> {
                if (!this.func_195745_a(\u2603, file)) {
                    return Util.func_215087_a(new RuntimeException("Hash check failure for file " + file + ", see log"));
                }
                return this.func_217816_a(file);
            })).whenComplete((void_, throwable) -> {
                if (throwable != null) {
                    field_195751_a.warn("Pack application failed: {}, deleting file {}", (Object)throwable.getMessage(), (Object)file);
                    DownloadingPackFinder.func_217811_b(file);
                }
            });
            return completableFuture;
        }
        finally {
            this.field_195755_e.unlock();
        }
    }

    private static void func_217811_b(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException iOException) {
            field_195751_a.warn("Failed to delete file {}: {}", (Object)file, (Object)iOException.getMessage());
        }
    }

    public void func_195749_c() {
        this.field_195755_e.lock();
        try {
            if (this.field_195756_f != null) {
                this.field_195756_f.cancel(true);
            }
            this.field_195756_f = null;
            if (this.field_195757_g != null) {
                this.field_195757_g = null;
                Minecraft.func_71410_x().func_213245_w();
            }
        }
        finally {
            this.field_195755_e.unlock();
        }
    }

    private boolean func_195745_a(String string2, File file) {
        try {
            String string2;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                String string3 = DigestUtils.sha1Hex((InputStream)fileInputStream);
            }
            if (string2.isEmpty()) {
                field_195751_a.info("Found file {} without verification hash", (Object)file);
                return true;
            }
            if (string3.toLowerCase(Locale.ROOT).equals(string2.toLowerCase(Locale.ROOT))) {
                field_195751_a.info("Found file {} matching requested hash {}", (Object)file, (Object)string2);
                return true;
            }
            field_195751_a.warn("File {} had wrong hash (expected {}, found {}).", (Object)file, (Object)string2, (Object)string3);
        }
        catch (IOException iOException) {
            field_195751_a.warn("File {} couldn't be hashed.", (Object)file, (Object)iOException);
        }
        return false;
    }

    private void func_195747_e() {
        try {
            ArrayList arrayList = Lists.newArrayList((Iterable)FileUtils.listFiles((File)this.field_195754_d, (IOFileFilter)TrueFileFilter.TRUE, null));
            arrayList.sort(LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            int \u26032 = 0;
            for (File file : arrayList) {
                if (\u26032++ < 10) continue;
                field_195751_a.info("Deleting old server resource pack {}", (Object)file.getName());
                FileUtils.deleteQuietly((File)file);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            field_195751_a.error("Error while deleting old server resource pack : {}", (Object)illegalArgumentException.getMessage());
        }
    }

    public CompletableFuture<Void> func_217816_a(File file) {
        PackMetadataSection packMetadataSection = null;
        NativeImage \u26032 = null;
        String \u26033 = null;
        try (FilePack filePack = new FilePack(file);){
            packMetadataSection = filePack.func_195760_a(PackMetadataSection.field_198964_a);
            try (InputStream inputStream = filePack.func_195763_b("pack.png");){
                \u26032 = NativeImage.func_195713_a(inputStream);
            }
            catch (IOException | IllegalArgumentException exception) {
                field_195751_a.info("Could not read pack.png: {}", (Object)exception.getMessage());
            }
        }
        catch (IOException iOException) {
            \u26033 = iOException.getMessage();
        }
        if (\u26033 != null) {
            return Util.func_215087_a(new RuntimeException(String.format("Invalid resourcepack at %s: %s", file, \u26033)));
        }
        field_195751_a.info("Applying server pack {}", (Object)file);
        this.field_195757_g = new ClientResourcePackInfo("server", true, () -> new FilePack(file), new TranslationTextComponent("resourcePack.server.name", new Object[0]), packMetadataSection.func_198963_a(), PackCompatibility.func_198969_a(packMetadataSection.func_198962_b()), ResourcePackInfo.Priority.TOP, true, \u26032);
        return Minecraft.func_71410_x().func_213245_w();
    }
}

