/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.client.util.JSONException;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class ShaderGroup
implements AutoCloseable {
    private final Framebuffer field_148035_a;
    private final IResourceManager field_148033_b;
    private final String field_148034_c;
    private final List<Shader> field_148031_d = Lists.newArrayList();
    private final Map<String, Framebuffer> field_148032_e = Maps.newHashMap();
    private final List<Framebuffer> field_148029_f = Lists.newArrayList();
    private Matrix4f field_148030_g;
    private int field_148038_h;
    private int field_148039_i;
    private float field_148036_j;
    private float field_148037_k;

    public ShaderGroup(TextureManager textureManager, IResourceManager iResourceManager, Framebuffer framebuffer, ResourceLocation resourceLocation) throws IOException, JsonSyntaxException {
        this.field_148033_b = iResourceManager;
        this.field_148035_a = framebuffer;
        this.field_148036_j = 0.0f;
        this.field_148037_k = 0.0f;
        this.field_148038_h = framebuffer.field_147621_c;
        this.field_148039_i = framebuffer.field_147618_d;
        this.field_148034_c = resourceLocation.toString();
        this.func_148024_c();
        this.func_152765_a(textureManager, resourceLocation);
    }

    private void func_152765_a(TextureManager textureManager, ResourceLocation resourceLocation) throws IOException, JsonSyntaxException {
        IResource iResource;
        block11: {
            iResource = null;
            try {
                int \u26032;
                JsonArray \u26033;
                iResource = this.field_148033_b.func_199002_a(resourceLocation);
                JsonObject jsonObject = JSONUtils.func_212743_a(new InputStreamReader(iResource.func_199027_b(), StandardCharsets.UTF_8));
                if (JSONUtils.func_151202_d(jsonObject, "targets")) {
                    \u26033 = jsonObject.getAsJsonArray("targets");
                    \u26032 = 0;
                    for (JsonElement jsonElement : \u26033) {
                        try {
                            this.func_148027_a(jsonElement);
                        }
                        catch (Exception exception) {
                            JSONException jSONException = JSONException.func_151379_a(exception);
                            jSONException.func_151380_a("targets[" + \u26032 + "]");
                            throw jSONException;
                        }
                        ++\u26032;
                    }
                }
                if (!JSONUtils.func_151202_d(jsonObject, "passes")) break block11;
                \u26033 = jsonObject.getAsJsonArray("passes");
                \u26032 = 0;
                for (JsonElement jsonElement : \u26033) {
                    try {
                        this.func_152764_a(textureManager, jsonElement);
                    }
                    catch (Exception exception) {
                        JSONException jSONException = JSONException.func_151379_a(exception);
                        jSONException.func_151380_a("passes[" + \u26032 + "]");
                        throw jSONException;
                    }
                    ++\u26032;
                }
            }
            catch (Exception exception) {
                try {
                    JSONException jSONException = JSONException.func_151379_a(exception);
                    jSONException.func_151381_b(resourceLocation.func_110623_a());
                    throw jSONException;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(iResource);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((Closeable)iResource);
    }

    private void func_148027_a(JsonElement jsonElement) throws JSONException {
        if (JSONUtils.func_151211_a(jsonElement)) {
            this.func_148020_a(jsonElement.getAsString(), this.field_148038_h, this.field_148039_i);
        } else {
            JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "target");
            String \u26032 = JSONUtils.func_151200_h(jsonObject, "name");
            int \u26033 = JSONUtils.func_151208_a(jsonObject, "width", this.field_148038_h);
            int \u26034 = JSONUtils.func_151208_a(jsonObject, "height", this.field_148039_i);
            if (this.field_148032_e.containsKey(\u26032)) {
                throw new JSONException(\u26032 + " is already defined");
            }
            this.func_148020_a(\u26032, \u26033, \u26034);
        }
    }

    private void func_152764_a(TextureManager textureManager, JsonElement jsonElement) throws IOException {
        JsonArray jsonArray;
        Object \u260311;
        block16: {
            JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "pass");
            String \u26032 = JSONUtils.func_151200_h(jsonObject, "name");
            String \u26033 = JSONUtils.func_151200_h(jsonObject, "intarget");
            String \u26034 = JSONUtils.func_151200_h(jsonObject, "outtarget");
            Framebuffer \u26035 = this.func_148017_a(\u26033);
            Framebuffer \u26036 = this.func_148017_a(\u26034);
            if (\u26035 == null) {
                throw new JSONException("Input target '" + \u26033 + "' does not exist");
            }
            if (\u26036 == null) {
                throw new JSONException("Output target '" + \u26034 + "' does not exist");
            }
            Shader \u26037 = this.func_148023_a(\u26032, \u26035, \u26036);
            JsonArray \u26038 = JSONUtils.func_151213_a(jsonObject, "auxtargets", null);
            if (\u26038 == null) break block16;
            int \u26039 = 0;
            for (JsonElement jsonElement2 : \u26038) {
                block15: {
                    Object \u260310;
                    try {
                        Framebuffer \u260312;
                        block17: {
                            JsonObject jsonObject2 = JSONUtils.func_151210_l(jsonElement2, "auxtarget");
                            \u260310 = JSONUtils.func_151200_h(jsonObject2, "name");
                            \u260311 = JSONUtils.func_151200_h(jsonObject2, "id");
                            \u260312 = this.func_148017_a((String)\u260311);
                            if (\u260312 != null) break block17;
                            ResourceLocation \u260313 = new ResourceLocation("textures/effect/" + (String)\u260311 + ".png");
                            IResource \u260314 = null;
                            try {
                                \u260314 = this.field_148033_b.func_199002_a(\u260313);
                            }
                            catch (FileNotFoundException \u260315) {
                                try {
                                    throw new JSONException("Render target or texture '" + (String)\u260311 + "' does not exist");
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(\u260314);
                                    throw throwable;
                                }
                            }
                            IOUtils.closeQuietly((Closeable)\u260314);
                            textureManager.func_110577_a(\u260313);
                            ITextureObject \u260316 = textureManager.func_110581_b(\u260313);
                            int \u260317 = JSONUtils.func_151203_m(jsonObject2, "width");
                            int \u260318 = JSONUtils.func_151203_m(jsonObject2, "height");
                            boolean \u260319 = JSONUtils.func_151212_i(jsonObject2, "bilinear");
                            if (\u260319) {
                                GlStateManager.texParameter(3553, 10241, 9729);
                                GlStateManager.texParameter(3553, 10240, 9729);
                            } else {
                                GlStateManager.texParameter(3553, 10241, 9728);
                                GlStateManager.texParameter(3553, 10240, 9728);
                            }
                            \u26037.func_148041_a((String)\u260310, \u260316.func_110552_b(), \u260317, \u260318);
                            break block15;
                        }
                        \u26037.func_148041_a((String)\u260310, \u260312, \u260312.field_147622_a, \u260312.field_147620_b);
                    }
                    catch (Exception exception) {
                        \u260310 = JSONException.func_151379_a(exception);
                        ((JSONException)\u260310).func_151380_a("auxtargets[" + \u26039 + "]");
                        throw \u260310;
                    }
                }
                ++\u26039;
            }
        }
        if ((jsonArray = JSONUtils.func_151213_a(jsonObject, "uniforms", null)) != null) {
            int n = 0;
            for (JsonObject jsonObject2 : jsonArray) {
                try {
                    this.func_148028_c((JsonElement)jsonObject2);
                }
                catch (Exception exception) {
                    \u260311 = JSONException.func_151379_a(exception);
                    ((JSONException)\u260311).func_151380_a("uniforms[" + n + "]");
                    throw \u260311;
                }
                ++n;
            }
        }
    }

    private void func_148028_c(JsonElement jsonElement) throws JSONException {
        JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "uniform");
        String \u26032 = JSONUtils.func_151200_h(jsonObject, "name");
        ShaderUniform \u26033 = this.field_148031_d.get(this.field_148031_d.size() - 1).func_217624_b().func_216539_a(\u26032);
        if (\u26033 == null) {
            throw new JSONException("Uniform '" + \u26032 + "' does not exist");
        }
        float[] \u26034 = new float[4];
        int \u26035 = 0;
        JsonArray \u26036 = JSONUtils.func_151214_t(jsonObject, "values");
        for (JsonElement jsonElement2 : \u26036) {
            try {
                \u26034[\u26035] = JSONUtils.func_151220_d(jsonElement2, "value");
            }
            catch (Exception exception) {
                JSONException jSONException = JSONException.func_151379_a(exception);
                jSONException.func_151380_a("values[" + \u26035 + "]");
                throw jSONException;
            }
            ++\u26035;
        }
        switch (\u26035) {
            case 0: {
                break;
            }
            case 1: {
                \u26033.func_148090_a(\u26034[0]);
                break;
            }
            case 2: {
                \u26033.func_148087_a(\u26034[0], \u26034[1]);
                break;
            }
            case 3: {
                \u26033.func_148095_a(\u26034[0], \u26034[1], \u26034[2]);
                break;
            }
            case 4: {
                \u26033.func_148081_a(\u26034[0], \u26034[1], \u26034[2], \u26034[3]);
            }
        }
    }

    public Framebuffer func_177066_a(String string) {
        return this.field_148032_e.get(string);
    }

    public void func_148020_a(String string, int n, int n2) {
        Framebuffer framebuffer = new Framebuffer(n, n2, true, Minecraft.field_142025_a);
        framebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.field_148032_e.put(string, framebuffer);
        if (n == this.field_148038_h && n2 == this.field_148039_i) {
            this.field_148029_f.add(framebuffer);
        }
    }

    @Override
    public void close() {
        for (Framebuffer framebuffer : this.field_148032_e.values()) {
            framebuffer.func_147608_a();
        }
        for (Shader shader : this.field_148031_d) {
            shader.close();
        }
        this.field_148031_d.clear();
    }

    public Shader func_148023_a(String string, Framebuffer framebuffer, Framebuffer framebuffer2) throws IOException {
        Shader shader = new Shader(this.field_148033_b, string, framebuffer, framebuffer2);
        this.field_148031_d.add(this.field_148031_d.size(), shader);
        return shader;
    }

    private void func_148024_c() {
        this.field_148030_g = Matrix4f.func_195877_a(this.field_148035_a.field_147622_a, this.field_148035_a.field_147620_b, 0.1f, 1000.0f);
    }

    public void func_148026_a(int n, int n2) {
        this.field_148038_h = this.field_148035_a.field_147622_a;
        this.field_148039_i = this.field_148035_a.field_147620_b;
        this.func_148024_c();
        for (Shader shader : this.field_148031_d) {
            shader.func_195654_a(this.field_148030_g);
        }
        for (Framebuffer framebuffer : this.field_148029_f) {
            framebuffer.func_216491_a(n, n2, Minecraft.field_142025_a);
        }
    }

    public void func_148018_a(float f) {
        if (f < this.field_148037_k) {
            this.field_148036_j += 1.0f - this.field_148037_k;
            this.field_148036_j += f;
        } else {
            this.field_148036_j += f - this.field_148037_k;
        }
        this.field_148037_k = f;
        while (this.field_148036_j > 20.0f) {
            this.field_148036_j -= 20.0f;
        }
        for (Shader shader : this.field_148031_d) {
            shader.func_148042_a(this.field_148036_j / 20.0f);
        }
    }

    public final String func_148022_b() {
        return this.field_148034_c;
    }

    private Framebuffer func_148017_a(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("minecraft:main")) {
            return this.field_148035_a;
        }
        return this.field_148032_e.get(string);
    }
}

