/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item.minecart;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.item.minecart.HopperMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartCommandBlockEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.item.minecart.SpawnerMinecartEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public abstract class AbstractMinecartEntity
extends Entity {
    private static final DataParameter<Integer> field_184265_a = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184266_b = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Float> field_184267_c = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184268_d = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184269_e = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184270_f = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187198_h);
    private boolean field_70499_f;
    private static final int[][][] field_70500_g = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int field_70510_h;
    private double field_70511_i;
    private double field_70509_j;
    private double field_70514_an;
    private double field_70512_ao;
    private double field_70513_ap;
    private double field_70508_aq;
    private double field_70507_ar;
    private double field_70506_as;

    protected AbstractMinecartEntity(EntityType<?> entityType, World world) {
        super(entityType, world);
        this.field_70156_m = true;
    }

    protected AbstractMinecartEntity(EntityType<?> entityType, World world, double d, double d2, double d3) {
        this(entityType, world);
        this.func_70107_b(d, d2, d3);
        this.func_213317_d(Vec3d.field_186680_a);
        this.field_70169_q = d;
        this.field_70167_r = d2;
        this.field_70166_s = d3;
    }

    public static AbstractMinecartEntity func_184263_a(World world, double d, double d2, double d3, Type type) {
        if (type == Type.CHEST) {
            return new ChestMinecartEntity(world, d, d2, d3);
        }
        if (type == Type.FURNACE) {
            return new FurnaceMinecartEntity(world, d, d2, d3);
        }
        if (type == Type.TNT) {
            return new TNTMinecartEntity(world, d, d2, d3);
        }
        if (type == Type.SPAWNER) {
            return new SpawnerMinecartEntity(world, d, d2, d3);
        }
        if (type == Type.HOPPER) {
            return new HopperMinecartEntity(world, d, d2, d3);
        }
        if (type == Type.COMMAND_BLOCK) {
            return new MinecartCommandBlockEntity(world, d, d2, d3);
        }
        return new MinecartEntity(world, d, d2, d3);
    }

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184265_a, 0);
        this.field_70180_af.func_187214_a(field_184266_b, 1);
        this.field_70180_af.func_187214_a(field_184267_c, Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(field_184268_d, Block.func_196246_j(Blocks.field_150350_a.func_176223_P()));
        this.field_70180_af.func_187214_a(field_184269_e, 6);
        this.field_70180_af.func_187214_a(field_184270_f, false);
    }

    @Override
    @Nullable
    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity.func_70104_M()) {
            return entity.func_174813_aQ();
        }
        return null;
    }

    @Override
    public boolean func_70104_M() {
        return true;
    }

    @Override
    public double func_70042_X() {
        return 0.0;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + f * 10.0f);
        boolean bl = \u2603 = damageSource.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)damageSource.func_76346_g()).field_71075_bZ.field_75098_d;
        if (\u2603 || this.func_70491_i() > 40.0f) {
            this.func_184226_ay();
            if (!\u2603 || this.func_145818_k_()) {
                this.func_94095_a(damageSource);
            } else {
                this.func_70106_y();
            }
        }
        return true;
    }

    public void func_94095_a(DamageSource damageSource) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack itemStack = new ItemStack(Items.field_151143_au);
            if (this.func_145818_k_()) {
                itemStack.func_200302_a(this.func_200201_e());
            }
            this.func_199701_a_(itemStack);
        }
    }

    @Override
    public void func_70057_ab() {
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70492_c(this.func_70491_i() + this.func_70491_i() * 10.0f);
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Override
    public Direction func_184172_bi() {
        return this.field_70499_f ? this.func_174811_aO().func_176734_d().func_176746_e() : this.func_174811_aO().func_176746_e();
    }

    @Override
    public void func_70071_h_() {
        int n;
        if (this.func_70496_j() > 0) {
            this.func_70497_h(this.func_70496_j() - 1);
        }
        if (this.func_70491_i() > 0.0f) {
            this.func_70492_c(this.func_70491_i() - 1.0f);
        }
        if (this.field_70163_u < -64.0) {
            this.func_70076_C();
        }
        this.func_213284_aV();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70510_h > 0) {
                double d = this.field_70165_t + (this.field_70511_i - this.field_70165_t) / (double)this.field_70510_h;
                \u2603 = this.field_70163_u + (this.field_70509_j - this.field_70163_u) / (double)this.field_70510_h;
                \u2603 = this.field_70161_v + (this.field_70514_an - this.field_70161_v) / (double)this.field_70510_h;
                \u2603 = MathHelper.func_76138_g(this.field_70512_ao - (double)this.field_70177_z);
                this.field_70177_z = (float)((double)this.field_70177_z + \u2603 / (double)this.field_70510_h);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70513_ap - (double)this.field_70125_A) / (double)this.field_70510_h);
                --this.field_70510_h;
                this.func_70107_b(d, \u2603, \u2603);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        if (this.field_70170_p.func_180495_p(new BlockPos(n = MathHelper.func_76128_c(this.field_70165_t), (\u2603 = MathHelper.func_76128_c(this.field_70163_u)) - 1, \u2603 = MathHelper.func_76128_c(this.field_70161_v))).func_203425_a(BlockTags.field_203437_y)) {
            --\u2603;
        }
        if ((\u2603 = this.field_70170_p.func_180495_p(\u2603 = new BlockPos(n, \u2603, \u2603))).func_203425_a(BlockTags.field_203437_y)) {
            this.func_180460_a(\u2603, \u2603);
            if (\u2603.func_177230_c() == Blocks.field_150408_cc) {
                this.func_96095_a(n, \u2603, \u2603, \u2603.func_177229_b(PoweredRailBlock.field_176569_M));
            }
        } else {
            this.func_180459_n();
        }
        this.func_145775_I();
        this.field_70125_A = 0.0f;
        double \u26032 = this.field_70169_q - this.field_70165_t;
        double \u26033 = this.field_70166_s - this.field_70161_v;
        if (\u26032 * \u26032 + \u26033 * \u26033 > 0.001) {
            this.field_70177_z = (float)(MathHelper.func_181159_b(\u26033, \u26032) * 180.0 / Math.PI);
            if (this.field_70499_f) {
                this.field_70177_z += 180.0f;
            }
        }
        if ((\u2603 = (double)MathHelper.func_76142_g(this.field_70177_z - this.field_70126_B)) < -170.0 || \u2603 >= 170.0) {
            this.field_70177_z += 180.0f;
            this.field_70499_f = !this.field_70499_f;
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.func_184264_v() == Type.RIDEABLE && AbstractMinecartEntity.func_213296_b(this.func_213322_ci()) > 0.01) {
            List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ().func_72314_b(0.2f, 0.0, 0.2f), EntityPredicates.func_200823_a(this));
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = list.get(i);
                    if (entity instanceof PlayerEntity || entity instanceof IronGolemEntity || entity instanceof AbstractMinecartEntity || this.func_184207_aI() || entity.func_184218_aH()) {
                        entity.func_70108_f(this);
                        continue;
                    }
                    entity.func_184220_m(this);
                }
            }
        } else {
            for (Entity entity : this.field_70170_p.func_72839_b(this, this.func_174813_aQ().func_72314_b(0.2f, 0.0, 0.2f))) {
                if (this.func_184196_w(entity) || !entity.func_70104_M() || !(entity instanceof AbstractMinecartEntity)) continue;
                entity.func_70108_f(this);
            }
        }
        this.func_70072_I();
    }

    protected double func_174898_m() {
        return 0.4;
    }

    public void func_96095_a(int n, int n2, int n3, boolean bl) {
    }

    protected void func_180459_n() {
        double d = this.func_174898_m();
        Vec3d \u26032 = this.func_213322_ci();
        this.func_213293_j(MathHelper.func_151237_a(\u26032.field_72450_a, -d, d), \u26032.field_72448_b, MathHelper.func_151237_a(\u26032.field_72449_c, -d, d));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (!this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.95));
        }
    }

    protected void func_180460_a(BlockPos blockPos2, BlockState blockState) {
        double d;
        Vec3d \u260320;
        double \u260319;
        double \u260318;
        double \u260317;
        BlockPos blockPos2;
        this.field_70143_R = 0.0f;
        Vec3d vec3d = this.func_70489_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70163_u = blockPos2.func_177956_o();
        boolean \u26032 = false;
        boolean \u26033 = false;
        AbstractRailBlock \u26034 = (AbstractRailBlock)blockState.func_177230_c();
        if (\u26034 == Blocks.field_196552_aC) {
            \u26032 = blockState.func_177229_b(PoweredRailBlock.field_176569_M);
            \u26033 = !\u26032;
        }
        double \u26035 = 0.0078125;
        vec3d2 = this.func_213322_ci();
        RailShape \u26036 = blockState.func_177229_b(\u26034.func_176560_l());
        switch (\u26036) {
            case ASCENDING_EAST: {
                this.func_213317_d(vec3d2.func_72441_c(-0.0078125, 0.0, 0.0));
                this.field_70163_u += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.func_213317_d(vec3d2.func_72441_c(0.0078125, 0.0, 0.0));
                this.field_70163_u += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.func_213317_d(vec3d2.func_72441_c(0.0, 0.0, 0.0078125));
                this.field_70163_u += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.func_213317_d(vec3d2.func_72441_c(0.0, 0.0, -0.0078125));
                this.field_70163_u += 1.0;
            }
        }
        vec3d2 = this.func_213322_ci();
        int[][] \u26037 = field_70500_g[\u26036.func_208091_a()];
        double \u26038 = \u26037[1][0] - \u26037[0][0];
        double \u26039 = \u26037[1][2] - \u26037[0][2];
        double \u260310 = Math.sqrt(\u26038 * \u26038 + \u26039 * \u26039);
        double \u260311 = vec3d2.field_72450_a * \u26038 + vec3d2.field_72449_c * \u26039;
        if (\u260311 < 0.0) {
            \u26038 = -\u26038;
            \u26039 = -\u26039;
        }
        double \u260312 = Math.min(2.0, Math.sqrt(AbstractMinecartEntity.func_213296_b(vec3d2)));
        vec3d2 = new Vec3d(\u260312 * \u26038 / \u260310, vec3d2.field_72448_b, \u260312 * \u26039 / \u260310);
        this.func_213317_d(vec3d2);
        Entity entity = \u2603 = this.func_184188_bt().isEmpty() ? null : this.func_184188_bt().get(0);
        if (\u2603 instanceof PlayerEntity) {
            \u2603 = \u2603.func_213322_ci();
            double d2 = AbstractMinecartEntity.func_213296_b(\u2603);
            \u2603 = AbstractMinecartEntity.func_213296_b(this.func_213322_ci());
            if (d2 > 1.0E-4 && \u2603 < 0.01) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(\u2603.field_72450_a * 0.1, 0.0, \u2603.field_72449_c * 0.1));
                \u26033 = false;
            }
        }
        if (\u26033) {
            double d3 = Math.sqrt(AbstractMinecartEntity.func_213296_b(this.func_213322_ci()));
            if (d3 < 0.03) {
                this.func_213317_d(Vec3d.field_186680_a);
            } else {
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 0.0, 0.5));
            }
        }
        double \u260313 = (double)blockPos2.func_177958_n() + 0.5 + (double)\u26037[0][0] * 0.5;
        double \u260314 = (double)blockPos2.func_177952_p() + 0.5 + (double)\u26037[0][2] * 0.5;
        double \u260315 = (double)blockPos2.func_177958_n() + 0.5 + (double)\u26037[1][0] * 0.5;
        double \u260316 = (double)blockPos2.func_177952_p() + 0.5 + (double)\u26037[1][2] * 0.5;
        \u26038 = \u260315 - \u260313;
        \u26039 = \u260316 - \u260314;
        if (\u26038 == 0.0) {
            this.field_70165_t = (double)blockPos2.func_177958_n() + 0.5;
            \u260317 = this.field_70161_v - (double)blockPos2.func_177952_p();
        } else if (\u26039 == 0.0) {
            this.field_70161_v = (double)blockPos2.func_177952_p() + 0.5;
            \u260317 = this.field_70165_t - (double)blockPos2.func_177958_n();
        } else {
            \u260318 = this.field_70165_t - \u260313;
            \u260319 = this.field_70161_v - \u260314;
            \u260317 = (\u260318 * \u26038 + \u260319 * \u26039) * 2.0;
        }
        this.field_70165_t = \u260313 + \u26038 * \u260317;
        this.field_70161_v = \u260314 + \u26039 * \u260317;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        \u260318 = this.func_184207_aI() ? 0.75 : 1.0;
        \u260319 = this.func_174898_m();
        Vec3d vec3d2 = this.func_213322_ci();
        this.func_213315_a(MoverType.SELF, new Vec3d(MathHelper.func_151237_a(\u260318 * vec3d2.field_72450_a, -\u260319, \u260319), 0.0, MathHelper.func_151237_a(\u260318 * vec3d2.field_72449_c, -\u260319, \u260319)));
        if (\u26037[0][1] != 0 && MathHelper.func_76128_c(this.field_70165_t) - blockPos2.func_177958_n() == \u26037[0][0] && MathHelper.func_76128_c(this.field_70161_v) - blockPos2.func_177952_p() == \u26037[0][2]) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)\u26037[0][1], this.field_70161_v);
        } else if (\u26037[1][1] != 0 && MathHelper.func_76128_c(this.field_70165_t) - blockPos2.func_177958_n() == \u26037[1][0] && MathHelper.func_76128_c(this.field_70161_v) - blockPos2.func_177952_p() == \u26037[1][2]) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)\u26037[1][1], this.field_70161_v);
        }
        this.func_94101_h();
        \u2603 = this.func_70489_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (\u2603 != null && vec3d != null) {
            double d4 = (vec3d.field_72448_b - \u2603.field_72448_b) * 0.05;
            \u260320 = this.func_213322_ci();
            d = Math.sqrt(AbstractMinecartEntity.func_213296_b(\u260320));
            if (d > 0.0) {
                this.func_213317_d(\u260320.func_216372_d((d + d4) / d, 1.0, (d + d4) / d));
            }
            this.func_70107_b(this.field_70165_t, \u2603.field_72448_b, this.field_70161_v);
        }
        int n = MathHelper.func_76128_c(this.field_70165_t);
        \u2603 = MathHelper.func_76128_c(this.field_70161_v);
        if (n != blockPos2.func_177958_n() || \u2603 != blockPos2.func_177952_p()) {
            \u260320 = this.func_213322_ci();
            d = Math.sqrt(AbstractMinecartEntity.func_213296_b(\u260320));
            this.func_213293_j(d * (double)(n - blockPos2.func_177958_n()), \u260320.field_72448_b, d * (double)(\u2603 - blockPos2.func_177952_p()));
        }
        if (\u26032) {
            \u260320 = this.func_213322_ci();
            d = Math.sqrt(AbstractMinecartEntity.func_213296_b(\u260320));
            if (d > 0.01) {
                \u2603 = 0.06;
                this.func_213317_d(\u260320.func_72441_c(\u260320.field_72450_a / d * 0.06, 0.0, \u260320.field_72449_c / d * 0.06));
            } else {
                Vec3d vec3d3 = this.func_213322_ci();
                double \u260321 = vec3d3.field_72450_a;
                double \u260322 = vec3d3.field_72449_c;
                if (\u26036 == RailShape.EAST_WEST) {
                    if (this.func_213900_a(blockPos2.func_177976_e())) {
                        \u260321 = 0.02;
                    } else if (this.func_213900_a(blockPos2.func_177974_f())) {
                        \u260321 = -0.02;
                    }
                } else if (\u26036 == RailShape.NORTH_SOUTH) {
                    if (this.func_213900_a(blockPos2.func_177978_c())) {
                        \u260322 = 0.02;
                    } else if (this.func_213900_a(blockPos2.func_177968_d())) {
                        \u260322 = -0.02;
                    }
                } else {
                    return;
                }
                this.func_213293_j(\u260321, vec3d3.field_72448_b, \u260322);
            }
        }
    }

    private boolean func_213900_a(BlockPos blockPos) {
        return this.field_70170_p.func_180495_p(blockPos).func_215686_e(this.field_70170_p, blockPos);
    }

    protected void func_94101_h() {
        double d = this.func_184207_aI() ? 0.997 : 0.96;
        this.func_213317_d(this.func_213322_ci().func_216372_d(d, 0.0, d));
    }

    @Nullable
    public Vec3d func_70495_a(double d, double \u260322, double d2, double d3) {
        int n = MathHelper.func_76128_c(d);
        if (this.field_70170_p.func_180495_p(new BlockPos(n, (\u2603 = MathHelper.func_76128_c(\u260322)) - 1, \u2603 = MathHelper.func_76128_c(d2))).func_203425_a(BlockTags.field_203437_y)) {
            --\u2603;
        }
        if ((\u2603 = this.field_70170_p.func_180495_p(new BlockPos(n, \u2603, \u2603))).func_203425_a(BlockTags.field_203437_y)) {
            RailShape railShape = \u2603.func_177229_b(((AbstractRailBlock)\u2603.func_177230_c()).func_176560_l());
            double \u260322 = \u2603;
            if (railShape.func_208092_c()) {
                \u260322 = \u2603 + 1;
            }
            int[][] \u26033 = field_70500_g[railShape.func_208091_a()];
            double \u26034 = \u26033[1][0] - \u26033[0][0];
            double \u26035 = \u26033[1][2] - \u26033[0][2];
            double \u26036 = Math.sqrt(\u26034 * \u26034 + \u26035 * \u26035);
            if (\u26033[0][1] != 0 && MathHelper.func_76128_c(d += (\u26034 /= \u26036) * d3) - n == \u26033[0][0] && MathHelper.func_76128_c(d2 += (\u26035 /= \u26036) * d3) - \u2603 == \u26033[0][2]) {
                \u260322 += (double)\u26033[0][1];
            } else if (\u26033[1][1] != 0 && MathHelper.func_76128_c(d) - n == \u26033[1][0] && MathHelper.func_76128_c(d2) - \u2603 == \u26033[1][2]) {
                \u260322 += (double)\u26033[1][1];
            }
            return this.func_70489_a(d, \u260322, d2);
        }
        return null;
    }

    @Nullable
    public Vec3d func_70489_a(double d4, double d2, double d3) {
        int n = MathHelper.func_76128_c(d4);
        if (this.field_70170_p.func_180495_p(new BlockPos(n, (\u2603 = MathHelper.func_76128_c(d2)) - 1, \u2603 = MathHelper.func_76128_c(d3))).func_203425_a(BlockTags.field_203437_y)) {
            --\u2603;
        }
        if ((\u2603 = this.field_70170_p.func_180495_p(new BlockPos(n, \u2603, \u2603))).func_203425_a(BlockTags.field_203437_y)) {
            double d4;
            double d5;
            RailShape railShape = \u2603.func_177229_b(((AbstractRailBlock)\u2603.func_177230_c()).func_176560_l());
            int[][] \u26032 = field_70500_g[railShape.func_208091_a()];
            double \u26033 = (double)n + 0.5 + (double)\u26032[0][0] * 0.5;
            double \u26034 = (double)\u2603 + 0.0625 + (double)\u26032[0][1] * 0.5;
            double \u26035 = (double)\u2603 + 0.5 + (double)\u26032[0][2] * 0.5;
            double \u26036 = (double)n + 0.5 + (double)\u26032[1][0] * 0.5;
            double \u26037 = (double)\u2603 + 0.0625 + (double)\u26032[1][1] * 0.5;
            double \u26038 = (double)\u2603 + 0.5 + (double)\u26032[1][2] * 0.5;
            double \u26039 = \u26036 - \u26033;
            double \u260310 = (\u26037 - \u26034) * 2.0;
            double \u260311 = \u26038 - \u26035;
            if (\u26039 == 0.0) {
                d5 = d3 - (double)\u2603;
            } else if (\u260311 == 0.0) {
                d5 = d4 - (double)n;
            } else {
                \u2603 = d4 - \u26033;
                \u2603 = d3 - \u26035;
                d5 = (\u2603 * \u26039 + \u2603 * \u260311) * 2.0;
            }
            d4 = \u26033 + \u26039 * d5;
            d2 = \u26034 + \u260310 * d5;
            d3 = \u26035 + \u260311 * d5;
            if (\u260310 < 0.0) {
                d2 += 1.0;
            }
            if (\u260310 > 0.0) {
                d2 += 0.5;
            }
            return new Vec3d(d4, d2, d3);
        }
        return null;
    }

    @Override
    public AxisAlignedBB func_184177_bl() {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
        if (this.func_94100_s()) {
            return axisAlignedBB.func_186662_g((double)Math.abs(this.func_94099_q()) / 16.0);
        }
        return axisAlignedBB;
    }

    @Override
    protected void func_70037_a(CompoundNBT compoundNBT) {
        if (compoundNBT.func_74767_n("CustomDisplayTile")) {
            this.func_174899_a(NBTUtil.func_190008_d(compoundNBT.func_74775_l("DisplayState")));
            this.func_94086_l(compoundNBT.func_74762_e("DisplayOffset"));
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compoundNBT) {
        if (this.func_94100_s()) {
            compoundNBT.func_74757_a("CustomDisplayTile", true);
            compoundNBT.func_218657_a("DisplayState", NBTUtil.func_190009_a(this.func_174897_t()));
            compoundNBT.func_74768_a("DisplayOffset", this.func_94099_q());
        }
    }

    @Override
    public void func_70108_f(Entity entity) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.field_70145_X || this.field_70145_X) {
            return;
        }
        if (this.func_184196_w(entity)) {
            return;
        }
        double d = entity.field_70165_t - this.field_70165_t;
        \u2603 = entity.field_70161_v - this.field_70161_v;
        \u2603 = d * d + \u2603 * \u2603;
        if (\u2603 >= (double)1.0E-4f) {
            \u2603 = MathHelper.func_76133_a(\u2603);
            d /= \u2603;
            \u2603 /= \u2603;
            \u2603 = 1.0 / \u2603;
            if (\u2603 > 1.0) {
                \u2603 = 1.0;
            }
            d *= \u2603;
            \u2603 *= \u2603;
            d *= (double)0.1f;
            \u2603 *= (double)0.1f;
            d *= (double)(1.0f - this.field_70144_Y);
            \u2603 *= (double)(1.0f - this.field_70144_Y);
            d *= 0.5;
            \u2603 *= 0.5;
            if (entity instanceof AbstractMinecartEntity) {
                \u2603 = entity.field_70165_t - this.field_70165_t;
                \u2603 = entity.field_70161_v - this.field_70161_v;
                Vec3d vec3d = new Vec3d(\u2603, 0.0, \u2603).func_72432_b();
                double \u26032 = Math.abs(vec3d.func_72430_b(\u2603 = new Vec3d(MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)), 0.0, MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180))).func_72432_b()));
                if (\u26032 < (double)0.8f) {
                    return;
                }
                \u2603 = this.func_213322_ci();
                \u2603 = entity.func_213322_ci();
                if (((AbstractMinecartEntity)entity).func_184264_v() == Type.FURNACE && this.func_184264_v() != Type.FURNACE) {
                    this.func_213317_d(\u2603.func_216372_d(0.2, 1.0, 0.2));
                    this.func_70024_g(\u2603.field_72450_a - d, 0.0, \u2603.field_72449_c - \u2603);
                    entity.func_213317_d(\u2603.func_216372_d(0.95, 1.0, 0.95));
                } else if (((AbstractMinecartEntity)entity).func_184264_v() != Type.FURNACE && this.func_184264_v() == Type.FURNACE) {
                    entity.func_213317_d(\u2603.func_216372_d(0.2, 1.0, 0.2));
                    entity.func_70024_g(\u2603.field_72450_a + d, 0.0, \u2603.field_72449_c + \u2603);
                    this.func_213317_d(\u2603.func_216372_d(0.95, 1.0, 0.95));
                } else {
                    double d2 = (\u2603.field_72450_a + \u2603.field_72450_a) / 2.0;
                    \u2603 = (\u2603.field_72449_c + \u2603.field_72449_c) / 2.0;
                    this.func_213317_d(\u2603.func_216372_d(0.2, 1.0, 0.2));
                    this.func_70024_g(d2 - d, 0.0, \u2603 - \u2603);
                    entity.func_213317_d(\u2603.func_216372_d(0.2, 1.0, 0.2));
                    entity.func_70024_g(d2 + d, 0.0, \u2603 + \u2603);
                }
            } else {
                this.func_70024_g(-d, 0.0, -\u2603);
                entity.func_70024_g(d / 4.0, 0.0, \u2603 / 4.0);
            }
        }
    }

    @Override
    public void func_180426_a(double d, double d2, double d3, float f, float f2, int n, boolean bl) {
        this.field_70511_i = d;
        this.field_70509_j = d2;
        this.field_70514_an = d3;
        this.field_70512_ao = f;
        this.field_70513_ap = f2;
        this.field_70510_h = n + 2;
        this.func_213293_j(this.field_70508_aq, this.field_70507_ar, this.field_70506_as);
    }

    @Override
    public void func_70016_h(double d, double d2, double d3) {
        this.field_70508_aq = d;
        this.field_70507_ar = d2;
        this.field_70506_as = d3;
        this.func_213293_j(this.field_70508_aq, this.field_70507_ar, this.field_70506_as);
    }

    public void func_70492_c(float f) {
        this.field_70180_af.func_187227_b(field_184267_c, Float.valueOf(f));
    }

    public float func_70491_i() {
        return this.field_70180_af.func_187225_a(field_184267_c).floatValue();
    }

    public void func_70497_h(int n) {
        this.field_70180_af.func_187227_b(field_184265_a, n);
    }

    public int func_70496_j() {
        return this.field_70180_af.func_187225_a(field_184265_a);
    }

    public void func_70494_i(int n) {
        this.field_70180_af.func_187227_b(field_184266_b, n);
    }

    public int func_70493_k() {
        return this.field_70180_af.func_187225_a(field_184266_b);
    }

    public abstract Type func_184264_v();

    public BlockState func_174897_t() {
        if (!this.func_94100_s()) {
            return this.func_180457_u();
        }
        return Block.func_196257_b(this.func_184212_Q().func_187225_a(field_184268_d));
    }

    public BlockState func_180457_u() {
        return Blocks.field_150350_a.func_176223_P();
    }

    public int func_94099_q() {
        if (!this.func_94100_s()) {
            return this.func_94085_r();
        }
        return this.func_184212_Q().func_187225_a(field_184269_e);
    }

    public int func_94085_r() {
        return 6;
    }

    public void func_174899_a(BlockState blockState) {
        this.func_184212_Q().func_187227_b(field_184268_d, Block.func_196246_j(blockState));
        this.func_94096_e(true);
    }

    public void func_94086_l(int n) {
        this.func_184212_Q().func_187227_b(field_184269_e, n);
        this.func_94096_e(true);
    }

    public boolean func_94100_s() {
        return this.func_184212_Q().func_187225_a(field_184270_f);
    }

    public void func_94096_e(boolean bl) {
        this.func_184212_Q().func_187227_b(field_184270_f, bl);
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket(this);
    }

    public static enum Type {
        RIDEABLE,
        CHEST,
        FURNACE,
        TNT,
        SPAWNER,
        HOPPER,
        COMMAND_BLOCK;

    }
}

