/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BannerItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;

public class PillagerEntity
extends AbstractIllagerEntity
implements ICrossbowUser,
IRangedAttackMob {
    private static final DataParameter<Boolean> field_213676_b = EntityDataManager.func_187226_a(PillagerEntity.class, DataSerializers.field_187198_h);
    private final Inventory field_213677_bz = new Inventory(5);

    public PillagerEntity(EntityType<? extends PillagerEntity> entityType, World world) {
        super((EntityType<? extends AbstractIllagerEntity>)entityType, world);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(2, new AbstractRaiderEntity.FindTargetGoal(this, this, 10.0f));
        this.field_70714_bg.func_75776_a(3, new RangedCrossbowAttackGoal<PillagerEntity>(this, 1.0, 8.0f));
        this.field_70714_bg.func_75776_a(8, new RandomWalkingGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(9, new LookAtGoal(this, PlayerEntity.class, 15.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, new LookAtGoal(this, MobEntity.class, 15.0f));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, AbstractRaiderEntity.class).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<AbstractVillagerEntity>((MobEntity)this, AbstractVillagerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<IronGolemEntity>((MobEntity)this, IronGolemEntity.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213676_b, false);
    }

    public boolean func_213675_dX() {
        return this.field_70180_af.func_187225_a(field_213676_b);
    }

    @Override
    public void func_213671_a(boolean bl) {
        this.field_70180_af.func_187227_b(field_213676_b, bl);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        super.func_213281_b(compoundNBT2);
        ListNBT listNBT = new ListNBT();
        for (int i = 0; i < this.field_213677_bz.func_70302_i_(); ++i) {
            ItemStack itemStack = this.field_213677_bz.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            listNBT.add(itemStack.func_77955_b(new CompoundNBT()));
        }
        compoundNBT2.func_218657_a("Inventory", listNBT);
    }

    @Override
    public AbstractIllagerEntity.ArmPose func_193077_p() {
        if (this.func_213675_dX()) {
            return AbstractIllagerEntity.ArmPose.CROSSBOW_CHARGE;
        }
        if (this.func_213382_a(Items.field_222114_py)) {
            return AbstractIllagerEntity.ArmPose.CROSSBOW_HOLD;
        }
        if (this.func_213398_dR()) {
            return AbstractIllagerEntity.ArmPose.ATTACKING;
        }
        return AbstractIllagerEntity.ArmPose.CROSSED;
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        ListNBT listNBT = compoundNBT.func_150295_c("Inventory", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            ItemStack itemStack = ItemStack.func_199557_a(listNBT.func_150305_b(i));
            if (itemStack.func_190926_b()) continue;
            this.field_213677_bz.func_174894_a(itemStack);
        }
        this.func_98053_h(true);
    }

    @Override
    public float func_205022_a(BlockPos blockPos, IWorldReader iWorldReader) {
        Block block = iWorldReader.func_180495_p(blockPos.func_177977_b()).func_177230_c();
        if (block == Blocks.field_196658_i || block == Blocks.field_150354_m) {
            return 10.0f;
        }
        return 0.5f - iWorldReader.func_205052_D(blockPos);
    }

    @Override
    public int func_70641_bl() {
        return 1;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        this.func_180481_a(difficultyInstance);
        this.func_180483_b(difficultyInstance);
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        ItemStack itemStack = new ItemStack(Items.field_222114_py);
        if (this.field_70146_Z.nextInt(300) == 0) {
            HashMap hashMap = Maps.newHashMap();
            hashMap.put(Enchantments.field_222194_I, 1);
            EnchantmentHelper.func_82782_a(hashMap, itemStack);
        }
        this.func_184201_a(EquipmentSlotType.MAINHAND, itemStack);
    }

    @Override
    public boolean func_184191_r(Entity entity) {
        if (super.func_184191_r(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entity.func_96124_cp() == null;
        }
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_219686_is;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219688_iu;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_219689_iv;
    }

    @Override
    public void func_82196_d(LivingEntity livingEntity, float f) {
        Hand hand = ProjectileHelper.func_221274_a(this, Items.field_222114_py);
        ItemStack \u26032 = this.func_184586_b(hand);
        if (this.func_213382_a(Items.field_222114_py)) {
            CrossbowItem.func_220014_a(this.field_70170_p, this, hand, \u26032, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        }
        this.field_70708_bq = 0;
    }

    @Override
    public void func_213670_a(LivingEntity livingEntity, ItemStack itemStack, IProjectile iProjectile, float f) {
        Entity entity = (Entity)((Object)iProjectile);
        double \u26032 = livingEntity.field_70165_t - this.field_70165_t;
        double \u26033 = livingEntity.field_70161_v - this.field_70161_v;
        double \u26034 = MathHelper.func_76133_a(\u26032 * \u26032 + \u26033 * \u26033);
        double \u26035 = livingEntity.func_174813_aQ().field_72338_b + (double)(livingEntity.func_213302_cg() / 3.0f) - entity.field_70163_u + \u26034 * (double)0.2f;
        Vector3f \u26036 = this.func_213673_a(new Vec3d(\u26032, \u26035, \u26033), f);
        iProjectile.func_70186_c(\u26036.func_195899_a(), \u26036.func_195900_b(), \u26036.func_195902_c(), 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(SoundEvents.field_219616_bH, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    private Vector3f func_213673_a(Vec3d vec3d, float f) {
        Vec3d vec3d2 = vec3d.func_72432_b();
        \u2603 = vec3d2.func_72431_c(new Vec3d(0.0, 1.0, 0.0));
        if (\u2603.func_189985_c() <= 1.0E-7) {
            \u2603 = vec3d2.func_72431_c(this.func_213286_i(1.0f));
        }
        Quaternion \u26032 = new Quaternion(new Vector3f(\u2603), 90.0f, true);
        Vector3f \u26033 = new Vector3f(vec3d2);
        \u26033.func_214905_a(\u26032);
        Quaternion \u26034 = new Quaternion(\u26033, f, true);
        Vector3f \u26035 = new Vector3f(vec3d2);
        \u26035.func_214905_a(\u26034);
        return \u26035;
    }

    public Inventory func_213674_eg() {
        return this.field_213677_bz;
    }

    @Override
    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.func_92059_d();
        if (itemStack.func_77973_b() instanceof BannerItem) {
            super.func_175445_a(itemEntity);
        } else {
            Item item = itemStack.func_77973_b();
            if (this.func_213672_b(item)) {
                ItemStack itemStack2 = this.field_213677_bz.func_174894_a(itemStack);
                if (itemStack2.func_190926_b()) {
                    itemEntity.func_70106_y();
                } else {
                    itemStack.func_190920_e(itemStack2.func_190916_E());
                }
            }
        }
    }

    private boolean func_213672_b(Item item) {
        return this.func_213657_el() && item == Items.field_196191_eg;
    }

    @Override
    public boolean func_174820_d(int n, ItemStack itemStack) {
        if (super.func_174820_d(n, itemStack)) {
            return true;
        }
        int n2 = n - 300;
        if (n2 >= 0 && n2 < this.field_213677_bz.func_70302_i_()) {
            this.field_213677_bz.func_70299_a(n2, itemStack);
            return true;
        }
        return false;
    }

    @Override
    public void func_213660_a(int n, boolean bl) {
        Raid raid = this.func_213663_ek();
        boolean bl2 = \u2603 = this.field_70146_Z.nextFloat() <= raid.func_221308_w();
        if (\u2603) {
            ItemStack itemStack = new ItemStack(Items.field_222114_py);
            HashMap \u26032 = Maps.newHashMap();
            if (n > raid.func_221306_a(Difficulty.NORMAL)) {
                \u26032.put(Enchantments.field_222193_H, 2);
            } else if (n > raid.func_221306_a(Difficulty.EASY)) {
                \u26032.put(Enchantments.field_222193_H, 1);
            }
            \u26032.put(Enchantments.field_222192_G, 1);
            EnchantmentHelper.func_82782_a(\u26032, itemStack);
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemStack);
        }
    }

    @Override
    public boolean func_213392_I() {
        return super.func_213392_I() && this.func_213674_eg().func_191420_l();
    }

    @Override
    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219687_it;
    }

    @Override
    public boolean func_213397_c(double d) {
        return super.func_213397_c(d) && this.func_213674_eg().func_191420_l();
    }
}

