/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RavagerEntity
extends AbstractRaiderEntity {
    private static final Predicate<Entity> field_213690_b = entity -> entity.func_70089_S() && !(entity instanceof RavagerEntity);
    private int field_213691_bz;
    private int field_213692_bA;
    private int field_213689_bB;

    public RavagerEntity(EntityType<? extends RavagerEntity> entityType, World world) {
        super((EntityType<? extends AbstractRaiderEntity>)entityType, world);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 20;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(4, new AttackGoal());
        this.field_70714_bg.func_75776_a(5, new WaterAvoidingRandomWalkingGoal(this, 0.4));
        this.field_70714_bg.func_75776_a(6, new LookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, new LookAtGoal(this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(2, new HurtByTargetGoal(this, AbstractRaiderEntity.class).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(4, new NearestAttackableTargetGoal<AbstractVillagerEntity>((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(4, new NearestAttackableTargetGoal<IronGolemEntity>((MobEntity)this, IronGolemEntity.class, true));
    }

    @Override
    protected void func_213385_F() {
        boolean bl = !(this.func_184179_bs() instanceof MobEntity) || this.func_184179_bs().func_200600_R().func_220341_a(EntityTypeTags.field_219765_b);
        \u2603 = !(this.func_184187_bx() instanceof BoatEntity);
        this.field_70714_bg.func_220878_a(Goal.Flag.MOVE, bl);
        this.field_70714_bg.func_220878_a(Goal.Flag.JUMP, bl && \u2603);
        this.field_70714_bg.func_220878_a(Goal.Flag.LOOK, bl);
        this.field_70714_bg.func_220878_a(Goal.Flag.TARGET, bl);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("AttackTick", this.field_213691_bz);
        compoundNBT.func_74768_a("StunTick", this.field_213692_bA);
        compoundNBT.func_74768_a("RoarTick", this.field_213689_bB);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.field_213691_bz = compoundNBT.func_74762_e("AttackTick");
        this.field_213692_bA = compoundNBT.func_74762_e("StunTick");
        this.field_213689_bB = compoundNBT.func_74762_e("RoarTick");
    }

    @Override
    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219645_fe;
    }

    @Override
    protected PathNavigator func_175447_b(World world) {
        return new Navigator(this, world);
    }

    @Override
    public int func_184649_cE() {
        return 45;
    }

    @Override
    public double func_70042_X() {
        return 2.1;
    }

    @Override
    public boolean func_82171_bF() {
        return !this.func_175446_cd() && this.func_184179_bs() instanceof LivingEntity;
    }

    @Override
    @Nullable
    public Entity func_184179_bs() {
        if (this.func_184188_bt().isEmpty()) {
            return null;
        }
        return this.func_184188_bt().get(0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_70089_S()) {
            return;
        }
        if (this.func_70610_aX()) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        } else {
            double d = this.func_70638_az() != null ? 0.35 : 0.3;
            \u2603 = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(MathHelper.func_219803_d(0.1, \u2603, d));
        }
        if (this.field_70123_F && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
            boolean \u26034 = false;
            AxisAlignedBB \u26032 = this.func_174813_aQ().func_186662_g(0.2);
            for (BlockPos blockPos : BlockPos.func_191531_b(MathHelper.func_76128_c(\u26032.field_72340_a), MathHelper.func_76128_c(\u26032.field_72338_b), MathHelper.func_76128_c(\u26032.field_72339_c), MathHelper.func_76128_c(\u26032.field_72336_d), MathHelper.func_76128_c(\u26032.field_72337_e), MathHelper.func_76128_c(\u26032.field_72334_f))) {
                BlockState blockState = this.field_70170_p.func_180495_p(blockPos);
                Block \u26033 = blockState.func_177230_c();
                if (!(\u26033 instanceof LeavesBlock)) continue;
                \u26034 = this.field_70170_p.func_175655_b(blockPos, true) || \u26034;
            }
            if (!\u26034 && this.field_70122_E) {
                this.func_70664_aZ();
            }
        }
        if (this.field_213689_bB > 0) {
            --this.field_213689_bB;
            if (this.field_213689_bB == 10) {
                this.func_213686_ei();
            }
        }
        if (this.field_213691_bz > 0) {
            --this.field_213691_bz;
        }
        if (this.field_213692_bA > 0) {
            --this.field_213692_bA;
            this.func_213682_eh();
            if (this.field_213692_bA == 0) {
                this.func_184185_a(SoundEvents.field_219650_fj, 1.0f, 1.0f);
                this.field_213689_bB = 20;
            }
        }
    }

    private void func_213682_eh() {
        if (this.field_70146_Z.nextInt(6) == 0) {
            double d = this.field_70165_t - (double)this.func_213311_cf() * Math.sin(this.field_70761_aq * ((float)Math.PI / 180)) + (this.field_70146_Z.nextDouble() * 0.6 - 0.3);
            \u2603 = this.field_70163_u + (double)this.func_213302_cg() - 0.3;
            \u2603 = this.field_70161_v + (double)this.func_213311_cf() * Math.cos(this.field_70761_aq * ((float)Math.PI / 180)) + (this.field_70146_Z.nextDouble() * 0.6 - 0.3);
            this.field_70170_p.func_195594_a(ParticleTypes.field_197625_r, d, \u2603, \u2603, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    @Override
    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.field_213691_bz > 0 || this.field_213692_bA > 0 || this.field_213689_bB > 0;
    }

    @Override
    public boolean func_70685_l(Entity entity) {
        if (this.field_213692_bA > 0 || this.field_213689_bB > 0) {
            return false;
        }
        return super.func_70685_l(entity);
    }

    @Override
    protected void func_213371_e(LivingEntity livingEntity) {
        if (this.field_213689_bB == 0) {
            if (this.field_70146_Z.nextDouble() < 0.5) {
                this.field_213692_bA = 40;
                this.func_184185_a(SoundEvents.field_219649_fi, 1.0f, 1.0f);
                this.field_70170_p.func_72960_a(this, (byte)39);
                livingEntity.func_70108_f(this);
            } else {
                this.func_213688_a(livingEntity);
            }
            livingEntity.field_70133_I = true;
        }
    }

    private void func_213686_ei() {
        if (this.func_70089_S()) {
            List<Entity> list = this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(4.0), field_213690_b);
            for (Entity entity : list) {
                if (!(entity instanceof AbstractIllagerEntity)) {
                    entity.func_70097_a(DamageSource.func_76358_a(this), 6.0f);
                }
                this.func_213688_a(entity);
            }
            Vec3d vec3d = this.func_174813_aQ().func_189972_c();
            for (int i = 0; i < 40; ++i) {
                double d = this.field_70146_Z.nextGaussian() * 0.2;
                \u2603 = this.field_70146_Z.nextGaussian() * 0.2;
                \u2603 = this.field_70146_Z.nextGaussian() * 0.2;
                this.field_70170_p.func_195594_a(ParticleTypes.field_197598_I, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, d, \u2603, \u2603);
            }
        }
    }

    private void func_213688_a(Entity entity) {
        double d = entity.field_70165_t - this.field_70165_t;
        \u2603 = entity.field_70161_v - this.field_70161_v;
        \u2603 = Math.max(d * d + \u2603 * \u2603, 0.001);
        entity.func_70024_g(d / \u2603 * 4.0, 0.2, \u2603 / \u2603 * 4.0);
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 4) {
            this.field_213691_bz = 10;
            this.func_184185_a(SoundEvents.field_219644_fd, 1.0f, 1.0f);
        } else if (by == 39) {
            this.field_213692_bA = 40;
        }
        super.func_70103_a(by);
    }

    public int func_213683_l() {
        return this.field_213691_bz;
    }

    public int func_213684_dX() {
        return this.field_213692_bA;
    }

    public int func_213687_eg() {
        return this.field_213689_bB;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        this.field_213691_bz = 10;
        this.field_70170_p.func_72960_a(this, (byte)4);
        this.func_184185_a(SoundEvents.field_219644_fd, 1.0f, 1.0f);
        return super.func_70652_k(entity);
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_219643_fc;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_219647_fg;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219646_ff;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_219648_fh, 0.15f, 1.0f);
    }

    @Override
    public boolean func_205019_a(IWorldReader iWorldReader) {
        return !iWorldReader.func_72953_d(this.func_174813_aQ());
    }

    @Override
    public void func_213660_a(int n, boolean bl) {
    }

    @Override
    public boolean func_213637_dY() {
        return false;
    }

    static class Processor
    extends WalkNodeProcessor {
        private Processor() {
        }

        @Override
        protected PathNodeType func_215744_a(IBlockReader iBlockReader, boolean bl, boolean bl2, BlockPos blockPos, PathNodeType pathNodeType) {
            if (pathNodeType == PathNodeType.LEAVES) {
                return PathNodeType.OPEN;
            }
            return super.func_215744_a(iBlockReader, bl, bl2, blockPos, pathNodeType);
        }
    }

    static class Navigator
    extends GroundPathNavigator {
        public Navigator(MobEntity mobEntity, World world) {
            super(mobEntity, world);
        }

        @Override
        protected PathFinder func_179679_a(int n) {
            this.field_179695_a = new Processor();
            return new PathFinder(this.field_179695_a, n);
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super(RavagerEntity.this, 1.0, true);
        }

        @Override
        protected double func_179512_a(LivingEntity livingEntity) {
            float f = RavagerEntity.this.func_213311_cf() - 0.1f;
            return f * 2.0f * (f * 2.0f) + livingEntity.func_213311_cf();
        }
    }
}

