/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.DefendVillageTargetGoal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.MoveTowardsVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.ShowVillagerFlowerGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class IronGolemEntity
extends GolemEntity {
    protected static final DataParameter<Byte> field_184750_a = EntityDataManager.func_187226_a(IronGolemEntity.class, DataSerializers.field_187191_a);
    private int field_70855_f;
    private int field_70856_g;

    public IronGolemEntity(EntityType<? extends IronGolemEntity> entityType, World world) {
        super((EntityType<? extends GolemEntity>)entityType, world);
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new MeleeAttackGoal(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, new MoveTowardsTargetGoal(this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(2, new MoveTowardsVillageGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(3, new MoveThroughVillageGoal(this, 0.6, false, 4, () -> false));
        this.field_70714_bg.func_75776_a(5, new ShowVillagerFlowerGoal(this));
        this.field_70714_bg.func_75776_a(6, new WaterAvoidingRandomWalkingGoal(this, 0.6));
        this.field_70714_bg.func_75776_a(7, new LookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, new LookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, new DefendVillageTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, new HurtByTargetGoal(this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<MobEntity>(this, MobEntity.class, 5, false, false, livingEntity -> livingEntity instanceof IMob && !(livingEntity instanceof CreeperEntity)));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184750_a, (byte)0);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected int func_70682_h(int n) {
        return n;
    }

    @Override
    protected void func_82167_n(Entity entity) {
        if (entity instanceof IMob && !(entity instanceof CreeperEntity) && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((LivingEntity)entity);
        }
        super.func_82167_n(entity);
    }

    @Override
    public void func_70636_d() {
        BlockState blockState;
        super.func_70636_d();
        if (this.field_70855_f > 0) {
            --this.field_70855_f;
        }
        if (this.field_70856_g > 0) {
            --this.field_70856_g;
        }
        if (IronGolemEntity.func_213296_b(this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && !(blockState = this.field_70170_p.func_180495_p(new BlockPos(\u2603 = MathHelper.func_76128_c(this.field_70165_t), \u2603 = MathHelper.func_76128_c(this.field_70163_u - (double)0.2f), \u2603 = MathHelper.func_76128_c(this.field_70161_v)))).func_196958_f()) {
            this.field_70170_p.func_195594_a(new BlockParticleData(ParticleTypes.field_197611_d, blockState), this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
    }

    @Override
    public boolean func_213358_a(EntityType<?> entityType) {
        if (this.func_70850_q() && entityType == EntityType.field_200729_aH) {
            return false;
        }
        if (entityType == EntityType.field_200797_k) {
            return false;
        }
        return super.func_213358_a(entityType);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74757_a("PlayerCreated", this.func_70850_q());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_70849_f(compoundNBT.func_74767_n("PlayerCreated"));
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        this.field_70855_f = 10;
        this.field_70170_p.func_72960_a(this, (byte)4);
        boolean bl = entity.func_70097_a(DamageSource.func_76358_a(this), 7 + this.field_70146_Z.nextInt(15));
        if (bl) {
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, 0.4f, 0.0));
            this.func_174815_a(this, entity);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return bl;
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 4) {
            this.field_70855_f = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else if (by == 11) {
            this.field_70856_g = 400;
        } else if (by == 34) {
            this.field_70856_g = 0;
        } else {
            super.func_70103_a(by);
        }
    }

    public int func_70854_o() {
        return this.field_70855_f;
    }

    public void func_70851_e(boolean bl) {
        if (bl) {
            this.field_70856_g = 400;
            this.field_70170_p.func_72960_a(this, (byte)11);
        } else {
            this.field_70856_g = 0;
            this.field_70170_p.func_72960_a(this, (byte)34);
        }
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187602_cF;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    public int func_70853_p() {
        return this.field_70856_g;
    }

    public boolean func_70850_q() {
        return (this.field_70180_af.func_187225_a(field_184750_a) & 1) != 0;
    }

    public void func_70849_f(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184750_a);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184750_a, (byte)(by | 1));
        } else {
            this.field_70180_af.func_187227_b(field_184750_a, (byte)(by & 0xFFFFFFFE));
        }
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
    }

    @Override
    public boolean func_205019_a(IWorldReader iWorldReader2) {
        BlockPos blockPos = new BlockPos(this);
        \u2603 = blockPos.func_177977_b();
        BlockState \u26032 = iWorldReader2.func_180495_p(\u2603);
        if (\u26032.func_215682_a(iWorldReader2, \u2603, this)) {
            IWorldReader iWorldReader2;
            for (int i = 1; i < 3; ++i) {
                BlockPos blockPos2 = blockPos.func_177981_b(i);
                if (WorldEntitySpawner.func_222266_a(iWorldReader2, blockPos2, \u2603 = iWorldReader2.func_180495_p(blockPos2), \u2603.func_204520_s())) continue;
                return false;
            }
            return WorldEntitySpawner.func_222266_a(iWorldReader2, blockPos, iWorldReader2.func_180495_p(blockPos), Fluids.field_204541_a.func_207188_f()) && iWorldReader2.func_217346_i(this);
        }
        return false;
    }
}

