/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class PandaEntity
extends AnimalEntity {
    private static final DataParameter<Integer> field_213609_bA = EntityDataManager.func_187226_a(PandaEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_213593_bB = EntityDataManager.func_187226_a(PandaEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_213594_bD = EntityDataManager.func_187226_a(PandaEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Byte> field_213595_bE = EntityDataManager.func_187226_a(PandaEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Byte> field_213596_bF = EntityDataManager.func_187226_a(PandaEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Byte> field_213597_bG = EntityDataManager.func_187226_a(PandaEntity.class, DataSerializers.field_187191_a);
    private boolean field_213598_bH;
    private boolean field_213599_bI;
    public int field_213608_bz;
    private Vec3d field_213600_bJ;
    private float field_213601_bK;
    private float field_213602_bL;
    private float field_213603_bM;
    private float field_213604_bN;
    private float field_213605_bO;
    private float field_213606_bP;
    private static final Predicate<ItemEntity> field_213607_bQ = itemEntity -> {
        Item item = itemEntity.func_92059_d().func_77973_b();
        return (item == Blocks.field_222405_kQ.func_199767_j() || item == Blocks.field_150414_aQ.func_199767_j()) && itemEntity.func_70089_S() && !itemEntity.func_174874_s();
    };

    public PandaEntity(EntityType<? extends PandaEntity> entityType, World world) {
        super((EntityType<? extends AnimalEntity>)entityType, world);
        this.field_70765_h = new MoveHelperController(this);
        if (!this.func_70631_g_()) {
            this.func_98053_h(true);
        }
    }

    @Override
    public boolean func_213365_e(ItemStack itemStack) {
        EquipmentSlotType equipmentSlotType = MobEntity.func_184640_d(itemStack);
        if (!this.func_184582_a(equipmentSlotType).func_190926_b()) {
            return false;
        }
        return equipmentSlotType == EquipmentSlotType.MAINHAND && super.func_213365_e(itemStack);
    }

    public int func_213544_dV() {
        return this.field_70180_af.func_187225_a(field_213609_bA);
    }

    public void func_213588_r(int n) {
        this.field_70180_af.func_187227_b(field_213609_bA, n);
    }

    public boolean func_213539_dW() {
        return this.func_213547_u(2);
    }

    public boolean func_213556_dX() {
        return this.func_213547_u(8);
    }

    public void func_213553_r(boolean bl) {
        this.func_213587_d(8, bl);
    }

    public boolean func_213567_dY() {
        return this.func_213547_u(16);
    }

    public void func_213542_s(boolean bl) {
        this.func_213587_d(16, bl);
    }

    public boolean func_213578_dZ() {
        return this.field_70180_af.func_187225_a(field_213594_bD) > 0;
    }

    public void func_213534_t(boolean bl) {
        this.field_70180_af.func_187227_b(field_213594_bD, bl ? 1 : 0);
    }

    private int func_213559_es() {
        return this.field_70180_af.func_187225_a(field_213594_bD);
    }

    private void func_213571_t(int n) {
        this.field_70180_af.func_187227_b(field_213594_bD, n);
    }

    public void func_213581_u(boolean bl) {
        this.func_213587_d(2, bl);
        if (!bl) {
            this.func_213562_s(0);
        }
    }

    public int func_213585_ee() {
        return this.field_70180_af.func_187225_a(field_213593_bB);
    }

    public void func_213562_s(int n) {
        this.field_70180_af.func_187227_b(field_213593_bB, n);
    }

    public Type func_213549_ef() {
        return Type.func_221105_a(this.field_70180_af.func_187225_a(field_213595_bE).byteValue());
    }

    public void func_213589_a(Type type) {
        if (type.func_221106_a() > 6) {
            type = Type.func_221104_a(this.field_70146_Z);
        }
        this.field_70180_af.func_187227_b(field_213595_bE, (byte)type.func_221106_a());
    }

    public Type func_213536_eg() {
        return Type.func_221105_a(this.field_70180_af.func_187225_a(field_213596_bF).byteValue());
    }

    public void func_213541_b(Type type) {
        if (type.func_221106_a() > 6) {
            type = Type.func_221104_a(this.field_70146_Z);
        }
        this.field_70180_af.func_187227_b(field_213596_bF, (byte)type.func_221106_a());
    }

    public boolean func_213564_eh() {
        return this.func_213547_u(4);
    }

    public void func_213576_v(boolean bl) {
        this.func_213587_d(4, bl);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213609_bA, 0);
        this.field_70180_af.func_187214_a(field_213593_bB, 0);
        this.field_70180_af.func_187214_a(field_213595_bE, (byte)0);
        this.field_70180_af.func_187214_a(field_213596_bF, (byte)0);
        this.field_70180_af.func_187214_a(field_213597_bG, (byte)0);
        this.field_70180_af.func_187214_a(field_213594_bD, 0);
    }

    private boolean func_213547_u(int n) {
        return (this.field_70180_af.func_187225_a(field_213597_bG) & n) != 0;
    }

    private void func_213587_d(int n, boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_213597_bG);
        if (bl) {
            this.field_70180_af.func_187227_b(field_213597_bG, (byte)(by | n));
        } else {
            this.field_70180_af.func_187227_b(field_213597_bG, (byte)(by & ~n));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74778_a("MainGene", this.func_213549_ef().func_221100_b());
        compoundNBT.func_74778_a("HiddenGene", this.func_213536_eg().func_221100_b());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_213589_a(Type.func_221108_a(compoundNBT.func_74779_i("MainGene")));
        this.func_213541_b(Type.func_221108_a(compoundNBT.func_74779_i("HiddenGene")));
    }

    @Override
    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        PandaEntity pandaEntity = EntityType.field_220353_aa.func_200721_a(this.field_70170_p);
        if (ageableEntity instanceof PandaEntity) {
            pandaEntity.func_213545_a(this, (PandaEntity)ageableEntity);
        }
        pandaEntity.func_213554_ep();
        return pandaEntity;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(2, new PanicGoal(this, 2.0));
        this.field_70714_bg.func_75776_a(2, new MateGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(3, new AttackGoal(this, (double)1.2f, true));
        this.field_70714_bg.func_75776_a(4, new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a(Blocks.field_222405_kQ.func_199767_j()), false));
        this.field_70714_bg.func_75776_a(6, new AvoidGoal<PlayerEntity>(this, PlayerEntity.class, 8.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(6, new AvoidGoal<MonsterEntity>(this, MonsterEntity.class, 4.0f, 2.0, 2.0));
        this.field_70714_bg.func_75776_a(7, new SitGoal());
        this.field_70714_bg.func_75776_a(8, new LieBackGoal(this));
        this.field_70714_bg.func_75776_a(8, new ChildPlayGoal(this));
        this.field_70714_bg.func_75776_a(9, new WatchGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, new LookRandomlyGoal(this));
        this.field_70714_bg.func_75776_a(12, new RollGoal(this));
        this.field_70714_bg.func_75776_a(13, new FollowParentGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(14, new WaterAvoidingRandomWalkingGoal(this, 1.0));
        this.field_70715_bh.func_75776_a(1, new RevengeGoal(this, new Class[0]).func_220794_a(new Class[0]));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    public Type func_213590_ei() {
        return Type.func_221101_b(this.func_213549_ef(), this.func_213536_eg());
    }

    public boolean func_213584_ej() {
        return this.func_213590_ei() == Type.LAZY;
    }

    public boolean func_213569_ek() {
        return this.func_213590_ei() == Type.WORRIED;
    }

    public boolean func_213557_el() {
        return this.func_213590_ei() == Type.PLAYFUL;
    }

    public boolean func_213582_en() {
        return this.func_213590_ei() == Type.WEAK;
    }

    @Override
    public boolean func_213398_dR() {
        return this.func_213590_ei() == Type.AGGRESSIVE;
    }

    @Override
    public boolean func_184652_a(PlayerEntity playerEntity) {
        return false;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        this.func_184185_a(SoundEvents.field_219680_ht, 1.0f, 1.0f);
        if (!this.func_213398_dR()) {
            this.field_213599_bI = true;
        }
        return super.func_70652_k(entity);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_213569_ek()) {
            if (this.field_70170_p.func_72911_I() && !this.func_70090_H()) {
                this.func_213553_r(true);
                this.func_213534_t(false);
            } else if (!this.func_213578_dZ()) {
                this.func_213553_r(false);
            }
        }
        if (this.func_70638_az() == null) {
            this.field_213598_bH = false;
            this.field_213599_bI = false;
        }
        if (this.func_213544_dV() > 0) {
            if (this.func_70638_az() != null) {
                this.func_70625_a(this.func_70638_az(), 90.0f, 90.0f);
            }
            if (this.func_213544_dV() == 29 || this.func_213544_dV() == 14) {
                this.func_184185_a(SoundEvents.field_219676_hp, 1.0f, 1.0f);
            }
            this.func_213588_r(this.func_213544_dV() - 1);
        }
        if (this.func_213539_dW()) {
            this.func_213562_s(this.func_213585_ee() + 1);
            if (this.func_213585_ee() > 20) {
                this.func_213581_u(false);
                this.func_213577_ez();
            } else if (this.func_213585_ee() == 1) {
                this.func_184185_a(SoundEvents.field_219669_hj, 1.0f, 1.0f);
            }
        }
        if (this.func_213564_eh()) {
            this.func_213535_ey();
        } else {
            this.field_213608_bz = 0;
        }
        if (this.func_213556_dX()) {
            this.field_70125_A = 0.0f;
        }
        this.func_213574_ev();
        this.func_213546_et();
        this.func_213563_ew();
        this.func_213550_ex();
    }

    public boolean func_213566_eo() {
        return this.func_213569_ek() && this.field_70170_p.func_72911_I();
    }

    private void func_213546_et() {
        if (!this.func_213578_dZ() && this.func_213556_dX() && !this.func_213566_eo() && !this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() && this.field_70146_Z.nextInt(80) == 1) {
            this.func_213534_t(true);
        } else if (this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() || !this.func_213556_dX()) {
            this.func_213534_t(false);
        }
        if (this.func_213578_dZ()) {
            this.func_213533_eu();
            if (!this.field_70170_p.field_72995_K && this.func_213559_es() > 80 && this.field_70146_Z.nextInt(20) == 1) {
                if (this.func_213559_es() > 100 && this.func_213548_j(this.func_184582_a(EquipmentSlotType.MAINHAND))) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                    }
                    this.func_213553_r(false);
                }
                this.func_213534_t(false);
                return;
            }
            this.func_213571_t(this.func_213559_es() + 1);
        }
    }

    private void func_213533_eu() {
        if (this.func_213559_es() % 5 == 0) {
            this.func_184185_a(SoundEvents.field_219674_hn, 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            for (int i = 0; i < 6; ++i) {
                Vec3d vec3d = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1);
                vec3d = vec3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                vec3d = vec3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                double \u26032 = (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3;
                \u2603 = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.8, \u26032, 1.0 + ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.4);
                \u2603 = \u2603.func_178785_b(-this.field_70761_aq * ((float)Math.PI / 180));
                \u2603 = \u2603.func_72441_c(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 1.0, this.field_70161_v);
                this.field_70170_p.func_195594_a(new ItemParticleData(ParticleTypes.field_197591_B, this.func_184582_a(EquipmentSlotType.MAINHAND)), \u2603.field_72450_a, \u2603.field_72448_b, \u2603.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
            }
        }
    }

    private void func_213574_ev() {
        this.field_213602_bL = this.field_213601_bK;
        this.field_213601_bK = this.func_213556_dX() ? Math.min(1.0f, this.field_213601_bK + 0.15f) : Math.max(0.0f, this.field_213601_bK - 0.19f);
    }

    private void func_213563_ew() {
        this.field_213604_bN = this.field_213603_bM;
        this.field_213603_bM = this.func_213567_dY() ? Math.min(1.0f, this.field_213603_bM + 0.15f) : Math.max(0.0f, this.field_213603_bM - 0.19f);
    }

    private void func_213550_ex() {
        this.field_213606_bP = this.field_213605_bO;
        this.field_213605_bO = this.func_213564_eh() ? Math.min(1.0f, this.field_213605_bO + 0.15f) : Math.max(0.0f, this.field_213605_bO - 0.19f);
    }

    public float func_213561_v(float f) {
        return MathHelper.func_219799_g(f, this.field_213602_bL, this.field_213601_bK);
    }

    public float func_213583_w(float f) {
        return MathHelper.func_219799_g(f, this.field_213604_bN, this.field_213603_bM);
    }

    public float func_213591_x(float f) {
        return MathHelper.func_219799_g(f, this.field_213606_bP, this.field_213605_bO);
    }

    private void func_213535_ey() {
        ++this.field_213608_bz;
        if (this.field_213608_bz > 32) {
            this.func_213576_v(false);
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            Vec3d vec3d = this.func_213322_ci();
            if (this.field_213608_bz == 1) {
                float f = this.field_70177_z * ((float)Math.PI / 180);
                \u2603 = this.func_70631_g_() ? 0.1f : 0.2f;
                this.field_213600_bJ = new Vec3d(vec3d.field_72450_a + (double)(-MathHelper.func_76126_a(f) * \u2603), 0.0, vec3d.field_72449_c + (double)(MathHelper.func_76134_b(f) * \u2603));
                this.func_213317_d(this.field_213600_bJ.func_72441_c(0.0, 0.27, 0.0));
            } else if ((float)this.field_213608_bz == 7.0f || (float)this.field_213608_bz == 15.0f || (float)this.field_213608_bz == 23.0f) {
                this.func_213293_j(0.0, this.field_70122_E ? 0.27 : vec3d.field_72448_b, 0.0);
            } else {
                this.func_213293_j(this.field_213600_bJ.field_72450_a, vec3d.field_72448_b, this.field_213600_bJ.field_72449_c);
            }
        }
    }

    private void func_213577_ez() {
        Vec3d vec3d = this.func_213322_ci();
        this.field_70170_p.func_195594_a(ParticleTypes.field_218421_R, this.field_70165_t - (double)(this.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a(this.field_70761_aq * ((float)Math.PI / 180)), this.field_70163_u + (double)this.func_70047_e() - (double)0.1f, this.field_70161_v + (double)(this.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b(this.field_70761_aq * ((float)Math.PI / 180)), vec3d.field_72450_a, 0.0, vec3d.field_72449_c);
        this.func_184185_a(SoundEvents.field_219670_hk, 1.0f, 1.0f);
        List<PandaEntity> \u26032 = this.field_70170_p.func_217357_a(PandaEntity.class, this.func_174813_aQ().func_186662_g(10.0));
        for (PandaEntity pandaEntity : \u26032) {
            if (pandaEntity.func_70631_g_() || !pandaEntity.field_70122_E || pandaEntity.func_70090_H() || !pandaEntity.func_213537_eq()) continue;
            pandaEntity.func_70664_aZ();
        }
        if (!this.field_70170_p.func_201670_d() && this.field_70146_Z.nextInt(700) == 0 && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            this.func_199703_a(Items.field_151123_aH);
        }
    }

    @Override
    protected void func_175445_a(ItemEntity itemEntity) {
        if (this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() && field_213607_bQ.test(itemEntity)) {
            ItemStack itemStack = itemEntity.func_92059_d();
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemStack);
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a(itemEntity, itemStack.func_190916_E());
            itemEntity.func_70106_y();
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        this.func_213553_r(false);
        return super.func_70097_a(damageSource, f);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        ILivingEntityData iLivingEntityData2 = super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData2, compoundNBT);
        this.func_213589_a(Type.func_221104_a(this.field_70146_Z));
        this.func_213541_b(Type.func_221104_a(this.field_70146_Z));
        this.func_213554_ep();
        if (iLivingEntityData2 instanceof PandaData) {
            if (this.field_70146_Z.nextInt(5) == 0) {
                this.func_70873_a(-24000);
            }
        } else {
            iLivingEntityData2 = new PandaData();
        }
        return iLivingEntityData2;
    }

    public void func_213545_a(PandaEntity pandaEntity, @Nullable PandaEntity pandaEntity2) {
        if (pandaEntity2 == null) {
            if (this.field_70146_Z.nextBoolean()) {
                this.func_213589_a(pandaEntity.func_213568_eA());
                this.func_213541_b(Type.func_221104_a(this.field_70146_Z));
            } else {
                this.func_213589_a(Type.func_221104_a(this.field_70146_Z));
                this.func_213541_b(pandaEntity.func_213568_eA());
            }
        } else if (this.field_70146_Z.nextBoolean()) {
            this.func_213589_a(pandaEntity.func_213568_eA());
            this.func_213541_b(pandaEntity2.func_213568_eA());
        } else {
            this.func_213589_a(pandaEntity2.func_213568_eA());
            this.func_213541_b(pandaEntity.func_213568_eA());
        }
        if (this.field_70146_Z.nextInt(32) == 0) {
            this.func_213589_a(Type.func_221104_a(this.field_70146_Z));
        }
        if (this.field_70146_Z.nextInt(32) == 0) {
            this.func_213541_b(Type.func_221104_a(this.field_70146_Z));
        }
    }

    private Type func_213568_eA() {
        if (this.field_70146_Z.nextBoolean()) {
            return this.func_213549_ef();
        }
        return this.func_213536_eg();
    }

    public void func_213554_ep() {
        if (this.func_213582_en()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        }
        if (this.func_213584_ej()) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.07f);
        }
    }

    private void func_213586_eB() {
        if (!this.func_70090_H()) {
            this.func_191989_p(0.0f);
            this.func_70661_as().func_75499_g();
            this.func_213553_r(true);
        }
    }

    @Override
    public boolean func_184645_a(PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (itemStack.func_77973_b() instanceof SpawnEggItem) {
            return super.func_184645_a(playerEntity, hand);
        }
        if (this.func_213566_eo()) {
            return false;
        }
        if (this.func_213567_dY()) {
            this.func_213542_s(false);
            return true;
        }
        if (this.func_70877_b(itemStack)) {
            if (this.func_70638_az() != null) {
                this.field_213598_bH = true;
            }
            if (this.func_70631_g_()) {
                this.func_175505_a(playerEntity, itemStack);
                this.func_175501_a((int)((float)(-this.func_70874_b() / 20) * 0.1f), true);
            } else if (!this.field_70170_p.field_72995_K && this.func_70874_b() == 0 && this.func_204701_dC()) {
                this.func_175505_a(playerEntity, itemStack);
                this.func_146082_f(playerEntity);
            } else if (!(this.field_70170_p.field_72995_K || this.func_213556_dX() || this.func_70090_H())) {
                this.func_213586_eB();
                this.func_213534_t(true);
                \u2603 = this.func_184582_a(EquipmentSlotType.MAINHAND);
                if (!\u2603.func_190926_b() && !playerEntity.field_71075_bZ.field_75098_d) {
                    this.func_199701_a_(\u2603);
                }
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(itemStack.func_77973_b(), 1));
                this.func_175505_a(playerEntity, itemStack);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_213398_dR()) {
            return SoundEvents.field_219677_hq;
        }
        if (this.func_213569_ek()) {
            return SoundEvents.field_219678_hr;
        }
        return SoundEvents.field_219672_hl;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_219675_ho, 0.15f, 1.0f);
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return itemStack.func_77973_b() == Blocks.field_222405_kQ.func_199767_j();
    }

    private boolean func_213548_j(ItemStack itemStack) {
        return this.func_70877_b(itemStack) || itemStack.func_77973_b() == Blocks.field_150414_aQ.func_199767_j();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219673_hm;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_219679_hs;
    }

    public boolean func_213537_eq() {
        return !this.func_213567_dY() && !this.func_213566_eo() && !this.func_213578_dZ() && !this.func_213564_eh() && !this.func_213556_dX();
    }

    static class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        private final PandaEntity field_220740_f;

        public PanicGoal(PandaEntity pandaEntity, double d) {
            super(pandaEntity, d);
            this.field_220740_f = pandaEntity;
        }

        @Override
        public boolean func_75250_a() {
            if (!this.field_220740_f.func_70027_ad()) {
                return false;
            }
            BlockPos blockPos = this.func_188497_a(this.field_75267_a.field_70170_p, this.field_75267_a, 5, 4);
            if (blockPos != null) {
                this.field_75266_c = blockPos.func_177958_n();
                this.field_75263_d = blockPos.func_177956_o();
                this.field_75264_e = blockPos.func_177952_p();
                return true;
            }
            return this.func_190863_f();
        }

        @Override
        public boolean func_75253_b() {
            if (this.field_220740_f.func_213556_dX()) {
                this.field_220740_f.func_70661_as().func_75499_g();
                return false;
            }
            return super.func_75253_b();
        }
    }

    static class RevengeGoal
    extends HurtByTargetGoal {
        private final PandaEntity field_220798_a;

        public RevengeGoal(PandaEntity pandaEntity, Class<?> ... classArray) {
            super(pandaEntity, classArray);
            this.field_220798_a = pandaEntity;
        }

        @Override
        public boolean func_75253_b() {
            if (this.field_220798_a.field_213598_bH || this.field_220798_a.field_213599_bI) {
                this.field_220798_a.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }

        @Override
        protected void func_220793_a(MobEntity mobEntity, LivingEntity livingEntity) {
            if (mobEntity instanceof PandaEntity && ((PandaEntity)mobEntity).func_213398_dR()) {
                mobEntity.func_70624_b(livingEntity);
            }
        }
    }

    static class LieBackGoal
    extends Goal {
        private final PandaEntity field_220828_a;
        private int field_220829_b;

        public LieBackGoal(PandaEntity pandaEntity) {
            this.field_220828_a = pandaEntity;
        }

        @Override
        public boolean func_75250_a() {
            return this.field_220829_b < this.field_220828_a.field_70173_aa && this.field_220828_a.func_213584_ej() && this.field_220828_a.func_213537_eq() && this.field_220828_a.field_70146_Z.nextInt(400) == 1;
        }

        @Override
        public boolean func_75253_b() {
            if (this.field_220828_a.func_70090_H() || !this.field_220828_a.func_213584_ej() && this.field_220828_a.field_70146_Z.nextInt(600) == 1) {
                return false;
            }
            return this.field_220828_a.field_70146_Z.nextInt(2000) != 1;
        }

        @Override
        public void func_75249_e() {
            this.field_220828_a.func_213542_s(true);
            this.field_220829_b = 0;
        }

        @Override
        public void func_75251_c() {
            this.field_220828_a.func_213542_s(false);
            this.field_220829_b = this.field_220828_a.field_70173_aa + 200;
        }
    }

    class SitGoal
    extends Goal {
        private int field_220832_b;

        public SitGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_220832_b > PandaEntity.this.field_70173_aa || PandaEntity.this.func_70631_g_() || PandaEntity.this.func_70090_H() || !PandaEntity.this.func_213537_eq() || PandaEntity.this.func_213544_dV() > 0) {
                return false;
            }
            List<ItemEntity> list = PandaEntity.this.field_70170_p.func_175647_a(ItemEntity.class, PandaEntity.this.func_174813_aQ().func_72314_b(6.0, 6.0, 6.0), field_213607_bQ);
            return !list.isEmpty() || !PandaEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b();
        }

        @Override
        public boolean func_75253_b() {
            if (PandaEntity.this.func_70090_H() || !PandaEntity.this.func_213584_ej() && PandaEntity.this.field_70146_Z.nextInt(600) == 1) {
                return false;
            }
            return PandaEntity.this.field_70146_Z.nextInt(2000) != 1;
        }

        @Override
        public void func_75246_d() {
            if (!PandaEntity.this.func_213556_dX() && !PandaEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                PandaEntity.this.func_213586_eB();
            }
        }

        @Override
        public void func_75249_e() {
            List<ItemEntity> list = PandaEntity.this.field_70170_p.func_175647_a(ItemEntity.class, PandaEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_213607_bQ);
            if (!list.isEmpty() && PandaEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                PandaEntity.this.func_70661_as().func_75497_a(list.get(0), 1.2f);
            } else if (!PandaEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                PandaEntity.this.func_213586_eB();
            }
            this.field_220832_b = 0;
        }

        @Override
        public void func_75251_c() {
            ItemStack itemStack = PandaEntity.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemStack.func_190926_b()) {
                PandaEntity.this.func_199701_a_(itemStack);
                PandaEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                int n = PandaEntity.this.func_213584_ej() ? PandaEntity.this.field_70146_Z.nextInt(50) + 10 : PandaEntity.this.field_70146_Z.nextInt(150) + 10;
                this.field_220832_b = PandaEntity.this.field_70173_aa + n * 20;
            }
            PandaEntity.this.func_213553_r(false);
        }
    }

    static class AvoidGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final PandaEntity field_220875_i;

        public AvoidGoal(PandaEntity pandaEntity, Class<T> clazz, float f, double d, double d2) {
            super(pandaEntity, clazz, f, d, d2, EntityPredicates.field_180132_d::test);
            this.field_220875_i = pandaEntity;
        }

        @Override
        public boolean func_75250_a() {
            return this.field_220875_i.func_213569_ek() && this.field_220875_i.func_213537_eq() && super.func_75250_a();
        }
    }

    static class MateGoal
    extends BreedGoal {
        private static final EntityPredicate field_220692_d = new EntityPredicate().func_221013_a(8.0).func_221011_b().func_221008_a();
        private final PandaEntity field_220693_e;
        private int field_220694_f;

        public MateGoal(PandaEntity pandaEntity, double d) {
            super(pandaEntity, d);
            this.field_220693_e = pandaEntity;
        }

        @Override
        public boolean func_75250_a() {
            if (super.func_75250_a() && this.field_220693_e.func_213544_dV() == 0) {
                if (!this.func_220691_h()) {
                    if (this.field_220694_f <= this.field_220693_e.field_70173_aa) {
                        this.field_220693_e.func_213588_r(32);
                        this.field_220694_f = this.field_220693_e.field_70173_aa + 600;
                        if (this.field_220693_e.func_70613_aW()) {
                            PlayerEntity playerEntity = this.field_75394_a.func_217370_a(field_220692_d, this.field_220693_e);
                            this.field_220693_e.func_70624_b(playerEntity);
                        }
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean func_220691_h() {
            BlockPos blockPos = new BlockPos(this.field_220693_e);
            BlockPos.MutableBlockPos \u26032 = new BlockPos.MutableBlockPos();
            for (int i = 0; i < 3; ++i) {
                for (\u2603 = 0; \u2603 < 8; ++\u2603) {
                    \u2603 = 0;
                    while (\u2603 <= \u2603) {
                        int n = \u2603 = \u2603 < \u2603 && \u2603 > -\u2603 ? \u2603 : 0;
                        while (\u2603 <= \u2603) {
                            \u26032.func_189533_g(blockPos).func_196234_d(\u2603, i, \u2603);
                            if (this.field_75394_a.func_180495_p(\u26032).func_177230_c() == Blocks.field_222405_kQ) {
                                return true;
                            }
                            \u2603 = \u2603 > 0 ? -\u2603 : 1 - \u2603;
                        }
                        \u2603 = \u2603 > 0 ? -\u2603 : 1 - \u2603;
                    }
                }
            }
            return false;
        }
    }

    static class ChildPlayGoal
    extends Goal {
        private final PandaEntity field_220833_a;

        public ChildPlayGoal(PandaEntity pandaEntity) {
            this.field_220833_a = pandaEntity;
        }

        @Override
        public boolean func_75250_a() {
            if (!this.field_220833_a.func_70631_g_() || !this.field_220833_a.func_213537_eq()) {
                return false;
            }
            if (this.field_220833_a.func_213582_en() && this.field_220833_a.field_70146_Z.nextInt(500) == 1) {
                return true;
            }
            return this.field_220833_a.field_70146_Z.nextInt(6000) == 1;
        }

        @Override
        public boolean func_75253_b() {
            return false;
        }

        @Override
        public void func_75249_e() {
            this.field_220833_a.func_213581_u(true);
        }
    }

    static class RollGoal
    extends Goal {
        private final PandaEntity field_220830_a;

        public RollGoal(PandaEntity pandaEntity) {
            this.field_220830_a = pandaEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        public boolean func_75250_a() {
            if (!this.field_220830_a.func_70631_g_() && !this.field_220830_a.func_213557_el() || !this.field_220830_a.field_70122_E) {
                return false;
            }
            if (!this.field_220830_a.func_213537_eq()) {
                return false;
            }
            float f = this.field_220830_a.field_70177_z * ((float)Math.PI / 180);
            int \u26032 = 0;
            int \u26033 = 0;
            \u2603 = -MathHelper.func_76126_a(f);
            \u2603 = MathHelper.func_76134_b(f);
            if ((double)Math.abs(\u2603) > 0.5) {
                \u26032 = (int)((float)\u26032 + \u2603 / Math.abs(\u2603));
            }
            if ((double)Math.abs(\u2603) > 0.5) {
                \u26033 = (int)((float)\u26033 + \u2603 / Math.abs(\u2603));
            }
            if (this.field_220830_a.field_70170_p.func_180495_p(new BlockPos(this.field_220830_a).func_177982_a(\u26032, -1, \u26033)).func_196958_f()) {
                return true;
            }
            if (this.field_220830_a.func_213557_el() && this.field_220830_a.field_70146_Z.nextInt(60) == 1) {
                return true;
            }
            return this.field_220830_a.field_70146_Z.nextInt(500) == 1;
        }

        @Override
        public boolean func_75253_b() {
            return false;
        }

        @Override
        public void func_75249_e() {
            this.field_220830_a.func_213576_v(true);
        }

        @Override
        public boolean func_220685_C_() {
            return false;
        }
    }

    static class WatchGoal
    extends LookAtGoal {
        private final PandaEntity field_220718_f;

        public WatchGoal(PandaEntity pandaEntity, Class<? extends LivingEntity> clazz, float f) {
            super(pandaEntity, clazz, f);
            this.field_220718_f = pandaEntity;
        }

        @Override
        public boolean func_75250_a() {
            return this.field_220718_f.func_213537_eq() && super.func_75250_a();
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        private final PandaEntity field_220722_d;

        public AttackGoal(PandaEntity pandaEntity, double d, boolean bl) {
            super(pandaEntity, d, bl);
            this.field_220722_d = pandaEntity;
        }

        @Override
        public boolean func_75250_a() {
            return this.field_220722_d.func_213537_eq() && super.func_75250_a();
        }
    }

    static class PandaData
    implements ILivingEntityData {
        private PandaData() {
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final PandaEntity field_220672_i;

        public MoveHelperController(PandaEntity pandaEntity) {
            super(pandaEntity);
            this.field_220672_i = pandaEntity;
        }

        @Override
        public void func_75641_c() {
            if (!this.field_220672_i.func_213537_eq()) {
                return;
            }
            super.func_75641_c();
        }
    }

    public static enum Type {
        NORMAL(0, "normal", false),
        LAZY(1, "lazy", false),
        WORRIED(2, "worried", false),
        PLAYFUL(3, "playful", false),
        BROWN(4, "brown", true),
        WEAK(5, "weak", true),
        AGGRESSIVE(6, "aggressive", false);

        private static final Type[] field_221109_h;
        private final int field_221110_i;
        private final String field_221111_j;
        private final boolean field_221112_k;

        private Type(int n2, String string2, boolean bl) {
            this.field_221110_i = n2;
            this.field_221111_j = string2;
            this.field_221112_k = bl;
        }

        public int func_221106_a() {
            return this.field_221110_i;
        }

        public String func_221100_b() {
            return this.field_221111_j;
        }

        public boolean func_221107_c() {
            return this.field_221112_k;
        }

        private static Type func_221101_b(Type type, Type type2) {
            if (type.func_221107_c()) {
                if (type == type2) {
                    return type;
                }
                return NORMAL;
            }
            return type;
        }

        public static Type func_221105_a(int n) {
            if (n < 0 || n >= field_221109_h.length) {
                n = 0;
            }
            return field_221109_h[n];
        }

        public static Type func_221108_a(String string) {
            for (Type type : Type.values()) {
                if (!type.field_221111_j.equals(string)) continue;
                return type;
            }
            return NORMAL;
        }

        public static Type func_221104_a(Random random) {
            int n = random.nextInt(16);
            if (n == 0) {
                return LAZY;
            }
            if (n == 1) {
                return WORRIED;
            }
            if (n == 2) {
                return PLAYFUL;
            }
            if (n == 4) {
                return AGGRESSIVE;
            }
            if (n < 9) {
                return WEAK;
            }
            if (n < 11) {
                return BROWN;
            }
            return NORMAL;
        }

        static {
            field_221109_h = (Type[])Arrays.stream(Type.values()).sorted(Comparator.comparingInt(Type::func_221106_a)).toArray(Type[]::new);
        }
    }
}

