/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.datasync;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.IDataSerializer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityDataManager {
    private static final Logger field_190303_a = LogManager.getLogger();
    private static final Map<Class<? extends Entity>, Integer> field_187232_a = Maps.newHashMap();
    private final Entity field_187233_b;
    private final Map<Integer, DataEntry<?>> field_187234_c = Maps.newHashMap();
    private final ReadWriteLock field_187235_d = new ReentrantReadWriteLock();
    private boolean field_187236_e = true;
    private boolean field_187237_f;

    public EntityDataManager(Entity entity) {
        this.field_187233_b = entity;
    }

    public static <T> DataParameter<T> func_187226_a(Class<? extends Entity> clazz2, IDataSerializer<T> iDataSerializer) {
        Class<? extends Entity> clazz2;
        if (field_190303_a.isDebugEnabled()) {
            try {
                Class<?> clazz3 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!clazz3.equals(clazz2)) {
                    field_190303_a.debug("defineId called for: {} from {}", clazz2, clazz3, (Object)new RuntimeException());
                }
            }
            catch (ClassNotFoundException clazz3) {
                // empty catch block
            }
        }
        if (field_187232_a.containsKey(clazz2)) {
            int n = field_187232_a.get(clazz2) + 1;
        } else {
            int n = 0;
            Class<? extends Entity> \u26032 = clazz2;
            while (\u26032 != Entity.class) {
                if (!field_187232_a.containsKey(\u26032 = \u26032.getSuperclass())) continue;
                n = field_187232_a.get(\u26032) + 1;
                break;
            }
            n = n;
        }
        if (n > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + n + "! (Max is " + 254 + ")");
        }
        field_187232_a.put(clazz2, n);
        return iDataSerializer.func_187161_a(n);
    }

    public <T> void func_187214_a(DataParameter<T> dataParameter, T t) {
        int n = dataParameter.func_187155_a();
        if (n > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + n + "! (Max is " + 254 + ")");
        }
        if (this.field_187234_c.containsKey(n)) {
            throw new IllegalArgumentException("Duplicate id value for " + n + "!");
        }
        if (DataSerializers.func_187188_b(dataParameter.func_187156_b()) < 0) {
            throw new IllegalArgumentException("Unregistered serializer " + dataParameter.func_187156_b() + " for " + n + "!");
        }
        this.func_187222_c(dataParameter, t);
    }

    private <T> void func_187222_c(DataParameter<T> dataParameter, T t) {
        DataEntry<T> dataEntry = new DataEntry<T>(dataParameter, t);
        this.field_187235_d.writeLock().lock();
        this.field_187234_c.put(dataParameter.func_187155_a(), dataEntry);
        this.field_187236_e = false;
        this.field_187235_d.writeLock().unlock();
    }

    private <T> DataEntry<T> func_187219_c(DataParameter<T> dataParameter) {
        this.field_187235_d.readLock().lock();
        try {
            DataEntry<?> dataEntry = this.field_187234_c.get(dataParameter.func_187155_a());
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Getting synched entity data");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Synched entity data");
            \u26032.func_71507_a("Data ID", dataParameter);
            throw new ReportedException(crashReport);
        }
        finally {
            this.field_187235_d.readLock().unlock();
        }
        return dataEntry;
    }

    public <T> T func_187225_a(DataParameter<T> dataParameter) {
        return this.func_187219_c(dataParameter).func_187206_b();
    }

    public <T> void func_187227_b(DataParameter<T> dataParameter, T t) {
        DataEntry<T> dataEntry = this.func_187219_c(dataParameter);
        if (ObjectUtils.notEqual(t, dataEntry.func_187206_b())) {
            dataEntry.func_187210_a(t);
            this.field_187233_b.func_184206_a(dataParameter);
            dataEntry.func_187208_a(true);
            this.field_187237_f = true;
        }
    }

    public boolean func_187223_a() {
        return this.field_187237_f;
    }

    public static void func_187229_a(List<DataEntry<?>> list, PacketBuffer packetBuffer2) throws IOException {
        PacketBuffer packetBuffer2;
        if (list != null) {
            int n = list.size();
            for (\u2603 = 0; \u2603 < n; ++\u2603) {
                EntityDataManager.func_187220_a(packetBuffer2, list.get(\u2603));
            }
        }
        packetBuffer2.writeByte(255);
    }

    @Nullable
    public List<DataEntry<?>> func_187221_b() {
        ArrayList arrayList = null;
        if (this.field_187237_f) {
            this.field_187235_d.readLock().lock();
            for (DataEntry<?> dataEntry : this.field_187234_c.values()) {
                if (!dataEntry.func_187209_c()) continue;
                dataEntry.func_187208_a(false);
                if (arrayList == null) {
                    arrayList = Lists.newArrayList();
                }
                arrayList.add(dataEntry.func_192735_d());
            }
            this.field_187235_d.readLock().unlock();
        }
        this.field_187237_f = false;
        return arrayList;
    }

    public void func_187216_a(PacketBuffer packetBuffer2) throws IOException {
        PacketBuffer packetBuffer2;
        this.field_187235_d.readLock().lock();
        for (DataEntry<?> dataEntry : this.field_187234_c.values()) {
            EntityDataManager.func_187220_a(packetBuffer2, dataEntry);
        }
        this.field_187235_d.readLock().unlock();
        packetBuffer2.writeByte(255);
    }

    @Nullable
    public List<DataEntry<?>> func_187231_c() {
        ArrayList arrayList = null;
        this.field_187235_d.readLock().lock();
        for (DataEntry<?> dataEntry : this.field_187234_c.values()) {
            if (arrayList == null) {
                arrayList = Lists.newArrayList();
            }
            arrayList.add(dataEntry.func_192735_d());
        }
        this.field_187235_d.readLock().unlock();
        return arrayList;
    }

    private static <T> void func_187220_a(PacketBuffer packetBuffer, DataEntry<T> dataEntry) throws IOException {
        DataParameter<T> dataParameter = dataEntry.func_187205_a();
        int \u26032 = DataSerializers.func_187188_b(dataParameter.func_187156_b());
        if (\u26032 < 0) {
            throw new EncoderException("Unknown serializer type " + dataParameter.func_187156_b());
        }
        packetBuffer.writeByte(dataParameter.func_187155_a());
        packetBuffer.func_150787_b(\u26032);
        dataParameter.func_187156_b().func_187160_a(packetBuffer, dataEntry.func_187206_b());
    }

    @Nullable
    public static List<DataEntry<?>> func_187215_b(PacketBuffer packetBuffer) throws IOException {
        ArrayList arrayList = null;
        while ((\u2603 = packetBuffer.readUnsignedByte()) != 255) {
            if (arrayList == null) {
                arrayList = Lists.newArrayList();
            }
            if ((\u2603 = DataSerializers.func_187190_a(\u2603 = packetBuffer.func_150792_a())) == null) {
                throw new DecoderException("Unknown serializer type " + \u2603);
            }
            arrayList.add(EntityDataManager.func_198167_a(packetBuffer, \u2603, \u2603));
        }
        return arrayList;
    }

    private static <T> DataEntry<T> func_198167_a(PacketBuffer packetBuffer, int n, IDataSerializer<T> iDataSerializer) {
        return new DataEntry<T>(iDataSerializer.func_187161_a(n), iDataSerializer.func_187159_a(packetBuffer));
    }

    public void func_187218_a(List<DataEntry<?>> list) {
        this.field_187235_d.writeLock().lock();
        for (DataEntry<?> dataEntry : list) {
            \u2603 = this.field_187234_c.get(dataEntry.func_187205_a().func_187155_a());
            if (\u2603 == null) continue;
            this.func_187224_a(\u2603, dataEntry);
            this.field_187233_b.func_184206_a(dataEntry.func_187205_a());
        }
        this.field_187235_d.writeLock().unlock();
        this.field_187237_f = true;
    }

    private <T> void func_187224_a(DataEntry<T> dataEntry, DataEntry<?> dataEntry2) {
        if (!Objects.equals(((DataEntry)dataEntry2).field_187211_a.func_187156_b(), ((DataEntry)dataEntry).field_187211_a.func_187156_b())) {
            throw new IllegalStateException(String.format("Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", ((DataEntry)dataEntry).field_187211_a.func_187155_a(), this.field_187233_b, ((DataEntry)dataEntry).field_187212_b, ((DataEntry)dataEntry).field_187212_b.getClass(), ((DataEntry)dataEntry2).field_187212_b, ((DataEntry)dataEntry2).field_187212_b.getClass()));
        }
        dataEntry.func_187210_a(dataEntry2.func_187206_b());
    }

    public boolean func_187228_d() {
        return this.field_187236_e;
    }

    public void func_187230_e() {
        this.field_187237_f = false;
        this.field_187235_d.readLock().lock();
        for (DataEntry<?> dataEntry : this.field_187234_c.values()) {
            dataEntry.func_187208_a(false);
        }
        this.field_187235_d.readLock().unlock();
    }

    public static class DataEntry<T> {
        private final DataParameter<T> field_187211_a;
        private T field_187212_b;
        private boolean field_187213_c;

        public DataEntry(DataParameter<T> dataParameter, T t) {
            this.field_187211_a = dataParameter;
            this.field_187212_b = t;
            this.field_187213_c = true;
        }

        public DataParameter<T> func_187205_a() {
            return this.field_187211_a;
        }

        public void func_187210_a(T t) {
            this.field_187212_b = t;
        }

        public T func_187206_b() {
            return this.field_187212_b;
        }

        public boolean func_187209_c() {
            return this.field_187213_c;
        }

        public void func_187208_a(boolean bl) {
            this.field_187213_c = bl;
        }

        public DataEntry<T> func_192735_d() {
            return new DataEntry<T>(this.field_187211_a, this.field_187211_a.func_187156_b().func_192717_a(this.field_187212_b));
        }
    }
}

