/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.integrated;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.LanServerPingThread;
import net.minecraft.command.Commands;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.DebugProfiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedPlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.CryptManager;
import net.minecraft.util.SharedConstants;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegratedServer
extends MinecraftServer {
    private static final Logger field_147148_h = LogManager.getLogger();
    private final Minecraft field_71349_l;
    private final WorldSettings field_71350_m;
    private boolean field_71348_o;
    private int field_195580_l = -1;
    private LanServerPingThread field_71345_q;
    private UUID field_211528_n;

    public IntegratedServer(Minecraft minecraft, String string, String string2, WorldSettings worldSettings, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, PlayerProfileCache playerProfileCache, IChunkStatusListenerFactory iChunkStatusListenerFactory) {
        super(new File(minecraft.field_71412_D, "saves"), minecraft.func_110437_J(), minecraft.func_184126_aj(), new Commands(false), yggdrasilAuthenticationService, minecraftSessionService, gameProfileRepository, playerProfileCache, iChunkStatusListenerFactory, string);
        this.func_71224_l(minecraft.func_110432_I().func_111285_a());
        this.func_71246_n(string2);
        this.func_71204_b(minecraft.func_71355_q());
        this.func_71194_c(worldSettings.func_77167_c());
        this.func_71191_d(256);
        this.func_184105_a(new IntegratedPlayerList(this));
        this.field_71349_l = minecraft;
        this.field_71350_m = this.func_71242_L() ? MinecraftServer.field_213219_c : worldSettings;
    }

    @Override
    public void func_71247_a(String string, String string2, long l, WorldType worldType, JsonElement jsonElement) {
        this.func_71237_c(string);
        SaveHandler saveHandler = this.func_71254_M().func_197715_a(string, this);
        this.func_175584_a(this.func_71270_I(), saveHandler);
        WorldInfo \u26032 = saveHandler.func_75757_d();
        if (\u26032 == null) {
            \u26032 = new WorldInfo(this.field_71350_m, string2);
        } else {
            \u26032.func_76062_a(string2);
        }
        this.func_195560_a(saveHandler.func_75765_b(), \u26032);
        IChunkStatusListener \u26033 = this.field_213220_d.create(11);
        this.func_213194_a(saveHandler, \u26032, this.field_71350_m, \u26033);
        if (this.func_71218_a(DimensionType.field_223227_a_).func_72912_H().func_176130_y() == null) {
            this.func_147139_a(this.field_71349_l.field_71474_y.field_74318_M, true);
        }
        this.func_213186_a(\u26033);
    }

    @Override
    public boolean func_71197_b() throws IOException {
        field_147148_h.info("Starting integrated minecraft server version " + SharedConstants.func_215069_a().getName());
        this.func_71229_d(true);
        this.func_71251_e(true);
        this.func_71257_f(true);
        this.func_71188_g(true);
        this.func_71245_h(true);
        field_147148_h.info("Generating keypair");
        this.func_71253_a(CryptManager.func_75891_b());
        this.func_71247_a(this.func_71270_I(), this.func_71221_J(), this.field_71350_m.func_77160_d(), this.field_71350_m.func_77165_h(), this.field_71350_m.func_205391_j());
        this.func_71205_p(this.func_71214_G() + " - " + this.func_71218_a(DimensionType.field_223227_a_).func_72912_H().func_76065_j());
        return true;
    }

    @Override
    public void func_71217_p(BooleanSupplier booleanSupplier) {
        boolean bl = this.field_71348_o;
        this.field_71348_o = Minecraft.func_71410_x().func_147114_u() != null && Minecraft.func_71410_x().func_147113_T();
        DebugProfiler \u26032 = this.func_213185_aS();
        if (!bl && this.field_71348_o) {
            \u26032.func_76320_a("autoSave");
            field_147148_h.info("Saving and pausing game...");
            this.func_184103_al().func_72389_g();
            this.func_213211_a(false, false, false);
            \u26032.func_76319_b();
        }
        if (this.field_71348_o) {
            return;
        }
        super.func_71217_p(booleanSupplier);
        int \u26033 = Math.max(2, this.field_71349_l.field_71474_y.field_151451_c + -2);
        if (\u26033 != this.func_184103_al().func_72395_o()) {
            field_147148_h.info("Changing view distance to {}, from {}", (Object)\u26033, (Object)this.func_184103_al().func_72395_o());
            this.func_184103_al().func_217884_a(\u26033);
        }
    }

    @Override
    public boolean func_71225_e() {
        return false;
    }

    @Override
    public GameType func_71265_f() {
        return this.field_71350_m.func_77162_e();
    }

    @Override
    public Difficulty func_147135_j() {
        return this.field_71349_l.field_71441_e.func_72912_H().func_176130_y();
    }

    @Override
    public boolean func_71199_h() {
        return this.field_71350_m.func_77158_f();
    }

    @Override
    public boolean func_195569_l() {
        return true;
    }

    @Override
    public boolean func_195041_r_() {
        return true;
    }

    @Override
    public File func_71238_n() {
        return this.field_71349_l.field_71412_D;
    }

    @Override
    public boolean func_71262_S() {
        return false;
    }

    @Override
    public boolean func_181035_ah() {
        return false;
    }

    @Override
    public void func_71228_a(CrashReport crashReport) {
        this.field_71349_l.func_71404_a(crashReport);
    }

    @Override
    public CrashReport func_71230_b(CrashReport crashReport) {
        crashReport = super.func_71230_b(crashReport);
        crashReport.func_85056_g().func_71507_a("Type", "Integrated Server (map_client.txt)");
        crashReport.func_85056_g().func_189529_a("Is Modded", () -> {
            String string = ClientBrandRetriever.getClientModName();
            if (!string.equals("vanilla")) {
                return "Definitely; Client brand changed to '" + string + "'";
            }
            string = this.getServerModName();
            if (!"vanilla".equals(string)) {
                return "Definitely; Server brand changed to '" + string + "'";
            }
            if (Minecraft.class.getSigners() == null) {
                return "Very likely; Jar signature invalidated";
            }
            return "Probably not. Jar signature remains and both client + server brands are untouched.";
        });
        return crashReport;
    }

    @Override
    public void func_70000_a(Snooper snooper) {
        super.func_70000_a(snooper);
        snooper.func_152768_a("snooper_partner", this.field_71349_l.func_71378_E().func_80006_f());
    }

    @Override
    public boolean func_195565_a(GameType gameType, boolean bl, int n) {
        try {
            this.func_147137_ag().func_151265_a(null, n);
            field_147148_h.info("Started serving on {}", (Object)n);
            this.field_195580_l = n;
            this.field_71345_q = new LanServerPingThread(this.func_71273_Y(), n + "");
            this.field_71345_q.start();
            this.func_184103_al().func_152604_a(gameType);
            this.func_184103_al().func_72387_b(bl);
            \u2603 = this.func_211833_a(this.field_71349_l.field_71439_g.func_146103_bH());
            this.field_71349_l.field_71439_g.func_184839_n(\u2603);
            for (ServerPlayerEntity serverPlayerEntity : this.func_184103_al().func_181057_v()) {
                this.func_195571_aL().func_197051_a(serverPlayerEntity);
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void func_71260_j() {
        super.func_71260_j();
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    @Override
    public void func_71263_m(boolean bl) {
        this.func_213167_f(() -> {
            ArrayList arrayList = Lists.newArrayList(this.func_184103_al().func_181057_v());
            for (ServerPlayerEntity serverPlayerEntity : arrayList) {
                if (serverPlayerEntity.func_110124_au().equals(this.field_211528_n)) continue;
                this.func_184103_al().func_72367_e(serverPlayerEntity);
            }
        });
        super.func_71263_m(bl);
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    @Override
    public boolean func_71344_c() {
        return this.field_195580_l > -1;
    }

    @Override
    public int func_71215_F() {
        return this.field_195580_l;
    }

    @Override
    public void func_71235_a(GameType gameType) {
        super.func_71235_a(gameType);
        this.func_184103_al().func_152604_a(gameType);
    }

    @Override
    public boolean func_82356_Z() {
        return true;
    }

    @Override
    public int func_110455_j() {
        return 2;
    }

    @Override
    public int func_223707_k() {
        return 2;
    }

    public void func_211527_b(UUID uUID) {
        this.field_211528_n = uUID;
    }

    @Override
    public boolean func_213199_b(GameProfile gameProfile) {
        return gameProfile.getName().equalsIgnoreCase(this.func_71214_G());
    }
}

