/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class RayTraceContext {
    private final Vec3d field_222254_a;
    private final Vec3d field_222255_b;
    private final BlockMode field_222256_c;
    private final FluidMode field_222257_d;
    private final ISelectionContext field_222258_e;

    public RayTraceContext(Vec3d vec3d, Vec3d vec3d2, BlockMode blockMode, FluidMode fluidMode, Entity entity) {
        this.field_222254_a = vec3d;
        this.field_222255_b = vec3d2;
        this.field_222256_c = blockMode;
        this.field_222257_d = fluidMode;
        this.field_222258_e = ISelectionContext.func_216374_a(entity);
    }

    public Vec3d func_222250_a() {
        return this.field_222255_b;
    }

    public Vec3d func_222253_b() {
        return this.field_222254_a;
    }

    public VoxelShape func_222251_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return this.field_222256_c.get(blockState, iBlockReader, blockPos, this.field_222258_e);
    }

    public VoxelShape func_222252_a(IFluidState iFluidState, IBlockReader iBlockReader, BlockPos blockPos) {
        return this.field_222257_d.func_222248_a(iFluidState) ? iFluidState.func_215676_d(iBlockReader, blockPos) : VoxelShapes.func_197880_a();
    }

    public static enum FluidMode {
        NONE(iFluidState -> false),
        SOURCE_ONLY(IFluidState::func_206889_d),
        ANY(iFluidState -> !iFluidState.func_206888_e());

        private final Predicate<IFluidState> field_222249_d;

        private FluidMode(Predicate<IFluidState> predicate) {
            this.field_222249_d = predicate;
        }

        public boolean func_222248_a(IFluidState iFluidState) {
            return this.field_222249_d.test(iFluidState);
        }
    }

    public static interface IVoxelProvider {
        public VoxelShape get(BlockState var1, IBlockReader var2, BlockPos var3, ISelectionContext var4);
    }

    public static enum BlockMode implements IVoxelProvider
    {
        COLLIDER(BlockState::func_215685_b),
        OUTLINE(BlockState::func_215700_a);

        private final IVoxelProvider field_222245_c;

        private BlockMode(IVoxelProvider iVoxelProvider) {
            this.field_222245_c = iVoxelProvider;
        }

        @Override
        public VoxelShape get(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
            return this.field_222245_c.get(blockState, iBlockReader, blockPos, iSelectionContext);
        }
    }
}

