/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import java.io.PrintStream;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.EntityOptions;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.server.DebugLoggingPrintStream;
import net.minecraft.util.LoggingPrintStream;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraft.world.biome.Biome;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Bootstrap {
    public static final PrintStream field_179872_a = System.out;
    private static boolean field_151355_a;
    private static final Logger field_179871_c;

    public static void func_151354_b() {
        if (field_151355_a) {
            return;
        }
        field_151355_a = true;
        if (Registry.field_212617_f.func_195866_d()) {
            throw new IllegalStateException("Unable to load registries");
        }
        FireBlock.func_149843_e();
        ComposterBlock.func_220297_d();
        if (EntityType.func_200718_a(EntityType.field_200729_aH) == null) {
            throw new IllegalStateException("Failed loading EntityTypes");
        }
        PotionBrewing.func_185207_a();
        EntityOptions.func_197445_a();
        IDispenseItemBehavior.func_218401_c();
        ArgumentTypes.func_197483_a();
        Bootstrap.func_179868_d();
    }

    private static <T> void func_218819_a(Registry<T> registry, Function<T, String> function, Set<String> set) {
        LanguageMap languageMap = LanguageMap.func_74808_a();
        registry.iterator().forEachRemaining(object -> {
            String string = (String)function.apply(object);
            if (!languageMap.func_210813_b(string)) {
                set.add(string);
            }
        });
    }

    public static Set<String> func_218816_b() {
        TreeSet<String> treeSet = new TreeSet<String>();
        Bootstrap.func_218819_a(Registry.field_212629_r, EntityType::func_210760_d, treeSet);
        Bootstrap.func_218819_a(Registry.field_212631_t, Effect::func_76393_a, treeSet);
        Bootstrap.func_218819_a(Registry.field_212630_s, Item::func_77658_a, treeSet);
        Bootstrap.func_218819_a(Registry.field_212628_q, Enchantment::func_77320_a, treeSet);
        Bootstrap.func_218819_a(Registry.field_212624_m, Biome::func_210773_k, treeSet);
        Bootstrap.func_218819_a(Registry.field_212618_g, Block::func_149739_a, treeSet);
        Bootstrap.func_218819_a(Registry.field_212623_l, resourceLocation -> "stat." + resourceLocation.toString().replace(':', '.'), treeSet);
        return treeSet;
    }

    public static void func_218821_c() {
        if (!field_151355_a) {
            throw new IllegalArgumentException("Not bootstrapped");
        }
        if (SharedConstants.field_206244_b) {
            return;
        }
        Bootstrap.func_218816_b().forEach(string -> field_179871_c.error("Missing translations: " + string));
    }

    private static void func_179868_d() {
        if (field_179871_c.isDebugEnabled()) {
            System.setErr(new DebugLoggingPrintStream("STDERR", System.err));
            System.setOut(new DebugLoggingPrintStream("STDOUT", field_179872_a));
        } else {
            System.setErr(new LoggingPrintStream("STDERR", System.err));
            System.setOut(new LoggingPrintStream("STDOUT", field_179872_a));
        }
    }

    public static void func_179870_a(String string) {
        field_179872_a.println(string);
    }

    static {
        field_179871_c = LogManager.getLogger();
    }
}

