/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.Util;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.NBTTextComponent;
import net.minecraft.util.text.ScoreTextComponent;
import net.minecraft.util.text.SelectorTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public interface ITextComponent
extends Message,
Iterable<ITextComponent> {
    public ITextComponent func_150255_a(Style var1);

    public Style func_150256_b();

    default public ITextComponent func_150258_a(String string) {
        return this.func_150257_a(new StringTextComponent(string));
    }

    public ITextComponent func_150257_a(ITextComponent var1);

    public String func_150261_e();

    default public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.func_212640_c().forEach(iTextComponent -> stringBuilder.append(iTextComponent.func_150261_e()));
        return stringBuilder.toString();
    }

    default public String func_212636_a(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator \u26032 = this.func_212640_c().iterator();
        while (\u26032.hasNext() && (\u2603 = n - stringBuilder.length()) > 0) {
            String string = ((ITextComponent)\u26032.next()).func_150261_e();
            stringBuilder.append(string.length() <= \u2603 ? string : string.substring(0, \u2603));
        }
        return stringBuilder.toString();
    }

    default public String func_150254_d() {
        StringBuilder stringBuilder = new StringBuilder();
        String \u26032 = "";
        Iterator \u26033 = this.func_212640_c().iterator();
        while (\u26033.hasNext()) {
            ITextComponent iTextComponent = (ITextComponent)\u26033.next();
            String \u26034 = iTextComponent.func_150261_e();
            if (\u26034.isEmpty()) continue;
            String \u26035 = iTextComponent.func_150256_b().func_150218_j();
            if (!\u26035.equals(\u26032)) {
                if (!\u26032.isEmpty()) {
                    stringBuilder.append((Object)TextFormatting.RESET);
                }
                stringBuilder.append(\u26035);
                \u26032 = \u26035;
            }
            stringBuilder.append(\u26034);
        }
        if (!\u26032.isEmpty()) {
            stringBuilder.append((Object)TextFormatting.RESET);
        }
        return stringBuilder.toString();
    }

    public List<ITextComponent> func_150253_a();

    public Stream<ITextComponent> func_212640_c();

    default public Stream<ITextComponent> func_212637_f() {
        return this.func_212640_c().map(ITextComponent::func_212639_b);
    }

    @Override
    default public Iterator<ITextComponent> iterator() {
        return this.func_212637_f().iterator();
    }

    public ITextComponent func_150259_f();

    default public ITextComponent func_212638_h() {
        ITextComponent iTextComponent = this.func_150259_f();
        iTextComponent.func_150255_a(this.func_150256_b().func_150232_l());
        for (ITextComponent iTextComponent2 : this.func_150253_a()) {
            iTextComponent.func_150257_a(iTextComponent2.func_212638_h());
        }
        return iTextComponent;
    }

    default public ITextComponent func_211710_a(Consumer<Style> consumer) {
        consumer.accept(this.func_150256_b());
        return this;
    }

    default public ITextComponent func_211709_a(TextFormatting ... textFormattingArray) {
        for (TextFormatting textFormatting : textFormattingArray) {
            this.func_211708_a(textFormatting);
        }
        return this;
    }

    default public ITextComponent func_211708_a(TextFormatting textFormatting) {
        Style style = this.func_150256_b();
        if (textFormatting.func_96302_c()) {
            style.func_150238_a(textFormatting);
        }
        if (textFormatting.func_96301_b()) {
            switch (textFormatting) {
                case OBFUSCATED: {
                    style.func_150237_e(true);
                    break;
                }
                case BOLD: {
                    style.func_150227_a(true);
                    break;
                }
                case STRIKETHROUGH: {
                    style.func_150225_c(true);
                    break;
                }
                case UNDERLINE: {
                    style.func_150228_d(true);
                    break;
                }
                case ITALIC: {
                    style.func_150217_b(true);
                    break;
                }
            }
        }
        return this;
    }

    public static ITextComponent func_212639_b(ITextComponent iTextComponent) {
        \u2603 = iTextComponent.func_150259_f();
        \u2603.func_150255_a(iTextComponent.func_150256_b().func_150206_m());
        return \u2603;
    }

    public static class Serializer
    implements JsonDeserializer<ITextComponent>,
    JsonSerializer<ITextComponent> {
        private static final Gson field_150700_a = Util.func_199748_a(() -> {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.disableHtmlEscaping();
            gsonBuilder.registerTypeHierarchyAdapter(ITextComponent.class, (Object)new Serializer());
            gsonBuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
            gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory());
            return gsonBuilder.create();
        });
        private static final Field field_197674_b = Util.func_199748_a(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("pos");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", noSuchFieldException);
            }
        });
        private static final Field field_200530_c = Util.func_199748_a(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("lineStart");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", noSuchFieldException);
            }
        });

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ITextComponent deserialize(JsonElement jsonElement2, Type type, JsonDeserializationContext jsonDeserializationContext2) throws JsonParseException {
            void var5_18;
            JsonElement jsonElement2;
            if (jsonElement2.isJsonPrimitive()) {
                return new StringTextComponent(jsonElement2.getAsString());
            }
            if (jsonElement2.isJsonObject()) {
                JsonDeserializationContext jsonDeserializationContext2;
                void var5_16;
                String string;
                JsonObject jsonObject = jsonElement2.getAsJsonObject();
                if (jsonObject.has("text")) {
                    StringTextComponent stringTextComponent = new StringTextComponent(JSONUtils.func_151200_h(jsonObject, "text"));
                } else if (jsonObject.has("translate")) {
                    string = JSONUtils.func_151200_h(jsonObject, "translate");
                    if (jsonObject.has("with")) {
                        JsonArray jsonArray = JSONUtils.func_151214_t(jsonObject, "with");
                        Object[] \u26032 = new Object[jsonArray.size()];
                        for (int i = 0; i < \u26032.length; ++i) {
                            \u26032[i] = this.deserialize(jsonArray.get(i), type, jsonDeserializationContext2);
                            if (!(\u26032[i] instanceof StringTextComponent) || !(\u2603 = (StringTextComponent)\u26032[i]).func_150256_b().func_150229_g() || !\u2603.func_150253_a().isEmpty()) continue;
                            \u26032[i] = \u2603.func_150265_g();
                        }
                        TranslationTextComponent translationTextComponent = new TranslationTextComponent(string, \u26032);
                    } else {
                        TranslationTextComponent translationTextComponent = new TranslationTextComponent(string, new Object[0]);
                    }
                } else if (jsonObject.has("score")) {
                    string = JSONUtils.func_152754_s(jsonObject, "score");
                    if (!string.has("name") || !string.has("objective")) throw new JsonParseException("A score component needs a least a name and an objective");
                    ScoreTextComponent scoreTextComponent = new ScoreTextComponent(JSONUtils.func_151200_h((JsonObject)string, "name"), JSONUtils.func_151200_h((JsonObject)string, "objective"));
                    if (string.has("value")) {
                        scoreTextComponent.func_179997_b(JSONUtils.func_151200_h((JsonObject)string, "value"));
                    }
                } else if (jsonObject.has("selector")) {
                    SelectorTextComponent selectorTextComponent = new SelectorTextComponent(JSONUtils.func_151200_h(jsonObject, "selector"));
                } else if (jsonObject.has("keybind")) {
                    KeybindTextComponent keybindTextComponent = new KeybindTextComponent(JSONUtils.func_151200_h(jsonObject, "keybind"));
                } else {
                    if (!jsonObject.has("nbt")) throw new JsonParseException("Don't know how to turn " + jsonElement2 + " into a Component");
                    string = JSONUtils.func_151200_h(jsonObject, "nbt");
                    boolean \u26033 = JSONUtils.func_151209_a(jsonObject, "interpret", false);
                    if (jsonObject.has("block")) {
                        NBTTextComponent.Block block = new NBTTextComponent.Block(string, \u26033, JSONUtils.func_151200_h(jsonObject, "block"));
                    } else {
                        if (!jsonObject.has("entity")) throw new JsonParseException("Don't know how to turn " + jsonElement2 + " into a Component");
                        NBTTextComponent.Entity entity = new NBTTextComponent.Entity(string, \u26033, JSONUtils.func_151200_h(jsonObject, "entity"));
                    }
                }
                if (jsonObject.has("extra")) {
                    string = JSONUtils.func_151214_t(jsonObject, "extra");
                    if (string.size() <= 0) throw new JsonParseException("Unexpected empty array of components");
                    for (int i = 0; i < string.size(); ++i) {
                        var5_16.func_150257_a(this.deserialize(string.get(i), type, jsonDeserializationContext2));
                    }
                }
                var5_16.func_150255_a((Style)jsonDeserializationContext2.deserialize(jsonElement2, Style.class));
                return var5_16;
            }
            if (!jsonElement2.isJsonArray()) throw new JsonParseException("Don't know how to turn " + jsonElement2 + " into a Component");
            JsonArray \u26034 = jsonElement2.getAsJsonArray();
            Object var5_17 = null;
            for (JsonElement jsonElement3 : \u26034) {
                ITextComponent iTextComponent = this.deserialize(jsonElement3, jsonElement3.getClass(), jsonDeserializationContext2);
                if (var5_18 == null) {
                    ITextComponent iTextComponent2 = iTextComponent;
                    continue;
                }
                var5_18.func_150257_a(iTextComponent);
            }
            return var5_18;
        }

        private void func_150695_a(Style style, JsonObject jsonObject, JsonSerializationContext jsonSerializationContext) {
            JsonElement jsonElement = jsonSerializationContext.serialize((Object)style);
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject2 = (JsonObject)jsonElement;
                for (Map.Entry entry : jsonObject2.entrySet()) {
                    jsonObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public JsonElement serialize(ITextComponent iTextComponent2, Type type, JsonSerializationContext jsonSerializationContext) {
            ITextComponent iTextComponent2;
            Object \u26032;
            JsonObject jsonObject = new JsonObject();
            if (!iTextComponent2.func_150256_b().func_150229_g()) {
                this.func_150695_a(iTextComponent2.func_150256_b(), jsonObject, jsonSerializationContext);
            }
            if (!iTextComponent2.func_150253_a().isEmpty()) {
                \u26032 = new JsonArray();
                for (ITextComponent iTextComponent3 : iTextComponent2.func_150253_a()) {
                    \u26032.add(this.serialize(iTextComponent3, iTextComponent3.getClass(), jsonSerializationContext));
                }
                jsonObject.add("extra", (JsonElement)\u26032);
            }
            if (iTextComponent2 instanceof StringTextComponent) {
                jsonObject.addProperty("text", ((StringTextComponent)iTextComponent2).func_150265_g());
                return jsonObject;
            } else if (iTextComponent2 instanceof TranslationTextComponent) {
                \u26032 = (TranslationTextComponent)iTextComponent2;
                jsonObject.addProperty("translate", ((TranslationTextComponent)\u26032).func_150268_i());
                if (((TranslationTextComponent)\u26032).func_150271_j() == null || ((TranslationTextComponent)\u26032).func_150271_j().length <= 0) return jsonObject;
                \u26033 = new JsonArray();
                for (Object object : ((TranslationTextComponent)\u26032).func_150271_j()) {
                    if (object instanceof ITextComponent) {
                        \u26033.add(this.serialize((ITextComponent)object, object.getClass(), jsonSerializationContext));
                        continue;
                    }
                    \u26033.add((JsonElement)new JsonPrimitive(String.valueOf(object)));
                }
                jsonObject.add("with", (JsonElement)\u26033);
                return jsonObject;
            } else if (iTextComponent2 instanceof ScoreTextComponent) {
                \u26032 = (ScoreTextComponent)iTextComponent2;
                \u26033 = new JsonObject();
                \u26033.addProperty("name", ((ScoreTextComponent)\u26032).func_179995_g());
                \u26033.addProperty("objective", ((ScoreTextComponent)\u26032).func_179994_h());
                \u26033.addProperty("value", ((ScoreTextComponent)\u26032).func_150261_e());
                jsonObject.add("score", (JsonElement)\u26033);
                return jsonObject;
            } else if (iTextComponent2 instanceof SelectorTextComponent) {
                \u26032 = (SelectorTextComponent)iTextComponent2;
                jsonObject.addProperty("selector", ((SelectorTextComponent)\u26032).func_179992_g());
                return jsonObject;
            } else if (iTextComponent2 instanceof KeybindTextComponent) {
                \u26032 = (KeybindTextComponent)iTextComponent2;
                jsonObject.addProperty("keybind", ((KeybindTextComponent)\u26032).func_193633_h());
                return jsonObject;
            } else {
                Object \u26033;
                if (!(iTextComponent2 instanceof NBTTextComponent)) throw new IllegalArgumentException("Don't know how to serialize " + iTextComponent2 + " as a Component");
                \u26032 = (NBTTextComponent)iTextComponent2;
                jsonObject.addProperty("nbt", ((NBTTextComponent)\u26032).func_218676_i());
                jsonObject.addProperty("interpret", Boolean.valueOf(((NBTTextComponent)\u26032).func_218677_j()));
                if (iTextComponent2 instanceof NBTTextComponent.Block) {
                    \u26033 = (NBTTextComponent.Block)iTextComponent2;
                    jsonObject.addProperty("block", ((NBTTextComponent.Block)\u26033).func_218683_k());
                    return jsonObject;
                } else {
                    if (!(iTextComponent2 instanceof NBTTextComponent.Entity)) throw new IllegalArgumentException("Don't know how to serialize " + iTextComponent2 + " as a Component");
                    \u26033 = (NBTTextComponent.Entity)iTextComponent2;
                    jsonObject.addProperty("entity", ((NBTTextComponent.Entity)\u26033).func_218687_k());
                }
            }
            return jsonObject;
        }

        public static String func_150696_a(ITextComponent iTextComponent) {
            return field_150700_a.toJson((Object)iTextComponent);
        }

        public static JsonElement func_200528_b(ITextComponent iTextComponent) {
            return field_150700_a.toJsonTree((Object)iTextComponent);
        }

        @Nullable
        public static ITextComponent func_150699_a(String string) {
            return JSONUtils.func_188176_a(field_150700_a, string, ITextComponent.class, false);
        }

        @Nullable
        public static ITextComponent func_197672_a(JsonElement jsonElement) {
            return (ITextComponent)field_150700_a.fromJson(jsonElement, ITextComponent.class);
        }

        @Nullable
        public static ITextComponent func_186877_b(String string) {
            return JSONUtils.func_188176_a(field_150700_a, string, ITextComponent.class, true);
        }

        public static ITextComponent func_197671_a(com.mojang.brigadier.StringReader stringReader) {
            try {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(stringReader.getRemaining()));
                jsonReader.setLenient(false);
                ITextComponent \u26032 = (ITextComponent)field_150700_a.getAdapter(ITextComponent.class).read(jsonReader);
                stringReader.setCursor(stringReader.getCursor() + Serializer.func_197673_a(jsonReader));
                return \u26032;
            }
            catch (IOException iOException) {
                throw new JsonParseException((Throwable)iOException);
            }
        }

        private static int func_197673_a(JsonReader jsonReader) {
            try {
                return field_197674_b.getInt(jsonReader) - field_200530_c.getInt(jsonReader) + 1;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("Couldn't read position of JsonReader", illegalAccessException);
            }
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((ITextComponent)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

