/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FillLayerConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.PhantomSpawner;

public class FlatChunkGenerator
extends ChunkGenerator<FlatGenerationSettings> {
    private final Biome field_202103_f;
    private final PhantomSpawner field_203229_i = new PhantomSpawner();
    private final CatSpawner field_222544_g = new CatSpawner();

    public FlatChunkGenerator(IWorld iWorld, BiomeProvider biomeProvider, FlatGenerationSettings flatGenerationSettings) {
        super(iWorld, biomeProvider, flatGenerationSettings);
        this.field_202103_f = this.func_202099_e();
    }

    /*
     * WARNING - void declaration
     */
    private Biome func_202099_e() {
        void var6_14;
        boolean bl;
        Biome biome = ((FlatGenerationSettings)this.field_222543_d).func_82648_a();
        WrapperBiome \u26032 = new WrapperBiome(biome.func_205401_q(), biome.func_201851_b(), biome.func_201856_r(), biome.func_185355_j(), biome.func_185360_m(), biome.func_185353_n(), biome.func_76727_i(), biome.func_185361_o(), biome.func_204274_p(), biome.func_205402_s());
        Map<String, Map<String, String>> \u26033 = ((FlatGenerationSettings)this.field_222543_d).func_82644_b();
        for (String string : \u26033.keySet()) {
            ConfiguredFeature<?>[] configuredFeatureArray = FlatGenerationSettings.field_202247_j.get(string);
            if (configuredFeatureArray == null) continue;
            ConfiguredFeature<?>[] configuredFeatureArray2 = configuredFeatureArray;
            int n = configuredFeatureArray2.length;
            for (int i = 0; i < n; ++i) {
                Structure structure;
                ConfiguredFeature<?> configuredFeature = configuredFeatureArray2[i];
                \u26032.func_203611_a(FlatGenerationSettings.field_202248_k.get(configuredFeature), configuredFeature);
                ConfiguredFeature<?> configuredFeature2 = ((DecoratedFeatureConfig)configuredFeature.field_222738_b).field_214689_a;
                if (!(configuredFeature2.field_222737_a instanceof Structure)) continue;
                Object \u26034 = biome.func_201857_b(structure = (Structure)configuredFeature2.field_222737_a);
                \u26032.func_201865_a(structure, \u26034 != null ? \u26034 : FlatGenerationSettings.field_202249_l.get(configuredFeature));
            }
        }
        boolean bl2 = bl = (!((FlatGenerationSettings)this.field_222543_d).func_202238_o() || biome == Biomes.field_185440_P) && \u26033.containsKey("decoration");
        if (bl) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(GenerationStage.Decoration.UNDERGROUND_STRUCTURES);
            arrayList.add(GenerationStage.Decoration.SURFACE_STRUCTURES);
            for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
                if (arrayList.contains((Object)decoration)) continue;
                for (ConfiguredFeature<?> configuredFeature : biome.func_203607_a(decoration)) {
                    \u26032.func_203611_a(decoration, configuredFeature);
                }
            }
        }
        BlockState[] blockStateArray = ((FlatGenerationSettings)this.field_222543_d).func_202233_q();
        boolean bl3 = false;
        while (var6_14 < blockStateArray.length) {
            BlockState blockState = blockStateArray[var6_14];
            if (blockState != null && !Heightmap.Type.MOTION_BLOCKING.func_222684_d().test(blockState)) {
                ((FlatGenerationSettings)this.field_222543_d).func_214990_a((int)var6_14);
                \u26032.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, Biome.func_222280_a(Feature.field_214486_aN, new FillLayerConfig((int)var6_14, blockState), Placement.field_215022_h, IPlacementConfig.field_202468_e));
            }
            ++var6_14;
        }
        return \u26032;
    }

    @Override
    public void func_222535_c(IChunk iChunk) {
    }

    @Override
    public int func_205470_d() {
        IChunk iChunk = this.field_222540_a.func_212866_a_(0, 0);
        return iChunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 8, 8);
    }

    @Override
    protected Biome func_222534_b(IChunk iChunk) {
        return this.field_202103_f;
    }

    @Override
    protected Biome func_222527_a(WorldGenRegion worldGenRegion, BlockPos blockPos) {
        return this.field_202103_f;
    }

    @Override
    public void func_222537_b(IWorld iWorld, IChunk iChunk) {
        BlockState[] blockStateArray = ((FlatGenerationSettings)this.field_222543_d).func_202233_q();
        BlockPos.MutableBlockPos \u26032 = new BlockPos.MutableBlockPos();
        Heightmap \u26033 = iChunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap \u26034 = iChunk.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        for (int i = 0; i < blockStateArray.length; ++i) {
            BlockState blockState = blockStateArray[i];
            if (blockState == null) continue;
            for (int j = 0; j < 16; ++j) {
                for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                    iChunk.func_177436_a(\u26032.func_181079_c(j, i, \u2603), blockState, false);
                    \u26033.func_202270_a(j, i, \u2603, blockState);
                    \u26034.func_202270_a(j, i, \u2603, blockState);
                }
            }
        }
    }

    @Override
    public int func_222529_a(int n, int n2, Heightmap.Type type) {
        BlockState[] blockStateArray = ((FlatGenerationSettings)this.field_222543_d).func_202233_q();
        for (int i = blockStateArray.length - 1; i >= 0; --i) {
            BlockState blockState = blockStateArray[i];
            if (blockState == null || !type.func_222684_d().test(blockState)) continue;
            return i + 1;
        }
        return 0;
    }

    @Override
    public void func_203222_a(ServerWorld serverWorld, boolean bl, boolean bl2) {
        this.field_203229_i.func_203232_a(serverWorld, bl, bl2);
        this.field_222544_g.func_221124_a(serverWorld, bl, bl2);
    }

    @Override
    public boolean func_202094_a(Biome biome, Structure<? extends IFeatureConfig> structure) {
        return this.field_202103_f.func_201858_a(structure);
    }

    @Override
    @Nullable
    public <C extends IFeatureConfig> C func_202087_b(Biome biome, Structure<C> structure) {
        return this.field_202103_f.func_201857_b(structure);
    }

    @Override
    @Nullable
    public BlockPos func_211403_a(World world, String string, BlockPos blockPos, int n, boolean bl) {
        if (!((FlatGenerationSettings)this.field_222543_d).func_82644_b().keySet().contains(string.toLowerCase(Locale.ROOT))) {
            return null;
        }
        return super.func_211403_a(world, string, blockPos, n, bl);
    }

    class WrapperBiome
    extends Biome {
        protected WrapperBiome(ConfiguredSurfaceBuilder<?> configuredSurfaceBuilder, Biome.RainType rainType, Biome.Category category, float f, float f2, float f3, float f4, int n, int n2, @Nullable String string) {
            super(new Biome.Builder().func_205416_a(configuredSurfaceBuilder).func_205415_a(rainType).func_205419_a(category).func_205421_a(f).func_205420_b(f2).func_205414_c(f3).func_205417_d(f4).func_205412_a(n).func_205413_b(n2).func_205418_a(string));
        }
    }
}

