/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LakesConfig;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import net.minecraft.world.gen.feature.structure.PillagerOutpostConfig;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.LakeChanceConfig;
import net.minecraft.world.gen.placement.Placement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlatGenerationSettings
extends GenerationSettings {
    private static final Logger field_211404_q = LogManager.getLogger();
    private static final ConfiguredFeature<?> field_202250_m = Biome.func_222280_a(Feature.field_202329_g, new MineshaftConfig(0.004, MineshaftStructure.Type.NORMAL), Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_202251_n = Biome.func_222280_a(Feature.field_214550_p, new VillageConfig("village/plains/town_centers", 6), Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_202252_o = Biome.func_222280_a(Feature.field_202335_m, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_202253_p = Biome.func_222280_a(Feature.field_202334_l, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_202254_q = Biome.func_222280_a(Feature.field_202332_j, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_202255_r = Biome.func_222280_a(Feature.field_202331_i, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_202256_s = Biome.func_222280_a(Feature.field_202333_k, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_204750_v = Biome.func_222280_a(Feature.field_204751_l, new ShipwreckConfig(false), Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_202257_t = Biome.func_222280_a(Feature.field_202336_n, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_202258_u = Biome.func_222280_a(Feature.field_202289_ai, new LakesConfig(Blocks.field_150355_j.func_176223_P()), Placement.field_215006_E, new LakeChanceConfig(4));
    private static final ConfiguredFeature<?> field_202259_v = Biome.func_222280_a(Feature.field_202289_ai, new LakesConfig(Blocks.field_150353_l.func_176223_P()), Placement.field_215005_D, new LakeChanceConfig(80));
    private static final ConfiguredFeature<?> field_202260_w = Biome.func_222280_a(Feature.field_204292_r, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_202261_x = Biome.func_222280_a(Feature.field_202330_h, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_202262_y = Biome.func_222280_a(Feature.field_202337_o, IFeatureConfig.field_202429_e, Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_204028_A = Biome.func_222280_a(Feature.field_204029_o, new OceanRuinConfig(OceanRuinStructure.Type.COLD, 0.3f, 0.1f), Placement.field_215022_h, IPlacementConfig.field_202468_e);
    private static final ConfiguredFeature<?> field_214991_M = Biome.func_222280_a(Feature.field_214536_b, new PillagerOutpostConfig(0.004), Placement.field_215022_h, IPlacementConfig.field_202468_e);
    public static final Map<ConfiguredFeature<?>, GenerationStage.Decoration> field_202248_k = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put(field_202250_m, GenerationStage.Decoration.UNDERGROUND_STRUCTURES);
        hashMap.put(field_202251_n, GenerationStage.Decoration.SURFACE_STRUCTURES);
        hashMap.put(field_202252_o, GenerationStage.Decoration.UNDERGROUND_STRUCTURES);
        hashMap.put(field_202253_p, GenerationStage.Decoration.SURFACE_STRUCTURES);
        hashMap.put(field_202254_q, GenerationStage.Decoration.SURFACE_STRUCTURES);
        hashMap.put(field_202255_r, GenerationStage.Decoration.SURFACE_STRUCTURES);
        hashMap.put(field_202256_s, GenerationStage.Decoration.SURFACE_STRUCTURES);
        hashMap.put(field_204750_v, GenerationStage.Decoration.SURFACE_STRUCTURES);
        hashMap.put(field_204028_A, GenerationStage.Decoration.SURFACE_STRUCTURES);
        hashMap.put(field_202258_u, GenerationStage.Decoration.LOCAL_MODIFICATIONS);
        hashMap.put(field_202259_v, GenerationStage.Decoration.LOCAL_MODIFICATIONS);
        hashMap.put(field_202260_w, GenerationStage.Decoration.SURFACE_STRUCTURES);
        hashMap.put(field_202261_x, GenerationStage.Decoration.SURFACE_STRUCTURES);
        hashMap.put(field_202262_y, GenerationStage.Decoration.UNDERGROUND_STRUCTURES);
        hashMap.put(field_202257_t, GenerationStage.Decoration.SURFACE_STRUCTURES);
        hashMap.put(field_214991_M, GenerationStage.Decoration.SURFACE_STRUCTURES);
    });
    public static final Map<String, ConfiguredFeature<?>[]> field_202247_j = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put("mineshaft", new ConfiguredFeature[]{field_202250_m});
        hashMap.put("village", new ConfiguredFeature[]{field_202251_n});
        hashMap.put("stronghold", new ConfiguredFeature[]{field_202252_o});
        hashMap.put("biome_1", new ConfiguredFeature[]{field_202253_p, field_202254_q, field_202255_r, field_202256_s, field_204028_A, field_204750_v});
        hashMap.put("oceanmonument", new ConfiguredFeature[]{field_202257_t});
        hashMap.put("lake", new ConfiguredFeature[]{field_202258_u});
        hashMap.put("lava_lake", new ConfiguredFeature[]{field_202259_v});
        hashMap.put("endcity", new ConfiguredFeature[]{field_202260_w});
        hashMap.put("mansion", new ConfiguredFeature[]{field_202261_x});
        hashMap.put("fortress", new ConfiguredFeature[]{field_202262_y});
        hashMap.put("pillager_outpost", new ConfiguredFeature[]{field_214991_M});
    });
    public static final Map<ConfiguredFeature<?>, IFeatureConfig> field_202249_l = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put(field_202250_m, new MineshaftConfig(0.004, MineshaftStructure.Type.NORMAL));
        hashMap.put(field_202251_n, new VillageConfig("village/plains/town_centers", 6));
        hashMap.put(field_202252_o, IFeatureConfig.field_202429_e);
        hashMap.put(field_202253_p, IFeatureConfig.field_202429_e);
        hashMap.put(field_202254_q, IFeatureConfig.field_202429_e);
        hashMap.put(field_202255_r, IFeatureConfig.field_202429_e);
        hashMap.put(field_202256_s, IFeatureConfig.field_202429_e);
        hashMap.put(field_204028_A, new OceanRuinConfig(OceanRuinStructure.Type.COLD, 0.3f, 0.9f));
        hashMap.put(field_204750_v, new ShipwreckConfig(false));
        hashMap.put(field_202257_t, IFeatureConfig.field_202429_e);
        hashMap.put(field_202260_w, IFeatureConfig.field_202429_e);
        hashMap.put(field_202261_x, IFeatureConfig.field_202429_e);
        hashMap.put(field_202262_y, IFeatureConfig.field_202429_e);
        hashMap.put(field_214991_M, new PillagerOutpostConfig(0.004));
    });
    private final List<FlatLayerInfo> field_82655_a = Lists.newArrayList();
    private final Map<String, Map<String, String>> field_82653_b = Maps.newHashMap();
    private Biome field_82654_c;
    private final BlockState[] field_202244_C = new BlockState[256];
    private boolean field_202245_D;
    private int field_202246_E;

    @Nullable
    public static Block func_212683_a(String string) {
        try {
            ResourceLocation resourceLocation = new ResourceLocation(string);
            return Registry.field_212618_g.func_218349_b(resourceLocation).orElse(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            field_211404_q.warn("Invalid blockstate: {}", (Object)string, (Object)illegalArgumentException);
            return null;
        }
    }

    public Biome func_82648_a() {
        return this.field_82654_c;
    }

    public void func_82647_a(Biome biome) {
        this.field_82654_c = biome;
    }

    public Map<String, Map<String, String>> func_82644_b() {
        return this.field_82653_b;
    }

    public List<FlatLayerInfo> func_82650_c() {
        return this.field_82655_a;
    }

    public void func_82645_d() {
        int \u26032 = 0;
        for (FlatLayerInfo flatLayerInfo2 : this.field_82655_a) {
            flatLayerInfo2.func_82660_d(\u26032);
            \u26032 += flatLayerInfo2.func_82657_a();
        }
        this.field_202246_E = 0;
        this.field_202245_D = true;
        \u26032 = 0;
        for (FlatLayerInfo flatLayerInfo2 : this.field_82655_a) {
            FlatLayerInfo flatLayerInfo2;
            for (int i = flatLayerInfo2.func_82656_d(); i < flatLayerInfo2.func_82656_d() + flatLayerInfo2.func_82657_a(); ++i) {
                BlockState blockState = flatLayerInfo2.func_175900_c();
                if (blockState.func_177230_c() == Blocks.field_150350_a) continue;
                this.field_202245_D = false;
                this.field_202244_C[i] = blockState;
            }
            if (flatLayerInfo2.func_175900_c().func_177230_c() == Blocks.field_150350_a) {
                \u26032 += flatLayerInfo2.func_82657_a();
                continue;
            }
            this.field_202246_E += flatLayerInfo2.func_82657_a() + \u26032;
            \u26032 = 0;
        }
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < this.field_82655_a.size(); ++n) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.field_82655_a.get(n));
        }
        stringBuilder.append(";");
        stringBuilder.append(Registry.field_212624_m.func_177774_c(this.field_82654_c));
        stringBuilder.append(";");
        if (!this.field_82653_b.isEmpty()) {
            n = 0;
            for (Map.Entry<String, Map<String, String>> entry : this.field_82653_b.entrySet()) {
                if (n++ > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(entry.getKey().toLowerCase(Locale.ROOT));
                Map<String, String> map = entry.getValue();
                if (map.isEmpty()) continue;
                stringBuilder.append("(");
                int \u26032 = 0;
                for (Map.Entry<String, String> entry2 : map.entrySet()) {
                    if (\u26032++ > 0) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(entry2.getKey());
                    stringBuilder.append("=");
                    stringBuilder.append(entry2.getValue());
                }
                stringBuilder.append(")");
            }
        }
        return stringBuilder.toString();
    }

    @Nullable
    private static FlatLayerInfo func_197526_a(String string, int n2) {
        int n2;
        int n3;
        String[] stringArray = string.split("\\*", 2);
        if (stringArray.length == 2) {
            try {
                n3 = Math.max(Integer.parseInt(stringArray[0]), 0);
            }
            catch (NumberFormatException numberFormatException) {
                field_211404_q.error("Error while parsing flat world string => {}", (Object)numberFormatException.getMessage());
                return null;
            }
        } else {
            n3 = 1;
        }
        \u2603 = Math.min(n2 + n3, 256);
        \u2603 = \u2603 - n2;
        try {
            Block block = FlatGenerationSettings.func_212683_a(stringArray[stringArray.length - 1]);
        }
        catch (Exception exception) {
            field_211404_q.error("Error while parsing flat world string => {}", (Object)exception.getMessage());
            return null;
        }
        if (block == null) {
            field_211404_q.error("Error while parsing flat world string => Unknown block, {}", (Object)stringArray[stringArray.length - 1]);
            return null;
        }
        FlatLayerInfo flatLayerInfo = new FlatLayerInfo(\u2603, block);
        flatLayerInfo.func_82660_d(n2);
        return flatLayerInfo;
    }

    private static List<FlatLayerInfo> func_197527_b(String string) {
        ArrayList arrayList = Lists.newArrayList();
        String[] \u26032 = string.split(",");
        int \u26033 = 0;
        for (String string2 : \u26032) {
            FlatLayerInfo flatLayerInfo = FlatGenerationSettings.func_197526_a(string2, \u26033);
            if (flatLayerInfo == null) {
                return Collections.emptyList();
            }
            arrayList.add(flatLayerInfo);
            \u26033 += flatLayerInfo.func_82657_a();
        }
        return arrayList;
    }

    public <T> Dynamic<T> func_210834_a(DynamicOps<T> dynamicOps) {
        Object object = dynamicOps.createList(this.field_82655_a.stream().map(flatLayerInfo -> dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("height"), (Object)dynamicOps.createInt(flatLayerInfo.func_82657_a()), (Object)dynamicOps.createString("block"), (Object)dynamicOps.createString(Registry.field_212618_g.func_177774_c(flatLayerInfo.func_175900_c().func_177230_c()).toString())))));
        \u2603 = dynamicOps.createMap(this.field_82653_b.entrySet().stream().map(entry2 -> Pair.of((Object)dynamicOps.createString(((String)entry2.getKey()).toLowerCase(Locale.ROOT)), (Object)dynamicOps.createMap(((Map)entry2.getValue()).entrySet().stream().map(entry -> Pair.of((Object)dynamicOps.createString((String)entry.getKey()), (Object)dynamicOps.createString((String)entry.getValue()))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond))))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        return new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("layers"), (Object)object, (Object)dynamicOps.createString("biome"), (Object)dynamicOps.createString(Registry.field_212624_m.func_177774_c(this.field_82654_c).toString()), (Object)dynamicOps.createString("structures"), (Object)\u2603)));
    }

    public static FlatGenerationSettings func_210835_a(Dynamic<?> dynamic2) {
        FlatGenerationSettings flatGenerationSettings = ChunkGeneratorType.field_205489_f.func_205483_a();
        List \u26032 = dynamic2.get("layers").asList(dynamic -> Pair.of((Object)dynamic.get("height").asInt(1), (Object)FlatGenerationSettings.func_212683_a(dynamic.get("block").asString(""))));
        if (\u26032.stream().anyMatch(pair -> pair.getSecond() == null)) {
            return FlatGenerationSettings.func_82649_e();
        }
        List \u26033 = \u26032.stream().map(pair -> new FlatLayerInfo((Integer)pair.getFirst(), (Block)pair.getSecond())).collect(Collectors.toList());
        if (\u26033.isEmpty()) {
            return FlatGenerationSettings.func_82649_e();
        }
        flatGenerationSettings.func_82650_c().addAll(\u26033);
        flatGenerationSettings.func_82645_d();
        flatGenerationSettings.func_82647_a(Registry.field_212624_m.func_82594_a(new ResourceLocation(dynamic2.get("biome").asString(""))));
        dynamic2.get("structures").flatMap(Dynamic::getMapValues).ifPresent(map -> map.keySet().forEach(dynamic -> dynamic.asString().map(string -> flatGenerationSettings.func_82644_b().put((String)string, Maps.newHashMap()))));
        return flatGenerationSettings;
    }

    public static FlatGenerationSettings func_82651_a(String string) {
        Iterator iterator = Splitter.on((char)';').split((CharSequence)string).iterator();
        if (!iterator.hasNext()) {
            return FlatGenerationSettings.func_82649_e();
        }
        FlatGenerationSettings \u26032 = ChunkGeneratorType.field_205489_f.func_205483_a();
        List<FlatLayerInfo> \u26033 = FlatGenerationSettings.func_197527_b((String)iterator.next());
        if (\u26033.isEmpty()) {
            return FlatGenerationSettings.func_82649_e();
        }
        \u26032.func_82650_c().addAll(\u26033);
        \u26032.func_82645_d();
        Biome \u26034 = iterator.hasNext() ? Registry.field_212624_m.func_82594_a(new ResourceLocation((String)iterator.next())) : null;
        \u26032.func_82647_a(\u26034 == null ? Biomes.field_76772_c : \u26034);
        if (iterator.hasNext()) {
            for (String string2 : \u2603 = ((String)iterator.next()).toLowerCase(Locale.ROOT).split(",")) {
                String[] stringArray = string2.split("\\(", 2);
                if (stringArray[0].isEmpty()) continue;
                \u26032.func_202234_c(stringArray[0]);
                if (stringArray.length <= 1 || !stringArray[1].endsWith(")") || stringArray[1].length() <= 1) continue;
                for (String string3 : \u2603 = stringArray[1].substring(0, stringArray[1].length() - 1).split(" ")) {
                    String[] stringArray2 = string3.split("=", 2);
                    if (stringArray2.length != 2) continue;
                    \u26032.func_202229_a(stringArray[0], stringArray2[0], stringArray2[1]);
                }
            }
        } else {
            \u26032.func_82644_b().put("village", Maps.newHashMap());
        }
        return \u26032;
    }

    private void func_202234_c(String string) {
        HashMap hashMap = Maps.newHashMap();
        this.field_82653_b.put(string, hashMap);
    }

    private void func_202229_a(String string, String string2, String string3) {
        this.field_82653_b.get(string).put(string2, string3);
        if ("village".equals(string) && "distance".equals(string2)) {
            this.field_214971_a = MathHelper.func_82714_a(string3, this.field_214971_a, 9);
        }
        if ("biome_1".equals(string) && "distance".equals(string2)) {
            this.field_214978_h = MathHelper.func_82714_a(string3, this.field_214978_h, 9);
        }
        if ("stronghold".equals(string)) {
            if ("distance".equals(string2)) {
                this.field_214975_e = MathHelper.func_82714_a(string3, this.field_214975_e, 1);
            } else if ("count".equals(string2)) {
                this.field_214976_f = MathHelper.func_82714_a(string3, this.field_214976_f, 1);
            } else if ("spread".equals(string2)) {
                this.field_214977_g = MathHelper.func_82714_a(string3, this.field_214977_g, 1);
            }
        }
        if ("oceanmonument".equals(string)) {
            if ("separation".equals(string2)) {
                this.field_214974_d = MathHelper.func_82714_a(string3, this.field_214974_d, 1);
            } else if ("spacing".equals(string2)) {
                this.field_214973_c = MathHelper.func_82714_a(string3, this.field_214973_c, 1);
            }
        }
        if ("endcity".equals(string) && "distance".equals(string2)) {
            this.field_214982_l = MathHelper.func_82714_a(string3, this.field_214982_l, 1);
        }
        if ("mansion".equals(string) && "distance".equals(string2)) {
            this.field_214986_p = MathHelper.func_82714_a(string3, this.field_214986_p, 1);
        }
    }

    public static FlatGenerationSettings func_82649_e() {
        FlatGenerationSettings flatGenerationSettings = ChunkGeneratorType.field_205489_f.func_205483_a();
        flatGenerationSettings.func_82647_a(Biomes.field_76772_c);
        flatGenerationSettings.func_82650_c().add(new FlatLayerInfo(1, Blocks.field_150357_h));
        flatGenerationSettings.func_82650_c().add(new FlatLayerInfo(2, Blocks.field_150346_d));
        flatGenerationSettings.func_82650_c().add(new FlatLayerInfo(1, Blocks.field_196658_i));
        flatGenerationSettings.func_82645_d();
        flatGenerationSettings.func_82644_b().put("village", Maps.newHashMap());
        return flatGenerationSettings;
    }

    public boolean func_202238_o() {
        return this.field_202245_D;
    }

    public BlockState[] func_202233_q() {
        return this.field_202244_C;
    }

    public void func_214990_a(int n) {
        this.field_202244_C[n] = null;
    }
}

