/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StrongholdPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class StrongholdStructure
extends Structure<NoFeatureConfig> {
    private boolean field_75056_f;
    private ChunkPos[] field_75057_g;
    private final List<StructureStart> field_214561_aT = Lists.newArrayList();
    private long field_202387_av;

    public StrongholdStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> function) {
        super(function);
    }

    @Override
    public boolean func_202372_a(ChunkGenerator<?> chunkGenerator, Random random, int n, int n2) {
        if (this.field_202387_av != chunkGenerator.func_202089_c()) {
            this.func_202386_c();
        }
        if (!this.field_75056_f) {
            this.func_202385_a(chunkGenerator);
            this.field_75056_f = true;
        }
        for (ChunkPos chunkPos : this.field_75057_g) {
            if (n != chunkPos.field_77276_a || n2 != chunkPos.field_77275_b) continue;
            return true;
        }
        return false;
    }

    private void func_202386_c() {
        this.field_75056_f = false;
        this.field_75057_g = null;
        this.field_214561_aT.clear();
    }

    @Override
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Override
    public String func_143025_a() {
        return "Stronghold";
    }

    @Override
    public int func_202367_b() {
        return 8;
    }

    @Override
    @Nullable
    public BlockPos func_211405_a(World world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, BlockPos blockPos, int n, boolean bl) {
        if (!chunkGenerator.func_202090_b().func_205004_a(this)) {
            return null;
        }
        if (this.field_202387_av != world.func_72905_C()) {
            this.func_202386_c();
        }
        if (!this.field_75056_f) {
            this.func_202385_a(chunkGenerator);
            this.field_75056_f = true;
        }
        BlockPos \u26034 = null;
        BlockPos.MutableBlockPos \u26032 = new BlockPos.MutableBlockPos();
        double \u26033 = Double.MAX_VALUE;
        for (ChunkPos chunkPos : this.field_75057_g) {
            \u26032.func_181079_c((chunkPos.field_77276_a << 4) + 8, 32, (chunkPos.field_77275_b << 4) + 8);
            double d = \u26032.func_177951_i(blockPos);
            if (\u26034 == null) {
                \u26034 = new BlockPos(\u26032);
                \u26033 = d;
                continue;
            }
            if (!(d < \u26033)) continue;
            \u26034 = new BlockPos(\u26032);
            \u26033 = d;
        }
        return \u26034;
    }

    private void func_202385_a(ChunkGenerator<?> chunkGenerator2) {
        ChunkGenerator<?> chunkGenerator2;
        this.field_202387_av = chunkGenerator2.func_202089_c();
        ArrayList arrayList = Lists.newArrayList();
        for (Biome biome : Registry.field_212624_m) {
            if (biome == null || !chunkGenerator2.func_202094_a(biome, Feature.field_202335_m)) continue;
            arrayList.add(biome);
        }
        int \u26032 = ((GenerationSettings)chunkGenerator2.func_201496_a_()).func_202172_d();
        int \u26033 = ((GenerationSettings)chunkGenerator2.func_201496_a_()).func_202176_e();
        int \u26034 = ((GenerationSettings)chunkGenerator2.func_201496_a_()).func_202175_f();
        this.field_75057_g = new ChunkPos[\u26033];
        int \u26035 = 0;
        for (StructureStart structureStart : this.field_214561_aT) {
            if (\u26035 >= this.field_75057_g.length) continue;
            this.field_75057_g[\u26035++] = new ChunkPos(structureStart.func_143019_e(), structureStart.func_143018_f());
        }
        Random random = new Random();
        random.setSeed(chunkGenerator2.func_202089_c());
        double \u26036 = random.nextDouble() * Math.PI * 2.0;
        int \u26037 = \u26035;
        if (\u26037 < this.field_75057_g.length) {
            int \u260311 = 0;
            \u2603 = 0;
            for (\u2603 = 0; \u2603 < this.field_75057_g.length; ++\u2603) {
                double d = (double)(4 * \u26032 + \u26032 * \u2603 * 6) + (random.nextDouble() - 0.5) * ((double)\u26032 * 2.5);
                int \u26038 = (int)Math.round(Math.cos(\u26036) * d);
                int \u26039 = (int)Math.round(Math.sin(\u26036) * d);
                BlockPos \u260310 = chunkGenerator2.func_202090_b().func_180630_a((\u26038 << 4) + 8, (\u26039 << 4) + 8, 112, arrayList, random);
                if (\u260310 != null) {
                    \u26038 = \u260310.func_177958_n() >> 4;
                    \u26039 = \u260310.func_177952_p() >> 4;
                }
                if (\u2603 >= \u26037) {
                    this.field_75057_g[\u2603] = new ChunkPos(\u26038, \u26039);
                }
                \u26036 += Math.PI * 2 / (double)\u26034;
                if (++\u260311 != \u26034) continue;
                \u260311 = 0;
                \u26034 += 2 * \u26034 / (++\u2603 + 1);
                \u26034 = Math.min(\u26034, this.field_75057_g.length - \u2603);
                \u26036 += random.nextDouble() * Math.PI * 2.0;
            }
        }
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int n, int n2, Biome biome, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, biome, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_214625_a(ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome) {
            int n3 = 0;
            long \u26032 = chunkGenerator.func_202089_c();
            do {
                this.field_75075_a.clear();
                this.field_75074_b = MutableBoundingBox.func_78887_a();
                this.field_214631_d.func_202425_c(\u26032 + (long)n3++, n, n2);
                StrongholdPieces.func_75198_a();
                StrongholdPieces.Stairs2 stairs2 = new StrongholdPieces.Stairs2(this.field_214631_d, (n << 4) + 2, (n2 << 4) + 2);
                this.field_75075_a.add(stairs2);
                stairs2.func_74861_a(stairs2, this.field_75075_a, this.field_214631_d);
                List<StructurePiece> \u26033 = stairs2.field_75026_c;
                while (!\u26033.isEmpty()) {
                    int n4 = this.field_214631_d.nextInt(\u26033.size());
                    StructurePiece \u26034 = \u26033.remove(n4);
                    \u26034.func_74861_a(stairs2, this.field_75075_a, this.field_214631_d);
                }
                this.func_202500_a();
                this.func_214628_a(chunkGenerator.func_222530_f(), this.field_214631_d, 10);
            } while (this.field_75075_a.isEmpty() || stairs2.field_75025_b == null);
            ((StrongholdStructure)this.func_214627_k()).field_214561_aT.add(this);
        }
    }
}

