/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.spawner;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class WorldEntitySpawner {
    private static final Logger field_209383_a = LogManager.getLogger();

    public static void func_222263_a(EntityClassification entityClassification, World world, Chunk chunk, BlockPos blockPos) {
        ChunkGenerator<?> chunkGenerator = world.func_72863_F().func_201711_g();
        int \u26032 = 0;
        BlockPos \u26033 = WorldEntitySpawner.func_222262_a(world, chunk);
        int \u26034 = \u26033.func_177958_n();
        int \u26035 = \u26033.func_177956_o();
        int \u26036 = \u26033.func_177952_p();
        if (\u26035 < 1) {
            return;
        }
        BlockState \u26037 = chunk.func_180495_p(\u26033);
        if (\u26037.func_215686_e(chunk, \u26033)) {
            return;
        }
        BlockPos.MutableBlockPos \u26038 = new BlockPos.MutableBlockPos();
        block2: for (int i = 0; i < 3; ++i) {
            \u2603 = \u26034;
            \u2603 = \u26036;
            \u2603 = 6;
            Biome.SpawnListEntry spawnListEntry = null;
            ILivingEntityData \u26039 = null;
            int \u260310 = MathHelper.func_76143_f(Math.random() * 4.0);
            int \u260311 = 0;
            for (int j = 0; j < \u260310; ++j) {
                MobEntity \u260313;
                \u26038.func_181079_c(\u2603 += world.field_73012_v.nextInt(6) - world.field_73012_v.nextInt(6), \u26035, \u2603 += world.field_73012_v.nextInt(6) - world.field_73012_v.nextInt(6));
                float f = (float)\u2603 + 0.5f;
                \u2603 = (float)\u2603 + 0.5f;
                PlayerEntity \u260312 = world.func_217365_a(f, \u2603, -1.0);
                if (\u260312 == null || (\u2603 = \u260312.func_70092_e(f, \u26035, \u2603)) <= 576.0 || blockPos.func_218137_a(new Vec3d(f, \u26035, \u2603), 24.0) || !Objects.equals(\u2603 = new ChunkPos(\u26038), chunk.func_76632_l()) && !world.func_72863_F().func_222865_a(\u2603)) continue;
                if (spawnListEntry == null) {
                    spawnListEntry = WorldEntitySpawner.func_222264_a(chunkGenerator, entityClassification, world.field_73012_v, \u26038);
                    if (spawnListEntry == null) continue block2;
                    \u260310 = spawnListEntry.field_76301_c + world.field_73012_v.nextInt(1 + spawnListEntry.field_76299_d - spawnListEntry.field_76301_c);
                }
                if (spawnListEntry.field_200702_b.func_220339_d() == EntityClassification.MISC || !spawnListEntry.field_200702_b.func_225437_d() && \u2603 > 16384.0 || !(\u2603 = spawnListEntry.field_200702_b).func_200720_b() || !WorldEntitySpawner.func_222261_a(chunkGenerator, entityClassification, spawnListEntry, \u26038) || !WorldEntitySpawner.func_209382_a(\u2603 = EntitySpawnPlacementRegistry.func_209344_a(\u2603), world, \u26038, \u2603) || !EntitySpawnPlacementRegistry.func_223515_a(\u2603, world, SpawnReason.NATURAL, \u26038, world.field_73012_v) || !world.func_217351_c(\u2603.func_220328_a(f, \u26035, \u2603))) continue;
                try {
                    Object obj = \u2603.func_200721_a(world);
                    if (!(obj instanceof MobEntity)) {
                        throw new IllegalStateException("Trying to spawn a non-mob: " + Registry.field_212629_r.func_177774_c(\u2603));
                    }
                    \u260313 = (MobEntity)obj;
                }
                catch (Exception exception) {
                    field_209383_a.warn("Failed to create mob", (Throwable)exception);
                    return;
                }
                \u260313.func_70012_b(f, \u26035, \u2603, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (\u2603 > 16384.0 && \u260313.func_213397_c(\u2603) || !\u260313.func_213380_a(world, SpawnReason.NATURAL) || !\u260313.func_205019_a(world)) continue;
                \u26039 = \u260313.func_213386_a(world, world.func_175649_E(new BlockPos(\u260313)), SpawnReason.NATURAL, \u26039, null);
                ++\u260311;
                world.func_217376_c(\u260313);
                if (++\u26032 >= \u260313.func_70641_bl()) {
                    return;
                }
                if (\u260313.func_204209_c(\u260311)) continue block2;
            }
        }
    }

    @Nullable
    private static Biome.SpawnListEntry func_222264_a(ChunkGenerator<?> chunkGenerator, EntityClassification entityClassification, Random random, BlockPos blockPos) {
        List<Biome.SpawnListEntry> list = chunkGenerator.func_177458_a(entityClassification, blockPos);
        if (list.isEmpty()) {
            return null;
        }
        return WeightedRandom.func_76271_a(random, list);
    }

    private static boolean func_222261_a(ChunkGenerator<?> chunkGenerator, EntityClassification entityClassification, Biome.SpawnListEntry spawnListEntry, BlockPos blockPos) {
        List<Biome.SpawnListEntry> list = chunkGenerator.func_177458_a(entityClassification, blockPos);
        if (list.isEmpty()) {
            return false;
        }
        return list.contains(spawnListEntry);
    }

    private static BlockPos func_222262_a(World world, Chunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        int \u26032 = chunkPos.func_180334_c() + world.field_73012_v.nextInt(16);
        int \u26033 = chunkPos.func_180333_d() + world.field_73012_v.nextInt(16);
        int \u26034 = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, \u26032, \u26033) + 1;
        int \u26035 = world.field_73012_v.nextInt(\u26034 + 1);
        return new BlockPos(\u26032, \u26035, \u26033);
    }

    public static boolean func_222266_a(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, IFluidState iFluidState) {
        if (blockState.func_224756_o(iBlockReader, blockPos)) {
            return false;
        }
        if (blockState.func_185897_m()) {
            return false;
        }
        if (!iFluidState.func_206888_e()) {
            return false;
        }
        return !blockState.func_203425_a(BlockTags.field_203437_y);
    }

    public static boolean func_209382_a(EntitySpawnPlacementRegistry.PlacementType placementType, IWorldReader iWorldReader, BlockPos blockPos, @Nullable EntityType<?> entityType) {
        if (placementType == EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS) {
            return true;
        }
        if (entityType == null || !iWorldReader.func_175723_af().func_177746_a(blockPos)) {
            return false;
        }
        BlockState blockState = iWorldReader.func_180495_p(blockPos);
        IFluidState \u26032 = iWorldReader.func_204610_c(blockPos);
        BlockPos \u26033 = blockPos.func_177984_a();
        BlockPos \u26034 = blockPos.func_177977_b();
        switch (placementType) {
            case IN_WATER: {
                return \u26032.func_206884_a(FluidTags.field_206959_a) && iWorldReader.func_204610_c(\u26034).func_206884_a(FluidTags.field_206959_a) && !iWorldReader.func_180495_p(\u26033).func_215686_e(iWorldReader, \u26033);
            }
        }
        \u2603 = iWorldReader.func_180495_p(\u26034);
        if (!\u2603.func_215688_a(iWorldReader, \u26034, entityType)) {
            return false;
        }
        return WorldEntitySpawner.func_222266_a(iWorldReader, blockPos, blockState, \u26032) && WorldEntitySpawner.func_222266_a(iWorldReader, \u26033, iWorldReader.func_180495_p(\u26033), iWorldReader.func_204610_c(\u26033));
    }

    public static void func_77191_a(IWorld iWorld, Biome biome, int n, int n2, Random random2) {
        List<Biome.SpawnListEntry> list = biome.func_76747_a(EntityClassification.CREATURE);
        if (list.isEmpty()) {
            return;
        }
        int \u26032 = n << 4;
        int \u26033 = n2 << 4;
        while (random2.nextFloat() < biome.func_76741_f()) {
            Biome.SpawnListEntry spawnListEntry = WeightedRandom.func_76271_a(random2, list);
            int \u26034 = spawnListEntry.field_76301_c + random2.nextInt(1 + spawnListEntry.field_76299_d - spawnListEntry.field_76301_c);
            ILivingEntityData \u26035 = null;
            int \u26036 = \u26032 + random2.nextInt(16);
            int \u26037 = \u26033 + random2.nextInt(16);
            int \u26038 = \u26036;
            int \u26039 = \u26037;
            for (int i = 0; i < \u26034; ++i) {
                boolean bl = false;
                for (int j = 0; !bl && j < 4; ++j) {
                    Random random2;
                    BlockPos blockPos = WorldEntitySpawner.func_208498_a(iWorld, spawnListEntry.field_200702_b, \u26036, \u26037);
                    if (spawnListEntry.field_200702_b.func_200720_b() && WorldEntitySpawner.func_209382_a(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, iWorld, blockPos, spawnListEntry.field_200702_b)) {
                        float f = spawnListEntry.field_200702_b.func_220333_h();
                        double \u260310 = MathHelper.func_151237_a(\u26036, (double)\u26032 + (double)f, (double)\u26032 + 16.0 - (double)f);
                        double \u260311 = MathHelper.func_151237_a(\u26037, (double)\u26033 + (double)f, (double)\u26033 + 16.0 - (double)f);
                        if (!iWorld.func_217351_c(spawnListEntry.field_200702_b.func_220328_a(\u260310, blockPos.func_177956_o(), \u260311)) || !EntitySpawnPlacementRegistry.func_223515_a(spawnListEntry.field_200702_b, iWorld, SpawnReason.CHUNK_GENERATION, new BlockPos(\u260310, (double)blockPos.func_177956_o(), \u260311), iWorld.func_201674_k())) continue;
                        try {
                            Object obj = spawnListEntry.field_200702_b.func_200721_a(iWorld.func_201672_e());
                        }
                        catch (Exception exception) {
                            field_209383_a.warn("Failed to create mob", (Throwable)exception);
                            continue;
                        }
                        ((Entity)obj).func_70012_b(\u260310, blockPos.func_177956_o(), \u260311, random2.nextFloat() * 360.0f, 0.0f);
                        if (obj instanceof MobEntity && (\u2603 = (MobEntity)obj).func_213380_a(iWorld, SpawnReason.CHUNK_GENERATION) && \u2603.func_205019_a(iWorld)) {
                            \u26035 = \u2603.func_213386_a(iWorld, iWorld.func_175649_E(new BlockPos(\u2603)), SpawnReason.CHUNK_GENERATION, \u26035, null);
                            iWorld.func_217376_c(\u2603);
                            bl = true;
                        }
                    }
                    \u26036 += random2.nextInt(5) - random2.nextInt(5);
                    \u26037 += random2.nextInt(5) - random2.nextInt(5);
                    while (\u26036 < \u26032 || \u26036 >= \u26032 + 16 || \u26037 < \u26033 || \u26037 >= \u26033 + 16) {
                        \u26036 = \u26038 + random2.nextInt(5) - random2.nextInt(5);
                        \u26037 = \u26039 + random2.nextInt(5) - random2.nextInt(5);
                    }
                }
            }
        }
    }

    private static BlockPos func_208498_a(IWorldReader iWorldReader, @Nullable EntityType<?> entityType, int n, int n2) {
        BlockPos blockPos = new BlockPos(n, iWorldReader.func_201676_a(EntitySpawnPlacementRegistry.func_209342_b(entityType), n, n2), n2);
        \u2603 = blockPos.func_177977_b();
        if (iWorldReader.func_180495_p(\u2603).func_196957_g(iWorldReader, \u2603, PathType.LAND)) {
            return \u2603;
        }
        return blockPos;
    }
}

