/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive.horse;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LlamaFollowCaravanGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LlamaEntity
extends AbstractChestedHorseEntity
implements IRangedAttackMob {
    private static final DataParameter<Integer> field_190720_bG = EntityDataManager.func_187226_a(LlamaEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_190721_bH = EntityDataManager.func_187226_a(LlamaEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_190722_bI = EntityDataManager.func_187226_a(LlamaEntity.class, DataSerializers.field_187192_b);
    private boolean field_190723_bJ;
    @Nullable
    private LlamaEntity field_190724_bK;
    @Nullable
    private LlamaEntity field_190725_bL;

    public LlamaEntity(EntityType<? extends LlamaEntity> p_i50237_1_, World p_i50237_2_) {
        super(p_i50237_1_, p_i50237_2_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_213800_eB() {
        return false;
    }

    private void func_190706_p(int strengthIn) {
        this.field_70180_af.func_187227_b(field_190720_bG, Math.max(1, Math.min(5, strengthIn)));
    }

    private void func_190705_dT() {
        int i = this.field_70146_Z.nextFloat() < 0.04f ? 5 : 3;
        this.func_190706_p(1 + this.field_70146_Z.nextInt(i));
    }

    public int func_190707_dL() {
        return this.field_70180_af.func_187225_a(field_190720_bG);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.func_190719_dM());
        compound.func_74768_a("Strength", this.func_190707_dL());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            compound.func_218657_a("DecorItem", this.field_110296_bG.func_70301_a(1).func_77955_b(new CompoundNBT()));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        this.func_190706_p(compound.func_74762_e("Strength"));
        super.func_70037_a(compound);
        this.func_190710_o(compound.func_74762_e("Variant"));
        if (compound.func_150297_b("DecorItem", 10)) {
            this.field_110296_bG.func_70299_a(1, ItemStack.func_199557_a(compound.func_74775_l("DecorItem")));
        }
        this.func_110232_cE();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorseEntity)((Object)this), 1.2));
        this.field_70714_bg.func_75776_a(2, (Goal)new LlamaFollowCaravanGoal(this, (double)2.1f));
        this.field_70714_bg.func_75776_a(3, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.25, 40, 20.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new DefendTargetGoal(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_190720_bG, 0);
        this.field_70180_af.func_187214_a(field_190721_bH, -1);
        this.field_70180_af.func_187214_a(field_190722_bI, 0);
    }

    public int func_190719_dM() {
        return MathHelper.func_76125_a((int)this.field_70180_af.func_187225_a(field_190722_bI), (int)0, (int)3);
    }

    public void func_190710_o(int variantIn) {
        this.field_70180_af.func_187227_b(field_190722_bI, variantIn);
    }

    protected int func_190686_di() {
        return this.func_190695_dh() ? 2 + 3 * this.func_190696_dl() : super.func_190686_di();
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f1 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float f2 = 0.3f;
            passenger.func_70107_b(this.field_70165_t + (double)(0.3f * f1), this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v - (double)(0.3f * f));
        }
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.67;
    }

    public boolean func_82171_bF() {
        return false;
    }

    protected boolean func_190678_b(PlayerEntity player, ItemStack stack) {
        int i = 0;
        int j = 0;
        float f = 0.0f;
        boolean flag = false;
        Item item = stack.func_77973_b();
        if (item == Items.field_151015_O) {
            i = 10;
            j = 3;
            f = 2.0f;
        } else if (item == Blocks.field_150407_cf.func_199767_j()) {
            i = 90;
            j = 6;
            f = 10.0f;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && this.func_204701_dC()) {
                flag = true;
                this.func_146082_f(player);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
            this.func_70691_i(f);
            flag = true;
        }
        if (this.func_70631_g_() && i > 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.func_110248_bS()) && this.func_110252_cg() < this.func_190676_dC()) {
            flag = true;
            if (!this.field_70170_p.field_72995_K) {
                this.func_110198_t(j);
            }
        }
        if (flag && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_191253_dD, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        return flag;
    }

    protected boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || this.func_110204_cc();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int i;
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_190705_dT();
        if (spawnDataIn instanceof LlamaData) {
            i = ((LlamaData)spawnDataIn).field_190886_a;
        } else {
            i = this.field_70146_Z.nextInt(4);
            spawnDataIn = new LlamaData(i);
        }
        this.func_190710_o(i);
        return spawnDataIn;
    }

    protected SoundEvent func_184785_dv() {
        return SoundEvents.field_191250_dA;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191260_dz;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191254_dE;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191252_dC;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_191256_dG, 0.15f, 1.0f);
    }

    protected void func_190697_dk() {
        this.func_184185_a(SoundEvents.field_191251_dB, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    public void func_190687_dF() {
        SoundEvent soundevent = this.func_184785_dv();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public int func_190696_dl() {
        return this.func_190707_dL();
    }

    public boolean func_190677_dK() {
        return true;
    }

    public boolean func_190682_f(ItemStack stack) {
        Item item = stack.func_77973_b();
        return ItemTags.field_200035_e.func_199685_a_(item);
    }

    public boolean func_190685_dA() {
        return false;
    }

    public void func_76316_a(IInventory invBasic) {
        DyeColor dyecolor = this.func_190704_dO();
        super.func_76316_a(invBasic);
        DyeColor dyecolor1 = this.func_190704_dO();
        if (this.field_70173_aa > 20 && dyecolor1 != null && dyecolor1 != dyecolor) {
            this.func_184185_a(SoundEvents.field_191257_dH, 0.5f, 1.0f);
        }
    }

    protected void func_110232_cE() {
        if (!this.field_70170_p.field_72995_K) {
            super.func_110232_cE();
            this.func_190711_a(LlamaEntity.func_195403_g(this.field_110296_bG.func_70301_a(1)));
        }
    }

    private void func_190711_a(@Nullable DyeColor color) {
        this.field_70180_af.func_187227_b(field_190721_bH, color == null ? -1 : color.func_196059_a());
    }

    @Nullable
    private static DyeColor func_195403_g(ItemStack p_195403_0_) {
        Block block = Block.func_149634_a(p_195403_0_.func_77973_b());
        return block instanceof CarpetBlock ? ((CarpetBlock)block).func_196547_d() : null;
    }

    @Nullable
    public DyeColor func_190704_dO() {
        int i = this.field_70180_af.func_187225_a(field_190721_bH);
        return i == -1 ? null : DyeColor.func_196056_a(i);
    }

    public int func_190676_dC() {
        return 30;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return otherAnimal != this && otherAnimal instanceof LlamaEntity && this.func_110200_cJ() && ((LlamaEntity)otherAnimal).func_110200_cJ();
    }

    public LlamaEntity func_90011_a(AgeableEntity ageable) {
        LlamaEntity llamaentity = this.func_213799_eF();
        this.func_190681_a(ageable, (AbstractHorseEntity)((Object)llamaentity));
        LlamaEntity llamaentity1 = (LlamaEntity)ageable;
        int i = this.field_70146_Z.nextInt(Math.max(this.func_190707_dL(), llamaentity1.func_190707_dL())) + 1;
        if (this.field_70146_Z.nextFloat() < 0.03f) {
            ++i;
        }
        llamaentity.func_190706_p(i);
        llamaentity.func_190710_o(this.field_70146_Z.nextBoolean() ? this.func_190719_dM() : llamaentity1.func_190719_dM());
        return llamaentity;
    }

    protected LlamaEntity func_213799_eF() {
        return EntityType.field_200769_I.func_200721_a(this.field_70170_p);
    }

    private void func_190713_e(LivingEntity target) {
        LlamaSpitEntity llamaspitentity = new LlamaSpitEntity(this.field_70170_p, this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - llamaspitentity.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        llamaspitentity.func_70186_c(d0, d1 + (double)f, d2, 1.5f, 10.0f);
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_191255_dF, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        this.field_70170_p.func_217376_c(llamaspitentity);
        this.field_190723_bJ = true;
    }

    private void func_190714_x(boolean didSpitIn) {
        this.field_190723_bJ = didSpitIn;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i = MathHelper.func_76123_f((float)((distance * 0.5f - 3.0f) * damageMultiplier));
        if (i > 0) {
            BlockPos pos;
            BlockState blockstate;
            if (distance >= 6.0f) {
                this.func_70097_a(DamageSource.field_76379_h, i);
                if (this.func_184207_aI()) {
                    for (Entity entity : this.func_184182_bu()) {
                        entity.func_70097_a(DamageSource.field_76379_h, i);
                    }
                }
            }
            if (!(blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v))).func_196958_f() && !this.func_174814_R()) {
                SoundType soundtype = blockstate.getSoundType(this.field_70170_p, pos, (Entity)((Object)this));
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundtype.func_185844_d(), this.func_184176_by(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    public void func_190709_dP() {
        if (this.field_190724_bK != null) {
            this.field_190724_bK.field_190725_bL = null;
        }
        this.field_190724_bK = null;
    }

    public void func_190715_a(LlamaEntity caravanHeadIn) {
        this.field_190724_bK = caravanHeadIn;
        this.field_190724_bK.field_190725_bL = this;
    }

    public boolean func_190712_dQ() {
        return this.field_190725_bL != null;
    }

    public boolean func_190718_dR() {
        return this.field_190724_bK != null;
    }

    @Nullable
    public LlamaEntity func_190716_dS() {
        return this.field_190724_bK;
    }

    protected double func_190634_dg() {
        return 2.0;
    }

    protected void func_190679_dD() {
        if (!this.func_190718_dR() && this.func_70631_g_()) {
            super.func_190679_dD();
        }
    }

    public boolean func_190684_dE() {
        return false;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.func_190713_e(target);
    }

    static class LlamaData
    implements ILivingEntityData {
        public final int field_190886_a;

        private LlamaData(int variantIn) {
            this.field_190886_a = variantIn;
        }
    }

    static class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal(LlamaEntity llama) {
            super((CreatureEntity)llama, new Class[0]);
        }

        public boolean func_75253_b() {
            LlamaEntity llamaentity;
            if (this.field_75299_d instanceof LlamaEntity && (llamaentity = (LlamaEntity)((Object)this.field_75299_d)).field_190723_bJ) {
                llamaentity.func_190714_x(false);
                return false;
            }
            return super.func_75253_b();
        }
    }

    static class DefendTargetGoal
    extends NearestAttackableTargetGoal<WolfEntity> {
        public DefendTargetGoal(LlamaEntity llama) {
            super((MobEntity)((Object)llama), WolfEntity.class, 16, false, true, p_220789_0_ -> !((WolfEntity)((Object)((Object)p_220789_0_))).func_70909_n());
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.25;
        }
    }
}

