/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.HopperContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.VanillaHopperItemHandler;
import net.minecraftforge.items.VanillaInventoryCodeHooks;

public class HopperTileEntity
extends LockableLootTileEntity
implements IHopper,
ITickableTileEntity {
    private NonNullList<ItemStack> field_145900_a = NonNullList.func_191197_a((int)5, (Object)((Object)ItemStack.field_190927_a));
    private int field_145901_j = -1;
    private long field_190578_g;

    public HopperTileEntity() {
        super(TileEntityType.field_200987_r);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.field_145900_a = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)((Object)ItemStack.field_190927_a));
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.field_145900_a);
        }
        this.field_145901_j = compound.func_74762_e("TransferCooldown");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.field_145900_a);
        }
        compound.func_74768_a("TransferCooldown", this.field_145901_j);
        return compound;
    }

    public int func_70302_i_() {
        return this.field_145900_a.size();
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188382_a(this.func_190576_q(), (int)index, (int)count);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.func_184281_d(null);
        this.func_190576_q().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.hopper", new Object[0]);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.field_145901_j;
            this.field_190578_g = this.field_145850_b.func_82737_E();
            if (!this.func_145888_j()) {
                this.func_145896_c(0);
                this.func_200109_a(() -> HopperTileEntity.func_145891_a(this));
            }
        }
    }

    private boolean func_200109_a(Supplier<Boolean> p_200109_1_) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.func_145888_j() && ((Boolean)this.func_195044_w().func_177229_b((IProperty)HopperBlock.field_176429_b)).booleanValue()) {
                boolean flag = false;
                if (!this.func_152104_k()) {
                    flag = this.func_145883_k();
                }
                if (!this.func_152105_l()) {
                    flag |= p_200109_1_.get().booleanValue();
                }
                if (flag) {
                    this.func_145896_c(8);
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean func_152104_k() {
        for (ItemStack itemstack : this.field_145900_a) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_191420_l() {
        return this.func_152104_k();
    }

    private boolean func_152105_l() {
        for (ItemStack itemstack : this.field_145900_a) {
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private boolean func_145883_k() {
        if (VanillaInventoryCodeHooks.insertHook((HopperTileEntity)this)) {
            return true;
        }
        IInventory iinventory = this.func_145895_l();
        if (iinventory == null) {
            return false;
        }
        Direction direction = ((Direction)((Object)this.func_195044_w().func_177229_b((IProperty)HopperBlock.field_176430_a))).func_176734_d();
        if (this.func_174919_a(iinventory, direction)) {
            return false;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            ItemStack itemstack = this.func_70301_a(i).func_77946_l();
            ItemStack itemstack1 = HopperTileEntity.func_174918_a((IInventory)this, iinventory, this.func_70298_a(i, 1), direction);
            if (itemstack1.func_190926_b()) {
                iinventory.func_70296_d();
                return true;
            }
            this.func_70299_a(i, itemstack);
        }
        return false;
    }

    private static IntStream func_213972_a(IInventory p_213972_0_, Direction p_213972_1_) {
        return p_213972_0_ instanceof ISidedInventory ? IntStream.of(((ISidedInventory)p_213972_0_).func_180463_a(p_213972_1_)) : IntStream.range(0, p_213972_0_.func_70302_i_());
    }

    private boolean func_174919_a(IInventory inventoryIn, Direction side) {
        return HopperTileEntity.func_213972_a(inventoryIn, side).allMatch(p_213970_1_ -> {
            ItemStack itemstack = inventoryIn.func_70301_a(p_213970_1_);
            return itemstack.func_190916_E() >= itemstack.func_77976_d();
        });
    }

    private static boolean func_174917_b(IInventory inventoryIn, Direction side) {
        return HopperTileEntity.func_213972_a(inventoryIn, side).allMatch(p_213973_1_ -> inventoryIn.func_70301_a(p_213973_1_).func_190926_b());
    }

    public static boolean func_145891_a(IHopper hopper) {
        Boolean ret = VanillaInventoryCodeHooks.extractHook((IHopper)hopper);
        if (ret != null) {
            return ret;
        }
        IInventory iinventory = HopperTileEntity.func_145884_b(hopper);
        if (iinventory != null) {
            Direction direction = Direction.DOWN;
            return HopperTileEntity.func_174917_b(iinventory, direction) ? false : HopperTileEntity.func_213972_a(iinventory, direction).anyMatch(p_213971_3_ -> HopperTileEntity.func_174915_a(hopper, iinventory, p_213971_3_, direction));
        }
        for (ItemEntity itementity : HopperTileEntity.func_200115_c(hopper)) {
            if (!HopperTileEntity.func_200114_a((IInventory)hopper, itementity)) continue;
            return true;
        }
        return false;
    }

    private static boolean func_174915_a(IHopper hopper, IInventory inventoryIn, int index, Direction direction) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (!itemstack.func_190926_b() && HopperTileEntity.func_174921_b(inventoryIn, itemstack, index, direction)) {
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = HopperTileEntity.func_174918_a(inventoryIn, (IInventory)hopper, inventoryIn.func_70298_a(index, 1), null);
            if (itemstack2.func_190926_b()) {
                inventoryIn.func_70296_d();
                return true;
            }
            inventoryIn.func_70299_a(index, itemstack1);
        }
        return false;
    }

    public static boolean func_200114_a(IInventory p_200114_0_, ItemEntity p_200114_1_) {
        boolean flag = false;
        ItemStack itemstack = p_200114_1_.func_92059_d().func_77946_l();
        ItemStack itemstack1 = HopperTileEntity.func_174918_a(null, p_200114_0_, itemstack, null);
        if (itemstack1.func_190926_b()) {
            flag = true;
            p_200114_1_.func_70106_y();
        } else {
            p_200114_1_.func_92058_a(itemstack1);
        }
        return flag;
    }

    public static ItemStack func_174918_a(@Nullable IInventory source, IInventory destination, ItemStack stack, @Nullable Direction direction) {
        if (destination instanceof ISidedInventory && direction != null) {
            ISidedInventory isidedinventory = (ISidedInventory)destination;
            int[] aint = isidedinventory.func_180463_a(direction);
            for (int k = 0; k < aint.length && !stack.func_190926_b(); ++k) {
                stack = HopperTileEntity.func_174916_c(source, destination, stack, aint[k], direction);
            }
        } else {
            int i = destination.func_70302_i_();
            for (int j = 0; j < i && !stack.func_190926_b(); ++j) {
                stack = HopperTileEntity.func_174916_c(source, destination, stack, j, direction);
            }
        }
        return stack;
    }

    private static boolean func_174920_a(IInventory inventoryIn, ItemStack stack, int index, @Nullable Direction side) {
        if (!inventoryIn.func_94041_b(index, stack)) {
            return false;
        }
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side);
    }

    private static boolean func_174921_b(IInventory inventoryIn, ItemStack stack, int index, Direction side) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180461_b(index, stack, side);
    }

    private static ItemStack func_174916_c(@Nullable IInventory source, IInventory destination, ItemStack stack, int index, @Nullable Direction direction) {
        ItemStack itemstack = destination.func_70301_a(index);
        if (HopperTileEntity.func_174920_a(destination, stack, index, direction)) {
            boolean flag = false;
            boolean flag1 = destination.func_191420_l();
            if (itemstack.func_190926_b()) {
                destination.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
                flag = true;
            } else if (HopperTileEntity.func_145894_a(itemstack, stack)) {
                int i = stack.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                HopperTileEntity hoppertileentity1;
                if (flag1 && destination instanceof HopperTileEntity && !(hoppertileentity1 = (HopperTileEntity)destination).func_174914_o()) {
                    int k = 0;
                    if (source instanceof HopperTileEntity) {
                        HopperTileEntity hoppertileentity = (HopperTileEntity)source;
                        if (hoppertileentity1.field_190578_g >= hoppertileentity.field_190578_g) {
                            k = 1;
                        }
                    }
                    hoppertileentity1.func_145896_c(8 - k);
                }
                destination.func_70296_d();
            }
        }
        return stack;
    }

    @Nullable
    private IInventory func_145895_l() {
        Direction direction = (Direction)((Object)this.func_195044_w().func_177229_b((IProperty)HopperBlock.field_176430_a));
        return HopperTileEntity.func_195484_a(this.func_145831_w(), this.field_174879_c.func_177972_a(direction));
    }

    @Nullable
    public static IInventory func_145884_b(IHopper hopper) {
        return HopperTileEntity.func_145893_b(hopper.func_145831_w(), hopper.func_96107_aA(), hopper.func_96109_aB() + 1.0, hopper.func_96108_aC());
    }

    public static List<ItemEntity> func_200115_c(IHopper p_200115_0_) {
        return p_200115_0_.func_200100_i().func_197756_d().stream().flatMap(p_200110_1_ -> p_200115_0_.func_145831_w().func_175647_a(ItemEntity.class, p_200110_1_.func_72317_d(p_200115_0_.func_96107_aA() - 0.5, p_200115_0_.func_96109_aB() - 0.5, p_200115_0_.func_96108_aC() - 0.5), EntityPredicates.field_94557_a).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static IInventory func_195484_a(World p_195484_0_, BlockPos p_195484_1_) {
        return HopperTileEntity.func_145893_b(p_195484_0_, (double)p_195484_1_.func_177958_n() + 0.5, (double)p_195484_1_.func_177956_o() + 0.5, (double)p_195484_1_.func_177952_p() + 0.5);
    }

    @Nullable
    public static IInventory func_145893_b(World worldIn, double x, double y, double z) {
        List<Entity> list;
        TileEntity tileentity;
        ISidedInventory iinventory = null;
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        if (block instanceof ISidedInventoryProvider) {
            iinventory = ((ISidedInventoryProvider)block).func_219966_a(blockstate, (IWorld)worldIn, blockpos);
        } else if (blockstate.hasTileEntity() && (tileentity = worldIn.func_175625_s(blockpos)) instanceof IInventory && (iinventory = (IInventory)tileentity) instanceof ChestTileEntity && block instanceof ChestBlock) {
            iinventory = ChestBlock.func_220105_a((BlockState)blockstate, (World)worldIn, (BlockPos)blockpos, (boolean)true);
        }
        if (iinventory == null && !(list = worldIn.func_175674_a(null, new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntityPredicates.field_96566_b)).isEmpty()) {
            iinventory = (IInventory)list.get(worldIn.field_73012_v.nextInt(list.size()));
        }
        return iinventory;
    }

    private static boolean func_145894_a(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77952_i() != stack2.func_77952_i()) {
            return false;
        }
        if (stack1.func_190916_E() > stack1.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a(stack1, stack2);
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public void func_145896_c(int ticks) {
        this.field_145901_j = ticks;
    }

    private boolean func_145888_j() {
        return this.field_145901_j > 0;
    }

    public boolean func_174914_o() {
        return this.field_145901_j > 8;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.field_145900_a;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.field_145900_a = itemsIn;
    }

    public void func_200113_a(Entity p_200113_1_) {
        if (p_200113_1_ instanceof ItemEntity) {
            BlockPos blockpos = this.func_174877_v();
            if (VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)p_200113_1_.func_174813_aQ().func_72317_d((double)(-blockpos.func_177958_n()), (double)(-blockpos.func_177956_o()), (double)(-blockpos.func_177952_p()))), (VoxelShape)this.func_200100_i(), (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
                this.func_200109_a(() -> HopperTileEntity.func_200114_a((IInventory)this, (ItemEntity)p_200113_1_));
            }
        }
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new HopperContainer(id, player, (IInventory)this);
    }

    protected IItemHandler createUnSidedHandler() {
        return new VanillaHopperItemHandler(this);
    }

    public long getLastUpdateTime() {
        return this.field_190578_g;
    }
}

