/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public enum Direction implements IStringSerializable
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));

    private final int field_176748_g;
    private final int field_176759_h;
    private final int field_176760_i;
    private final String field_176757_j;
    private final Axis field_176758_k;
    private final AxisDirection field_176755_l;
    private final Vec3i field_176756_m;
    private static final Direction[] field_199792_n;
    private static final Map<String, Direction> field_176761_p;
    private static final Direction[] field_82609_l;
    private static final Direction[] field_176754_o;
    private static final Long2ObjectMap<Direction> field_218387_r;

    private Direction(int indexIn, int oppositeIn, int horizontalIndexIn, String nameIn, AxisDirection axisDirectionIn, Axis axisIn, Vec3i directionVecIn) {
        this.field_176748_g = indexIn;
        this.field_176760_i = horizontalIndexIn;
        this.field_176759_h = oppositeIn;
        this.field_176757_j = nameIn;
        this.field_176758_k = axisIn;
        this.field_176755_l = axisDirectionIn;
        this.field_176756_m = directionVecIn;
    }

    public static Direction[] func_196054_a(Entity entityIn) {
        Direction direction2;
        float f = entityIn.func_195050_f(1.0f) * ((float)Math.PI / 180);
        float f1 = -entityIn.func_195046_g(1.0f) * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76126_a((float)f);
        float f3 = MathHelper.func_76134_b((float)f);
        float f4 = MathHelper.func_76126_a((float)f1);
        float f5 = MathHelper.func_76134_b((float)f1);
        boolean flag = f4 > 0.0f;
        boolean flag1 = f2 < 0.0f;
        boolean flag2 = f5 > 0.0f;
        float f6 = flag ? f4 : -f4;
        float f7 = flag1 ? -f2 : f2;
        float f8 = flag2 ? f5 : -f5;
        float f9 = f6 * f3;
        float f10 = f8 * f3;
        Direction direction = flag ? EAST : WEST;
        Direction direction1 = flag1 ? UP : DOWN;
        Direction direction3 = direction2 = flag2 ? SOUTH : NORTH;
        if (f6 > f8) {
            if (f7 > f9) {
                return Direction.func_196053_a(direction1, direction, direction2);
            }
            return f10 > f7 ? Direction.func_196053_a(direction, direction2, direction1) : Direction.func_196053_a(direction, direction1, direction2);
        }
        if (f7 > f10) {
            return Direction.func_196053_a(direction1, direction2, direction);
        }
        return f9 > f7 ? Direction.func_196053_a(direction2, direction, direction1) : Direction.func_196053_a(direction2, direction1, direction);
    }

    private static Direction[] func_196053_a(Direction first, Direction second, Direction third) {
        return new Direction[]{first, second, third, third.func_176734_d(), second.func_176734_d(), first.func_176734_d()};
    }

    public int func_176745_a() {
        return this.field_176748_g;
    }

    public int func_176736_b() {
        return this.field_176760_i;
    }

    public AxisDirection func_176743_c() {
        return this.field_176755_l;
    }

    public Direction func_176734_d() {
        return Direction.func_82600_a(this.field_176759_h);
    }

    public Direction func_176732_a(Axis axis) {
        switch (axis) {
            case X: {
                if (this != WEST && this != EAST) {
                    return this.func_176744_n();
                }
                return this;
            }
            case Y: {
                if (this != UP && this != DOWN) {
                    return this.func_176746_e();
                }
                return this;
            }
            case Z: {
                if (this != NORTH && this != SOUTH) {
                    return this.func_176738_p();
                }
                return this;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + axis);
    }

    public Direction func_176746_e() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + (Object)((Object)this));
    }

    private Direction func_176744_n() {
        switch (this) {
            case NORTH: {
                return DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get X-rotated facing of " + (Object)((Object)this));
            }
            case SOUTH: {
                return UP;
            }
            case UP: {
                return NORTH;
            }
            case DOWN: 
        }
        return SOUTH;
    }

    private Direction func_176738_p() {
        switch (this) {
            case EAST: {
                return DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get Z-rotated facing of " + (Object)((Object)this));
            }
            case WEST: {
                return UP;
            }
            case UP: {
                return EAST;
            }
            case DOWN: 
        }
        return WEST;
    }

    public Direction func_176735_f() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case EAST: {
                return NORTH;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + (Object)((Object)this));
    }

    public int func_82601_c() {
        return this.field_176758_k == Axis.X ? this.field_176755_l.func_179524_a() : 0;
    }

    public int func_96559_d() {
        return this.field_176758_k == Axis.Y ? this.field_176755_l.func_179524_a() : 0;
    }

    public int func_82599_e() {
        return this.field_176758_k == Axis.Z ? this.field_176755_l.func_179524_a() : 0;
    }

    public String func_176742_j() {
        return this.field_176757_j;
    }

    public Axis func_176740_k() {
        return this.field_176758_k;
    }

    @Nullable
    public static Direction func_176739_a(@Nullable String name) {
        return name == null ? null : field_176761_p.get(name.toLowerCase(Locale.ROOT));
    }

    public static Direction func_82600_a(int index) {
        return field_82609_l[MathHelper.func_76130_a((int)(index % field_82609_l.length))];
    }

    public static Direction func_176731_b(int horizontalIndexIn) {
        return field_176754_o[MathHelper.func_76130_a((int)(horizontalIndexIn % field_176754_o.length))];
    }

    @Nullable
    public static Direction func_218383_a(int p_218383_0_, int p_218383_1_, int p_218383_2_) {
        return (Direction)((Object)field_218387_r.get(BlockPos.func_218276_a((int)p_218383_0_, (int)p_218383_1_, (int)p_218383_2_)));
    }

    public static Direction func_176733_a(double angle) {
        return Direction.func_176731_b(MathHelper.func_76128_c((double)(angle / 90.0 + 0.5)) & 3);
    }

    public static Direction func_211699_a(Axis axisIn, AxisDirection axisDirectionIn) {
        switch (axisIn) {
            case X: {
                return axisDirectionIn == AxisDirection.POSITIVE ? EAST : WEST;
            }
            case Y: {
                return axisDirectionIn == AxisDirection.POSITIVE ? UP : DOWN;
            }
        }
        return axisDirectionIn == AxisDirection.POSITIVE ? SOUTH : NORTH;
    }

    public float func_185119_l() {
        return (this.field_176760_i & 3) * 90;
    }

    public static Direction func_176741_a(Random rand) {
        return Direction.values()[rand.nextInt(Direction.values().length)];
    }

    public static Direction func_210769_a(double x, double y, double z) {
        return Direction.func_176737_a((float)x, (float)y, (float)z);
    }

    public static Direction func_176737_a(float x, float y, float z) {
        Direction direction = NORTH;
        float f = Float.MIN_VALUE;
        for (Direction direction1 : field_199792_n) {
            float f1 = x * (float)direction1.field_176756_m.func_177958_n() + y * (float)direction1.field_176756_m.func_177956_o() + z * (float)direction1.field_176756_m.func_177952_p();
            if (!(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }

    public String toString() {
        return this.field_176757_j;
    }

    public String func_176610_l() {
        return this.field_176757_j;
    }

    public static Direction func_181076_a(AxisDirection axisDirectionIn, Axis axisIn) {
        for (Direction direction : Direction.values()) {
            if (direction.func_176743_c() != axisDirectionIn || direction.func_176740_k() != axisIn) continue;
            return direction;
        }
        throw new IllegalArgumentException("No such direction: " + (Object)((Object)axisDirectionIn) + " " + axisIn);
    }

    public Vec3i func_176730_m() {
        return this.field_176756_m;
    }

    static {
        field_199792_n = Direction.values();
        field_176761_p = Arrays.stream(field_199792_n).collect(Collectors.toMap(Direction::func_176742_j, p_199787_0_ -> p_199787_0_));
        field_82609_l = (Direction[])Arrays.stream(field_199792_n).sorted(Comparator.comparingInt(p_199790_0_ -> p_199790_0_.field_176748_g)).toArray(Direction[]::new);
        field_176754_o = (Direction[])Arrays.stream(field_199792_n).filter(p_199786_0_ -> p_199786_0_.func_176740_k().func_176722_c()).sorted(Comparator.comparingInt(p_199789_0_ -> p_199789_0_.field_176760_i)).toArray(Direction[]::new);
        field_218387_r = (Long2ObjectMap)Arrays.stream(field_199792_n).collect(Collectors.toMap(p_218385_0_ -> new BlockPos(p_218385_0_.func_176730_m()).func_218275_a(), p_218384_0_ -> p_218384_0_, (p_218386_0_, p_218386_1_) -> {
            throw new IllegalArgumentException("Duplicate keys");
        }, Long2ObjectOpenHashMap::new));
    }

    public static enum Plane implements Iterable<Direction>,
    Predicate<Direction>
    {
        HORIZONTAL(new Direction[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z}),
        VERTICAL(new Direction[]{UP, DOWN}, new Axis[]{Axis.Y});

        private final Direction[] field_209387_c;
        private final Axis[] field_209388_d;

        private Plane(Direction[] facingValuesIn, Axis[] axisValuesIn) {
            this.field_209387_c = facingValuesIn;
            this.field_209388_d = axisValuesIn;
        }

        public Direction func_179518_a(Random rand) {
            return this.field_209387_c[rand.nextInt(this.field_209387_c.length)];
        }

        @Override
        public boolean test(@Nullable Direction p_test_1_) {
            return p_test_1_ != null && p_test_1_.func_176740_k().func_176716_d() == this;
        }

        @Override
        public Iterator<Direction> iterator() {
            return Iterators.forArray((Object[])this.field_209387_c);
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int field_179528_c;
        private final String field_179525_d;

        private AxisDirection(int offset, String description) {
            this.field_179528_c = offset;
            this.field_179525_d = description;
        }

        public int func_179524_a() {
            return this.field_179528_c;
        }

        public String toString() {
            return this.field_179525_d;
        }
    }

    public static enum Axis implements IStringSerializable,
    Predicate<Direction>
    {
        X("x"){

            @Override
            public int func_196052_a(int x, int y, int z) {
                return x;
            }

            @Override
            public double func_196051_a(double x, double y, double z) {
                return x;
            }
        }
        ,
        Y("y"){

            @Override
            public int func_196052_a(int x, int y, int z) {
                return y;
            }

            @Override
            public double func_196051_a(double x, double y, double z) {
                return y;
            }
        }
        ,
        Z("z"){

            @Override
            public int func_196052_a(int x, int y, int z) {
                return z;
            }

            @Override
            public double func_196051_a(double x, double y, double z) {
                return z;
            }
        };

        private static final Map<String, Axis> field_176725_d;
        private final String field_176726_e;

        private Axis(String nameIn) {
            this.field_176726_e = nameIn;
        }

        @Nullable
        public static Axis func_176717_a(String name) {
            return field_176725_d.get(name.toLowerCase(Locale.ROOT));
        }

        public String func_176719_a() {
            return this.field_176726_e;
        }

        public boolean func_200128_b() {
            return this == Y;
        }

        public boolean func_176722_c() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.field_176726_e;
        }

        public static Axis func_218393_a(Random p_218393_0_) {
            return Axis.values()[p_218393_0_.nextInt(Axis.values().length)];
        }

        @Override
        public boolean test(@Nullable Direction p_test_1_) {
            return p_test_1_ != null && p_test_1_.func_176740_k() == this;
        }

        public Plane func_176716_d() {
            switch (this) {
                case X: 
                case Z: {
                    return Plane.HORIZONTAL;
                }
                case Y: {
                    return Plane.VERTICAL;
                }
            }
            throw new Error("Someone's been tampering with the universe!");
        }

        public String func_176610_l() {
            return this.field_176726_e;
        }

        public abstract int func_196052_a(int var1, int var2, int var3);

        public abstract double func_196051_a(double var1, double var3, double var5);

        static {
            field_176725_d = Arrays.stream(Axis.values()).collect(Collectors.toMap(Axis::func_176719_a, p_199785_0_ -> p_199785_0_));
        }
    }
}

