/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class StructureStart {
    public static final StructureStart field_214630_a = new StructureStart((Structure)Feature.field_202329_g, 0, 0, Biomes.field_76772_c, MutableBoundingBox.func_78887_a(), 0, 0L){

        @Override
        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
        }
    };
    private final Structure<?> field_214632_e;
    protected final List<StructurePiece> field_75075_a = Lists.newArrayList();
    protected MutableBoundingBox field_75074_b;
    private final int field_143024_c;
    private final int field_143023_d;
    private final Biome field_202505_e;
    private int field_212688_f;
    protected final SharedSeedRandom field_214631_d;

    public StructureStart(Structure<?> p_i51341_1_, int chunkX, int chunkZ, Biome biomeIn, MutableBoundingBox boundsIn, int referenceIn, long seed) {
        this.field_214632_e = p_i51341_1_;
        this.field_143024_c = chunkX;
        this.field_143023_d = chunkZ;
        this.field_212688_f = referenceIn;
        this.field_202505_e = biomeIn;
        this.field_214631_d = new SharedSeedRandom();
        this.field_214631_d.func_202425_c(seed, chunkX, chunkZ);
        this.field_75074_b = boundsIn;
    }

    public abstract void func_214625_a(ChunkGenerator<?> var1, TemplateManager var2, int var3, int var4, Biome var5);

    public MutableBoundingBox func_75071_a() {
        return this.field_75074_b;
    }

    public List<StructurePiece> func_186161_c() {
        return this.field_75075_a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_75068_a(IWorld worldIn, Random rand, MutableBoundingBox structurebb, ChunkPos pos) {
        List<StructurePiece> list = this.field_75075_a;
        synchronized (list) {
            Iterator<StructurePiece> iterator = this.field_75075_a.iterator();
            while (iterator.hasNext()) {
                StructurePiece structurepiece = iterator.next();
                if (!structurepiece.func_74874_b().func_78884_a(structurebb) || structurepiece.func_74875_a(worldIn, rand, structurebb, pos)) continue;
                iterator.remove();
            }
            this.func_202500_a();
        }
    }

    protected void func_202500_a() {
        this.field_75074_b = MutableBoundingBox.func_78887_a();
        for (StructurePiece structurepiece : this.field_75075_a) {
            this.field_75074_b.func_78888_b(structurepiece.func_74874_b());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundNBT func_143021_a(int chunkX, int chunkZ) {
        CompoundNBT compoundnbt = new CompoundNBT();
        if (this.func_75069_d()) {
            if (Registry.field_218361_B.func_177774_c(this.func_214627_k()) == null) {
                throw new RuntimeException("StructureStart \"" + this.getClass().getName() + "\": \"" + this.func_214627_k() + "\" missing ID Mapping, Modder see MapGenStructureIO");
            }
            compoundnbt.func_74778_a("id", Registry.field_218361_B.func_177774_c(this.func_214627_k()).toString());
            compoundnbt.func_74778_a("biome", Registry.field_212624_m.func_177774_c(this.field_202505_e).toString());
            compoundnbt.func_74768_a("ChunkX", chunkX);
            compoundnbt.func_74768_a("ChunkZ", chunkZ);
            compoundnbt.func_74768_a("references", this.field_212688_f);
            compoundnbt.func_218657_a("BB", (INBT)this.field_75074_b.func_151535_h());
            ListNBT lvt_4_1_ = new ListNBT();
            List<StructurePiece> list = this.field_75075_a;
            synchronized (list) {
                for (StructurePiece structurepiece : this.field_75075_a) {
                    lvt_4_1_.add((Object)structurepiece.func_143010_b());
                }
            }
            compoundnbt.func_218657_a("Children", (INBT)lvt_4_1_);
            return compoundnbt;
        }
        compoundnbt.func_74778_a("id", "INVALID");
        return compoundnbt;
    }

    protected void func_214628_a(int p_214628_1_, Random p_214628_2_, int p_214628_3_) {
        int i = p_214628_1_ - p_214628_3_;
        int j = this.field_75074_b.func_78882_c() + 1;
        if (j < i) {
            j += p_214628_2_.nextInt(i - j);
        }
        int k = j - this.field_75074_b.field_78894_e;
        this.field_75074_b.func_78886_a(0, k, 0);
        for (StructurePiece structurepiece : this.field_75075_a) {
            structurepiece.func_181138_a(0, k, 0);
        }
    }

    protected void func_214626_a(Random p_214626_1_, int p_214626_2_, int p_214626_3_) {
        int i = p_214626_3_ - p_214626_2_ + 1 - this.field_75074_b.func_78882_c();
        int j = i > 1 ? p_214626_2_ + p_214626_1_.nextInt(i) : p_214626_2_;
        int k = j - this.field_75074_b.field_78895_b;
        this.field_75074_b.func_78886_a(0, k, 0);
        for (StructurePiece structurepiece : this.field_75075_a) {
            structurepiece.func_181138_a(0, k, 0);
        }
    }

    public boolean func_75069_d() {
        return !this.field_75075_a.isEmpty();
    }

    public int func_143019_e() {
        return this.field_143024_c;
    }

    public int func_143018_f() {
        return this.field_143023_d;
    }

    public BlockPos func_204294_a() {
        return new BlockPos(this.field_143024_c << 4, 0, this.field_143023_d << 4);
    }

    public boolean func_212687_g() {
        return this.field_212688_f < this.func_212686_i();
    }

    public void func_212685_h() {
        ++this.field_212688_f;
    }

    protected int func_212686_i() {
        return 1;
    }

    public Structure<?> func_214627_k() {
        return this.field_214632_e;
    }
}

