/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class FlowingFluidBlock
extends Block
implements IBucketPickupHandler {
    public static final IntegerProperty field_176367_b = BlockStateProperties.field_208132_ag;
    private final FlowingFluid field_204517_c;
    private final List<IFluidState> field_212565_c;
    private final Supplier<? extends Fluid> supplier;
    private boolean fluidStateCacheInitialized = false;

    @Deprecated
    protected FlowingFluidBlock(FlowingFluid fluidIn, Block.Properties builder) {
        super(builder);
        this.field_204517_c = fluidIn;
        this.field_212565_c = Lists.newArrayList();
        this.field_212565_c.add(fluidIn.func_207204_a(false));
        for (int i = 1; i < 8; ++i) {
            this.field_212565_c.add(fluidIn.func_207207_a(8 - i, false));
        }
        this.field_212565_c.add(fluidIn.func_207207_a(8, true));
        this.func_180632_j((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176367_b, Integer.valueOf(0))));
        this.fluidStateCacheInitialized = true;
        this.supplier = fluidIn.delegate;
    }

    public FlowingFluidBlock(Supplier<? extends FlowingFluid> supplier, Block.Properties p_i48368_1_) {
        super(p_i48368_1_);
        this.field_204517_c = null;
        this.field_212565_c = Lists.newArrayList();
        this.func_180632_j((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176367_b, Integer.valueOf(0))));
        this.supplier = supplier;
    }

    @Override
    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        p_225542_2_.func_204610_c(p_225542_3_).func_206891_b(p_225542_2_, p_225542_3_, p_225542_4_);
    }

    @Override
    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return !this.field_204517_c.func_207185_a(FluidTags.field_206960_b);
    }

    @Override
    public IFluidState func_204507_t(BlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)field_176367_b);
        if (!this.fluidStateCacheInitialized) {
            this.initFluidStateCache();
        }
        return this.field_212565_c.get(Math.min(i, 8));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_204520_s().func_206886_c().func_207187_a((Fluid)this.field_204517_c);
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Collections.emptyList();
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    @Override
    public int func_149738_a(IWorldReader worldIn) {
        return this.field_204517_c.func_205569_a(worldIn);
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.func_204515_c(worldIn, pos, state)) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)state.func_204520_s().func_206886_c(), this.func_149738_a(worldIn));
        }
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.func_204520_s().func_206889_d() || facingState.func_204520_s().func_206889_d()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)stateIn.func_204520_s().func_206886_c(), this.func_149738_a(worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (this.func_204515_c(worldIn, pos, state)) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)state.func_204520_s().func_206886_c(), this.func_149738_a(worldIn));
        }
    }

    public boolean func_204515_c(World worldIn, BlockPos pos, BlockState state) {
        if (this.field_204517_c.func_207185_a(FluidTags.field_206960_b)) {
            boolean flag = false;
            for (Direction direction : Direction.values()) {
                if (direction == Direction.DOWN || !worldIn.func_204610_c(pos.func_177972_a(direction)).func_206884_a(FluidTags.field_206959_a)) continue;
                flag = true;
                break;
            }
            if (flag) {
                IFluidState ifluidstate = worldIn.func_204610_c(pos);
                if (ifluidstate.func_206889_d()) {
                    worldIn.func_175656_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)worldIn, (BlockPos)pos, (BlockPos)pos, (BlockState)Blocks.field_150343_Z.func_176223_P()));
                    this.func_180688_d(worldIn, pos);
                    return false;
                }
                if (ifluidstate.func_215679_a((IBlockReader)((Object)worldIn), pos) >= 0.44444445f) {
                    worldIn.func_175656_a(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)worldIn, (BlockPos)pos, (BlockPos)pos, (BlockState)Blocks.field_150347_e.func_176223_P()));
                    this.func_180688_d(worldIn, pos);
                    return false;
                }
            }
        }
        return true;
    }

    private void func_180688_d(IWorld worldIn, BlockPos pos) {
        worldIn.func_217379_c(1501, pos, 0);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176367_b});
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        if ((Integer)state.func_177229_b((IProperty)field_176367_b) == 0) {
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            return this.field_204517_c;
        }
        return Fluids.field_204541_a;
    }

    @Override
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (this.field_204517_c.func_207185_a(FluidTags.field_206960_b)) {
            entityIn.func_213292_aB();
        }
    }

    public FlowingFluid getFluid() {
        return (FlowingFluid)this.supplier.get();
    }

    protected synchronized void initFluidStateCache() {
        if (!this.fluidStateCacheInitialized) {
            this.field_212565_c.add(this.getFluid().func_207204_a(false));
            for (int i = 1; i < 8; ++i) {
                this.field_212565_c.add(this.getFluid().func_207207_a(8 - i, false));
            }
            this.field_212565_c.add(this.getFluid().func_207207_a(8, true));
            this.fluidStateCacheInitialized = true;
        }
    }
}

