/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class SugarCaneBlock
extends Block
implements IPlantable {
    public static final IntegerProperty field_176355_a = BlockStateProperties.field_208171_X;
    protected static final VoxelShape field_196503_b = Block.func_208617_a(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);

    protected SugarCaneBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176355_a, Integer.valueOf(0))));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return field_196503_b;
    }

    @Override
    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        if (!p_225534_1_.func_196955_c(p_225534_2_, p_225534_3_)) {
            p_225534_2_.func_175655_b(p_225534_3_, true);
        } else if (p_225534_2_.func_175623_d(p_225534_3_.func_177984_a())) {
            int i = 1;
            while (p_225534_2_.func_180495_p(p_225534_3_.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)p_225534_1_.func_177229_b((IProperty)field_176355_a);
                if (ForgeHooks.onCropsGrowPre((World)p_225534_2_, (BlockPos)p_225534_3_, (BlockState)p_225534_1_, (boolean)true)) {
                    if (j == 15) {
                        p_225534_2_.func_175656_a(p_225534_3_.func_177984_a(), this.func_176223_P());
                        p_225534_2_.func_180501_a(p_225534_3_, (BlockState)((Object)p_225534_1_.func_206870_a((IProperty)field_176355_a, Integer.valueOf(0))), 4);
                    } else {
                        p_225534_2_.func_180501_a(p_225534_3_, (BlockState)((Object)p_225534_1_.func_206870_a((IProperty)field_176355_a, Integer.valueOf(j + 1))), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)p_225534_2_, (BlockPos)p_225534_3_, (BlockState)p_225534_1_);
                }
            }
        }
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c(worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (soil.canSustainPlant((IBlockReader)((Object)worldIn), pos.func_177977_b(), Direction.UP, this)) {
            return true;
        }
        Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (block == this) {
            return true;
        }
        if (block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150354_m || block == Blocks.field_196611_F) {
            BlockPos blockpos = pos.func_177977_b();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockstate = worldIn.func_180495_p(blockpos.func_177972_a(direction));
                IFluidState ifluidstate = worldIn.func_204610_c(blockpos.func_177972_a(direction));
                if (!ifluidstate.func_206884_a(FluidTags.field_206959_a) && blockstate.func_177230_c() != Blocks.field_185778_de) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176355_a});
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.Beach;
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        return this.func_176223_P();
    }
}

