/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.ClipboardHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AccessibilityScreen;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.client.gui.screen.ChatOptionsScreen;
import net.minecraft.client.gui.screen.ControlsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.util.NativeUtil;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class KeyboardListener {
    private final Minecraft field_197972_a;
    private boolean field_197973_b;
    private final ClipboardHelper field_216821_c = new ClipboardHelper();
    private long field_197974_c = -1L;
    private long field_204871_d = -1L;
    private long field_204872_e = -1L;
    private boolean field_197975_d;

    public KeyboardListener(Minecraft mcIn) {
        this.field_197972_a = mcIn;
    }

    private void func_197964_a(String message, Object ... args) {
        this.field_197972_a.field_71456_v.func_146158_b().func_146227_a(new StringTextComponent("").func_150257_a(new TranslationTextComponent("debug.prefix", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.BOLD})).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent(message, args)));
    }

    private void func_204869_b(String message, Object ... args) {
        this.field_197972_a.field_71456_v.func_146158_b().func_146227_a(new StringTextComponent("").func_150257_a(new TranslationTextComponent("debug.prefix", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD})).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent(message, args)));
    }

    private boolean func_197962_c(int key) {
        if (this.field_197974_c > 0L && this.field_197974_c < Util.func_211177_b() - 100L) {
            return true;
        }
        switch (key) {
            case 65: {
                this.field_197972_a.field_71438_f.func_72712_a();
                this.func_197964_a("debug.reload_chunks.message", new Object[0]);
                return true;
            }
            case 66: {
                boolean flag = !this.field_197972_a.func_175598_ae().func_178634_b();
                this.field_197972_a.func_175598_ae().func_178629_b(flag);
                this.func_197964_a(flag ? "debug.show_hitboxes.on" : "debug.show_hitboxes.off", new Object[0]);
                return true;
            }
            case 67: {
                if (this.field_197972_a.field_71439_g.func_175140_cp()) {
                    return false;
                }
                this.func_197964_a("debug.copy_location.message", new Object[0]);
                this.func_197960_a(String.format(Locale.ROOT, "/execute in %s run tp @s %.2f %.2f %.2f %.2f %.2f", DimensionType.func_212678_a(this.field_197972_a.field_71439_g.field_70170_p.field_73011_w.func_186058_p()), this.field_197972_a.field_71439_g.func_226277_ct_(), this.field_197972_a.field_71439_g.func_226278_cu_(), this.field_197972_a.field_71439_g.func_226281_cx_(), Float.valueOf(this.field_197972_a.field_71439_g.field_70177_z), Float.valueOf(this.field_197972_a.field_71439_g.field_70125_A)));
                return true;
            }
            case 68: {
                if (this.field_197972_a.field_71456_v != null) {
                    this.field_197972_a.field_71456_v.func_146158_b().func_146231_a(false);
                }
                return true;
            }
            default: {
                return false;
            }
            case 70: {
                AbstractOption.field_216706_m.func_216727_a(this.field_197972_a.field_71474_y, MathHelper.func_151237_a((double)(this.field_197972_a.field_71474_y.field_151451_c + (Screen.hasShiftDown() ? -1 : 1)), (double)AbstractOption.field_216706_m.func_216732_b(), (double)AbstractOption.field_216706_m.func_216733_c()));
                this.func_197964_a("debug.cycle_renderdistance.message", this.field_197972_a.field_71474_y.field_151451_c);
                return true;
            }
            case 71: {
                boolean flag1 = this.field_197972_a.field_184132_p.func_190075_b();
                this.func_197964_a(flag1 ? "debug.chunk_boundaries.on" : "debug.chunk_boundaries.off", new Object[0]);
                return true;
            }
            case 72: {
                this.field_197972_a.field_71474_y.field_82882_x = !this.field_197972_a.field_71474_y.field_82882_x;
                this.func_197964_a(this.field_197972_a.field_71474_y.field_82882_x ? "debug.advanced_tooltips.on" : "debug.advanced_tooltips.off", new Object[0]);
                this.field_197972_a.field_71474_y.func_74303_b();
                return true;
            }
            case 73: {
                if (!this.field_197972_a.field_71439_g.func_175140_cp()) {
                    this.func_211556_a(this.field_197972_a.field_71439_g.func_211513_k(2), !Screen.hasShiftDown());
                }
                return true;
            }
            case 78: {
                if (!this.field_197972_a.field_71439_g.func_211513_k(2)) {
                    this.func_197964_a("debug.creative_spectator.error", new Object[0]);
                } else if (this.field_197972_a.field_71439_g.func_184812_l_()) {
                    this.field_197972_a.field_71439_g.func_71165_d("/gamemode spectator");
                } else {
                    this.field_197972_a.field_71439_g.func_71165_d("/gamemode creative");
                }
                return true;
            }
            case 80: {
                this.field_197972_a.field_71474_y.field_82881_y = !this.field_197972_a.field_71474_y.field_82881_y;
                this.field_197972_a.field_71474_y.func_74303_b();
                this.func_197964_a(this.field_197972_a.field_71474_y.field_82881_y ? "debug.pause_focus.on" : "debug.pause_focus.off", new Object[0]);
                return true;
            }
            case 81: {
                this.func_197964_a("debug.help.message", new Object[0]);
                NewChatGui newchatgui = this.field_197972_a.field_71456_v.func_146158_b();
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.reload_chunks.help", new Object[0]));
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.show_hitboxes.help", new Object[0]));
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.copy_location.help", new Object[0]));
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.clear_chat.help", new Object[0]));
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.cycle_renderdistance.help", new Object[0]));
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.chunk_boundaries.help", new Object[0]));
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.advanced_tooltips.help", new Object[0]));
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.inspect.help", new Object[0]));
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.creative_spectator.help", new Object[0]));
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.pause_focus.help", new Object[0]));
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.help.help", new Object[0]));
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.reload_resourcepacks.help", new Object[0]));
                newchatgui.func_146227_a((ITextComponent)new TranslationTextComponent("debug.pause.help", new Object[0]));
                return true;
            }
            case 84: 
        }
        this.func_197964_a("debug.reload_resourcepacks.message", new Object[0]);
        this.field_197972_a.func_213237_g();
        return true;
    }

    private void func_211556_a(boolean privileged, boolean askServer) {
        RayTraceResult raytraceresult = this.field_197972_a.field_71476_x;
        if (raytraceresult != null) {
            switch (raytraceresult.func_216346_c()) {
                case BLOCK: {
                    BlockPos blockpos = ((BlockRayTraceResult)raytraceresult).func_216350_a();
                    BlockState blockstate = this.field_197972_a.field_71439_g.field_70170_p.func_180495_p(blockpos);
                    if (privileged) {
                        if (askServer) {
                            this.field_197972_a.field_71439_g.field_71174_a.func_211523_k().func_211547_a(blockpos, p_211561_3_ -> {
                                this.func_211558_a(blockstate, blockpos, (CompoundNBT)p_211561_3_);
                                this.func_197964_a("debug.inspect.server.block", new Object[0]);
                            });
                            break;
                        }
                        TileEntity tileentity = this.field_197972_a.field_71439_g.field_70170_p.func_175625_s(blockpos);
                        CompoundNBT compoundnbt1 = tileentity != null ? tileentity.func_189515_b(new CompoundNBT()) : null;
                        this.func_211558_a(blockstate, blockpos, compoundnbt1);
                        this.func_197964_a("debug.inspect.client.block", new Object[0]);
                        break;
                    }
                    this.func_211558_a(blockstate, blockpos, null);
                    this.func_197964_a("debug.inspect.client.block", new Object[0]);
                    break;
                }
                case ENTITY: {
                    Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                    ResourceLocation resourcelocation = Registry.field_212629_r.func_177774_c(entity.func_200600_R());
                    if (privileged) {
                        if (askServer) {
                            this.field_197972_a.field_71439_g.field_71174_a.func_211523_k().func_211549_a(entity.func_145782_y(), p_227999_3_ -> {
                                this.func_211557_a(resourcelocation, entity.func_213303_ch(), (CompoundNBT)p_227999_3_);
                                this.func_197964_a("debug.inspect.server.entity", new Object[0]);
                            });
                            break;
                        }
                        CompoundNBT compoundnbt = entity.func_189511_e(new CompoundNBT());
                        this.func_211557_a(resourcelocation, entity.func_213303_ch(), compoundnbt);
                        this.func_197964_a("debug.inspect.client.entity", new Object[0]);
                        break;
                    }
                    this.func_211557_a(resourcelocation, entity.func_213303_ch(), null);
                    this.func_197964_a("debug.inspect.client.entity", new Object[0]);
                }
            }
        }
    }

    private void func_211558_a(BlockState state, BlockPos pos, @Nullable CompoundNBT compound) {
        if (compound != null) {
            compound.func_82580_o("x");
            compound.func_82580_o("y");
            compound.func_82580_o("z");
            compound.func_82580_o("id");
        }
        StringBuilder stringbuilder = new StringBuilder(BlockStateParser.func_197247_a(state));
        if (compound != null) {
            stringbuilder.append(compound);
        }
        String s = String.format(Locale.ROOT, "/setblock %d %d %d %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stringbuilder);
        this.func_197960_a(s);
    }

    private void func_211557_a(ResourceLocation entityIdIn, Vec3d pos, @Nullable CompoundNBT compound) {
        String s;
        if (compound != null) {
            compound.func_82580_o("UUIDMost");
            compound.func_82580_o("UUIDLeast");
            compound.func_82580_o("Pos");
            compound.func_82580_o("Dimension");
            String s1 = compound.func_197637_c().getString();
            s = String.format(Locale.ROOT, "/summon %s %.2f %.2f %.2f %s", entityIdIn.toString(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, s1);
        } else {
            s = String.format(Locale.ROOT, "/summon %s %.2f %.2f %.2f", entityIdIn.toString(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
        this.func_197960_a(s);
    }

    public void func_197961_a(long windowPointer, int key, int scanCode, int action, int modifiers) {
        if (windowPointer == this.field_197972_a.func_228018_at_().func_198092_i()) {
            boolean flag;
            if (this.field_197974_c > 0L) {
                if (!InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)67) || !InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)292)) {
                    this.field_197974_c = -1L;
                }
            } else if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)67) && InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)292)) {
                this.field_197975_d = true;
                this.field_197974_c = Util.func_211177_b();
                this.field_204871_d = Util.func_211177_b();
                this.field_204872_e = 0L;
            }
            Screen inestedguieventhandler = this.field_197972_a.field_71462_r;
            if (!(this.field_197972_a.field_71462_r instanceof ControlsScreen) || ((ControlsScreen)((Object)inestedguieventhandler)).field_152177_g <= Util.func_211177_b() - 20L) {
                if (action == 1) {
                    if (this.field_197972_a.field_71474_y.field_152395_am.func_197976_a(key, scanCode)) {
                        this.field_197972_a.func_228018_at_().func_198077_g();
                        this.field_197972_a.field_71474_y.field_74353_u = this.field_197972_a.func_228018_at_().func_198113_j();
                        return;
                    }
                    if (this.field_197972_a.field_71474_y.field_151447_Z.func_197976_a(key, scanCode)) {
                        if (Screen.hasControlDown()) {
                            // empty if block
                        }
                        ScreenShotHelper.func_148260_a(this.field_197972_a.field_71412_D, this.field_197972_a.func_228018_at_().func_198109_k(), this.field_197972_a.func_228018_at_().func_198091_l(), this.field_197972_a.func_147110_a(), p_212449_1_ -> this.field_197972_a.execute(() -> this.field_197972_a.field_71456_v.func_146158_b().func_146227_a(p_212449_1_)));
                        return;
                    }
                } else if (action == 0 && this.field_197972_a.field_71462_r instanceof ControlsScreen) {
                    ((ControlsScreen)((Object)this.field_197972_a.field_71462_r)).field_146491_f = null;
                }
            }
            boolean bl = flag = inestedguieventhandler == null || !(inestedguieventhandler.getFocused() instanceof TextFieldWidget) || !((TextFieldWidget)inestedguieventhandler.getFocused()).func_212955_f();
            if (action != 0 && key == 66 && Screen.hasControlDown() && flag) {
                AbstractOption.field_216715_v.func_216722_a(this.field_197972_a.field_71474_y, 1);
                if (inestedguieventhandler instanceof ChatOptionsScreen) {
                    ((ChatOptionsScreen)inestedguieventhandler).func_193024_a();
                }
                if (inestedguieventhandler instanceof AccessibilityScreen) {
                    ((AccessibilityScreen)inestedguieventhandler).func_212985_a();
                }
            }
            if (inestedguieventhandler != null) {
                boolean[] aboolean = new boolean[]{false};
                Screen.wrapScreenError(() -> this.lambda$onKeyEvent$4(action, aboolean, key, scanCode, modifiers, (INestedGuiEventHandler)inestedguieventhandler), "keyPressed event handler", ((Object)((Object)inestedguieventhandler)).getClass().getCanonicalName());
                if (aboolean[0]) {
                    return;
                }
            }
            if (this.field_197972_a.field_71462_r == null || this.field_197972_a.field_71462_r.passEvents) {
                InputMappings.Input inputmappings$input = InputMappings.func_197954_a((int)key, (int)scanCode);
                if (action == 0) {
                    KeyBinding.func_197980_a(inputmappings$input, false);
                    if (key == 292) {
                        if (this.field_197975_d) {
                            this.field_197975_d = false;
                        } else {
                            this.field_197972_a.field_71474_y.field_74330_P = !this.field_197972_a.field_71474_y.field_74330_P;
                            this.field_197972_a.field_71474_y.field_74329_Q = this.field_197972_a.field_71474_y.field_74330_P && Screen.hasShiftDown();
                            this.field_197972_a.field_71474_y.field_181657_aC = this.field_197972_a.field_71474_y.field_74330_P && Screen.hasAltDown();
                        }
                    }
                } else {
                    if (key == 293 && this.field_197972_a.field_71460_t != null) {
                        this.field_197972_a.field_71460_t.func_175071_c();
                    }
                    boolean flag1 = false;
                    if (this.field_197972_a.field_71462_r == null) {
                        if (key == 256) {
                            boolean flag2 = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)292);
                            this.field_197972_a.func_71385_j(flag2);
                        }
                        flag1 = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)292) && this.func_197962_c(key);
                        this.field_197975_d |= flag1;
                        if (key == 290) {
                            boolean bl2 = this.field_197972_a.field_71474_y.field_74319_N = !this.field_197972_a.field_71474_y.field_74319_N;
                        }
                    }
                    if (flag1) {
                        KeyBinding.func_197980_a(inputmappings$input, false);
                    } else {
                        KeyBinding.func_197980_a(inputmappings$input, true);
                        KeyBinding.func_197981_a(inputmappings$input);
                    }
                    if (this.field_197972_a.field_71474_y.field_74329_Q) {
                        if (key == 48) {
                            this.field_197972_a.func_71383_b(0);
                        }
                        for (int i = 0; i < 9; ++i) {
                            if (key != 49 + i) continue;
                            this.field_197972_a.func_71383_b(i + 1);
                        }
                    }
                }
            }
            ForgeHooksClient.fireKeyInput((int)key, (int)scanCode, (int)action, (int)modifiers);
        }
    }

    private void func_197963_a(long windowPointer, int codePoint, int modifiers) {
        Screen iguieventlistener;
        if (windowPointer == this.field_197972_a.func_228018_at_().func_198092_i() && (iguieventlistener = this.field_197972_a.field_71462_r) != null && this.field_197972_a.func_213250_au() == null) {
            if (Character.charCount(codePoint) == 1) {
                Screen.wrapScreenError(() -> this.lambda$onCharEvent$5(codePoint, modifiers, (IGuiEventListener)iguieventlistener), "charTyped event handler", ((Object)((Object)iguieventlistener)).getClass().getCanonicalName());
            } else {
                for (char c0 : Character.toChars(codePoint)) {
                    Screen.wrapScreenError(() -> this.lambda$onCharEvent$6(c0, modifiers, (IGuiEventListener)iguieventlistener), "charTyped event handler", ((Object)((Object)iguieventlistener)).getClass().getCanonicalName());
                }
            }
        }
    }

    public void func_197967_a(boolean p_197967_1_) {
        this.field_197973_b = p_197967_1_;
    }

    public void func_197968_a(long window) {
        InputMappings.func_216505_a((long)window, (p_228001_1_, p_228001_3_, p_228001_4_, p_228001_5_, p_228001_6_) -> this.field_197972_a.execute(() -> this.func_197961_a(p_228001_1_, p_228001_3_, p_228001_4_, p_228001_5_, p_228001_6_)), (p_228000_1_, p_228000_3_, p_228000_4_) -> this.field_197972_a.execute(() -> this.func_197963_a(p_228000_1_, p_228000_3_, p_228000_4_)));
    }

    public String func_197965_a() {
        return this.field_216821_c.func_216487_a(this.field_197972_a.func_228018_at_().func_198092_i(), (p_227998_1_, p_227998_2_) -> {
            if (p_227998_1_ != 65545) {
                this.field_197972_a.func_228018_at_().func_198084_a(p_227998_1_, p_227998_2_);
            }
        });
    }

    public void func_197960_a(String string) {
        this.field_216821_c.func_216489_a(this.field_197972_a.func_228018_at_().func_198092_i(), string);
    }

    public void func_204870_b() {
        if (this.field_197974_c > 0L) {
            long i = Util.func_211177_b();
            long j = 10000L - (i - this.field_197974_c);
            long k = i - this.field_204871_d;
            if (j < 0L) {
                if (Screen.hasControlDown()) {
                    NativeUtil.func_216393_a();
                }
                throw new ReportedException(new CrashReport("Manually triggered debug crash", new Throwable()));
            }
            if (k >= 1000L) {
                if (this.field_204872_e == 0L) {
                    this.func_197964_a("debug.crash.message", new Object[0]);
                } else {
                    this.func_204869_b("debug.crash.warning", MathHelper.func_76123_f((float)((float)j / 1000.0f)));
                }
                this.field_204871_d = i;
                ++this.field_204872_e;
            }
        }
    }

    private /* synthetic */ void lambda$onCharEvent$6(char c0, int modifiers, IGuiEventListener iguieventlistener) {
        if (ForgeHooksClient.onGuiCharTypedPre((Screen)this.field_197972_a.field_71462_r, (char)c0, (int)modifiers)) {
            return;
        }
        if (iguieventlistener.charTyped(c0, modifiers)) {
            return;
        }
        ForgeHooksClient.onGuiCharTypedPost((Screen)this.field_197972_a.field_71462_r, (char)c0, (int)modifiers);
    }

    private /* synthetic */ void lambda$onCharEvent$5(int codePoint, int modifiers, IGuiEventListener iguieventlistener) {
        if (ForgeHooksClient.onGuiCharTypedPre((Screen)this.field_197972_a.field_71462_r, (char)((char)codePoint), (int)modifiers)) {
            return;
        }
        if (iguieventlistener.charTyped((char)codePoint, modifiers)) {
            return;
        }
        ForgeHooksClient.onGuiCharTypedPost((Screen)this.field_197972_a.field_71462_r, (char)((char)codePoint), (int)modifiers);
    }

    private /* synthetic */ void lambda$onKeyEvent$4(int action, boolean[] aboolean, int key, int scanCode, int modifiers, INestedGuiEventHandler inestedguieventhandler) {
        if (!(action == 1 || action == 2 && this.field_197973_b)) {
            if (action == 0) {
                aboolean[0] = ForgeHooksClient.onGuiKeyReleasedPre((Screen)this.field_197972_a.field_71462_r, (int)key, (int)scanCode, (int)modifiers);
                if (!aboolean[0]) {
                    aboolean[0] = inestedguieventhandler.func_223281_a_(key, scanCode, modifiers);
                }
                if (!aboolean[0]) {
                    aboolean[0] = ForgeHooksClient.onGuiKeyReleasedPost((Screen)this.field_197972_a.field_71462_r, (int)key, (int)scanCode, (int)modifiers);
                }
            }
        } else {
            aboolean[0] = ForgeHooksClient.onGuiKeyPressedPre((Screen)this.field_197972_a.field_71462_r, (int)key, (int)scanCode, (int)modifiers);
            if (!aboolean[0]) {
                aboolean[0] = inestedguieventhandler.keyPressed(key, scanCode, modifiers);
            }
            if (!aboolean[0]) {
                aboolean[0] = ForgeHooksClient.onGuiKeyPressedPost((Screen)this.field_197972_a.field_71462_r, (int)key, (int)scanCode, (int)modifiers);
            }
        }
    }
}

