/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.CreativeCraftingListener;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.CreativeSettings;
import net.minecraft.client.settings.HotbarSnapshot;
import net.minecraft.client.util.IMutableSearchTree;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class CreativeScreen
extends DisplayEffectsScreen<CreativeContainer> {
    private static final ResourceLocation field_147061_u = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final Inventory field_195378_x = new Inventory(45);
    private static int field_147058_w = ItemGroup.field_78030_b.func_78021_a();
    private float field_147067_x;
    private boolean field_147066_y;
    private TextFieldWidget field_147062_A;
    @Nullable
    private List<Slot> field_147063_B;
    @Nullable
    private Slot field_147064_C;
    private CreativeCraftingListener field_147059_E;
    private boolean field_195377_F;
    private boolean field_199506_G;
    private final Map<ResourceLocation, Tag<Item>> field_214085_w = Maps.newTreeMap();
    private static int tabPage = 0;
    private int maxPages = 0;

    public CreativeScreen(PlayerEntity player) {
        super(new CreativeContainer(player), player.field_71071_by, (ITextComponent)new StringTextComponent(""));
        player.field_71070_bA = this.field_147002_h;
        this.passEvents = true;
        this.field_147000_g = 136;
        this.field_146999_f = 195;
    }

    @Override
    public void tick() {
        if (!this.minecraft.field_71442_b.func_78758_h()) {
            this.minecraft.func_147108_a((Screen)new InventoryScreen((PlayerEntity)this.minecraft.field_71439_g));
        } else if (this.field_147062_A != null) {
            this.field_147062_A.func_146178_a();
        }
    }

    @Override
    protected void func_184098_a(@Nullable Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (this.func_208018_a(slotIn)) {
            this.field_147062_A.func_146202_e();
            this.field_147062_A.func_146199_i(0);
        }
        boolean flag = type == ClickType.QUICK_MOVE;
        ClickType clickType = type = slotId == -999 && type == ClickType.PICKUP ? ClickType.THROW : type;
        if (slotIn == null && field_147058_w != ItemGroup.field_78036_m.func_78021_a() && type != ClickType.QUICK_CRAFT) {
            PlayerInventory playerinventory1 = this.minecraft.field_71439_g.field_71071_by;
            if (!playerinventory1.func_70445_o().func_190926_b() && this.field_199506_G) {
                if (mouseButton == 0) {
                    this.minecraft.field_71439_g.func_71019_a(playerinventory1.func_70445_o(), true);
                    this.minecraft.field_71442_b.func_78752_a(playerinventory1.func_70445_o());
                    playerinventory1.func_70437_b(ItemStack.field_190927_a);
                }
                if (mouseButton == 1) {
                    ItemStack itemstack6 = playerinventory1.func_70445_o().func_77979_a(1);
                    this.minecraft.field_71439_g.func_71019_a(itemstack6, true);
                    this.minecraft.field_71442_b.func_78752_a(itemstack6);
                }
            }
        } else {
            if (slotIn != null && !slotIn.func_82869_a(this.minecraft.field_71439_g)) {
                return;
            }
            if (slotIn == this.field_147064_C && flag) {
                for (int j = 0; j < this.minecraft.field_71439_g.field_71069_bz.func_75138_a().size(); ++j) {
                    this.minecraft.field_71442_b.func_78761_a(ItemStack.field_190927_a, j);
                }
            } else if (field_147058_w == ItemGroup.field_78036_m.func_78021_a()) {
                if (slotIn == this.field_147064_C) {
                    this.minecraft.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                } else if (type == ClickType.THROW && slotIn != null && slotIn.func_75216_d()) {
                    ItemStack itemstack = slotIn.func_75209_a(mouseButton == 0 ? 1 : slotIn.func_75211_c().func_77976_d());
                    ItemStack itemstack1 = slotIn.func_75211_c();
                    this.minecraft.field_71439_g.func_71019_a(itemstack, true);
                    this.minecraft.field_71442_b.func_78752_a(itemstack);
                    this.minecraft.field_71442_b.func_78761_a(itemstack1, ((CreativeSlot)((CreativeSlot)slotIn)).field_148332_b.field_75222_d);
                } else if (type == ClickType.THROW && !this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    this.minecraft.field_71439_g.func_71019_a(this.minecraft.field_71439_g.field_71071_by.func_70445_o(), true);
                    this.minecraft.field_71442_b.func_78752_a(this.minecraft.field_71439_g.field_71071_by.func_70445_o());
                    this.minecraft.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                } else {
                    this.minecraft.field_71439_g.field_71069_bz.func_184996_a(slotIn == null ? slotId : ((CreativeSlot)((CreativeSlot)slotIn)).field_148332_b.field_75222_d, mouseButton, type, this.minecraft.field_71439_g);
                    this.minecraft.field_71439_g.field_71069_bz.func_75142_b();
                }
            } else if (type != ClickType.QUICK_CRAFT && slotIn.field_75224_c == field_195378_x) {
                PlayerInventory playerinventory = this.minecraft.field_71439_g.field_71071_by;
                ItemStack itemstack5 = playerinventory.func_70445_o();
                ItemStack itemstack7 = slotIn.func_75211_c();
                if (type == ClickType.SWAP) {
                    if (!itemstack7.func_190926_b() && mouseButton >= 0 && mouseButton < 9) {
                        ItemStack itemstack10 = itemstack7.func_77946_l();
                        itemstack10.func_190920_e(itemstack10.func_77976_d());
                        this.minecraft.field_71439_g.field_71071_by.func_70299_a(mouseButton, itemstack10);
                        this.minecraft.field_71439_g.field_71069_bz.func_75142_b();
                    }
                    return;
                }
                if (type == ClickType.CLONE) {
                    if (playerinventory.func_70445_o().func_190926_b() && slotIn.func_75216_d()) {
                        ItemStack itemstack9 = slotIn.func_75211_c().func_77946_l();
                        itemstack9.func_190920_e(itemstack9.func_77976_d());
                        playerinventory.func_70437_b(itemstack9);
                    }
                    return;
                }
                if (type == ClickType.THROW) {
                    if (!itemstack7.func_190926_b()) {
                        ItemStack itemstack8 = itemstack7.func_77946_l();
                        itemstack8.func_190920_e(mouseButton == 0 ? 1 : itemstack8.func_77976_d());
                        this.minecraft.field_71439_g.func_71019_a(itemstack8, true);
                        this.minecraft.field_71442_b.func_78752_a(itemstack8);
                    }
                    return;
                }
                if (!itemstack5.func_190926_b() && !itemstack7.func_190926_b() && itemstack5.func_77969_a(itemstack7) && ItemStack.func_77970_a(itemstack5, itemstack7)) {
                    if (mouseButton == 0) {
                        if (flag) {
                            itemstack5.func_190920_e(itemstack5.func_77976_d());
                        } else if (itemstack5.func_190916_E() < itemstack5.func_77976_d()) {
                            itemstack5.func_190917_f(1);
                        }
                    } else {
                        itemstack5.func_190918_g(1);
                    }
                } else if (!itemstack7.func_190926_b() && itemstack5.func_190926_b()) {
                    playerinventory.func_70437_b(itemstack7.func_77946_l());
                    itemstack5 = playerinventory.func_70445_o();
                    if (flag) {
                        itemstack5.func_190920_e(itemstack5.func_77976_d());
                    }
                } else if (mouseButton == 0) {
                    playerinventory.func_70437_b(ItemStack.field_190927_a);
                } else {
                    playerinventory.func_70445_o().func_190918_g(1);
                }
            } else if (this.field_147002_h != null) {
                ItemStack itemstack3 = slotIn == null ? ItemStack.field_190927_a : ((CreativeContainer)this.field_147002_h).func_75139_a(slotIn.field_75222_d).func_75211_c();
                ((CreativeContainer)this.field_147002_h).func_184996_a(slotIn == null ? slotId : slotIn.field_75222_d, mouseButton, type, this.minecraft.field_71439_g);
                if (Container.func_94532_c(mouseButton) == 2) {
                    for (int k = 0; k < 9; ++k) {
                        this.minecraft.field_71442_b.func_78761_a(((CreativeContainer)this.field_147002_h).func_75139_a(45 + k).func_75211_c(), 36 + k);
                    }
                } else if (slotIn != null) {
                    ItemStack itemstack4 = ((CreativeContainer)this.field_147002_h).func_75139_a(slotIn.field_75222_d).func_75211_c();
                    this.minecraft.field_71442_b.func_78761_a(itemstack4, slotIn.field_75222_d - ((CreativeContainer)this.field_147002_h).field_75151_b.size() + 9 + 36);
                    int i = 45 + mouseButton;
                    if (type == ClickType.SWAP) {
                        this.minecraft.field_71442_b.func_78761_a(itemstack3, i - ((CreativeContainer)this.field_147002_h).field_75151_b.size() + 9 + 36);
                    } else if (type == ClickType.THROW && !itemstack3.func_190926_b()) {
                        ItemStack itemstack2 = itemstack3.func_77946_l();
                        itemstack2.func_190920_e(mouseButton == 0 ? 1 : itemstack2.func_77976_d());
                        this.minecraft.field_71439_g.func_71019_a(itemstack2, true);
                        this.minecraft.field_71442_b.func_78752_a(itemstack2);
                    }
                    this.minecraft.field_71439_g.field_71069_bz.func_75142_b();
                }
            }
        }
    }

    private boolean func_208018_a(@Nullable Slot p_208018_1_) {
        return p_208018_1_ != null && p_208018_1_.field_75224_c == field_195378_x;
    }

    @Override
    protected void func_175378_g() {
        int i = this.field_147003_i;
        super.func_175378_g();
        if (this.field_147062_A != null && this.field_147003_i != i) {
            this.field_147062_A.func_212952_l(this.field_147003_i + 82);
        }
    }

    @Override
    protected void init() {
        if (this.minecraft.field_71442_b.func_78758_h()) {
            super.init();
            this.minecraft.field_195559_v.func_197967_a(true);
            int tabCount = ItemGroup.field_78032_a.length;
            if (tabCount > 12) {
                this.addButton(new Button(this.field_147003_i, this.field_147009_r - 50, 20, 20, "<", b -> {
                    tabPage = Math.max(tabPage - 1, 0);
                }));
                this.addButton(new Button(this.field_147003_i + this.field_146999_f - 20, this.field_147009_r - 50, 20, 20, ">", b -> {
                    tabPage = Math.min(tabPage + 1, this.maxPages);
                }));
                this.maxPages = (int)Math.ceil((double)(tabCount - 12) / 10.0);
            }
            this.field_147062_A = new TextFieldWidget(this.font, this.field_147003_i + 82, this.field_147009_r + 6, 80, 9, I18n.func_135052_a("itemGroup.search", new Object[0]));
            this.field_147062_A.func_146203_f(50);
            this.field_147062_A.func_146185_a(false);
            this.field_147062_A.func_146189_e(false);
            this.field_147062_A.func_146193_g(0xFFFFFF);
            this.children.add(this.field_147062_A);
            int i = field_147058_w;
            field_147058_w = -1;
            this.func_147050_b(ItemGroup.field_78032_a[i]);
            this.minecraft.field_71439_g.field_71069_bz.func_82847_b((IContainerListener)this.field_147059_E);
            this.field_147059_E = new CreativeCraftingListener(this.minecraft);
            this.minecraft.field_71439_g.field_71069_bz.func_75132_a((IContainerListener)this.field_147059_E);
        } else {
            this.minecraft.func_147108_a((Screen)new InventoryScreen((PlayerEntity)this.minecraft.field_71439_g));
        }
    }

    @Override
    public void resize(Minecraft p_resize_1_, int p_resize_2_, int p_resize_3_) {
        String s = this.field_147062_A.func_146179_b();
        this.init(p_resize_1_, p_resize_2_, p_resize_3_);
        this.field_147062_A.func_146180_a(s);
        if (!this.field_147062_A.func_146179_b().isEmpty()) {
            this.func_147053_i();
        }
    }

    @Override
    public void removed() {
        super.removed();
        if (this.minecraft.field_71439_g != null && this.minecraft.field_71439_g.field_71071_by != null) {
            this.minecraft.field_71439_g.field_71069_bz.func_82847_b((IContainerListener)this.field_147059_E);
        }
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.field_195377_F) {
            return false;
        }
        if (!ItemGroup.field_78032_a[field_147058_w].hasSearchBar()) {
            return false;
        }
        String s = this.field_147062_A.func_146179_b();
        if (this.field_147062_A.charTyped(p_charTyped_1_, p_charTyped_2_)) {
            if (!Objects.equals(s, this.field_147062_A.func_146179_b())) {
                this.func_147053_i();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        boolean flag;
        this.field_195377_F = false;
        if (!ItemGroup.field_78032_a[field_147058_w].hasSearchBar()) {
            if (this.minecraft.field_71474_y.field_74310_D.func_197976_a(p_keyPressed_1_, p_keyPressed_2_)) {
                this.field_195377_F = true;
                this.func_147050_b(ItemGroup.field_78027_g);
                return true;
            }
            return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        }
        boolean bl = flag = !this.func_208018_a(this.field_147006_u) || this.field_147006_u != null && this.field_147006_u.func_75216_d();
        if (flag && this.func_195363_d(p_keyPressed_1_, p_keyPressed_2_)) {
            this.field_195377_F = true;
            return true;
        }
        String s = this.field_147062_A.func_146179_b();
        if (this.field_147062_A.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            if (!Objects.equals(s, this.field_147062_A.func_146179_b())) {
                this.func_147053_i();
            }
            return true;
        }
        return this.field_147062_A.isFocused() && this.field_147062_A.func_146176_q() && p_keyPressed_1_ != 256 ? true : super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean func_223281_a_(int p_223281_1_, int p_223281_2_, int p_223281_3_) {
        this.field_195377_F = false;
        return super.func_223281_a_(p_223281_1_, p_223281_2_, p_223281_3_);
    }

    private void func_147053_i() {
        ((CreativeContainer)this.field_147002_h).field_148330_a.clear();
        this.field_214085_w.clear();
        ItemGroup tab = ItemGroup.field_78032_a[field_147058_w];
        if (tab.hasSearchBar() && tab != ItemGroup.field_78027_g) {
            tab.func_78018_a(((CreativeContainer)this.field_147002_h).field_148330_a);
            if (!this.field_147062_A.func_146179_b().isEmpty()) {
                String search = this.field_147062_A.func_146179_b().toLowerCase(Locale.ROOT);
                Iterator itr = ((CreativeContainer)this.field_147002_h).field_148330_a.iterator();
                while (itr.hasNext()) {
                    ItemStack stack = (ItemStack)((Object)itr.next());
                    boolean matches = false;
                    for (ITextComponent line : stack.func_82840_a(this.minecraft.field_71439_g, (ITooltipFlag)(this.minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL))) {
                        if (!TextFormatting.func_110646_a((String)line.getString()).toLowerCase(Locale.ROOT).contains(search)) continue;
                        matches = true;
                        break;
                    }
                    if (matches) continue;
                    itr.remove();
                }
            }
            this.field_147067_x = 0.0f;
            ((CreativeContainer)this.field_147002_h).func_148329_a(0.0f);
            return;
        }
        String s = this.field_147062_A.func_146179_b();
        if (s.isEmpty()) {
            for (Item item : Registry.field_212630_s) {
                item.func_150895_a(ItemGroup.field_78027_g, ((CreativeContainer)this.field_147002_h).field_148330_a);
            }
        } else {
            IMutableSearchTree<ItemStack> isearchtree;
            if (s.startsWith("#")) {
                s = s.substring(1);
                isearchtree = this.minecraft.func_213253_a(SearchTreeManager.field_215360_b);
                this.func_214080_a(s);
            } else {
                isearchtree = this.minecraft.func_213253_a(SearchTreeManager.field_215359_a);
            }
            ((CreativeContainer)this.field_147002_h).field_148330_a.addAll((Collection)isearchtree.func_194038_a(s.toLowerCase(Locale.ROOT)));
        }
        this.field_147067_x = 0.0f;
        ((CreativeContainer)this.field_147002_h).func_148329_a(0.0f);
    }

    private void func_214080_a(String search) {
        Predicate<ResourceLocation> predicate;
        int i = search.indexOf(58);
        if (i == -1) {
            predicate = p_214084_1_ -> p_214084_1_.func_110623_a().contains(search);
        } else {
            String s = search.substring(0, i).trim();
            String s1 = search.substring(i + 1).trim();
            predicate = p_214081_2_ -> p_214081_2_.func_110624_b().contains(s) && p_214081_2_.func_110623_a().contains(s1);
        }
        TagCollection<Item> tagcollection = ItemTags.func_199903_a();
        tagcollection.func_199908_a().stream().filter(predicate).forEach(p_214082_2_ -> {
            Tag tag = this.field_214085_w.put((ResourceLocation)p_214082_2_, tagcollection.func_199910_a((ResourceLocation)p_214082_2_));
        });
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        ItemGroup itemgroup = ItemGroup.field_78032_a[field_147058_w];
        if (itemgroup != null && itemgroup.func_78019_g()) {
            RenderSystem.disableBlend();
            this.font.func_211126_b(I18n.func_135052_a(itemgroup.func_78024_c(), new Object[0]), 8.0f, 6.0f, itemgroup.getLabelColor());
        }
    }

    @Override
    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (p_mouseClicked_5_ == 0) {
            double d0 = p_mouseClicked_1_ - (double)this.field_147003_i;
            double d1 = p_mouseClicked_3_ - (double)this.field_147009_r;
            for (ItemGroup itemgroup : ItemGroup.field_78032_a) {
                if (itemgroup == null || !this.func_195375_a(itemgroup, d0, d1)) continue;
                return true;
            }
            if (field_147058_w != ItemGroup.field_78036_m.func_78021_a() && this.func_195376_a(p_mouseClicked_1_, p_mouseClicked_3_)) {
                this.field_147066_y = this.func_147055_p();
                return true;
            }
        }
        return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    @Override
    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (p_mouseReleased_5_ == 0) {
            double d0 = p_mouseReleased_1_ - (double)this.field_147003_i;
            double d1 = p_mouseReleased_3_ - (double)this.field_147009_r;
            this.field_147066_y = false;
            for (ItemGroup itemgroup : ItemGroup.field_78032_a) {
                if (itemgroup == null || !this.func_195375_a(itemgroup, d0, d1)) continue;
                this.func_147050_b(itemgroup);
                return true;
            }
        }
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    private boolean func_147055_p() {
        if (ItemGroup.field_78032_a[field_147058_w] == null) {
            return false;
        }
        return field_147058_w != ItemGroup.field_78036_m.func_78021_a() && ItemGroup.field_78032_a[field_147058_w].func_78017_i() && ((CreativeContainer)this.field_147002_h).func_148328_e();
    }

    private void func_147050_b(ItemGroup tab) {
        if (tab == null) {
            return;
        }
        int i = field_147058_w;
        field_147058_w = tab.func_78021_a();
        this.slotColor = tab.getSlotColor();
        this.field_147008_s.clear();
        ((CreativeContainer)this.field_147002_h).field_148330_a.clear();
        if (tab == ItemGroup.field_192395_m) {
            CreativeSettings creativesettings = this.minecraft.func_199403_al();
            for (int j = 0; j < 9; ++j) {
                HotbarSnapshot hotbarsnapshot = creativesettings.func_192563_a(j);
                if (hotbarsnapshot.isEmpty()) {
                    for (int k = 0; k < 9; ++k) {
                        if (k == j) {
                            ItemStack itemstack = new ItemStack(Items.field_151121_aF);
                            itemstack.func_190925_c("CustomCreativeLock");
                            String s = this.minecraft.field_71474_y.field_151456_ac[j].func_197978_k();
                            String s1 = this.minecraft.field_71474_y.field_193629_ap.func_197978_k();
                            itemstack.func_200302_a((ITextComponent)new TranslationTextComponent("inventory.hotbarInfo", s1, s));
                            ((CreativeContainer)this.field_147002_h).field_148330_a.add((Object)itemstack);
                            continue;
                        }
                        ((CreativeContainer)this.field_147002_h).field_148330_a.add((Object)ItemStack.field_190927_a);
                    }
                    continue;
                }
                ((CreativeContainer)this.field_147002_h).field_148330_a.addAll((Collection)hotbarsnapshot);
            }
        } else if (tab != ItemGroup.field_78027_g) {
            tab.func_78018_a(((CreativeContainer)this.field_147002_h).field_148330_a);
        }
        if (tab == ItemGroup.field_78036_m) {
            PlayerContainer container = this.minecraft.field_71439_g.field_71069_bz;
            if (this.field_147063_B == null) {
                this.field_147063_B = ImmutableList.copyOf((Collection)((CreativeContainer)this.field_147002_h).field_75151_b);
            }
            ((CreativeContainer)this.field_147002_h).field_75151_b.clear();
            for (int l = 0; l < container.field_75151_b.size(); ++l) {
                int j1;
                int i1;
                if (l >= 5 && l < 9) {
                    int l1 = l - 5;
                    int j2 = l1 / 2;
                    int l2 = l1 % 2;
                    i1 = 54 + j2 * 54;
                    j1 = 6 + l2 * 27;
                } else if (l >= 0 && l < 5) {
                    i1 = -2000;
                    j1 = -2000;
                } else if (l == 45) {
                    i1 = 35;
                    j1 = 20;
                } else {
                    int k1 = l - 9;
                    int i2 = k1 % 9;
                    int k2 = k1 / 9;
                    i1 = 9 + i2 * 18;
                    j1 = l >= 36 ? 112 : 54 + k2 * 18;
                }
                CreativeSlot slot = new CreativeSlot(container.field_75151_b.get(l), l, i1, j1);
                ((CreativeContainer)this.field_147002_h).field_75151_b.add(slot);
            }
            this.field_147064_C = new Slot((IInventory)field_195378_x, 0, 173, 112);
            ((CreativeContainer)this.field_147002_h).field_75151_b.add(this.field_147064_C);
        } else if (i == ItemGroup.field_78036_m.func_78021_a()) {
            ((CreativeContainer)this.field_147002_h).field_75151_b.clear();
            ((CreativeContainer)this.field_147002_h).field_75151_b.addAll(this.field_147063_B);
            this.field_147063_B = null;
        }
        if (this.field_147062_A != null) {
            if (tab.hasSearchBar()) {
                this.field_147062_A.func_146189_e(true);
                this.field_147062_A.func_146205_d(false);
                this.field_147062_A.func_146195_b(true);
                if (i != tab.func_78021_a()) {
                    this.field_147062_A.func_146180_a("");
                }
                this.field_147062_A.setWidth(tab.getSearchbarWidth());
                this.field_147062_A.x = this.field_147003_i + 171 - this.field_147062_A.getWidth();
                this.func_147053_i();
            } else {
                this.field_147062_A.func_146189_e(false);
                this.field_147062_A.func_146205_d(true);
                this.field_147062_A.func_146195_b(false);
                this.field_147062_A.func_146180_a("");
            }
        }
        this.field_147067_x = 0.0f;
        ((CreativeContainer)this.field_147002_h).func_148329_a(0.0f);
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.func_147055_p()) {
            return false;
        }
        int i = (((CreativeContainer)this.field_147002_h).field_148330_a.size() + 9 - 1) / 9 - 5;
        this.field_147067_x = (float)((double)this.field_147067_x - p_mouseScrolled_5_ / (double)i);
        this.field_147067_x = MathHelper.func_76131_a((float)this.field_147067_x, (float)0.0f, (float)1.0f);
        ((CreativeContainer)this.field_147002_h).func_148329_a(this.field_147067_x);
        return true;
    }

    @Override
    protected boolean func_195361_a(double p_195361_1_, double p_195361_3_, int p_195361_5_, int p_195361_6_, int p_195361_7_) {
        boolean flag = p_195361_1_ < (double)p_195361_5_ || p_195361_3_ < (double)p_195361_6_ || p_195361_1_ >= (double)(p_195361_5_ + this.field_146999_f) || p_195361_3_ >= (double)(p_195361_6_ + this.field_147000_g);
        this.field_199506_G = flag && !this.func_195375_a(ItemGroup.field_78032_a[field_147058_w], p_195361_1_, p_195361_3_);
        return this.field_199506_G;
    }

    protected boolean func_195376_a(double p_195376_1_, double p_195376_3_) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int k = i + 175;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + 112;
        return p_195376_1_ >= (double)k && p_195376_3_ >= (double)l && p_195376_1_ < (double)i1 && p_195376_3_ < (double)j1;
    }

    @Override
    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.field_147066_y) {
            int i = this.field_147009_r + 18;
            int j = i + 112;
            this.field_147067_x = ((float)p_mouseDragged_3_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.field_147067_x = MathHelper.func_76131_a((float)this.field_147067_x, (float)0.0f, (float)1.0f);
            ((CreativeContainer)this.field_147002_h).func_148329_a(this.field_147067_x);
            return true;
        }
        return super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    @Override
    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        super.render(p_render_1_, p_render_2_, p_render_3_);
        int start = tabPage * 10;
        int end = Math.min(ItemGroup.field_78032_a.length, (tabPage + 1) * 10 + 2);
        if (tabPage != 0) {
            start += 2;
        }
        boolean rendered = false;
        for (int x = start; x < end; ++x) {
            ItemGroup itemgroup = ItemGroup.field_78032_a[x];
            if (itemgroup == null || !this.func_147052_b(itemgroup, p_render_1_, p_render_2_)) continue;
            rendered = true;
            break;
        }
        if (!rendered && !this.func_147052_b(ItemGroup.field_78027_g, p_render_1_, p_render_2_)) {
            this.func_147052_b(ItemGroup.field_78036_m, p_render_1_, p_render_2_);
        }
        if (this.field_147064_C != null && field_147058_w == ItemGroup.field_78036_m.func_78021_a() && this.func_195359_a(this.field_147064_C.field_75223_e, this.field_147064_C.field_75221_f, 16, 16, p_render_1_, p_render_2_)) {
            this.renderTooltip(I18n.func_135052_a("inventory.binSlot", new Object[0]), p_render_1_, p_render_2_);
        }
        if (this.maxPages != 0) {
            String page = String.format("%d / %d", tabPage + 1, this.maxPages + 1);
            RenderSystem.disableLighting();
            this.setBlitOffset(300);
            this.itemRenderer.field_77023_b = 300.0f;
            this.font.func_211126_b(page, (float)(this.field_147003_i + this.field_146999_f / 2 - this.font.func_78256_a(page) / 2), (float)(this.field_147009_r - 44), -1);
            this.setBlitOffset(0);
            this.itemRenderer.field_77023_b = 0.0f;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_191948_b(p_render_1_, p_render_2_);
    }

    @Override
    protected void renderTooltip(ItemStack p_renderTooltip_1_, int p_renderTooltip_2_, int p_renderTooltip_3_) {
        if (field_147058_w == ItemGroup.field_78027_g.func_78021_a()) {
            Map<Enchantment, Integer> map;
            List<ITextComponent> list = p_renderTooltip_1_.func_82840_a(this.minecraft.field_71439_g, (ITooltipFlag)(this.minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            ArrayList list1 = Lists.newArrayListWithCapacity((int)list.size());
            for (ITextComponent itextcomponent : list) {
                list1.add(itextcomponent.func_150254_d());
            }
            Item item = p_renderTooltip_1_.func_77973_b();
            ItemGroup itemgroup1 = item.func_77640_w();
            if (itemgroup1 == null && item == Items.field_151134_bR && (map = EnchantmentHelper.func_82781_a(p_renderTooltip_1_)).size() == 1) {
                Enchantment enchantment = map.keySet().iterator().next();
                for (ItemGroup itemgroup : ItemGroup.field_78032_a) {
                    if (!itemgroup.func_111226_a(enchantment.field_77351_y)) continue;
                    itemgroup1 = itemgroup;
                    break;
                }
            }
            this.field_214085_w.forEach((p_214083_2_, p_214083_3_) -> {
                if (p_214083_3_.func_199685_a_(item)) {
                    list1.add(1, "" + TextFormatting.BOLD + TextFormatting.DARK_PURPLE + "#" + p_214083_2_);
                }
            });
            if (itemgroup1 != null) {
                list1.add(1, "" + TextFormatting.BOLD + TextFormatting.BLUE + I18n.func_135052_a(itemgroup1.func_78024_c(), new Object[0]));
            }
            for (int i = 0; i < list1.size(); ++i) {
                if (i == 0) {
                    list1.set(i, p_renderTooltip_1_.func_77953_t().field_77937_e + (String)list1.get(i));
                    continue;
                }
                list1.set(i, TextFormatting.GRAY + (String)list1.get(i));
            }
            FontRenderer font = p_renderTooltip_1_.func_77973_b().getFontRenderer(p_renderTooltip_1_);
            GuiUtils.preItemToolTip((ItemStack)p_renderTooltip_1_);
            this.renderTooltip(list1, p_renderTooltip_2_, p_renderTooltip_3_, font == null ? this.font : font);
            GuiUtils.postItemToolTip();
        } else {
            super.renderTooltip(p_renderTooltip_1_, p_renderTooltip_2_, p_renderTooltip_3_);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemGroup itemgroup = ItemGroup.field_78032_a[field_147058_w];
        int start = tabPage * 10;
        int end = Math.min(ItemGroup.field_78032_a.length, (tabPage + 1) * 10 + 2);
        if (tabPage != 0) {
            start += 2;
        }
        for (int idx = start; idx < end; ++idx) {
            ItemGroup itemgroup1 = ItemGroup.field_78032_a[idx];
            if (itemgroup1 == null || itemgroup1.func_78021_a() == field_147058_w) continue;
            this.minecraft.func_110434_K().func_110577_a(itemgroup1.getTabsImage());
            this.func_147051_a(itemgroup1);
        }
        if (tabPage != 0) {
            if (itemgroup != ItemGroup.field_78027_g) {
                this.minecraft.func_110434_K().func_110577_a(ItemGroup.field_78027_g.getTabsImage());
                this.func_147051_a(ItemGroup.field_78027_g);
            }
            if (itemgroup != ItemGroup.field_78036_m) {
                this.minecraft.func_110434_K().func_110577_a(ItemGroup.field_78036_m.getTabsImage());
                this.func_147051_a(ItemGroup.field_78036_m);
            }
        }
        this.minecraft.func_110434_K().func_110577_a(itemgroup.getBackgroundImage());
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_147062_A.render(mouseX, mouseY, partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.field_147003_i + 175;
        int j = this.field_147009_r + 18;
        int k = j + 112;
        this.minecraft.func_110434_K().func_110577_a(itemgroup.getTabsImage());
        if (itemgroup.func_78017_i()) {
            this.blit(i, j + (int)((float)(k - j - 17) * this.field_147067_x), 232 + (this.func_147055_p() ? 0 : 12), 0, 12, 15);
        }
        if ((itemgroup == null || itemgroup.getTabPage() != tabPage) && itemgroup != ItemGroup.field_78027_g && itemgroup != ItemGroup.field_78036_m) {
            return;
        }
        this.func_147051_a(itemgroup);
        if (itemgroup == ItemGroup.field_78036_m) {
            InventoryScreen.func_228187_a_((int)(this.field_147003_i + 88), (int)(this.field_147009_r + 45), (int)20, (float)(this.field_147003_i + 88 - mouseX), (float)(this.field_147009_r + 45 - 30 - mouseY), (LivingEntity)this.minecraft.field_71439_g);
        }
    }

    protected boolean func_195375_a(ItemGroup p_195375_1_, double p_195375_2_, double p_195375_4_) {
        if (p_195375_1_.getTabPage() != tabPage && p_195375_1_ != ItemGroup.field_78027_g && p_195375_1_ != ItemGroup.field_78036_m) {
            return false;
        }
        int i = p_195375_1_.func_78020_k();
        int j = 28 * i;
        int k = 0;
        if (p_195375_1_.func_192394_m()) {
            j = this.field_146999_f - 28 * (6 - i) + 2;
        } else if (i > 0) {
            j += i;
        }
        k = p_195375_1_.func_78023_l() ? (k -= 32) : (k += this.field_147000_g);
        return p_195375_2_ >= (double)j && p_195375_2_ <= (double)(j + 28) && p_195375_4_ >= (double)k && p_195375_4_ <= (double)(k + 32);
    }

    protected boolean func_147052_b(ItemGroup tab, int mouseX, int mouseY) {
        int i = tab.func_78020_k();
        int j = 28 * i;
        int k = 0;
        if (tab.func_192394_m()) {
            j = this.field_146999_f - 28 * (6 - i) + 2;
        } else if (i > 0) {
            j += i;
        }
        k = tab.func_78023_l() ? (k -= 32) : (k += this.field_147000_g);
        if (this.func_195359_a(j + 3, k + 3, 23, 27, mouseX, mouseY)) {
            this.renderTooltip(I18n.func_135052_a(tab.func_78024_c(), new Object[0]), mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected void func_147051_a(ItemGroup tab) {
        boolean flag = tab.func_78021_a() == field_147058_w;
        boolean flag1 = tab.func_78023_l();
        int i = tab.func_78020_k();
        int j = i * 28;
        int k = 0;
        int l = this.field_147003_i + 28 * i;
        int i1 = this.field_147009_r;
        int j1 = 32;
        if (flag) {
            k += 32;
        }
        if (tab.func_192394_m()) {
            l = this.field_147003_i + this.field_146999_f - 28 * (6 - i);
        } else if (i > 0) {
            l += i;
        }
        if (flag1) {
            i1 -= 28;
        } else {
            k += 64;
            i1 += this.field_147000_g - 4;
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        this.blit(l, i1, j, k, 28, 32);
        this.setBlitOffset(100);
        this.itemRenderer.field_77023_b = 100.0f;
        i1 = i1 + 8 + (flag1 ? 1 : -1);
        RenderSystem.enableRescaleNormal();
        ItemStack itemstack = tab.func_151244_d();
        this.itemRenderer.func_180450_b(itemstack, l += 6, i1);
        this.itemRenderer.func_175030_a(this.font, itemstack, l, i1);
        this.itemRenderer.field_77023_b = 0.0f;
        this.setBlitOffset(0);
    }

    public int func_147056_g() {
        return field_147058_w;
    }

    public static void func_192044_a(Minecraft client, int index, boolean load, boolean save) {
        ClientPlayerEntity clientplayerentity = client.field_71439_g;
        CreativeSettings creativesettings = client.func_199403_al();
        HotbarSnapshot hotbarsnapshot = creativesettings.func_192563_a(index);
        if (load) {
            for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
                ItemStack itemstack = ((ItemStack)((Object)hotbarsnapshot.get(i))).func_77946_l();
                clientplayerentity.field_71071_by.func_70299_a(i, itemstack);
                client.field_71442_b.func_78761_a(itemstack, 36 + i);
            }
            clientplayerentity.field_71069_bz.func_75142_b();
        } else if (save) {
            for (int j = 0; j < PlayerInventory.func_70451_h(); ++j) {
                hotbarsnapshot.set(j, (Object)clientplayerentity.field_71071_by.func_70301_a(j).func_77946_l());
            }
            String s = client.field_71474_y.field_151456_ac[index].func_197978_k();
            String s1 = client.field_71474_y.field_193630_aq.func_197978_k();
            client.field_71456_v.func_175188_a((ITextComponent)new TranslationTextComponent("inventory.hotbarSaved", s1, s), false);
            creativesettings.func_192564_b();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class LockedSlot
    extends Slot {
        public LockedSlot(IInventory p_i47453_1_, int p_i47453_2_, int p_i47453_3_, int p_i47453_4_) {
            super(p_i47453_1_, p_i47453_2_, p_i47453_3_, p_i47453_4_);
        }

        @Override
        public boolean func_82869_a(PlayerEntity playerIn) {
            if (super.func_82869_a(playerIn) && this.func_75216_d()) {
                return this.func_75211_c().func_179543_a("CustomCreativeLock") == null;
            }
            return !this.func_75216_d();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CreativeSlot
    extends Slot {
        private final Slot field_148332_b;

        public CreativeSlot(Slot p_i229959_1_, int p_i229959_2_, int p_i229959_3_, int p_i229959_4_) {
            super(p_i229959_1_.field_75224_c, p_i229959_2_, p_i229959_3_, p_i229959_4_);
            this.field_148332_b = p_i229959_1_;
        }

        @Override
        public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
            return this.field_148332_b.func_190901_a(thePlayer, stack);
        }

        @Override
        public boolean func_75214_a(ItemStack stack) {
            return this.field_148332_b.func_75214_a(stack);
        }

        @Override
        public ItemStack func_75211_c() {
            return this.field_148332_b.func_75211_c();
        }

        @Override
        public boolean func_75216_d() {
            return this.field_148332_b.func_75216_d();
        }

        @Override
        public void func_75215_d(ItemStack stack) {
            this.field_148332_b.func_75215_d(stack);
        }

        @Override
        public void func_75218_e() {
            this.field_148332_b.func_75218_e();
        }

        @Override
        public int func_75219_a() {
            return this.field_148332_b.func_75219_a();
        }

        @Override
        public int func_178170_b(ItemStack stack) {
            return this.field_148332_b.func_178170_b(stack);
        }

        @Override
        @Nullable
        public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
            return this.field_148332_b.func_225517_c_();
        }

        @Override
        public ItemStack func_75209_a(int amount) {
            return this.field_148332_b.func_75209_a(amount);
        }

        @Override
        public boolean func_111238_b() {
            return this.field_148332_b.func_111238_b();
        }

        @Override
        public boolean func_82869_a(PlayerEntity playerIn) {
            return this.field_148332_b.func_82869_a(playerIn);
        }

        @Override
        public int getSlotIndex() {
            return this.field_148332_b.getSlotIndex();
        }

        @Override
        public boolean isSameInventory(Slot other) {
            return this.field_148332_b.isSameInventory(other);
        }

        @Override
        public Slot setBackground(ResourceLocation atlas, ResourceLocation sprite) {
            this.field_148332_b.setBackground(atlas, sprite);
            return this;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CreativeContainer
    extends Container {
        public final NonNullList<ItemStack> field_148330_a = NonNullList.func_191196_a();

        public CreativeContainer(PlayerEntity player) {
            super(null, 0);
            PlayerInventory playerinventory = player.field_71071_by;
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.func_75146_a(new LockedSlot((IInventory)field_195378_x, i * 9 + j, 9 + j * 18, 18 + i * 18));
                }
            }
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a(new Slot(playerinventory, k, 9 + k * 18, 112));
            }
            this.func_148329_a(0.0f);
        }

        @Override
        public boolean func_75145_c(PlayerEntity playerIn) {
            return true;
        }

        public void func_148329_a(float pos) {
            int i = (this.field_148330_a.size() + 9 - 1) / 9 - 5;
            int j = (int)((double)(pos * (float)i) + 0.5);
            if (j < 0) {
                j = 0;
            }
            for (int k = 0; k < 5; ++k) {
                for (int l = 0; l < 9; ++l) {
                    int i1 = l + (k + j) * 9;
                    if (i1 >= 0 && i1 < this.field_148330_a.size()) {
                        field_195378_x.func_70299_a(l + k * 9, (ItemStack)((Object)this.field_148330_a.get(i1)));
                        continue;
                    }
                    field_195378_x.func_70299_a(l + k * 9, ItemStack.field_190927_a);
                }
            }
        }

        public boolean func_148328_e() {
            return this.field_148330_a.size() > 45;
        }

        @Override
        public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
            Slot slot;
            if (index >= this.field_75151_b.size() - 9 && index < this.field_75151_b.size() && (slot = (Slot)this.field_75151_b.get(index)) != null && slot.func_75216_d()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public boolean func_94530_a(ItemStack stack, Slot slotIn) {
            return slotIn.field_75224_c != field_195378_x;
        }

        @Override
        public boolean func_94531_b(Slot slotIn) {
            return slotIn.field_75224_c != field_195378_x;
        }
    }
}

