/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

@OnlyIn(value=Dist.CLIENT)
public class ItemRenderer
implements IResourceManagerReloadListener {
    public static final ResourceLocation field_110798_h = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final Set<Item> field_195411_c = Sets.newHashSet((Object[])new Item[]{Items.field_190931_a});
    public float field_77023_b;
    private final ItemModelMesher field_175059_m;
    private final TextureManager field_175057_n;
    private final ItemColors field_184395_f;

    public ItemRenderer(TextureManager textureManagerIn, ModelManager modelManagerIn, ItemColors itemColorsIn) {
        this.field_175057_n = textureManagerIn;
        this.field_175059_m = new ItemModelMesherForge(modelManagerIn);
        for (Item item : Registry.field_212630_s) {
            if (field_195411_c.contains((Object)item)) continue;
            this.field_175059_m.func_199311_a(item, new ModelResourceLocation(Registry.field_212630_s.func_177774_c((Object)item), "inventory"));
        }
        this.field_184395_f = itemColorsIn;
    }

    public ItemModelMesher func_175037_a() {
        return this.field_175059_m;
    }

    private void func_229114_a_(IBakedModel p_229114_1_, ItemStack p_229114_2_, int p_229114_3_, int p_229114_4_, MatrixStack p_229114_5_, IVertexBuilder p_229114_6_) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            this.func_229112_a_(p_229114_5_, p_229114_6_, p_229114_1_.func_200117_a(null, direction, random), p_229114_2_, p_229114_3_, p_229114_4_);
        }
        random.setSeed(42L);
        this.func_229112_a_(p_229114_5_, p_229114_6_, p_229114_1_.func_200117_a(null, null, random), p_229114_2_, p_229114_3_, p_229114_4_);
    }

    public void func_229111_a_(ItemStack p_229111_1_, ItemCameraTransforms.TransformType p_229111_2_, boolean p_229111_3_, MatrixStack p_229111_4_, IRenderTypeBuffer p_229111_5_, int p_229111_6_, int p_229111_7_, IBakedModel p_229111_8_) {
        if (!p_229111_1_.func_190926_b()) {
            boolean flag1;
            p_229111_4_.func_227860_a_();
            boolean flag = p_229111_2_ == ItemCameraTransforms.TransformType.GUI;
            boolean bl = flag1 = flag || p_229111_2_ == ItemCameraTransforms.TransformType.GROUND || p_229111_2_ == ItemCameraTransforms.TransformType.FIXED;
            if (p_229111_1_.func_77973_b() == Items.field_203184_eO && flag1) {
                p_229111_8_ = this.field_175059_m.func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            p_229111_8_ = ForgeHooksClient.handleCameraTransforms((MatrixStack)p_229111_4_, (IBakedModel)p_229111_8_, (ItemCameraTransforms.TransformType)p_229111_2_, (boolean)p_229111_3_);
            p_229111_4_.func_227861_a_(-0.5, -0.5, -0.5);
            if (!p_229111_8_.func_188618_c() && (p_229111_1_.func_77973_b() != Items.field_203184_eO || flag1)) {
                RenderType rendertype = RenderTypeLookup.func_228389_a_(p_229111_1_);
                RenderType rendertype1 = flag && Objects.equals(rendertype, Atlases.func_228784_i_()) ? Atlases.func_228785_j_() : rendertype;
                IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_(p_229111_5_, rendertype1, true, p_229111_1_.func_77962_s());
                this.func_229114_a_(p_229111_8_, p_229111_1_, p_229111_6_, p_229111_7_, p_229111_4_, ivertexbuilder);
            } else {
                p_229111_1_.func_77973_b().getItemStackTileEntityRenderer().func_228364_a_(p_229111_1_, p_229111_4_, p_229111_5_, p_229111_6_, p_229111_7_);
            }
            p_229111_4_.func_227865_b_();
        }
    }

    public static IVertexBuilder func_229113_a_(IRenderTypeBuffer p_229113_0_, RenderType p_229113_1_, boolean p_229113_2_, boolean p_229113_3_) {
        return p_229113_3_ ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)p_229113_0_.getBuffer(p_229113_2_ ? RenderType.func_228653_j_() : RenderType.func_228655_k_()), (IVertexBuilder)p_229113_0_.getBuffer(p_229113_1_)) : p_229113_0_.getBuffer(p_229113_1_);
    }

    public void func_229112_a_(MatrixStack p_229112_1_, IVertexBuilder p_229112_2_, List<BakedQuad> p_229112_3_, ItemStack p_229112_4_, int p_229112_5_, int p_229112_6_) {
        boolean flag = !p_229112_4_.func_190926_b();
        MatrixStack.Entry matrixstack$entry = p_229112_1_.func_227866_c_();
        for (BakedQuad bakedquad : p_229112_3_) {
            int i = -1;
            if (flag && bakedquad.func_178212_b()) {
                i = this.field_184395_f.func_186728_a(p_229112_4_, bakedquad.func_178211_c());
            }
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            p_229112_2_.addVertexData(matrixstack$entry, bakedquad, f, f1, f2, p_229112_5_, p_229112_6_, true);
        }
    }

    public IBakedModel func_184393_a(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entitylivingbaseIn) {
        Item item = stack.func_77973_b();
        IBakedModel ibakedmodel = item == Items.field_203184_eO ? this.field_175059_m.func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident_in_hand#inventory")) : this.field_175059_m.func_178089_a(stack);
        return !item.func_185040_i() ? ibakedmodel : this.func_204207_a(ibakedmodel, stack, worldIn, entitylivingbaseIn);
    }

    private IBakedModel func_204207_a(IBakedModel model, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
        IBakedModel ibakedmodel = model.func_188617_f().func_209581_a(model, stack, worldIn, entityIn);
        return ibakedmodel == null ? this.field_175059_m.func_178083_a().func_174951_a() : ibakedmodel;
    }

    public void func_229110_a_(ItemStack p_229110_1_, ItemCameraTransforms.TransformType p_229110_2_, int p_229110_3_, int p_229110_4_, MatrixStack p_229110_5_, IRenderTypeBuffer p_229110_6_) {
        this.func_229109_a_(null, p_229110_1_, p_229110_2_, false, p_229110_5_, p_229110_6_, null, p_229110_3_, p_229110_4_);
    }

    public void func_229109_a_(@Nullable LivingEntity p_229109_1_, ItemStack p_229109_2_, ItemCameraTransforms.TransformType p_229109_3_, boolean p_229109_4_, MatrixStack p_229109_5_, IRenderTypeBuffer p_229109_6_, @Nullable World p_229109_7_, int p_229109_8_, int p_229109_9_) {
        if (!p_229109_2_.func_190926_b()) {
            IBakedModel ibakedmodel = this.func_184393_a(p_229109_2_, p_229109_7_, p_229109_1_);
            this.func_229111_a_(p_229109_2_, p_229109_3_, p_229109_4_, p_229109_5_, p_229109_6_, p_229109_8_, p_229109_9_, ibakedmodel);
        }
    }

    public void func_175042_a(ItemStack stack, int x, int y) {
        this.func_191962_a(stack, x, y, this.func_184393_a(stack, null, null));
    }

    protected void func_191962_a(ItemStack stack, int x, int y, IBakedModel bakedmodel) {
        boolean flag;
        RenderSystem.pushMatrix();
        this.field_175057_n.func_110577_a(AtlasTexture.field_110575_b);
        this.field_175057_n.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)x, (float)y, (float)(100.0f + this.field_77023_b));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !bakedmodel.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        this.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    public void func_180450_b(ItemStack stack, int xPosition, int yPosition) {
        this.func_184391_a(Minecraft.func_71410_x().field_71439_g, stack, xPosition, yPosition);
    }

    public void func_184391_a(@Nullable LivingEntity entityIn, ItemStack itemIn, int x, int y) {
        if (!itemIn.func_190926_b()) {
            this.field_77023_b += 50.0f;
            try {
                this.func_191962_a(itemIn, x, y, this.func_184393_a(itemIn, null, entityIn));
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Rendering item");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being rendered");
                crashreportcategory.func_189529_a("Item Type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf((Object)itemIn.func_77973_b())));
                crashreportcategory.func_189529_a("Registry Name", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(itemIn.func_77973_b().getRegistryName())));
                crashreportcategory.func_189529_a("Item Damage", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(itemIn.func_77952_i())));
                crashreportcategory.func_189529_a("Item NBT", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(itemIn.func_77978_p())));
                crashreportcategory.func_189529_a("Item Foil", (ICrashReportDetail<String>)((ICrashReportDetail)() -> String.valueOf(itemIn.func_77962_s())));
                throw new ReportedException(crashreport);
            }
            this.field_77023_b -= 50.0f;
        }
    }

    public void func_175030_a(FontRenderer fr, ItemStack stack, int xPosition, int yPosition) {
        this.func_180453_a(fr, stack, xPosition, yPosition, null);
    }

    public void func_180453_a(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text) {
        if (!stack.func_190926_b()) {
            ClientPlayerEntity clientplayerentity;
            float f3;
            MatrixStack matrixstack = new MatrixStack();
            if (stack.func_190916_E() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                matrixstack.func_227861_a_(0.0, 0.0, (double)(this.field_77023_b + 200.0f));
                IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                fr.func_228079_a_(s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF, true, matrixstack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
                irendertypebuffer$impl.func_228461_a_();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                this.func_181565_a(bufferbuilder, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                this.func_181565_a(bufferbuilder, xPosition + 2, yPosition + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f = f3 = (clientplayerentity = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : clientplayerentity.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
                this.func_181565_a(bufferbuilder1, xPosition, yPosition + MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
    }

    private void func_181565_a(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_225582_a_(x + 0, y + 0, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_(x + 0, y + height, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_(x + width, y + height, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_(x + width, y + 0, 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        this.field_175059_m.func_178085_b();
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }
}

