/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ViewFrustum {
    protected final WorldRenderer field_178169_a;
    protected final World field_178167_b;
    protected int field_178168_c;
    protected int field_178165_d;
    protected int field_178166_e;
    public ChunkRenderDispatcher.ChunkRender[] field_178164_f;

    public ViewFrustum(ChunkRenderDispatcher p_i226000_1_, World p_i226000_2_, int p_i226000_3_, WorldRenderer p_i226000_4_) {
        this.field_178169_a = p_i226000_4_;
        this.field_178167_b = p_i226000_2_;
        this.func_178159_a(p_i226000_3_);
        this.func_228789_a_(p_i226000_1_);
    }

    protected void func_228789_a_(ChunkRenderDispatcher p_228789_1_) {
        int i = this.field_178165_d * this.field_178168_c * this.field_178166_e;
        this.field_178164_f = new ChunkRenderDispatcher.ChunkRender[i];
        for (int j = 0; j < this.field_178165_d; ++j) {
            for (int k = 0; k < this.field_178168_c; ++k) {
                for (int l = 0; l < this.field_178166_e; ++l) {
                    int i1 = this.func_212478_a(j, k, l);
                    this.field_178164_f[i1] = new ChunkRenderDispatcher.ChunkRender(p_228789_1_);
                    this.field_178164_f[i1].func_189562_a(j * 16, k * 16, l * 16);
                }
            }
        }
    }

    public void func_178160_a() {
        for (ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender : this.field_178164_f) {
            chunkrenderdispatcher$chunkrender.func_178566_a();
        }
    }

    private int func_212478_a(int x, int y, int z) {
        return (z * this.field_178168_c + y) * this.field_178165_d + x;
    }

    protected void func_178159_a(int renderDistanceChunks) {
        int i;
        this.field_178165_d = i = renderDistanceChunks * 2 + 1;
        this.field_178168_c = 16;
        this.field_178166_e = i;
    }

    public void func_178163_a(double viewEntityX, double viewEntityZ) {
        int i = MathHelper.func_76128_c((double)viewEntityX);
        int j = MathHelper.func_76128_c((double)viewEntityZ);
        for (int k = 0; k < this.field_178165_d; ++k) {
            int l = this.field_178165_d * 16;
            int i1 = i - 8 - l / 2;
            int j1 = i1 + Math.floorMod(k * 16 - i1, l);
            for (int k1 = 0; k1 < this.field_178166_e; ++k1) {
                int l1 = this.field_178166_e * 16;
                int i2 = j - 8 - l1 / 2;
                int j2 = i2 + Math.floorMod(k1 * 16 - i2, l1);
                for (int k2 = 0; k2 < this.field_178168_c; ++k2) {
                    int l2 = k2 * 16;
                    ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender = this.field_178164_f[this.func_212478_a(k, k2, k1)];
                    chunkrenderdispatcher$chunkrender.func_189562_a(j1, l2, j2);
                }
            }
        }
    }

    public void func_217628_a(int sectionX, int sectionY, int sectionZ, boolean rerenderOnMainThread) {
        int i = Math.floorMod(sectionX, this.field_178165_d);
        int j = Math.floorMod(sectionY, this.field_178168_c);
        int k = Math.floorMod(sectionZ, this.field_178166_e);
        ChunkRenderDispatcher.ChunkRender chunkrenderdispatcher$chunkrender = this.field_178164_f[this.func_212478_a(i, j, k)];
        chunkrenderdispatcher$chunkrender.func_178575_a(rerenderOnMainThread);
    }

    @Nullable
    protected ChunkRenderDispatcher.ChunkRender func_178161_a(BlockPos pos) {
        int i = MathHelper.func_76137_a((int)pos.func_177958_n(), (int)16);
        int j = MathHelper.func_76137_a((int)pos.func_177956_o(), (int)16);
        int k = MathHelper.func_76137_a((int)pos.func_177952_p(), (int)16);
        if (j >= 0 && j < this.field_178168_c) {
            i = MathHelper.func_180184_b((int)i, (int)this.field_178165_d);
            k = MathHelper.func_180184_b((int)k, (int)this.field_178166_e);
            return this.field_178164_f[this.func_212478_a(i, j, k)];
        }
        return null;
    }
}

