/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public abstract class ArmorLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    protected final A field_177189_c;
    protected final A field_177186_d;
    private static final Map<String, ResourceLocation> field_177191_j = Maps.newHashMap();

    protected ArmorLayer(IEntityRenderer<T, M> p_i50951_1_, A p_i50951_2_, A p_i50951_3_) {
        super(p_i50951_1_);
        this.field_177189_c = p_i50951_2_;
        this.field_177186_d = p_i50951_3_;
    }

    public void func_225628_a_(MatrixStack p_225628_1_, IRenderTypeBuffer p_225628_2_, int p_225628_3_, T p_225628_4_, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        this.func_229129_a_(p_225628_1_, p_225628_2_, p_225628_4_, p_225628_5_, p_225628_6_, p_225628_7_, p_225628_8_, p_225628_9_, p_225628_10_, EquipmentSlotType.CHEST, p_225628_3_);
        this.func_229129_a_(p_225628_1_, p_225628_2_, p_225628_4_, p_225628_5_, p_225628_6_, p_225628_7_, p_225628_8_, p_225628_9_, p_225628_10_, EquipmentSlotType.LEGS, p_225628_3_);
        this.func_229129_a_(p_225628_1_, p_225628_2_, p_225628_4_, p_225628_5_, p_225628_6_, p_225628_7_, p_225628_8_, p_225628_9_, p_225628_10_, EquipmentSlotType.FEET, p_225628_3_);
        this.func_229129_a_(p_225628_1_, p_225628_2_, p_225628_4_, p_225628_5_, p_225628_6_, p_225628_7_, p_225628_8_, p_225628_9_, p_225628_10_, EquipmentSlotType.HEAD, p_225628_3_);
    }

    private void func_229129_a_(MatrixStack p_229129_1_, IRenderTypeBuffer p_229129_2_, T p_229129_3_, float p_229129_4_, float p_229129_5_, float p_229129_6_, float p_229129_7_, float p_229129_8_, float p_229129_9_, EquipmentSlotType p_229129_10_, int p_229129_11_) {
        ArmorItem armoritem;
        ItemStack itemstack = ((LivingEntity)((Object)p_229129_3_)).func_184582_a(p_229129_10_);
        if (itemstack.func_77973_b() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.func_77973_b()).func_185083_B_() == p_229129_10_) {
            A a = this.func_215337_a(p_229129_10_);
            a = this.getArmorModelHook(p_229129_3_, itemstack, p_229129_10_, a);
            ((BipedModel)this.func_215332_c()).func_217148_a(a);
            a.func_212843_a_(p_229129_3_, p_229129_4_, p_229129_5_, p_229129_6_);
            this.func_188359_a(a, p_229129_10_);
            a.func_225597_a_(p_229129_3_, p_229129_4_, p_229129_5_, p_229129_7_, p_229129_8_, p_229129_9_);
            boolean flag = this.func_188363_b(p_229129_10_);
            boolean flag1 = itemstack.func_77962_s();
            if (armoritem instanceof IDyeableArmorItem) {
                int i = ((IDyeableArmorItem)armoritem).func_200886_f(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderArmor(p_229129_1_, p_229129_2_, p_229129_11_, flag1, a, f, f1, f2, this.getArmorResource((Entity)((Object)p_229129_3_), itemstack, p_229129_10_, null));
                this.renderArmor(p_229129_1_, p_229129_2_, p_229129_11_, flag1, a, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)((Object)p_229129_3_), itemstack, p_229129_10_, "overlay"));
            } else {
                this.renderArmor(p_229129_1_, p_229129_2_, p_229129_11_, flag1, a, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)((Object)p_229129_3_), itemstack, p_229129_10_, null));
            }
        }
    }

    private void func_229128_a_(MatrixStack p_229128_1_, IRenderTypeBuffer p_229128_2_, int p_229128_3_, ArmorItem p_229128_4_, boolean p_229128_5_, A p_229128_6_, boolean p_229128_7_, float p_229128_8_, float p_229128_9_, float p_229128_10_, @Nullable String p_229128_11_) {
        this.renderArmor(p_229128_1_, p_229128_2_, p_229128_3_, p_229128_5_, p_229128_6_, p_229128_8_, p_229128_9_, p_229128_10_, this.func_177178_a(p_229128_4_, p_229128_7_, p_229128_11_));
    }

    private void renderArmor(MatrixStack p_229128_1_, IRenderTypeBuffer p_229128_2_, int p_229128_3_, boolean p_229128_5_, A p_229128_6_, float p_229128_8_, float p_229128_9_, float p_229128_10_, ResourceLocation armorResource) {
        IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_(p_229128_2_, RenderType.func_228640_c_((ResourceLocation)armorResource), false, p_229128_5_);
        p_229128_6_.func_225598_a_(p_229128_1_, ivertexbuilder, p_229128_3_, OverlayTexture.field_229196_a_, p_229128_8_, p_229128_9_, p_229128_10_, 1.0f);
    }

    public A func_215337_a(EquipmentSlotType p_215337_1_) {
        return this.func_188363_b(p_215337_1_) ? this.field_177189_c : this.field_177186_d;
    }

    private boolean func_188363_b(EquipmentSlotType slotIn) {
        return slotIn == EquipmentSlotType.LEGS;
    }

    @Deprecated
    private ResourceLocation func_177178_a(ArmorItem armor, boolean p_177178_2_, @Nullable String p_177178_3_) {
        String s = "textures/models/armor/" + armor.func_200880_d().func_200897_d() + "_layer_" + (p_177178_2_ ? 2 : 1) + (p_177178_3_ == null ? "" : "_" + p_177178_3_) + ".png";
        return field_177191_j.computeIfAbsent(s, ResourceLocation::new);
    }

    protected abstract void func_188359_a(A var1, EquipmentSlotType var2);

    protected abstract void func_177194_a(A var1);

    protected A getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlotType slot, A model) {
        return model;
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.func_188363_b(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = field_177191_j.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            field_177191_j.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

