/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class LayeredTexture
extends Texture {
    private static final Logger field_147638_c = LogManager.getLogger();
    public final List<String> field_110567_b;

    public LayeredTexture(String ... textureNames) {
        this.field_110567_b = Lists.newArrayList((Object[])textureNames);
        if (this.field_110567_b.isEmpty()) {
            throw new IllegalStateException("Layered texture with no layers.");
        }
    }

    @Override
    public void func_195413_a(IResourceManager manager) throws IOException {
        Iterator<String> iterator = this.field_110567_b.iterator();
        String s = iterator.next();
        try (IResource iresource = manager.func_199002_a(new ResourceLocation(s));){
            NativeImage nativeimage = MinecraftForgeClient.getImageLayer((ResourceLocation)new ResourceLocation(s), (IResourceManager)manager);
            while (iterator.hasNext()) {
                String s1 = iterator.next();
                if (s1 == null) continue;
                IResource iresource1 = manager.func_199002_a(new ResourceLocation(s1));
                Throwable throwable = null;
                try {
                    NativeImage nativeimage1 = NativeImage.func_195713_a(iresource1.func_199027_b());
                    Throwable throwable2 = null;
                    try {
                        for (int i = 0; i < nativeimage1.func_195714_b(); ++i) {
                            for (int j = 0; j < nativeimage1.func_195702_a(); ++j) {
                                nativeimage.func_195718_b(j, i, nativeimage1.func_195709_a(j, i));
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (nativeimage1 == null) continue;
                        if (throwable2 != null) {
                            try {
                                nativeimage1.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        nativeimage1.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (iresource1 == null) continue;
                    if (throwable != null) {
                        try {
                            iresource1.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    iresource1.close();
                }
            }
            if (!RenderSystem.isOnRenderThreadOrInit()) {
                RenderSystem.recordRenderCall(() -> this.func_229167_a_(nativeimage));
            } else {
                this.func_229167_a_(nativeimage);
            }
        }
        catch (IOException ioexception) {
            field_147638_c.error("Couldn't load layered image", (Throwable)ioexception);
        }
    }

    private void func_229167_a_(NativeImage p_229167_1_) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)p_229167_1_.func_195702_a(), (int)p_229167_1_.func_195714_b());
        p_229167_1_.func_195697_a(0, 0, 0, true);
    }
}

