/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.base.Charsets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.util.LWJGLMemoryUntracker;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public final class NativeImage
implements AutoCloseable {
    private static final Logger field_227785_a_ = LogManager.getLogger();
    private static final Set<StandardOpenOption> field_209272_a = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    private final PixelFormat field_211680_b;
    private final int field_195719_a;
    private final int field_195720_b;
    private final boolean field_195721_c;
    private long field_195722_d;
    private final long field_195723_e;

    public NativeImage(int widthIn, int heightIn, boolean clear) {
        this(PixelFormat.RGBA, widthIn, heightIn, clear);
    }

    public NativeImage(PixelFormat pixelFormatIn, int widthIn, int heightIn, boolean initialize) {
        this.field_211680_b = pixelFormatIn;
        this.field_195719_a = widthIn;
        this.field_195720_b = heightIn;
        this.field_195723_e = (long)widthIn * (long)heightIn * (long)pixelFormatIn.func_211651_a();
        this.field_195721_c = false;
        this.field_195722_d = initialize ? MemoryUtil.nmemCalloc((long)1L, (long)this.field_195723_e) : MemoryUtil.nmemAlloc((long)this.field_195723_e);
    }

    private NativeImage(PixelFormat pixelFormatIn, int widthIn, int heightIn, boolean stbiPointerIn, long pointer) {
        this.field_211680_b = pixelFormatIn;
        this.field_195719_a = widthIn;
        this.field_195720_b = heightIn;
        this.field_195721_c = stbiPointerIn;
        this.field_195722_d = pointer;
        this.field_195723_e = widthIn * heightIn * pixelFormatIn.func_211651_a();
    }

    public String toString() {
        return "NativeImage[" + (Object)((Object)this.field_211680_b) + " " + this.field_195719_a + "x" + this.field_195720_b + "@" + this.field_195722_d + (this.field_195721_c ? "S" : "N") + "]";
    }

    public static NativeImage func_195713_a(InputStream inputStreamIn) throws IOException {
        return NativeImage.func_211679_a(PixelFormat.RGBA, inputStreamIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeImage func_211679_a(@Nullable PixelFormat pixelFormatIn, InputStream inputStreamIn) throws IOException {
        NativeImage nativeimage;
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.func_225684_a_((InputStream)inputStreamIn);
            bytebuffer.rewind();
            nativeimage = NativeImage.func_211677_a(pixelFormatIn, bytebuffer);
        }
        finally {
            MemoryUtil.memFree((Buffer)bytebuffer);
            IOUtils.closeQuietly((InputStream)inputStreamIn);
        }
        return nativeimage;
    }

    public static NativeImage func_195704_a(ByteBuffer byteBufferIn) throws IOException {
        return NativeImage.func_211677_a(PixelFormat.RGBA, byteBufferIn);
    }

    public static NativeImage func_211677_a(@Nullable PixelFormat pixelFormatIn, ByteBuffer byteBufferIn) throws IOException {
        NativeImage nativeimage;
        if (pixelFormatIn != null && !pixelFormatIn.func_211654_w()) {
            throw new UnsupportedOperationException("Don't know how to read format " + (Object)((Object)pixelFormatIn));
        }
        if (MemoryUtil.memAddress((ByteBuffer)byteBufferIn) == 0L) {
            throw new IllegalArgumentException("Invalid buffer");
        }
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            ByteBuffer bytebuffer = STBImage.stbi_load_from_memory((ByteBuffer)byteBufferIn, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2, (int)(pixelFormatIn == null ? 0 : pixelFormatIn.field_211659_e));
            if (bytebuffer == null) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            nativeimage = new NativeImage(pixelFormatIn == null ? PixelFormat.func_211646_b(intbuffer2.get(0)) : pixelFormatIn, intbuffer.get(0), intbuffer1.get(0), true, MemoryUtil.memAddress((ByteBuffer)bytebuffer));
        }
        return nativeimage;
    }

    private static void func_195707_b(boolean clamp) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (clamp) {
            GlStateManager.func_227677_b_(3553, 10242, 10496);
            GlStateManager.func_227677_b_(3553, 10243, 10496);
        } else {
            GlStateManager.func_227677_b_(3553, 10242, 10497);
            GlStateManager.func_227677_b_(3553, 10243, 10497);
        }
    }

    private static void func_195705_a(boolean linear, boolean mipmap) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (linear) {
            GlStateManager.func_227677_b_(3553, 10241, mipmap ? 9987 : 9729);
            GlStateManager.func_227677_b_(3553, 10240, 9729);
        } else {
            GlStateManager.func_227677_b_(3553, 10241, mipmap ? 9986 : 9728);
            GlStateManager.func_227677_b_(3553, 10240, 9728);
        }
    }

    private void func_195696_g() {
        if (this.field_195722_d == 0L) {
            throw new IllegalStateException("Image is not allocated.");
        }
    }

    @Override
    public void close() {
        if (this.field_195722_d != 0L) {
            if (this.field_195721_c) {
                STBImage.nstbi_image_free((long)this.field_195722_d);
            } else {
                MemoryUtil.nmemFree((long)this.field_195722_d);
            }
        }
        this.field_195722_d = 0L;
    }

    public int func_195702_a() {
        return this.field_195719_a;
    }

    public int func_195714_b() {
        return this.field_195720_b;
    }

    public PixelFormat func_211678_c() {
        return this.field_211680_b;
    }

    public int func_195709_a(int x, int y) {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.field_211680_b}));
        }
        if (x >= 0 && y >= 0 && x < this.field_195719_a && y < this.field_195720_b) {
            this.func_195696_g();
            long i = (x + y * this.field_195719_a) * 4;
            return MemoryUtil.memGetInt((long)(this.field_195722_d + i));
        }
        throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.field_195719_a, this.field_195720_b));
    }

    public void func_195700_a(int x, int y, int value) {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.field_211680_b}));
        }
        if (x < 0 || y < 0 || x >= this.field_195719_a || y >= this.field_195720_b) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.field_195719_a, this.field_195720_b));
        }
        this.func_195696_g();
        long i = (x + y * this.field_195719_a) * 4;
        MemoryUtil.memPutInt((long)(this.field_195722_d + i), (int)value);
    }

    public byte func_211675_e(int x, int y) {
        if (!this.field_211680_b.func_211653_r()) {
            throw new IllegalArgumentException(String.format("no luminance or alpha in %s", new Object[]{this.field_211680_b}));
        }
        if (x >= 0 && y >= 0 && x < this.field_195719_a && y < this.field_195720_b) {
            int i = (x + y * this.field_195719_a) * this.field_211680_b.func_211651_a() + this.field_211680_b.func_211647_v() / 8;
            return MemoryUtil.memGetByte((long)(this.field_195722_d + (long)i));
        }
        throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.field_195719_a, this.field_195720_b));
    }

    public void func_195718_b(int xIn, int yIn, int colIn) {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new UnsupportedOperationException("Can only call blendPixel with RGBA format");
        }
        int i = this.func_195709_a(xIn, yIn);
        float f = (float)NativeImage.func_227786_a_(colIn) / 255.0f;
        float f1 = (float)NativeImage.func_227795_d_(colIn) / 255.0f;
        float f2 = (float)NativeImage.func_227793_c_(colIn) / 255.0f;
        float f3 = (float)NativeImage.func_227791_b_(colIn) / 255.0f;
        float f4 = (float)NativeImage.func_227786_a_(i) / 255.0f;
        float f5 = (float)NativeImage.func_227795_d_(i) / 255.0f;
        float f6 = (float)NativeImage.func_227793_c_(i) / 255.0f;
        float f7 = (float)NativeImage.func_227791_b_(i) / 255.0f;
        float f8 = 1.0f - f;
        float f9 = f * f + f4 * f8;
        float f10 = f1 * f + f5 * f8;
        float f11 = f2 * f + f6 * f8;
        float f12 = f3 * f + f7 * f8;
        if (f9 > 1.0f) {
            f9 = 1.0f;
        }
        if (f10 > 1.0f) {
            f10 = 1.0f;
        }
        if (f11 > 1.0f) {
            f11 = 1.0f;
        }
        if (f12 > 1.0f) {
            f12 = 1.0f;
        }
        int j = (int)(f9 * 255.0f);
        int k = (int)(f10 * 255.0f);
        int l = (int)(f11 * 255.0f);
        int i1 = (int)(f12 * 255.0f);
        this.func_195700_a(xIn, yIn, NativeImage.func_227787_a_(j, k, l, i1));
    }

    @Deprecated
    public int[] func_195716_c() {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new UnsupportedOperationException("can only call makePixelArray for RGBA images.");
        }
        this.func_195696_g();
        int[] aint = new int[this.func_195702_a() * this.func_195714_b()];
        for (int i = 0; i < this.func_195714_b(); ++i) {
            for (int j = 0; j < this.func_195702_a(); ++j) {
                int l1;
                int k = this.func_195709_a(j, i);
                int l = NativeImage.func_227786_a_(k);
                int i1 = NativeImage.func_227795_d_(k);
                int j1 = NativeImage.func_227793_c_(k);
                int k1 = NativeImage.func_227791_b_(k);
                aint[j + i * this.func_195702_a()] = l1 = l << 24 | k1 << 16 | j1 << 8 | i1;
            }
        }
        return aint;
    }

    public void func_195697_a(int level, int xOffset, int yOffset, boolean mipmap) {
        this.func_227788_a_(level, xOffset, yOffset, 0, 0, this.field_195719_a, this.field_195720_b, false, mipmap);
    }

    public void func_227788_a_(int p_227788_1_, int p_227788_2_, int p_227788_3_, int p_227788_4_, int p_227788_5_, int p_227788_6_, int p_227788_7_, boolean p_227788_8_, boolean p_227788_9_) {
        this.func_227789_a_(p_227788_1_, p_227788_2_, p_227788_3_, p_227788_4_, p_227788_5_, p_227788_6_, p_227788_7_, false, false, p_227788_8_, p_227788_9_);
    }

    public void func_227789_a_(int p_227789_1_, int p_227789_2_, int p_227789_3_, int p_227789_4_, int p_227789_5_, int p_227789_6_, int p_227789_7_, boolean p_227789_8_, boolean p_227789_9_, boolean p_227789_10_, boolean p_227789_11_) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.func_227792_b_(p_227789_1_, p_227789_2_, p_227789_3_, p_227789_4_, p_227789_5_, p_227789_6_, p_227789_7_, p_227789_8_, p_227789_9_, p_227789_10_, p_227789_11_));
        } else {
            this.func_227792_b_(p_227789_1_, p_227789_2_, p_227789_3_, p_227789_4_, p_227789_5_, p_227789_6_, p_227789_7_, p_227789_8_, p_227789_9_, p_227789_10_, p_227789_11_);
        }
    }

    private void func_227792_b_(int p_227792_1_, int p_227792_2_, int p_227792_3_, int p_227792_4_, int p_227792_5_, int p_227792_6_, int p_227792_7_, boolean p_227792_8_, boolean p_227792_9_, boolean p_227792_10_, boolean p_227792_11_) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.func_195696_g();
        NativeImage.func_195705_a(p_227792_8_, p_227792_10_);
        NativeImage.func_195707_b(p_227792_9_);
        if (p_227792_6_ == this.func_195702_a()) {
            GlStateManager.func_227748_o_(3314, 0);
        } else {
            GlStateManager.func_227748_o_(3314, this.func_195702_a());
        }
        GlStateManager.func_227748_o_(3316, p_227792_4_);
        GlStateManager.func_227748_o_(3315, p_227792_5_);
        this.field_211680_b.func_211658_c();
        GlStateManager.func_227646_a_(3553, p_227792_1_, p_227792_2_, p_227792_3_, p_227792_6_, p_227792_7_, this.field_211680_b.func_211650_d(), 5121, this.field_195722_d);
        if (p_227792_11_) {
            this.close();
        }
    }

    public void func_195717_a(int level, boolean opaque) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        this.func_195696_g();
        this.field_211680_b.func_211656_b();
        GlStateManager.func_227649_a_(3553, level, this.field_211680_b.func_211650_d(), 5121, this.field_195722_d);
        if (opaque && this.field_211680_b.func_211645_i()) {
            for (int i = 0; i < this.func_195714_b(); ++i) {
                for (int j = 0; j < this.func_195702_a(); ++j) {
                    this.func_195700_a(j, i, this.func_195709_a(j, i) | 255 << this.field_211680_b.func_211648_n());
                }
            }
        }
    }

    public void func_209271_a(File fileIn) throws IOException {
        this.func_209270_a(fileIn.toPath());
    }

    public void func_211676_a(STBTTFontinfo info, int glyphIndex, int widthIn, int heightIn, float scaleX, float scaleY, float shiftX, float shiftY, int x, int y) {
        if (x >= 0 && x + widthIn <= this.func_195702_a() && y >= 0 && y + heightIn <= this.func_195714_b()) {
            if (this.field_211680_b.func_211651_a() != 1) {
                throw new IllegalArgumentException("Can only write fonts into 1-component images.");
            }
        } else {
            throw new IllegalArgumentException(String.format("Out of bounds: start: (%s, %s) (size: %sx%s); size: %sx%s", x, y, widthIn, heightIn, this.func_195702_a(), this.func_195714_b()));
        }
        STBTruetype.nstbtt_MakeGlyphBitmapSubpixel((long)info.address(), (long)(this.field_195722_d + (long)x + (long)(y * this.func_195702_a())), (int)widthIn, (int)heightIn, (int)this.func_195702_a(), (float)scaleX, (float)scaleY, (float)shiftX, (float)shiftY, (int)glyphIndex);
    }

    public void func_209270_a(Path pathIn) throws IOException {
        if (!this.field_211680_b.func_211654_w()) {
            throw new UnsupportedOperationException("Don't know how to write format " + (Object)((Object)this.field_211680_b));
        }
        this.func_195696_g();
        try (SeekableByteChannel writablebytechannel = Files.newByteChannel(pathIn, field_209272_a, new FileAttribute[0]);){
            if (!this.func_227790_a_(writablebytechannel)) {
                throw new IOException("Could not write image to the PNG file \"" + pathIn.toAbsolutePath() + "\": " + STBImage.stbi_failure_reason());
            }
        }
    }

    public byte[] func_227796_e_() throws IOException {
        byte[] abyte;
        try (ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
             WritableByteChannel writablebytechannel = Channels.newChannel(bytearrayoutputstream);){
            if (!this.func_227790_a_(writablebytechannel)) {
                throw new IOException("Could not write image to byte array: " + STBImage.stbi_failure_reason());
            }
            abyte = bytearrayoutputstream.toByteArray();
        }
        return abyte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean func_227790_a_(WritableByteChannel p_227790_1_) throws IOException {
        boolean flag;
        WriteCallback nativeimage$writecallback = new WriteCallback(p_227790_1_);
        try {
            int i = Math.min(this.func_195714_b(), Integer.MAX_VALUE / this.func_195702_a() / this.field_211680_b.func_211651_a());
            if (i < this.func_195714_b()) {
                field_227785_a_.warn("Dropping image height from {} to {} to fit the size into 32-bit signed int", (Object)this.func_195714_b(), (Object)i);
            }
            if (STBImageWrite.nstbi_write_png_to_func((long)nativeimage$writecallback.address(), (long)0L, (int)this.func_195702_a(), (int)i, (int)this.field_211680_b.func_211651_a(), (long)this.field_195722_d, (int)0) != 0) {
                boolean flag2;
                nativeimage$writecallback.func_209267_a();
                boolean bl = flag2 = true;
                return bl;
            }
            flag = false;
        }
        finally {
            nativeimage$writecallback.free();
        }
        return flag;
    }

    public void func_195703_a(NativeImage from) {
        if (from.func_211678_c() != this.field_211680_b) {
            throw new UnsupportedOperationException("Image formats don't match.");
        }
        int i = this.field_211680_b.func_211651_a();
        this.func_195696_g();
        from.func_195696_g();
        if (this.field_195719_a == from.field_195719_a) {
            MemoryUtil.memCopy((long)from.field_195722_d, (long)this.field_195722_d, (long)Math.min(this.field_195723_e, from.field_195723_e));
        } else {
            int j = Math.min(this.func_195702_a(), from.func_195702_a());
            int k = Math.min(this.func_195714_b(), from.func_195714_b());
            for (int l = 0; l < k; ++l) {
                int i1 = l * from.func_195702_a() * i;
                int j1 = l * this.func_195702_a() * i;
                MemoryUtil.memCopy((long)(from.field_195722_d + (long)i1), (long)(this.field_195722_d + (long)j1), (long)j);
            }
        }
    }

    public void func_195715_a(int x, int y, int widthIn, int heightIn, int value) {
        for (int i = y; i < y + heightIn; ++i) {
            for (int j = x; j < x + widthIn; ++j) {
                this.func_195700_a(j, i, value);
            }
        }
    }

    public void func_195699_a(int xFrom, int yFrom, int xToDelta, int yToDelta, int widthIn, int heightIn, boolean mirrorX, boolean mirrorY) {
        for (int i = 0; i < heightIn; ++i) {
            for (int j = 0; j < widthIn; ++j) {
                int k = mirrorX ? widthIn - 1 - j : j;
                int l = mirrorY ? heightIn - 1 - i : i;
                int i1 = this.func_195709_a(xFrom + j, yFrom + i);
                this.func_195700_a(xFrom + xToDelta + k, yFrom + yToDelta + l, i1);
            }
        }
    }

    public void func_195710_e() {
        this.func_195696_g();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            int i = this.field_211680_b.func_211651_a();
            int j = this.func_195702_a() * i;
            long k = memorystack.nmalloc(j);
            for (int l = 0; l < this.func_195714_b() / 2; ++l) {
                int i1 = l * this.func_195702_a() * i;
                int j1 = (this.func_195714_b() - 1 - l) * this.func_195702_a() * i;
                MemoryUtil.memCopy((long)(this.field_195722_d + (long)i1), (long)k, (long)j);
                MemoryUtil.memCopy((long)(this.field_195722_d + (long)j1), (long)(this.field_195722_d + (long)i1), (long)j);
                MemoryUtil.memCopy((long)k, (long)(this.field_195722_d + (long)j1), (long)j);
            }
        }
    }

    public void func_195708_a(int xIn, int yIn, int widthIn, int heightIn, NativeImage imageIn) {
        this.func_195696_g();
        if (imageIn.func_211678_c() != this.field_211680_b) {
            throw new UnsupportedOperationException("resizeSubRectTo only works for images of the same format.");
        }
        int i = this.field_211680_b.func_211651_a();
        STBImageResize.nstbir_resize_uint8((long)(this.field_195722_d + (long)((xIn + yIn * this.func_195702_a()) * i)), (int)widthIn, (int)heightIn, (int)(this.func_195702_a() * i), (long)imageIn.field_195722_d, (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b(), (int)0, (int)i);
    }

    public void func_195711_f() {
        LWJGLMemoryUntracker.func_197933_a((long)this.field_195722_d);
    }

    public static NativeImage func_216511_b(String p_216511_0_) throws IOException {
        NativeImage nativeimage;
        byte[] abyte = Base64.getDecoder().decode(p_216511_0_.replaceAll("\n", "").getBytes(Charsets.UTF_8));
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(abyte.length);
            bytebuffer.put(abyte);
            bytebuffer.rewind();
            nativeimage = NativeImage.func_195704_a(bytebuffer);
        }
        return nativeimage;
    }

    public static int func_227786_a_(int p_227786_0_) {
        return p_227786_0_ >> 24 & 0xFF;
    }

    public static int func_227791_b_(int p_227791_0_) {
        return p_227791_0_ >> 0 & 0xFF;
    }

    public static int func_227793_c_(int p_227793_0_) {
        return p_227793_0_ >> 8 & 0xFF;
    }

    public static int func_227795_d_(int p_227795_0_) {
        return p_227795_0_ >> 16 & 0xFF;
    }

    public static int func_227787_a_(int p_227787_0_, int p_227787_1_, int p_227787_2_, int p_227787_3_) {
        return (p_227787_0_ & 0xFF) << 24 | (p_227787_1_ & 0xFF) << 16 | (p_227787_2_ & 0xFF) << 8 | (p_227787_3_ & 0xFF) << 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class WriteCallback
    extends STBIWriteCallback {
        private final WritableByteChannel field_209268_a;
        @Nullable
        private IOException field_209269_b;

        private WriteCallback(WritableByteChannel byteChannelIn) {
            this.field_209268_a = byteChannelIn;
        }

        public void invoke(long p_invoke_1_, long p_invoke_3_, int p_invoke_5_) {
            ByteBuffer bytebuffer = WriteCallback.getData((long)p_invoke_3_, (int)p_invoke_5_);
            try {
                this.field_209268_a.write(bytebuffer);
            }
            catch (IOException ioexception) {
                this.field_209269_b = ioexception;
            }
        }

        public void func_209267_a() throws IOException {
            if (this.field_209269_b != null) {
                throw this.field_209269_b;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum PixelFormatGLCode {
        RGBA(6408),
        RGB(6407),
        LUMINANCE_ALPHA(6410),
        LUMINANCE(6409),
        INTENSITY(32841);

        private final int field_211673_f;

        private PixelFormatGLCode(int glFormatIn) {
            this.field_211673_f = glFormatIn;
        }

        int func_211672_a() {
            return this.field_211673_f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum PixelFormat {
        RGBA(4, 6408, true, true, true, false, true, 0, 8, 16, 255, 24, true),
        RGB(3, 6407, true, true, true, false, false, 0, 8, 16, 255, 255, true),
        LUMINANCE_ALPHA(2, 6410, false, false, false, true, true, 255, 255, 255, 0, 8, true),
        LUMINANCE(1, 6409, false, false, false, true, false, 0, 0, 0, 0, 255, true);

        private final int field_211659_e;
        private final int field_211660_f;
        private final boolean field_211661_g;
        private final boolean field_211662_h;
        private final boolean field_211663_i;
        private final boolean field_211664_j;
        private final boolean field_211665_k;
        private final int field_211666_l;
        private final int field_211667_m;
        private final int field_211668_n;
        private final int field_211669_o;
        private final int field_211670_p;
        private final boolean field_211671_q;

        private PixelFormat(int channelsIn, int glFormatIn, boolean redIn, boolean greenIn, boolean blueIn, boolean luminanceIn, boolean alphaIn, int offsetRedIn, int offsetGreenIn, int offsetBlueIn, int offsetLuminanceIn, int offsetAlphaIn, boolean standardIn) {
            this.field_211659_e = channelsIn;
            this.field_211660_f = glFormatIn;
            this.field_211661_g = redIn;
            this.field_211662_h = greenIn;
            this.field_211663_i = blueIn;
            this.field_211664_j = luminanceIn;
            this.field_211665_k = alphaIn;
            this.field_211666_l = offsetRedIn;
            this.field_211667_m = offsetGreenIn;
            this.field_211668_n = offsetBlueIn;
            this.field_211669_o = offsetLuminanceIn;
            this.field_211670_p = offsetAlphaIn;
            this.field_211671_q = standardIn;
        }

        public int func_211651_a() {
            return this.field_211659_e;
        }

        public void func_211656_b() {
            RenderSystem.assertThread(RenderSystem::isOnRenderThread);
            GlStateManager.func_227748_o_(3333, this.func_211651_a());
        }

        public void func_211658_c() {
            RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
            GlStateManager.func_227748_o_(3317, this.func_211651_a());
        }

        public int func_211650_d() {
            return this.field_211660_f;
        }

        public boolean func_211645_i() {
            return this.field_211665_k;
        }

        public int func_211648_n() {
            return this.field_211670_p;
        }

        public boolean func_211653_r() {
            return this.field_211664_j || this.field_211665_k;
        }

        public int func_211647_v() {
            return this.field_211664_j ? this.field_211669_o : this.field_211670_p;
        }

        public boolean func_211654_w() {
            return this.field_211671_q;
        }

        private static PixelFormat func_211646_b(int channelsIn) {
            switch (channelsIn) {
                case 1: {
                    return LUMINANCE;
                }
                case 2: {
                    return LUMINANCE_ALPHA;
                }
                case 3: {
                    return RGB;
                }
            }
            return RGBA;
        }
    }
}

