/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.AdvancedLogMessageAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

@OnlyIn(value=Dist.CLIENT)
public class Stitcher {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Comparator<Holder> field_217797_a = Comparator.comparing(p_217793_0_ -> -p_217793_0_.field_94201_d).thenComparing(p_217795_0_ -> -p_217795_0_.field_94204_c).thenComparing(p_217794_0_ -> p_217794_0_.field_229213_a_.func_229248_a_());
    private final int field_147971_a;
    private final Set<Holder> field_94319_a = Sets.newHashSetWithExpectedSize((int)256);
    private final List<Slot> field_94317_b = Lists.newArrayListWithCapacity((int)256);
    private int field_94318_c;
    private int field_94315_d;
    private final int field_94316_e;
    private final int field_94313_f;

    public Stitcher(int p_i50910_1_, int p_i50910_2_, int p_i50910_3_) {
        this.field_147971_a = p_i50910_3_;
        this.field_94316_e = p_i50910_1_;
        this.field_94313_f = p_i50910_2_;
    }

    public int func_110935_a() {
        return this.field_94318_c;
    }

    public int func_110936_b() {
        return this.field_94315_d;
    }

    public void func_229211_a_(TextureAtlasSprite.Info p_229211_1_) {
        Holder stitcher$holder = new Holder(p_229211_1_, this.field_147971_a);
        this.field_94319_a.add(stitcher$holder);
    }

    public void func_94305_f() {
        ArrayList list = Lists.newArrayList(this.field_94319_a);
        list.sort(field_217797_a);
        for (Holder stitcher$holder : list) {
            if (this.func_94310_b(stitcher$holder)) continue;
            LOGGER.info((Message)new AdvancedLogMessageAdapter(sb -> {
                sb.append("Unable to fit: ").append(stitcher$holder.field_229213_a_.func_229248_a_());
                sb.append(" - size: ").append(stitcher$holder.field_229213_a_.func_229250_b_()).append("x").append(stitcher$holder.field_229213_a_.func_229252_c_());
                sb.append(" - Maybe try a lower resolution resourcepack?\n");
                list.forEach(h -> sb.append("\t").append(h).append("\n"));
            }));
            throw new StitcherException(stitcher$holder.field_229213_a_, (Collection)list.stream().map(p_229212_0_ -> p_229212_0_.field_229213_a_).collect(ImmutableList.toImmutableList()));
        }
        this.field_94318_c = MathHelper.func_151236_b((int)this.field_94318_c);
        this.field_94315_d = MathHelper.func_151236_b((int)this.field_94315_d);
    }

    public void func_229209_a_(ISpriteLoader p_229209_1_) {
        for (Slot stitcher$slot : this.field_94317_b) {
            stitcher$slot.func_217792_a(p_229210_2_ -> {
                Holder stitcher$holder = p_229210_2_.func_94183_a();
                TextureAtlasSprite.Info textureatlassprite$info = stitcher$holder.field_229213_a_;
                p_229209_1_.load(textureatlassprite$info, this.field_94318_c, this.field_94315_d, p_229210_2_.func_94186_b(), p_229210_2_.func_94185_c());
            });
        }
    }

    private static int func_147969_b(int dimensionIn, int mipmapLevelIn) {
        return (dimensionIn >> mipmapLevelIn) + ((dimensionIn & (1 << mipmapLevelIn) - 1) == 0 ? 0 : 1) << mipmapLevelIn;
    }

    private boolean func_94310_b(Holder holderIn) {
        for (Slot stitcher$slot : this.field_94317_b) {
            if (!stitcher$slot.func_94182_a(holderIn)) continue;
            return true;
        }
        return this.func_94311_c(holderIn);
    }

    private boolean func_94311_c(Holder holderIn) {
        Slot stitcher$slot;
        boolean flag;
        boolean flag4;
        boolean flag2;
        int i = MathHelper.func_151236_b((int)this.field_94318_c);
        int j = MathHelper.func_151236_b((int)this.field_94315_d);
        int k = MathHelper.func_151236_b((int)(this.field_94318_c + holderIn.field_94204_c));
        int l = MathHelper.func_151236_b((int)(this.field_94315_d + holderIn.field_94201_d));
        boolean flag1 = k <= this.field_94316_e;
        boolean bl = flag2 = l <= this.field_94313_f;
        if (!flag1 && !flag2) {
            return false;
        }
        boolean flag3 = flag1 && i != k;
        boolean bl2 = flag4 = flag2 && j != l;
        if (flag3 ^ flag4) {
            flag = !flag3 && flag1;
        } else {
            boolean bl3 = flag = flag1 && i <= j;
        }
        if (flag) {
            if (this.field_94315_d == 0) {
                this.field_94315_d = holderIn.field_94201_d;
            }
            stitcher$slot = new Slot(this.field_94318_c, 0, holderIn.field_94204_c, this.field_94315_d);
            this.field_94318_c += holderIn.field_94204_c;
        } else {
            stitcher$slot = new Slot(0, this.field_94315_d, this.field_94318_c, holderIn.field_94201_d);
            this.field_94315_d += holderIn.field_94201_d;
        }
        stitcher$slot.func_94182_a(holderIn);
        this.field_94317_b.add(stitcher$slot);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Slot {
        private final int field_94192_a;
        private final int field_94190_b;
        private final int field_94191_c;
        private final int field_94188_d;
        private List<Slot> field_94189_e;
        private Holder field_94187_f;

        public Slot(int originXIn, int originYIn, int widthIn, int heightIn) {
            this.field_94192_a = originXIn;
            this.field_94190_b = originYIn;
            this.field_94191_c = widthIn;
            this.field_94188_d = heightIn;
        }

        public Holder func_94183_a() {
            return this.field_94187_f;
        }

        public int func_94186_b() {
            return this.field_94192_a;
        }

        public int func_94185_c() {
            return this.field_94190_b;
        }

        public boolean func_94182_a(Holder holderIn) {
            if (this.field_94187_f != null) {
                return false;
            }
            int i = holderIn.field_94204_c;
            int j = holderIn.field_94201_d;
            if (i <= this.field_94191_c && j <= this.field_94188_d) {
                if (i == this.field_94191_c && j == this.field_94188_d) {
                    this.field_94187_f = holderIn;
                    return true;
                }
                if (this.field_94189_e == null) {
                    this.field_94189_e = Lists.newArrayListWithCapacity((int)1);
                    this.field_94189_e.add(new Slot(this.field_94192_a, this.field_94190_b, i, j));
                    int k = this.field_94191_c - i;
                    int l = this.field_94188_d - j;
                    if (l > 0 && k > 0) {
                        int j1;
                        int i1 = Math.max(this.field_94188_d, k);
                        if (i1 >= (j1 = Math.max(this.field_94191_c, l))) {
                            this.field_94189_e.add(new Slot(this.field_94192_a, this.field_94190_b + j, i, l));
                            this.field_94189_e.add(new Slot(this.field_94192_a + i, this.field_94190_b, k, this.field_94188_d));
                        } else {
                            this.field_94189_e.add(new Slot(this.field_94192_a + i, this.field_94190_b, k, j));
                            this.field_94189_e.add(new Slot(this.field_94192_a, this.field_94190_b + j, this.field_94191_c, l));
                        }
                    } else if (k == 0) {
                        this.field_94189_e.add(new Slot(this.field_94192_a, this.field_94190_b + j, i, l));
                    } else if (l == 0) {
                        this.field_94189_e.add(new Slot(this.field_94192_a + i, this.field_94190_b, k, j));
                    }
                }
                for (Slot stitcher$slot : this.field_94189_e) {
                    if (!stitcher$slot.func_94182_a(holderIn)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }

        public void func_217792_a(Consumer<Slot> p_217792_1_) {
            if (this.field_94187_f != null) {
                p_217792_1_.accept(this);
            } else if (this.field_94189_e != null) {
                for (Slot stitcher$slot : this.field_94189_e) {
                    stitcher$slot.func_217792_a(p_217792_1_);
                }
            }
        }

        public String toString() {
            return "Slot{originX=" + this.field_94192_a + ", originY=" + this.field_94190_b + ", width=" + this.field_94191_c + ", height=" + this.field_94188_d + ", texture=" + this.field_94187_f + ", subSlots=" + this.field_94189_e + '}';
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface ISpriteLoader {
        public void load(TextureAtlasSprite.Info var1, int var2, int var3, int var4, int var5);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Holder {
        public final TextureAtlasSprite.Info field_229213_a_;
        public final int field_94204_c;
        public final int field_94201_d;

        public Holder(TextureAtlasSprite.Info p_i226045_1_, int p_i226045_2_) {
            this.field_229213_a_ = p_i226045_1_;
            this.field_94204_c = Stitcher.func_147969_b(p_i226045_1_.func_229250_b_(), p_i226045_2_);
            this.field_94201_d = Stitcher.func_147969_b(p_i226045_1_.func_229252_c_(), p_i226045_2_);
        }

        public String toString() {
            return "Holder{width=" + this.field_94204_c + ", height=" + this.field_94201_d + ", name=" + this.field_229213_a_.func_229248_a_() + '}';
        }
    }
}

