/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item.minecart;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.item.minecart.HopperMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartCommandBlockEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.item.minecart.SpawnerMinecartEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeEntityMinecart;

public abstract class AbstractMinecartEntity
extends Entity
implements IForgeEntityMinecart {
    private static final DataParameter<Integer> field_184265_a = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184266_b = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Float> field_184267_c = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184268_d = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184269_e = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184270_f = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187198_h);
    private boolean field_70499_f;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> field_70500_g = (Map)Util.func_200696_a((Object)Maps.newEnumMap(RailShape.class), p_226574_0_ -> {
        Vec3i vec3i = Direction.WEST.func_176730_m();
        Vec3i vec3i1 = Direction.EAST.func_176730_m();
        Vec3i vec3i2 = Direction.NORTH.func_176730_m();
        Vec3i vec3i3 = Direction.SOUTH.func_176730_m();
        Vec3i vec3i4 = vec3i.func_177977_b();
        Vec3i vec3i5 = vec3i1.func_177977_b();
        Vec3i vec3i6 = vec3i2.func_177977_b();
        Vec3i vec3i7 = vec3i3.func_177977_b();
        p_226574_0_.put(RailShape.NORTH_SOUTH, Pair.of((Object)vec3i2, (Object)vec3i3));
        p_226574_0_.put(RailShape.EAST_WEST, Pair.of((Object)vec3i, (Object)vec3i1));
        p_226574_0_.put(RailShape.ASCENDING_EAST, Pair.of((Object)vec3i4, (Object)vec3i1));
        p_226574_0_.put(RailShape.ASCENDING_WEST, Pair.of((Object)vec3i, (Object)vec3i5));
        p_226574_0_.put(RailShape.ASCENDING_NORTH, Pair.of((Object)vec3i2, (Object)vec3i7));
        p_226574_0_.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)vec3i6, (Object)vec3i3));
        p_226574_0_.put(RailShape.SOUTH_EAST, Pair.of((Object)vec3i3, (Object)vec3i1));
        p_226574_0_.put(RailShape.SOUTH_WEST, Pair.of((Object)vec3i3, (Object)vec3i));
        p_226574_0_.put(RailShape.NORTH_WEST, Pair.of((Object)vec3i2, (Object)vec3i));
        p_226574_0_.put(RailShape.NORTH_EAST, Pair.of((Object)vec3i2, (Object)vec3i1));
    });
    private int field_70510_h;
    private double field_70511_i;
    private double field_70509_j;
    private double field_70514_an;
    private double field_70512_ao;
    private double field_70513_ap;
    @OnlyIn(value=Dist.CLIENT)
    private double field_70508_aq;
    @OnlyIn(value=Dist.CLIENT)
    private double field_70507_ar;
    @OnlyIn(value=Dist.CLIENT)
    private double field_70506_as;
    private boolean canBePushed = true;
    private boolean canUseRail = true;
    private float currentSpeedOnRail;
    private float maxSpeedAirLateral = 0.4f;
    private float maxSpeedAirVertical = -1.0f;
    private double dragAir = 0.95f;

    protected AbstractMinecartEntity(EntityType<?> type, World p_i48538_2_) {
        super(type, p_i48538_2_);
        this.field_70156_m = true;
    }

    protected AbstractMinecartEntity(EntityType<?> type, World p_i48539_2_, double p_i48539_3_, double p_i48539_5_, double p_i48539_7_) {
        this(type, p_i48539_2_);
        this.func_70107_b(p_i48539_3_, p_i48539_5_, p_i48539_7_);
        this.func_213317_d(Vec3d.field_186680_a);
        this.field_70169_q = p_i48539_3_;
        this.field_70167_r = p_i48539_5_;
        this.field_70166_s = p_i48539_7_;
    }

    public static AbstractMinecartEntity func_184263_a(World worldIn, double x, double y, double z, Type typeIn) {
        if (typeIn == Type.CHEST) {
            return new ChestMinecartEntity(worldIn, x, y, z);
        }
        if (typeIn == Type.FURNACE) {
            return new FurnaceMinecartEntity(worldIn, x, y, z);
        }
        if (typeIn == Type.TNT) {
            return new TNTMinecartEntity(worldIn, x, y, z);
        }
        if (typeIn == Type.SPAWNER) {
            return new SpawnerMinecartEntity(worldIn, x, y, z);
        }
        if (typeIn == Type.HOPPER) {
            return new HopperMinecartEntity(worldIn, x, y, z);
        }
        return typeIn == Type.COMMAND_BLOCK ? new MinecartCommandBlockEntity(worldIn, x, y, z) : new MinecartEntity(worldIn, x, y, z);
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184265_a, 0);
        this.field_70180_af.func_187214_a(field_184266_b, 1);
        this.field_70180_af.func_187214_a(field_184267_c, Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(field_184268_d, Block.func_196246_j(Blocks.field_150350_a.func_176223_P()));
        this.field_70180_af.func_187214_a(field_184269_e, 6);
        this.field_70180_af.func_187214_a(field_184270_f, false);
    }

    @Override
    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        if (this.getCollisionHandler() != null) {
            return this.getCollisionHandler().getCollisionBox(this, entityIn);
        }
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    @Override
    public boolean func_70104_M() {
        return this.canBePushed;
    }

    @Override
    public double func_70042_X() {
        return 0.0;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (this.func_180431_b(source)) {
                return false;
            }
            this.func_70494_i(-this.func_70493_k());
            this.func_70497_h(10);
            this.func_70018_K();
            this.func_70492_c(this.func_70491_i() + amount * 10.0f);
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.func_70491_i() > 40.0f) {
                this.func_184226_ay();
                if (flag && !this.func_145818_k_()) {
                    this.func_70106_y();
                } else {
                    this.func_94095_a(source);
                }
            }
            return true;
        }
        return true;
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack itemstack = new ItemStack(Items.field_151143_au);
            if (this.func_145818_k_()) {
                itemstack.func_200302_a(this.func_200201_e());
            }
            this.func_199701_a_(itemstack);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70492_c(this.func_70491_i() + this.func_70491_i() * 10.0f);
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    private static Pair<Vec3i, Vec3i> func_226573_a_(RailShape p_226573_0_) {
        return field_70500_g.get(p_226573_0_);
    }

    @Override
    public Direction func_184172_bi() {
        return this.field_70499_f ? this.func_174811_aO().func_176734_d().func_176746_e() : this.func_174811_aO().func_176746_e();
    }

    @Override
    public void func_70071_h_() {
        if (this.func_70496_j() > 0) {
            this.func_70497_h(this.func_70496_j() - 1);
        }
        if (this.func_70491_i() > 0.0f) {
            this.func_70492_c(this.func_70491_i() - 1.0f);
        }
        if (this.func_226278_cu_() < -64.0) {
            this.func_70076_C();
        }
        this.func_213284_aV();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70510_h > 0) {
                double d4 = this.func_226277_ct_() + (this.field_70511_i - this.func_226277_ct_()) / (double)this.field_70510_h;
                double d5 = this.func_226278_cu_() + (this.field_70509_j - this.func_226278_cu_()) / (double)this.field_70510_h;
                double d6 = this.func_226281_cx_() + (this.field_70514_an - this.func_226281_cx_()) / (double)this.field_70510_h;
                double d1 = MathHelper.func_76138_g((double)(this.field_70512_ao - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d1 / (double)this.field_70510_h);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70513_ap - (double)this.field_70125_A) / (double)this.field_70510_h);
                --this.field_70510_h;
                this.func_70107_b(d4, d5, d6);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.func_226264_Z_();
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else {
            double d3;
            int k;
            int j;
            int i;
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            if (this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.func_226277_ct_()), (j = MathHelper.func_76128_c((double)this.func_226278_cu_())) - 1, k = MathHelper.func_76128_c((double)this.func_226281_cx_()))).func_203425_a(BlockTags.field_203437_y)) {
                --j;
            }
            BlockPos blockpos = new BlockPos(i, j, k);
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            if (this.canUseRail() && blockstate.func_203425_a(BlockTags.field_203437_y)) {
                this.func_180460_a(blockpos, blockstate);
                if (blockstate.func_177230_c() instanceof PoweredRailBlock && ((PoweredRailBlock)blockstate.func_177230_c()).isActivatorRail()) {
                    this.func_96095_a(i, j, k, (Boolean)blockstate.func_177229_b((IProperty)PoweredRailBlock.field_176569_M));
                }
            } else {
                this.func_180459_n();
            }
            this.func_145775_I();
            this.field_70125_A = 0.0f;
            double d0 = this.field_70169_q - this.func_226277_ct_();
            double d2 = this.field_70166_s - this.func_226281_cx_();
            if (d0 * d0 + d2 * d2 > 0.001) {
                this.field_70177_z = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 180.0 / Math.PI);
                if (this.field_70499_f) {
                    this.field_70177_z += 180.0f;
                }
            }
            if ((d3 = (double)MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70126_B))) < -170.0 || d3 >= 170.0) {
                this.field_70177_z += 180.0f;
                this.field_70499_f = !this.field_70499_f;
            }
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            AxisAlignedBB box = this.getCollisionHandler() != null ? this.getCollisionHandler().getMinecartCollisionBox(this) : this.func_174813_aQ().func_72314_b((double)0.2f, 0.0, (double)0.2f);
            if (this.canBeRidden() && AbstractMinecartEntity.func_213296_b(this.func_213322_ci()) > 0.01) {
                List<Entity> list = this.field_70170_p.func_175674_a(this, box, EntityPredicates.func_200823_a((Entity)this));
                if (!list.isEmpty()) {
                    for (int l = 0; l < list.size(); ++l) {
                        Entity entity1 = list.get(l);
                        if (!(entity1 instanceof PlayerEntity || entity1 instanceof IronGolemEntity || entity1 instanceof AbstractMinecartEntity || this.func_184207_aI() || entity1.func_184218_aH())) {
                            entity1.func_184220_m(this);
                            continue;
                        }
                        entity1.func_70108_f(this);
                    }
                }
            } else {
                for (Entity entity : this.field_70170_p.func_72839_b(this, box)) {
                    if (this.func_184196_w(entity) || !entity.func_70104_M() || !(entity instanceof AbstractMinecartEntity)) continue;
                    entity.func_70108_f(this);
                }
            }
            this.func_70072_I();
        }
    }

    protected double func_174898_m() {
        return 0.4;
    }

    public void func_96095_a(int x, int y, int z, boolean receivingPower) {
    }

    protected void func_180459_n() {
        double d0 = this.field_70122_E ? this.func_174898_m() : (double)this.getMaxSpeedAirLateral();
        Vec3d vec3d = this.func_213322_ci();
        this.func_213293_j(MathHelper.func_151237_a((double)vec3d.field_72450_a, (double)(-d0), (double)d0), vec3d.field_72448_b, MathHelper.func_151237_a((double)vec3d.field_72449_c, (double)(-d0), (double)d0));
        if (this.getMaxSpeedAirVertical() > 0.0f && this.func_213322_ci().field_72448_b > (double)this.getMaxSpeedAirVertical()) {
            if (Math.abs(this.func_213322_ci().field_72450_a) < (double)0.3f && Math.abs(this.func_213322_ci().field_72449_c) < (double)0.3f) {
                this.func_213317_d(new Vec3d(this.func_213322_ci().field_72450_a, 0.15f, this.func_213322_ci().field_72449_c));
            } else {
                this.func_213317_d(new Vec3d(this.func_213322_ci().field_72450_a, this.getMaxSpeedAirVertical(), this.func_213322_ci().field_72449_c));
            }
        }
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (!this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(this.getDragAir()));
        }
    }

    protected void func_180460_a(BlockPos pos, BlockState state) {
        double d14;
        Entity entity;
        this.field_70143_R = 0.0f;
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        Vec3d vec3d = this.func_70489_a(d0, d1, d2);
        d1 = pos.func_177956_o();
        boolean flag = false;
        boolean flag1 = false;
        AbstractRailBlock abstractrailblock = (AbstractRailBlock)state.func_177230_c();
        if (abstractrailblock instanceof PoweredRailBlock && !((PoweredRailBlock)abstractrailblock).isActivatorRail()) {
            flag = (Boolean)state.func_177229_b((IProperty)PoweredRailBlock.field_176569_M);
            flag1 = !flag;
        }
        Vec3d vec3d1 = this.func_213322_ci();
        RailShape railshape = ((AbstractRailBlock)state.func_177230_c()).getRailDirection(state, (IBlockReader)((Object)this.field_70170_p), pos, this);
        switch (railshape) {
            case ASCENDING_EAST: {
                this.func_213317_d(vec3d1.func_72441_c(-1.0 * this.getSlopeAdjustment(), 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.func_213317_d(vec3d1.func_72441_c(this.getSlopeAdjustment(), 0.0, 0.0));
                d1 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.func_213317_d(vec3d1.func_72441_c(0.0, 0.0, this.getSlopeAdjustment()));
                d1 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.func_213317_d(vec3d1.func_72441_c(0.0, 0.0, -1.0 * this.getSlopeAdjustment()));
                d1 += 1.0;
            }
        }
        vec3d1 = this.func_213322_ci();
        Pair<Vec3i, Vec3i> pair = AbstractMinecartEntity.func_226573_a_(railshape);
        Vec3i vec3i = (Vec3i)pair.getFirst();
        Vec3i vec3i1 = (Vec3i)pair.getSecond();
        double d4 = vec3i1.func_177958_n() - vec3i.func_177958_n();
        double d5 = vec3i1.func_177952_p() - vec3i.func_177952_p();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = vec3d1.field_72450_a * d4 + vec3d1.field_72449_c * d5;
        if (d7 < 0.0) {
            d4 = -d4;
            d5 = -d5;
        }
        double d8 = Math.min(2.0, Math.sqrt(AbstractMinecartEntity.func_213296_b(vec3d1)));
        vec3d1 = new Vec3d(d8 * d4 / d6, vec3d1.field_72448_b, d8 * d5 / d6);
        this.func_213317_d(vec3d1);
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : this.func_184188_bt().get(0);
        if (entity instanceof PlayerEntity) {
            Vec3d vec3d2 = entity.func_213322_ci();
            double d9 = AbstractMinecartEntity.func_213296_b(vec3d2);
            double d11 = AbstractMinecartEntity.func_213296_b(this.func_213322_ci());
            if (d9 > 1.0E-4 && d11 < 0.01) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(vec3d2.field_72450_a * 0.1, 0.0, vec3d2.field_72449_c * 0.1));
                flag1 = false;
            }
        }
        if (flag1 && this.shouldDoRailFunctions()) {
            double d22 = Math.sqrt(AbstractMinecartEntity.func_213296_b(this.func_213322_ci()));
            if (d22 < 0.03) {
                this.func_213317_d(Vec3d.field_186680_a);
            } else {
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 0.0, 0.5));
            }
        }
        double d23 = (double)pos.func_177958_n() + 0.5 + (double)vec3i.func_177958_n() * 0.5;
        double d10 = (double)pos.func_177952_p() + 0.5 + (double)vec3i.func_177952_p() * 0.5;
        double d12 = (double)pos.func_177958_n() + 0.5 + (double)vec3i1.func_177958_n() * 0.5;
        double d13 = (double)pos.func_177952_p() + 0.5 + (double)vec3i1.func_177952_p() * 0.5;
        d4 = d12 - d23;
        d5 = d13 - d10;
        if (d4 == 0.0) {
            d14 = d2 - (double)pos.func_177952_p();
        } else if (d5 == 0.0) {
            d14 = d0 - (double)pos.func_177958_n();
        } else {
            double d15 = d0 - d23;
            double d16 = d2 - d10;
            d14 = (d15 * d4 + d16 * d5) * 2.0;
        }
        d0 = d23 + d4 * d14;
        d2 = d10 + d5 * d14;
        this.func_70107_b(d0, d1, d2);
        this.moveMinecartOnRail(pos);
        if (vec3i.func_177956_o() != 0 && MathHelper.func_76128_c((double)this.func_226277_ct_()) - pos.func_177958_n() == vec3i.func_177958_n() && MathHelper.func_76128_c((double)this.func_226281_cx_()) - pos.func_177952_p() == vec3i.func_177952_p()) {
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)vec3i.func_177956_o(), this.func_226281_cx_());
        } else if (vec3i1.func_177956_o() != 0 && MathHelper.func_76128_c((double)this.func_226277_ct_()) - pos.func_177958_n() == vec3i1.func_177958_n() && MathHelper.func_76128_c((double)this.func_226281_cx_()) - pos.func_177952_p() == vec3i1.func_177952_p()) {
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)vec3i1.func_177956_o(), this.func_226281_cx_());
        }
        this.func_94101_h();
        Vec3d vec3d3 = this.func_70489_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        if (vec3d3 != null && vec3d != null) {
            double d17 = (vec3d.field_72448_b - vec3d3.field_72448_b) * 0.05;
            Vec3d vec3d4 = this.func_213322_ci();
            double d18 = Math.sqrt(AbstractMinecartEntity.func_213296_b(vec3d4));
            if (d18 > 0.0) {
                this.func_213317_d(vec3d4.func_216372_d((d18 + d17) / d18, 1.0, (d18 + d17) / d18));
            }
            this.func_70107_b(this.func_226277_ct_(), vec3d3.field_72448_b, this.func_226281_cx_());
        }
        int j = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int i = MathHelper.func_76128_c((double)this.func_226281_cx_());
        if (j != pos.func_177958_n() || i != pos.func_177952_p()) {
            Vec3d vec3d5 = this.func_213322_ci();
            double d26 = Math.sqrt(AbstractMinecartEntity.func_213296_b(vec3d5));
            this.func_213293_j(d26 * (double)(j - pos.func_177958_n()), vec3d5.field_72448_b, d26 * (double)(i - pos.func_177952_p()));
        }
        if (this.shouldDoRailFunctions()) {
            ((AbstractRailBlock)state.func_177230_c()).onMinecartPass(state, this.field_70170_p, pos, this);
        }
        if (flag && this.shouldDoRailFunctions()) {
            Vec3d vec3d6 = this.func_213322_ci();
            double d27 = Math.sqrt(AbstractMinecartEntity.func_213296_b(vec3d6));
            if (d27 > 0.01) {
                double d19 = 0.06;
                this.func_213317_d(vec3d6.func_72441_c(vec3d6.field_72450_a / d27 * 0.06, 0.0, vec3d6.field_72449_c / d27 * 0.06));
            } else {
                Vec3d vec3d7 = this.func_213322_ci();
                double d20 = vec3d7.field_72450_a;
                double d21 = vec3d7.field_72449_c;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.func_213900_a(pos.func_177976_e())) {
                        d20 = 0.02;
                    } else if (this.func_213900_a(pos.func_177974_f())) {
                        d20 = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.func_213900_a(pos.func_177978_c())) {
                        d21 = 0.02;
                    } else if (this.func_213900_a(pos.func_177968_d())) {
                        d21 = -0.02;
                    }
                }
                this.func_213293_j(d20, vec3d7.field_72448_b, d21);
            }
        }
    }

    private boolean func_213900_a(BlockPos p_213900_1_) {
        return this.field_70170_p.func_180495_p(p_213900_1_).func_215686_e((IBlockReader)((Object)this.field_70170_p), p_213900_1_);
    }

    protected void func_94101_h() {
        double d0 = this.func_184207_aI() ? 0.997 : 0.96;
        this.func_213317_d(this.func_213322_ci().func_216372_d(d0, 0.0, d0));
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_70495_a(double x, double y, double z, double offset) {
        BlockState blockstate;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)x);
        if (this.field_70170_p.func_180495_p(new BlockPos(i, (j = MathHelper.func_76128_c((double)y)) - 1, k = MathHelper.func_76128_c((double)z))).func_203425_a(BlockTags.field_203437_y)) {
            --j;
        }
        if ((blockstate = this.field_70170_p.func_180495_p(new BlockPos(i, j, k))).func_203425_a(BlockTags.field_203437_y)) {
            RailShape railshape = ((AbstractRailBlock)blockstate.func_177230_c()).getRailDirection(blockstate, (IBlockReader)((Object)this.field_70170_p), new BlockPos(i, j, k), this);
            y = j;
            if (railshape.func_208092_c()) {
                y = j + 1;
            }
            Pair<Vec3i, Vec3i> pair = AbstractMinecartEntity.func_226573_a_(railshape);
            Vec3i vec3i = (Vec3i)pair.getFirst();
            Vec3i vec3i1 = (Vec3i)pair.getSecond();
            double d0 = vec3i1.func_177958_n() - vec3i.func_177958_n();
            double d1 = vec3i1.func_177952_p() - vec3i.func_177952_p();
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            if (vec3i.func_177956_o() != 0 && MathHelper.func_76128_c((double)(x += (d0 /= d2) * offset)) - i == vec3i.func_177958_n() && MathHelper.func_76128_c((double)(z += (d1 /= d2) * offset)) - k == vec3i.func_177952_p()) {
                y += (double)vec3i.func_177956_o();
            } else if (vec3i1.func_177956_o() != 0 && MathHelper.func_76128_c((double)x) - i == vec3i1.func_177958_n() && MathHelper.func_76128_c((double)z) - k == vec3i1.func_177952_p()) {
                y += (double)vec3i1.func_177956_o();
            }
            return this.func_70489_a(x, y, z);
        }
        return null;
    }

    @Nullable
    public Vec3d func_70489_a(double p_70489_1_, double p_70489_3_, double p_70489_5_) {
        BlockState blockstate;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)p_70489_1_);
        if (this.field_70170_p.func_180495_p(new BlockPos(i, (j = MathHelper.func_76128_c((double)p_70489_3_)) - 1, k = MathHelper.func_76128_c((double)p_70489_5_))).func_203425_a(BlockTags.field_203437_y)) {
            --j;
        }
        if ((blockstate = this.field_70170_p.func_180495_p(new BlockPos(i, j, k))).func_203425_a(BlockTags.field_203437_y)) {
            double d9;
            RailShape railshape = ((AbstractRailBlock)blockstate.func_177230_c()).getRailDirection(blockstate, (IBlockReader)((Object)this.field_70170_p), new BlockPos(i, j, k), this);
            Pair<Vec3i, Vec3i> pair = AbstractMinecartEntity.func_226573_a_(railshape);
            Vec3i vec3i = (Vec3i)pair.getFirst();
            Vec3i vec3i1 = (Vec3i)pair.getSecond();
            double d0 = (double)i + 0.5 + (double)vec3i.func_177958_n() * 0.5;
            double d1 = (double)j + 0.0625 + (double)vec3i.func_177956_o() * 0.5;
            double d2 = (double)k + 0.5 + (double)vec3i.func_177952_p() * 0.5;
            double d3 = (double)i + 0.5 + (double)vec3i1.func_177958_n() * 0.5;
            double d4 = (double)j + 0.0625 + (double)vec3i1.func_177956_o() * 0.5;
            double d5 = (double)k + 0.5 + (double)vec3i1.func_177952_p() * 0.5;
            double d6 = d3 - d0;
            double d7 = (d4 - d1) * 2.0;
            double d8 = d5 - d2;
            if (d6 == 0.0) {
                d9 = p_70489_5_ - (double)k;
            } else if (d8 == 0.0) {
                d9 = p_70489_1_ - (double)i;
            } else {
                double d10 = p_70489_1_ - d0;
                double d11 = p_70489_5_ - d2;
                d9 = (d10 * d6 + d11 * d8) * 2.0;
            }
            p_70489_1_ = d0 + d6 * d9;
            p_70489_3_ = d1 + d7 * d9;
            p_70489_5_ = d2 + d8 * d9;
            if (d7 < 0.0) {
                p_70489_3_ += 1.0;
            } else if (d7 > 0.0) {
                p_70489_3_ += 0.5;
            }
            return new Vec3d(p_70489_1_, p_70489_3_, p_70489_5_);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        return this.func_94100_s() ? axisalignedbb.func_186662_g((double)Math.abs(this.func_94099_q()) / 16.0) : axisalignedbb;
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_74767_n("CustomDisplayTile")) {
            this.func_174899_a(NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("DisplayState")));
            this.func_94086_l(compound.func_74762_e("DisplayOffset"));
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        if (this.func_94100_s()) {
            compound.func_74757_a("CustomDisplayTile", true);
            compound.func_218657_a("DisplayState", NBTUtil.func_190009_a((BlockState)this.func_174897_t()));
            compound.func_74768_a("DisplayOffset", this.func_94099_q());
        }
    }

    @Override
    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (this.getCollisionHandler() != null) {
            this.getCollisionHandler().onEntityCollision(this, entityIn);
            return;
        }
        if (!(this.field_70170_p.field_72995_K || entityIn.field_70145_X || this.field_70145_X || this.func_184196_w(entityIn) || !((d2 = (d0 = entityIn.func_226277_ct_() - this.func_226277_ct_()) * d0 + (d1 = entityIn.func_226281_cx_() - this.func_226281_cx_()) * d1) >= (double)1.0E-4f))) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.1f;
            d1 *= (double)0.1f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            d0 *= 0.5;
            d1 *= 0.5;
            if (entityIn instanceof AbstractMinecartEntity) {
                Vec3d vec3d1;
                double d5;
                double d4 = entityIn.func_226277_ct_() - this.func_226277_ct_();
                Vec3d vec3d = new Vec3d(d4, 0.0, d5 = entityIn.func_226281_cx_() - this.func_226281_cx_()).func_72432_b();
                double d6 = Math.abs(vec3d.func_72430_b(vec3d1 = new Vec3d(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))), 0.0, MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)))).func_72432_b()));
                if (d6 < (double)0.8f) {
                    return;
                }
                Vec3d vec3d2 = this.func_213322_ci();
                Vec3d vec3d3 = entityIn.func_213322_ci();
                if (((AbstractMinecartEntity)entityIn).isPoweredCart() && !this.isPoweredCart()) {
                    this.func_213317_d(vec3d2.func_216372_d(0.2, 1.0, 0.2));
                    this.func_70024_g(vec3d3.field_72450_a - d0, 0.0, vec3d3.field_72449_c - d1);
                    entityIn.func_213317_d(vec3d3.func_216372_d(0.95, 1.0, 0.95));
                } else if (!((AbstractMinecartEntity)entityIn).isPoweredCart() && this.isPoweredCart()) {
                    entityIn.func_213317_d(vec3d3.func_216372_d(0.2, 1.0, 0.2));
                    entityIn.func_70024_g(vec3d2.field_72450_a + d0, 0.0, vec3d2.field_72449_c + d1);
                    this.func_213317_d(vec3d2.func_216372_d(0.95, 1.0, 0.95));
                } else {
                    double d7 = (vec3d3.field_72450_a + vec3d2.field_72450_a) / 2.0;
                    double d8 = (vec3d3.field_72449_c + vec3d2.field_72449_c) / 2.0;
                    this.func_213317_d(vec3d2.func_216372_d(0.2, 1.0, 0.2));
                    this.func_70024_g(d7 - d0, 0.0, d8 - d1);
                    entityIn.func_213317_d(vec3d3.func_216372_d(0.2, 1.0, 0.2));
                    entityIn.func_70024_g(d7 + d0, 0.0, d8 + d1);
                }
            } else {
                this.func_70024_g(-d0, 0.0, -d1);
                entityIn.func_70024_g(d0 / 4.0, 0.0, d1 / 4.0);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.field_70511_i = x;
        this.field_70509_j = y;
        this.field_70514_an = z;
        this.field_70512_ao = yaw;
        this.field_70513_ap = pitch;
        this.field_70510_h = posRotationIncrements + 2;
        this.func_213293_j(this.field_70508_aq, this.field_70507_ar, this.field_70506_as);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70508_aq = x;
        this.field_70507_ar = y;
        this.field_70506_as = z;
        this.func_213293_j(this.field_70508_aq, this.field_70507_ar, this.field_70506_as);
    }

    public void func_70492_c(float damage) {
        this.field_70180_af.func_187227_b(field_184267_c, Float.valueOf(damage));
    }

    public float func_70491_i() {
        return this.field_70180_af.func_187225_a(field_184267_c).floatValue();
    }

    public void func_70497_h(int rollingAmplitude) {
        this.field_70180_af.func_187227_b(field_184265_a, rollingAmplitude);
    }

    public int func_70496_j() {
        return this.field_70180_af.func_187225_a(field_184265_a);
    }

    public void func_70494_i(int rollingDirection) {
        this.field_70180_af.func_187227_b(field_184266_b, rollingDirection);
    }

    public int func_70493_k() {
        return this.field_70180_af.func_187225_a(field_184266_b);
    }

    public abstract Type func_184264_v();

    public BlockState func_174897_t() {
        return !this.func_94100_s() ? this.func_180457_u() : Block.func_196257_b(this.func_184212_Q().func_187225_a(field_184268_d));
    }

    public BlockState func_180457_u() {
        return Blocks.field_150350_a.func_176223_P();
    }

    public int func_94099_q() {
        return !this.func_94100_s() ? this.func_94085_r() : this.func_184212_Q().func_187225_a(field_184269_e).intValue();
    }

    public int func_94085_r() {
        return 6;
    }

    public void func_174899_a(BlockState displayTile) {
        this.func_184212_Q().func_187227_b(field_184268_d, Block.func_196246_j(displayTile));
        this.func_94096_e(true);
    }

    public void func_94086_l(int displayTileOffset) {
        this.func_184212_Q().func_187227_b(field_184269_e, displayTileOffset);
        this.func_94096_e(true);
    }

    public boolean func_94100_s() {
        return this.func_184212_Q().func_187225_a(field_184270_f);
    }

    public void func_94096_e(boolean showBlock) {
        this.func_184212_Q().func_187227_b(field_184270_f, showBlock);
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }

    public boolean canUseRail() {
        return this.canUseRail;
    }

    public void setCanUseRail(boolean value) {
        this.canUseRail = value;
    }

    public float getCurrentCartSpeedCapOnRail() {
        return this.currentSpeedOnRail;
    }

    public void setCurrentCartSpeedCapOnRail(float value) {
        this.currentSpeedOnRail = Math.min(value, this.getMaxCartSpeedOnRail());
    }

    public float getMaxSpeedAirLateral() {
        return this.maxSpeedAirLateral;
    }

    public void setMaxSpeedAirLateral(float value) {
        this.maxSpeedAirLateral = value;
    }

    public float getMaxSpeedAirVertical() {
        return this.maxSpeedAirVertical;
    }

    public void setMaxSpeedAirVertical(float value) {
        this.maxSpeedAirVertical = value;
    }

    public double getDragAir() {
        return this.dragAir;
    }

    public void setDragAir(double value) {
        this.dragAir = value;
    }

    public double getMaxSpeedWithRail() {
        if (!this.canUseRail()) {
            return this.func_174898_m();
        }
        BlockPos pos = this.getCurrentRailPosition();
        BlockState state = this.getMinecart().field_70170_p.func_180495_p(pos);
        if (!state.func_203425_a(BlockTags.field_203437_y)) {
            return this.func_174898_m();
        }
        float railMaxSpeed = ((AbstractRailBlock)state.func_177230_c()).getRailMaxSpeed(state, this.getMinecart().field_70170_p, pos, this.getMinecart());
        return Math.min(railMaxSpeed, this.getCurrentCartSpeedCapOnRail());
    }

    public void moveMinecartOnRail(BlockPos pos) {
        AbstractMinecartEntity mc = this.getMinecart();
        double d24 = mc.func_184207_aI() ? 0.75 : 1.0;
        double d25 = mc.getMaxSpeedWithRail();
        Vec3d vec3d1 = mc.func_213322_ci();
        mc.func_213315_a(MoverType.SELF, new Vec3d(MathHelper.func_151237_a((double)(d24 * vec3d1.field_72450_a), (double)(-d25), (double)d25), 0.0, MathHelper.func_151237_a((double)(d24 * vec3d1.field_72449_c), (double)(-d25), (double)d25)));
    }

    public static enum Type {
        RIDEABLE,
        CHEST,
        FURNACE,
        TNT,
        SPAWNER,
        HOPPER,
        COMMAND_BLOCK;

    }
}

