/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.merchant.villager;

import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.INPC;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public abstract class AbstractVillagerEntity
extends AgeableEntity
implements INPC,
IMerchant {
    private static final DataParameter<Integer> field_222820_bA = EntityDataManager.func_187226_a(AbstractVillagerEntity.class, DataSerializers.field_187192_b);
    @Nullable
    private PlayerEntity field_213725_bA;
    @Nullable
    protected MerchantOffers field_213724_bz;
    private final Inventory field_213722_bB = new Inventory(8);

    public AbstractVillagerEntity(EntityType<? extends AbstractVillagerEntity> p_i50185_1_, World p_i50185_2_) {
        super(p_i50185_1_, p_i50185_2_);
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableEntity.AgeableData();
            ((AgeableEntity.AgeableData)spawnDataIn).func_226259_a_(false);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public int func_213719_ec() {
        return this.field_70180_af.func_187225_a(field_222820_bA);
    }

    public void func_213720_r(int p_213720_1_) {
        this.field_70180_af.func_187227_b(field_222820_bA, p_213720_1_);
    }

    public int func_213708_dV() {
        return 0;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.81f : 1.62f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_222820_bA, 0);
    }

    public void func_70932_a_(@Nullable PlayerEntity player) {
        this.field_213725_bA = player;
    }

    @Nullable
    public PlayerEntity func_70931_l_() {
        return this.field_213725_bA;
    }

    public boolean func_213716_dX() {
        return this.field_213725_bA != null;
    }

    public MerchantOffers func_213706_dY() {
        if (this.field_213724_bz == null) {
            this.field_213724_bz = new MerchantOffers();
            this.func_213712_ef();
        }
        return this.field_213724_bz;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_213703_a(@Nullable MerchantOffers p_213703_1_) {
    }

    public void func_213702_q(int p_213702_1_) {
    }

    public void func_213704_a(MerchantOffer p_213704_1_) {
        p_213704_1_.func_222219_j();
        this.field_70757_a = -this.func_70627_aG();
        this.func_213713_b(p_213704_1_);
        if (this.field_213725_bA instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_192138_r.func_215114_a((ServerPlayerEntity)this.field_213725_bA, this, p_213704_1_.func_222200_d());
        }
    }

    protected abstract void func_213713_b(MerchantOffer var1);

    public boolean func_213705_dZ() {
        return true;
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(this.func_213721_r(!stack.func_190926_b()), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public SoundEvent func_213714_ea() {
        return SoundEvents.field_187915_go;
    }

    protected SoundEvent func_213721_r(boolean p_213721_1_) {
        return p_213721_1_ ? SoundEvents.field_187915_go : SoundEvents.field_187913_gm;
    }

    public void func_213711_eb() {
        this.func_184185_a(SoundEvents.field_219721_mv, this.func_70599_aP(), this.func_70647_i());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        MerchantOffers merchantoffers = this.func_213706_dY();
        if (!merchantoffers.isEmpty()) {
            compound.func_218657_a("Offers", merchantoffers.func_222199_a());
        }
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.field_213722_bB.func_70302_i_(); ++i) {
            ItemStack itemstack = this.field_213722_bB.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            listnbt.add((Object)itemstack.func_77955_b(new CompoundNBT()));
        }
        compound.func_218657_a("Inventory", (INBT)listnbt);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Offers", 10)) {
            this.field_213724_bz = new MerchantOffers(compound.func_74775_l("Offers"));
        }
        ListNBT listnbt = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            ItemStack itemstack = ItemStack.func_199557_a(listnbt.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.field_213722_bB.func_174894_a(itemstack);
        }
    }

    @Nullable
    public Entity changeDimension(DimensionType destination, ITeleporter teleporter) {
        this.func_213750_eg();
        return super.changeDimension(destination, teleporter);
    }

    protected void func_213750_eg() {
        this.func_70932_a_(null);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.func_213750_eg();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void func_213718_a(IParticleData particleData) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(particleData, this.func_226282_d_(1.0), this.func_226279_cv_() + 1.0, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public Inventory func_213715_ed() {
        return this.field_213722_bB;
    }

    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        if (super.func_174820_d(inventorySlot, itemStackIn)) {
            return true;
        }
        int i = inventorySlot - 300;
        if (i >= 0 && i < this.field_213722_bB.func_70302_i_()) {
            this.field_213722_bB.func_70299_a(i, itemStackIn);
            return true;
        }
        return false;
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    protected abstract void func_213712_ef();

    protected void func_213717_a(MerchantOffers givenMerchantOffers, VillagerTrades.ITrade[] newTrades, int maxNumbers) {
        HashSet set = Sets.newHashSet();
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.field_70146_Z.nextInt(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ITrade villagertrades$itrade = newTrades[integer];
            MerchantOffer merchantoffer = villagertrades$itrade.func_221182_a((Entity)((Object)this), this.field_70146_Z);
            if (merchantoffer == null) continue;
            givenMerchantOffers.add((Object)merchantoffer);
        }
    }
}

