/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.storage.RegionBitmap;
import net.minecraft.world.chunk.storage.RegionFileVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionFile
implements AutoCloseable {
    private static final Logger field_227122_a_ = LogManager.getLogger();
    private static final ByteBuffer field_227123_b_ = ByteBuffer.allocateDirect(1);
    private final FileChannel field_76719_c;
    private final Path field_227124_d_;
    private final RegionFileVersion field_227125_e_;
    private final ByteBuffer field_227126_f_ = ByteBuffer.allocateDirect(8192);
    private final IntBuffer field_76716_d;
    private final IntBuffer field_227127_h_;
    private final RegionBitmap field_227128_i_ = new RegionBitmap();
    private final Path filePath;

    public RegionFile(File p_i225784_1_, File p_i225784_2_) throws IOException {
        this(p_i225784_1_.toPath(), p_i225784_2_.toPath(), RegionFileVersion.field_227159_b_);
    }

    public RegionFile(Path p_i225785_1_, Path p_i225785_2_, RegionFileVersion p_i225785_3_) throws IOException {
        this.field_227125_e_ = p_i225785_3_;
        this.filePath = p_i225785_1_;
        if (!Files.isDirectory(p_i225785_2_, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + p_i225785_2_.toAbsolutePath());
        }
        this.field_227124_d_ = p_i225785_2_;
        this.field_76716_d = this.field_227126_f_.asIntBuffer();
        this.field_76716_d.limit(1024);
        this.field_227126_f_.position(4096);
        this.field_227127_h_ = this.field_227126_f_.asIntBuffer();
        this.field_76719_c = FileChannel.open(p_i225785_1_, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.field_227128_i_.func_227120_a_(0, 2);
        this.field_227126_f_.position(0);
        int i = this.field_76719_c.read(this.field_227126_f_, 0L);
        if (i != -1) {
            if (i != 8192) {
                field_227122_a_.warn("Region file {} has truncated header: {}", (Object)p_i225785_1_, (Object)i);
            }
            for (int j = 0; j < 1024; ++j) {
                int k = this.field_76716_d.get(j);
                if (k == 0) continue;
                int l = RegionFile.func_227142_b_(k);
                int i1 = RegionFile.func_227131_a_(k);
                if (i1 == 255) {
                    i1 = this.forgeGetRealLength(j, l);
                }
                this.field_227128_i_.func_227120_a_(l, i1);
            }
        }
    }

    private int forgeGetRealLength(int index, int offset) throws IOException {
        int chunkX = index & 0x1F;
        int chunkZ = index >> 5 & 0x1F;
        ByteBuffer header = ByteBuffer.allocate(5);
        this.field_76719_c.read(header, offset * 4096);
        header.flip();
        if (header.remaining() < 5) {
            field_227122_a_.error("Chunk {},{} in {} header is truncated: expected 5 but read {}", (Object)chunkX, (Object)chunkZ, (Object)this.filePath.getFileName(), (Object)header.remaining());
            return 255;
        }
        return (header.getInt() + 4) / 4096 + 1;
    }

    public RegionFile extractLargeChunks(ChunkPos pos) throws IOException {
        ChunkPos regionBase = new ChunkPos(pos.func_222241_h() * 32, pos.func_222242_i() * 32);
        for (int index = 0; index < 1024; ++index) {
            int offset = this.field_76716_d.get(index);
            if (RegionFile.func_227131_a_(offset) != 255) continue;
            offset = RegionFile.func_227142_b_(offset);
            ChunkPos chunk = new ChunkPos(regionBase.field_77276_a + (index & 0x1F), regionBase.field_77275_b + (index >> 5 & 0x1F));
            ByteBuffer header = ByteBuffer.allocate(5);
            this.field_76719_c.read(header, offset * 4096);
            header.flip();
            if (header.remaining() < 5) {
                field_227122_a_.error("Chunk {} in {} header is truncated: expected 5 but read {}", (Object)chunk, (Object)this.filePath.getFileName(), (Object)header.remaining());
                continue;
            }
            int length = header.getInt();
            byte version = header.get();
            int sectors = (length + 4) / 4096 + 1;
            if (sectors <= 255 || RegionFile.func_227130_a_(version)) continue;
            ByteBuffer data = ByteBuffer.allocate(length + 4);
            this.field_76719_c.read(data, offset * 4096);
            data.flip();
            if (data.remaining() < length + 4) {
                field_227122_a_.error("Chunk {} in {} is truncated: expected {} but read {}", (Object)chunk, (Object)this.filePath.getFileName(), (Object)(length + 4), (Object)data.remaining());
                continue;
            }
            this.func_227135_a_(chunk, data);
        }
        return this;
    }

    private Path func_227145_e_(ChunkPos p_227145_1_) {
        String s = "c." + p_227145_1_.field_77276_a + "." + p_227145_1_.field_77275_b + ".mcc";
        return this.field_227124_d_.resolve(s);
    }

    @Nullable
    public synchronized DataInputStream func_222666_a(ChunkPos pos) throws IOException {
        int i = this.func_222660_e(pos);
        if (i == 0) {
            return null;
        }
        int j = RegionFile.func_227142_b_(i);
        int k = RegionFile.func_227131_a_(i);
        int l = k * 4096;
        ByteBuffer bytebuffer = ByteBuffer.allocate(l);
        this.field_76719_c.read(bytebuffer, j * 4096);
        bytebuffer.flip();
        if (bytebuffer.remaining() < 5) {
            field_227122_a_.error("Chunk {} header is truncated: expected {} but read {}", (Object)pos, (Object)l, (Object)bytebuffer.remaining());
            return null;
        }
        int i1 = bytebuffer.getInt();
        byte b0 = bytebuffer.get();
        if (i1 == 0) {
            field_227122_a_.warn("Chunk {} is allocated, but stream is missing", (Object)pos);
            return null;
        }
        int j1 = i1 - 1;
        if (RegionFile.func_227130_a_(b0)) {
            if (j1 != 0) {
                field_227122_a_.warn("Chunk has both internal and external streams");
            }
            return this.func_227133_a_(pos, RegionFile.func_227141_b_(b0));
        }
        if (j1 > bytebuffer.remaining()) {
            field_227122_a_.error("Chunk {} stream is truncated: expected {} but read {}", (Object)pos, (Object)j1, (Object)bytebuffer.remaining());
            return null;
        }
        if (j1 < 0) {
            field_227122_a_.error("Declared size {} of chunk {} is negative", (Object)i1, (Object)pos);
            return null;
        }
        return this.func_227134_a_(pos, b0, RegionFile.func_227137_a_(bytebuffer, j1));
    }

    private static boolean func_227130_a_(byte p_227130_0_) {
        return (p_227130_0_ & 0x80) != 0;
    }

    private static byte func_227141_b_(byte p_227141_0_) {
        return (byte)(p_227141_0_ & 0xFFFFFF7F);
    }

    @Nullable
    private DataInputStream func_227134_a_(ChunkPos p_227134_1_, byte p_227134_2_, InputStream p_227134_3_) throws IOException {
        RegionFileVersion regionfileversion = RegionFileVersion.func_227166_a_((int)p_227134_2_);
        if (regionfileversion == null) {
            field_227122_a_.error("Chunk {} has invalid chunk stream version {}", (Object)p_227134_1_, (Object)p_227134_2_);
            return null;
        }
        return new DataInputStream(new BufferedInputStream(regionfileversion.func_227168_a_(p_227134_3_)));
    }

    @Nullable
    private DataInputStream func_227133_a_(ChunkPos p_227133_1_, byte p_227133_2_) throws IOException {
        Path path = this.func_227145_e_(p_227133_1_);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            field_227122_a_.error("External chunk path {} is not file", (Object)path);
            return null;
        }
        return this.func_227134_a_(p_227133_1_, p_227133_2_, Files.newInputStream(path, new OpenOption[0]));
    }

    private static ByteArrayInputStream func_227137_a_(ByteBuffer p_227137_0_, int p_227137_1_) {
        return new ByteArrayInputStream(p_227137_0_.array(), p_227137_0_.position(), p_227137_1_);
    }

    private int func_227132_a_(int p_227132_1_, int p_227132_2_) {
        return p_227132_1_ << 8 | p_227132_2_;
    }

    private static int func_227131_a_(int p_227131_0_) {
        return p_227131_0_ & 0xFF;
    }

    private static int func_227142_b_(int p_227142_0_) {
        return p_227142_0_ >> 8;
    }

    private static int func_227144_c_(int p_227144_0_) {
        return (p_227144_0_ + 4096 - 1) / 4096;
    }

    public boolean func_222662_b(ChunkPos p_222662_1_) {
        int i = this.func_222660_e(p_222662_1_);
        if (i == 0) {
            return false;
        }
        int j = RegionFile.func_227142_b_(i);
        int k = RegionFile.func_227131_a_(i);
        ByteBuffer bytebuffer = ByteBuffer.allocate(5);
        try {
            this.field_76719_c.read(bytebuffer, j * 4096);
            bytebuffer.flip();
            if (bytebuffer.remaining() != 5) {
                return false;
            }
            int l = bytebuffer.getInt();
            byte b0 = bytebuffer.get();
            if (RegionFile.func_227130_a_(b0)) {
                if (!RegionFileVersion.func_227170_b_((int)RegionFile.func_227141_b_(b0))) {
                    return false;
                }
                if (!Files.isRegularFile(this.func_227145_e_(p_222662_1_), new LinkOption[0])) {
                    return false;
                }
            } else {
                if (!RegionFileVersion.func_227170_b_((int)b0)) {
                    return false;
                }
                if (l == 0) {
                    return false;
                }
                int i1 = l - 1;
                if (i1 < 0 || i1 > 4096 * k) {
                    return false;
                }
            }
            return true;
        }
        catch (IOException var9) {
            return false;
        }
    }

    public DataOutputStream func_222661_c(ChunkPos p_222661_1_) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(this.field_227125_e_.func_227169_a_((OutputStream)new ChunkBuffer(p_222661_1_))));
    }

    protected synchronized void func_227135_a_(ChunkPos p_227135_1_, ByteBuffer p_227135_2_) throws IOException {
        ICompleteCallback regionfile$icompletecallback;
        int k1;
        int i1;
        int j1;
        int i = RegionFile.func_222668_f(p_227135_1_);
        int j = this.field_76716_d.get(i);
        int k = RegionFile.func_227142_b_(j);
        int l = RegionFile.func_227131_a_(j);
        if (l == 255) {
            l = this.forgeGetRealLength(i, k);
        }
        if ((j1 = RegionFile.func_227144_c_(i1 = p_227135_2_.remaining())) >= 256) {
            Path path = this.func_227145_e_(p_227135_1_);
            field_227122_a_.warn("Saving oversized chunk {} ({} bytes} to external file {}", (Object)p_227135_1_, (Object)i1, (Object)path);
            j1 = 1;
            k1 = this.field_227128_i_.func_227119_a_(j1);
            regionfile$icompletecallback = this.func_227138_a_(path, p_227135_2_);
            ByteBuffer bytebuffer = this.func_227129_a_();
            this.field_76719_c.write(bytebuffer, k1 * 4096);
        } else {
            k1 = this.field_227128_i_.func_227119_a_(j1);
            regionfile$icompletecallback = () -> Files.deleteIfExists(this.func_227145_e_(p_227135_1_));
            this.field_76719_c.write(p_227135_2_, k1 * 4096);
        }
        int l1 = (int)(Util.func_211179_d() / 1000L);
        this.field_76716_d.put(i, this.func_227132_a_(k1, j1));
        this.field_227127_h_.put(i, l1);
        this.func_227140_b_();
        regionfile$icompletecallback.run();
        if (k != 0) {
            this.field_227128_i_.func_227121_b_(k, l);
        }
    }

    private ByteBuffer func_227129_a_() {
        ByteBuffer bytebuffer = ByteBuffer.allocate(5);
        bytebuffer.putInt(1);
        bytebuffer.put((byte)(this.field_227125_e_.func_227165_a_() | 0x80));
        bytebuffer.flip();
        return bytebuffer;
    }

    private ICompleteCallback func_227138_a_(Path p_227138_1_, ByteBuffer p_227138_2_) throws IOException {
        Path path = Files.createTempFile(this.field_227124_d_, "tmp", (String)null, new FileAttribute[0]);
        try (FileChannel filechannel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            p_227138_2_.position(5);
            filechannel.write(p_227138_2_);
        }
        return () -> Files.move(path, p_227138_1_, StandardCopyOption.REPLACE_EXISTING);
    }

    private void func_227140_b_() throws IOException {
        this.field_227126_f_.position(0);
        this.field_76719_c.write(this.field_227126_f_, 0L);
    }

    private int func_222660_e(ChunkPos p_222660_1_) {
        return this.field_76716_d.get(RegionFile.func_222668_f(p_222660_1_));
    }

    public boolean func_222667_d(ChunkPos p_222667_1_) {
        return this.func_222660_e(p_222667_1_) != 0;
    }

    private static int func_222668_f(ChunkPos p_222668_0_) {
        return p_222668_0_.func_222240_j() + p_222668_0_.func_222238_k() * 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.func_227143_c_();
        }
        finally {
            try {
                this.func_227140_b_();
            }
            finally {
                try {
                    this.field_76719_c.force(true);
                }
                finally {
                    this.field_76719_c.close();
                }
            }
        }
    }

    private void func_227143_c_() throws IOException {
        int j;
        int i = (int)this.field_76719_c.size();
        if (i != (j = RegionFile.func_227144_c_(i) * 4096)) {
            ByteBuffer bytebuffer = field_227123_b_.duplicate();
            bytebuffer.position(0);
            this.field_76719_c.write(bytebuffer, j - 1);
        }
    }

    static interface ICompleteCallback {
        public void run() throws IOException;
    }

    class ChunkBuffer
    extends ByteArrayOutputStream {
        private final ChunkPos field_222659_b;

        public ChunkBuffer(ChunkPos p_i50620_2_) {
            super(8096);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(RegionFile.this.field_227125_e_.func_227165_a_());
            this.field_222659_b = p_i50620_2_;
        }

        @Override
        public void close() throws IOException {
            ByteBuffer bytebuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            bytebuffer.putInt(0, this.count - 5 + 1);
            RegionFile.this.func_227135_a_(this.field_222659_b, bytebuffer);
        }
    }
}

