/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.template;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IClearable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;

public class Template {
    private final List<List<BlockInfo>> field_204769_a = Lists.newArrayList();
    private final List<EntityInfo> field_186271_b = Lists.newArrayList();
    private BlockPos field_186272_c = BlockPos.field_177992_a;
    private String field_186273_d = "?";

    public BlockPos func_186259_a() {
        return this.field_186272_c;
    }

    public void func_186252_a(String authorIn) {
        this.field_186273_d = authorIn;
    }

    public String func_186261_b() {
        return this.field_186273_d;
    }

    public void func_186254_a(World worldIn, BlockPos startPos, BlockPos size, boolean takeEntities, @Nullable Block toIgnore) {
        if (size.func_177958_n() >= 1 && size.func_177956_o() >= 1 && size.func_177952_p() >= 1) {
            BlockPos blockpos = startPos.func_177971_a((Vec3i)size).func_177982_a(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(startPos.func_177958_n(), blockpos.func_177958_n()), Math.min(startPos.func_177956_o(), blockpos.func_177956_o()), Math.min(startPos.func_177952_p(), blockpos.func_177952_p()));
            BlockPos blockpos2 = new BlockPos(Math.max(startPos.func_177958_n(), blockpos.func_177958_n()), Math.max(startPos.func_177956_o(), blockpos.func_177956_o()), Math.max(startPos.func_177952_p(), blockpos.func_177952_p()));
            this.field_186272_c = size;
            for (BlockPos blockpos3 : BlockPos.func_218278_a((BlockPos)blockpos1, (BlockPos)blockpos2)) {
                BlockPos blockpos4 = blockpos3.func_177973_b((Vec3i)blockpos1);
                BlockState blockstate = worldIn.func_180495_p(blockpos3);
                if (toIgnore != null && toIgnore == blockstate.func_177230_c()) continue;
                TileEntity tileentity = worldIn.func_175625_s(blockpos3);
                if (tileentity != null) {
                    CompoundNBT compoundnbt = tileentity.func_189515_b(new CompoundNBT());
                    compoundnbt.func_82580_o("x");
                    compoundnbt.func_82580_o("y");
                    compoundnbt.func_82580_o("z");
                    list1.add(new BlockInfo(blockpos4, blockstate, compoundnbt));
                    continue;
                }
                if (!blockstate.func_200015_d((IBlockReader)((Object)worldIn), blockpos3) && !blockstate.func_224756_o((IBlockReader)((Object)worldIn), blockpos3)) {
                    list2.add(new BlockInfo(blockpos4, blockstate, null));
                    continue;
                }
                list.add(new BlockInfo(blockpos4, blockstate, null));
            }
            ArrayList list3 = Lists.newArrayList();
            list3.addAll(list);
            list3.addAll(list1);
            list3.addAll(list2);
            this.field_204769_a.clear();
            this.field_204769_a.add(list3);
            if (takeEntities) {
                this.func_186255_a(worldIn, blockpos1, blockpos2.func_177982_a(1, 1, 1));
            } else {
                this.field_186271_b.clear();
            }
        }
    }

    private void func_186255_a(World worldIn, BlockPos startPos, BlockPos endPos) {
        List<Entity> list = worldIn.func_175647_a(Entity.class, new AxisAlignedBB(startPos, endPos), p_201048_0_ -> !(p_201048_0_ instanceof PlayerEntity));
        this.field_186271_b.clear();
        for (Entity entity : list) {
            Vec3d vec3d = new Vec3d(entity.func_226277_ct_() - (double)startPos.func_177958_n(), entity.func_226278_cu_() - (double)startPos.func_177956_o(), entity.func_226281_cx_() - (double)startPos.func_177952_p());
            CompoundNBT compoundnbt = new CompoundNBT();
            entity.func_70039_c(compoundnbt);
            BlockPos blockpos = entity instanceof PaintingEntity ? ((PaintingEntity)entity).func_174857_n().func_177973_b((Vec3i)startPos) : new BlockPos(vec3d);
            this.field_186271_b.add(new EntityInfo(vec3d, blockpos, compoundnbt));
        }
    }

    public List<BlockInfo> func_215381_a(BlockPos p_215381_1_, PlacementSettings p_215381_2_, Block p_215381_3_) {
        return this.func_215386_a(p_215381_1_, p_215381_2_, p_215381_3_, true);
    }

    public List<BlockInfo> func_215386_a(BlockPos p_215386_1_, PlacementSettings p_215386_2_, Block p_215386_3_, boolean p_215386_4_) {
        ArrayList list = Lists.newArrayList();
        MutableBoundingBox mutableboundingbox = p_215386_2_.func_186213_g();
        for (BlockInfo template$blockinfo : p_215386_2_.func_227459_a_(this.field_204769_a, p_215386_1_)) {
            BlockState blockstate;
            BlockPos blockpos;
            BlockPos blockPos = blockpos = p_215386_4_ ? Template.func_186266_a(p_215386_2_, template$blockinfo.field_186242_a).func_177971_a((Vec3i)p_215386_1_) : template$blockinfo.field_186242_a;
            if (mutableboundingbox != null && !mutableboundingbox.func_175898_b((Vec3i)blockpos) || (blockstate = template$blockinfo.field_186243_b).func_177230_c() != p_215386_3_) continue;
            list.add(new BlockInfo(blockpos, blockstate.func_185907_a(p_215386_2_.func_186215_c()), template$blockinfo.field_186244_c));
        }
        return list;
    }

    public BlockPos func_186262_a(PlacementSettings placementIn, BlockPos p_186262_2_, PlacementSettings p_186262_3_, BlockPos p_186262_4_) {
        BlockPos blockpos = Template.func_186266_a(placementIn, p_186262_2_);
        BlockPos blockpos1 = Template.func_186266_a(p_186262_3_, p_186262_4_);
        return blockpos.func_177973_b((Vec3i)blockpos1);
    }

    public static BlockPos func_186266_a(PlacementSettings placementIn, BlockPos pos) {
        return Template.func_207669_a(pos, placementIn.func_186212_b(), placementIn.func_186215_c(), placementIn.func_207664_d());
    }

    public static Vec3d transformedVec3d(PlacementSettings placementIn, Vec3d pos) {
        return Template.func_207667_a(pos, placementIn.func_186212_b(), placementIn.func_186215_c(), placementIn.func_207664_d());
    }

    public void func_186260_a(IWorld worldIn, BlockPos pos, PlacementSettings placementIn) {
        placementIn.func_186224_i();
        this.func_186253_b(worldIn, pos, placementIn);
    }

    public void func_186253_b(IWorld worldIn, BlockPos pos, PlacementSettings placementIn) {
        this.func_189962_a(worldIn, pos, placementIn, 2);
    }

    public boolean func_189962_a(IWorld worldIn, BlockPos pos, PlacementSettings placementIn, int flags) {
        if (this.field_204769_a.isEmpty()) {
            return false;
        }
        List list = placementIn.func_227459_a_(this.field_204769_a, pos);
        if (!(list.isEmpty() && (placementIn.func_186221_e() || this.field_186271_b.isEmpty()) || this.field_186272_c.func_177958_n() < 1 || this.field_186272_c.func_177956_o() < 1 || this.field_186272_c.func_177952_p() < 1)) {
            MutableBoundingBox mutableboundingbox = placementIn.func_186213_g();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(placementIn.func_204763_l() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)list.size());
            int i = Integer.MAX_VALUE;
            int j = Integer.MAX_VALUE;
            int k = Integer.MAX_VALUE;
            int l = Integer.MIN_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            for (BlockInfo template$blockinfo : Template.processBlockInfos(this, worldIn, pos, placementIn, list)) {
                TileEntity tileentity1;
                BlockPos blockpos = template$blockinfo.field_186242_a;
                if (mutableboundingbox != null && !mutableboundingbox.func_175898_b((Vec3i)blockpos)) continue;
                IFluidState ifluidstate = placementIn.func_204763_l() ? worldIn.func_204610_c(blockpos) : null;
                BlockState blockstate = template$blockinfo.field_186243_b.func_185902_a(placementIn.func_186212_b()).func_185907_a(placementIn.func_186215_c());
                if (template$blockinfo.field_186244_c != null) {
                    TileEntity tileentity = worldIn.func_175625_s(blockpos);
                    IClearable.func_213131_a((Object)((Object)tileentity));
                    worldIn.func_180501_a(blockpos, Blocks.field_180401_cv.func_176223_P(), 20);
                }
                if (!worldIn.func_180501_a(blockpos, blockstate, flags)) continue;
                i = Math.min(i, blockpos.func_177958_n());
                j = Math.min(j, blockpos.func_177956_o());
                k = Math.min(k, blockpos.func_177952_p());
                l = Math.max(l, blockpos.func_177958_n());
                i1 = Math.max(i1, blockpos.func_177956_o());
                j1 = Math.max(j1, blockpos.func_177952_p());
                list2.add(Pair.of((Object)blockpos, (Object)template$blockinfo.field_186244_c));
                if (template$blockinfo.field_186244_c != null && (tileentity1 = worldIn.func_175625_s(blockpos)) != null) {
                    template$blockinfo.field_186244_c.func_74768_a("x", blockpos.func_177958_n());
                    template$blockinfo.field_186244_c.func_74768_a("y", blockpos.func_177956_o());
                    template$blockinfo.field_186244_c.func_74768_a("z", blockpos.func_177952_p());
                    tileentity1.func_145839_a(template$blockinfo.field_186244_c);
                    tileentity1.func_189668_a(placementIn.func_186212_b());
                    tileentity1.func_189667_a(placementIn.func_186215_c());
                }
                if (ifluidstate == null || !(blockstate.func_177230_c() instanceof ILiquidContainer)) continue;
                ((ILiquidContainer)blockstate.func_177230_c()).func_204509_a(worldIn, blockpos, blockstate, ifluidstate);
                if (ifluidstate.func_206889_d()) continue;
                list1.add(blockpos);
            }
            boolean flag = true;
            Direction[] adirection = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    BlockState blockstate2;
                    Block block;
                    BlockPos blockpos2;
                    BlockPos blockpos3 = blockpos2 = (BlockPos)iterator.next();
                    IFluidState ifluidstate2 = worldIn.func_204610_c(blockpos2);
                    for (int k1 = 0; k1 < adirection.length && !ifluidstate2.func_206889_d(); ++k1) {
                        BlockPos blockpos1 = blockpos3.func_177972_a(adirection[k1]);
                        IFluidState ifluidstate1 = worldIn.func_204610_c(blockpos1);
                        if (!(ifluidstate1.func_215679_a((IBlockReader)((Object)worldIn), blockpos1) > ifluidstate2.func_215679_a((IBlockReader)((Object)worldIn), blockpos3)) && (!ifluidstate1.func_206889_d() || ifluidstate2.func_206889_d())) continue;
                        ifluidstate2 = ifluidstate1;
                        blockpos3 = blockpos1;
                    }
                    if (!ifluidstate2.func_206889_d() || !((block = (blockstate2 = worldIn.func_180495_p(blockpos2)).func_177230_c()) instanceof ILiquidContainer)) continue;
                    ((ILiquidContainer)block).func_204509_a(worldIn, blockpos2, blockstate2, ifluidstate2);
                    flag = true;
                    iterator.remove();
                }
            }
            if (i <= l) {
                if (!placementIn.func_215218_i()) {
                    BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(l - i + 1, i1 - j + 1, j1 - k + 1);
                    int l1 = i;
                    int i2 = j;
                    int j2 = k;
                    for (Pair pair1 : list2) {
                        BlockPos blockpos5 = (BlockPos)pair1.getFirst();
                        voxelshapepart.func_199625_a(blockpos5.func_177958_n() - l1, blockpos5.func_177956_o() - i2, blockpos5.func_177952_p() - j2, true, true);
                    }
                    Template.func_222857_a(worldIn, flags, (VoxelShapePart)voxelshapepart, l1, i2, j2);
                }
                for (Pair pair : list2) {
                    TileEntity tileentity2;
                    BlockPos blockpos4 = (BlockPos)pair.getFirst();
                    if (!placementIn.func_215218_i()) {
                        BlockState blockstate3;
                        BlockState blockstate1 = worldIn.func_180495_p(blockpos4);
                        if (blockstate1 != (blockstate3 = Block.func_199770_b(blockstate1, worldIn, blockpos4))) {
                            worldIn.func_180501_a(blockpos4, blockstate3, flags & 0xFFFFFFFE | 0x10);
                        }
                        worldIn.func_195592_c(blockpos4, blockstate3.func_177230_c());
                    }
                    if (pair.getSecond() == null || (tileentity2 = worldIn.func_175625_s(blockpos4)) == null) continue;
                    tileentity2.func_70296_d();
                }
            }
            if (!placementIn.func_186221_e()) {
                this.addEntitiesToWorld(worldIn, pos, placementIn, placementIn.func_186212_b(), placementIn.func_186215_c(), placementIn.func_207664_d(), placementIn.func_186213_g());
            }
            return true;
        }
        return false;
    }

    public static void func_222857_a(IWorld p_222857_0_, int p_222857_1_, VoxelShapePart p_222857_2_, int p_222857_3_, int p_222857_4_, int p_222857_5_) {
        p_222857_2_.func_211540_a((p_222856_5_, p_222856_6_, p_222856_7_, p_222856_8_) -> {
            BlockState blockstate3;
            BlockState blockstate1;
            BlockState blockstate2;
            BlockPos blockpos = new BlockPos(p_222857_3_ + p_222856_6_, p_222857_4_ + p_222856_7_, p_222857_5_ + p_222856_8_);
            BlockPos blockpos1 = blockpos.func_177972_a(p_222856_5_);
            BlockState blockstate = p_222857_0_.func_180495_p(blockpos);
            if (blockstate != (blockstate2 = blockstate.func_196956_a(p_222856_5_, blockstate1 = p_222857_0_.func_180495_p(blockpos1), p_222857_0_, blockpos, blockpos1))) {
                p_222857_0_.func_180501_a(blockpos, blockstate2, p_222857_1_ & 0xFFFFFFFE | 0x10);
            }
            if (blockstate1 != (blockstate3 = blockstate1.func_196956_a(p_222856_5_.func_176734_d(), blockstate2, p_222857_0_, blockpos1, blockpos))) {
                p_222857_0_.func_180501_a(blockpos1, blockstate3, p_222857_1_ & 0xFFFFFFFE | 0x10);
            }
        });
    }

    @Deprecated
    public static List<BlockInfo> func_215387_a(IWorld p_215387_0_, BlockPos p_215387_1_, PlacementSettings p_215387_2_, List<BlockInfo> p_215387_3_) {
        return Template.processBlockInfos(null, p_215387_0_, p_215387_1_, p_215387_2_, p_215387_3_);
    }

    public static List<BlockInfo> processBlockInfos(@Nullable Template template, IWorld p_215387_0_, BlockPos p_215387_1_, PlacementSettings p_215387_2_, List<BlockInfo> p_215387_3_) {
        ArrayList list = Lists.newArrayList();
        for (BlockInfo template$blockinfo : p_215387_3_) {
            BlockPos blockpos = Template.func_186266_a(p_215387_2_, template$blockinfo.field_186242_a).func_177971_a((Vec3i)p_215387_1_);
            BlockInfo template$blockinfo1 = new BlockInfo(blockpos, template$blockinfo.field_186243_b, template$blockinfo.field_186244_c);
            Iterator iterator = p_215387_2_.func_215221_j().iterator();
            while (template$blockinfo1 != null && iterator.hasNext()) {
                template$blockinfo1 = ((StructureProcessor)iterator.next()).process(p_215387_0_, p_215387_1_, template$blockinfo, template$blockinfo1, p_215387_2_, template);
            }
            if (template$blockinfo1 == null) continue;
            list.add(template$blockinfo1);
        }
        return list;
    }

    public static List<EntityInfo> processEntityInfos(@Nullable Template template, IWorld p_215387_0_, BlockPos p_215387_1_, PlacementSettings p_215387_2_, List<EntityInfo> p_215387_3_) {
        ArrayList list = Lists.newArrayList();
        for (EntityInfo entityInfo : p_215387_3_) {
            StructureProcessor proc;
            Vec3d pos = Template.transformedVec3d(p_215387_2_, entityInfo.field_186247_a).func_178787_e(new Vec3d((Vec3i)p_215387_1_));
            BlockPos blockpos = Template.func_186266_a(p_215387_2_, entityInfo.field_186248_b).func_177971_a((Vec3i)p_215387_1_);
            EntityInfo info = new EntityInfo(pos, blockpos, entityInfo.field_186249_c);
            Iterator iterator = p_215387_2_.func_215221_j().iterator();
            while (iterator.hasNext() && (info = (proc = (StructureProcessor)iterator.next()).processEntity(p_215387_0_, p_215387_1_, entityInfo, info, p_215387_2_, template)) != null) {
            }
            if (info == null) continue;
            list.add(info);
        }
        return list;
    }

    @Deprecated
    private void func_207668_a(IWorld p_207668_1_, BlockPos p_207668_2_, Mirror p_207668_3_, Rotation p_207668_4_, BlockPos p_207668_5_, @Nullable MutableBoundingBox p_207668_6_) {
        this.addEntitiesToWorld(p_207668_1_, p_207668_2_, new PlacementSettings().func_186214_a(p_207668_3_).func_186220_a(p_207668_4_).func_207665_a(p_207668_5_).func_186223_a(p_207668_6_), p_207668_3_, p_207668_4_, p_207668_2_, p_207668_6_);
    }

    private void addEntitiesToWorld(IWorld p_207668_1_, BlockPos p_207668_2_, PlacementSettings placementIn, Mirror p_207668_3_, Rotation p_207668_4_, BlockPos p_207668_5_, @Nullable MutableBoundingBox p_207668_6_) {
        for (EntityInfo template$entityinfo : Template.processEntityInfos(this, p_207668_1_, p_207668_2_, placementIn, this.field_186271_b)) {
            BlockPos blockpos = Template.func_207669_a(template$entityinfo.field_186248_b, p_207668_3_, p_207668_4_, p_207668_5_).func_177971_a((Vec3i)p_207668_2_);
            blockpos = template$entityinfo.field_186248_b;
            if (p_207668_6_ != null && !p_207668_6_.func_175898_b((Vec3i)blockpos)) continue;
            CompoundNBT compoundnbt = template$entityinfo.field_186249_c;
            Vec3d vec3d = Template.func_207667_a(template$entityinfo.field_186247_a, p_207668_3_, p_207668_4_, p_207668_5_);
            vec3d = vec3d.func_72441_c(p_207668_2_.func_177958_n(), p_207668_2_.func_177956_o(), p_207668_2_.func_177952_p());
            Vec3d vec3d1 = template$entityinfo.field_186247_a;
            ListNBT listnbt = new ListNBT();
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)vec3d1.field_72450_a));
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)vec3d1.field_72448_b));
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)vec3d1.field_72449_c));
            compoundnbt.func_218657_a("Pos", (INBT)listnbt);
            compoundnbt.func_82580_o("UUIDMost");
            compoundnbt.func_82580_o("UUIDLeast");
            Template.func_215382_a(p_207668_1_, compoundnbt).ifPresent(p_215383_4_ -> {
                float f = p_215383_4_.func_184217_a(p_207668_3_);
                p_215383_4_.func_70012_b(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, f += p_215383_4_.field_70177_z - p_215383_4_.func_184229_a(p_207668_4_), p_215383_4_.field_70125_A);
                p_207668_1_.func_217376_c((Entity)((Object)p_215383_4_));
            });
        }
    }

    private static Optional<Entity> func_215382_a(IWorld p_215382_0_, CompoundNBT p_215382_1_) {
        try {
            return EntityType.func_220330_a(p_215382_1_, p_215382_0_.func_201672_e());
        }
        catch (Exception var3) {
            return Optional.empty();
        }
    }

    public BlockPos func_186257_a(Rotation rotationIn) {
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(this.field_186272_c.func_177952_p(), this.field_186272_c.func_177956_o(), this.field_186272_c.func_177958_n());
            }
        }
        return this.field_186272_c;
    }

    public static BlockPos func_207669_a(BlockPos targetPos, Mirror mirrorIn, Rotation rotationIn, BlockPos offset) {
        int i = targetPos.func_177958_n();
        int j = targetPos.func_177956_o();
        int k = targetPos.func_177952_p();
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        int l = offset.func_177958_n();
        int i1 = offset.func_177952_p();
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(l - i1 + k, j, l + i1 - i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(l + i1 - k, j, i1 - l + i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(l + l - i, j, i1 + i1 - k);
            }
        }
        return flag ? new BlockPos(i, j, k) : targetPos;
    }

    private static Vec3d func_207667_a(Vec3d target, Mirror mirrorIn, Rotation rotationIn, BlockPos centerOffset) {
        double d0 = target.field_72450_a;
        double d1 = target.field_72448_b;
        double d2 = target.field_72449_c;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        int i = centerOffset.func_177958_n();
        int j = centerOffset.func_177952_p();
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d((double)(i - j) + d2, d1, (double)(i + j + 1) - d0);
            }
            case CLOCKWISE_90: {
                return new Vec3d((double)(i + j + 1) - d2, d1, (double)(j - i) + d0);
            }
            case CLOCKWISE_180: {
                return new Vec3d((double)(i + i + 1) - d0, d1, (double)(j + j + 1) - d2);
            }
        }
        return flag ? new Vec3d(d0, d1, d2) : target;
    }

    public BlockPos func_189961_a(BlockPos p_189961_1_, Mirror p_189961_2_, Rotation p_189961_3_) {
        return Template.func_191157_a(p_189961_1_, p_189961_2_, p_189961_3_, this.func_186259_a().func_177958_n(), this.func_186259_a().func_177952_p());
    }

    public static BlockPos func_191157_a(BlockPos p_191157_0_, Mirror p_191157_1_, Rotation p_191157_2_, int p_191157_3_, int p_191157_4_) {
        int i = p_191157_1_ == Mirror.FRONT_BACK ? --p_191157_3_ : 0;
        int j = p_191157_1_ == Mirror.LEFT_RIGHT ? --p_191157_4_ : 0;
        BlockPos blockpos = p_191157_0_;
        switch (p_191157_2_) {
            case COUNTERCLOCKWISE_90: {
                blockpos = p_191157_0_.func_177982_a(j, 0, p_191157_3_ - i);
                break;
            }
            case CLOCKWISE_90: {
                blockpos = p_191157_0_.func_177982_a(p_191157_4_ - j, 0, i);
                break;
            }
            case CLOCKWISE_180: {
                blockpos = p_191157_0_.func_177982_a(p_191157_3_ - i, 0, p_191157_4_ - j);
                break;
            }
            case NONE: {
                blockpos = p_191157_0_.func_177982_a(i, 0, j);
            }
        }
        return blockpos;
    }

    public MutableBoundingBox func_215388_b(PlacementSettings p_215388_1_, BlockPos p_215388_2_) {
        Rotation rotation = p_215388_1_.func_186215_c();
        BlockPos blockpos = p_215388_1_.func_207664_d();
        BlockPos blockpos1 = this.func_186257_a(rotation);
        Mirror mirror = p_215388_1_.func_186212_b();
        int i = blockpos.func_177958_n();
        int j = blockpos.func_177952_p();
        int k = blockpos1.func_177958_n() - 1;
        int l = blockpos1.func_177956_o() - 1;
        int i1 = blockpos1.func_177952_p() - 1;
        MutableBoundingBox mutableboundingbox = new MutableBoundingBox(0, 0, 0, 0, 0, 0);
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                mutableboundingbox = new MutableBoundingBox(i - j, 0, i + j - i1, i - j + k, l, i + j);
                break;
            }
            case CLOCKWISE_90: {
                mutableboundingbox = new MutableBoundingBox(i + j - k, 0, j - i, i + j, l, j - i + i1);
                break;
            }
            case CLOCKWISE_180: {
                mutableboundingbox = new MutableBoundingBox(i + i - k, 0, j + j - i1, i + i, l, j + j);
                break;
            }
            case NONE: {
                mutableboundingbox = new MutableBoundingBox(0, 0, 0, k, l, i1);
            }
        }
        switch (mirror) {
            case LEFT_RIGHT: {
                this.func_215385_a(rotation, i1, k, mutableboundingbox, Direction.NORTH, Direction.SOUTH);
                break;
            }
            case FRONT_BACK: {
                this.func_215385_a(rotation, k, i1, mutableboundingbox, Direction.WEST, Direction.EAST);
            }
        }
        mutableboundingbox.func_78886_a(p_215388_2_.func_177958_n(), p_215388_2_.func_177956_o(), p_215388_2_.func_177952_p());
        return mutableboundingbox;
    }

    private void func_215385_a(Rotation p_215385_1_, int p_215385_2_, int p_215385_3_, MutableBoundingBox p_215385_4_, Direction p_215385_5_, Direction p_215385_6_) {
        BlockPos blockpos = BlockPos.field_177992_a;
        blockpos = p_215385_1_ != Rotation.CLOCKWISE_90 && p_215385_1_ != Rotation.COUNTERCLOCKWISE_90 ? (p_215385_1_ == Rotation.CLOCKWISE_180 ? blockpos.func_177967_a(p_215385_6_, p_215385_2_) : blockpos.func_177967_a(p_215385_5_, p_215385_2_)) : blockpos.func_177967_a(p_215385_1_.func_185831_a(p_215385_5_), p_215385_3_);
        p_215385_4_.func_78886_a(blockpos.func_177958_n(), 0, blockpos.func_177952_p());
    }

    public CompoundNBT func_189552_a(CompoundNBT nbt) {
        if (this.field_204769_a.isEmpty()) {
            nbt.func_218657_a("blocks", (INBT)new ListNBT());
            nbt.func_218657_a("palette", (INBT)new ListNBT());
        } else {
            ArrayList list = Lists.newArrayList();
            BasicPalette template$basicpalette = new BasicPalette();
            list.add(template$basicpalette);
            for (int i = 1; i < this.field_204769_a.size(); ++i) {
                list.add(new BasicPalette());
            }
            ListNBT listnbt1 = new ListNBT();
            List<BlockInfo> list1 = this.field_204769_a.get(0);
            for (int j = 0; j < list1.size(); ++j) {
                BlockInfo template$blockinfo = list1.get(j);
                CompoundNBT compoundnbt = new CompoundNBT();
                compoundnbt.func_218657_a("pos", (INBT)this.func_186267_a(template$blockinfo.field_186242_a.func_177958_n(), template$blockinfo.field_186242_a.func_177956_o(), template$blockinfo.field_186242_a.func_177952_p()));
                int k = template$basicpalette.func_189954_a(template$blockinfo.field_186243_b);
                compoundnbt.func_74768_a("state", k);
                if (template$blockinfo.field_186244_c != null) {
                    compoundnbt.func_218657_a("nbt", template$blockinfo.field_186244_c);
                }
                listnbt1.add((Object)compoundnbt);
                for (int l = 1; l < this.field_204769_a.size(); ++l) {
                    BasicPalette template$basicpalette1 = (BasicPalette)list.get(l);
                    template$basicpalette1.func_189956_a(this.field_204769_a.get((int)l).get((int)j).field_186243_b, k);
                }
            }
            nbt.func_218657_a("blocks", (INBT)listnbt1);
            if (list.size() == 1) {
                ListNBT listnbt2 = new ListNBT();
                for (BlockState blockstate : template$basicpalette) {
                    listnbt2.add((Object)NBTUtil.func_190009_a((BlockState)blockstate));
                }
                nbt.func_218657_a("palette", (INBT)listnbt2);
            } else {
                ListNBT listnbt3 = new ListNBT();
                for (BasicPalette template$basicpalette2 : list) {
                    ListNBT listnbt4 = new ListNBT();
                    for (BlockState blockstate1 : template$basicpalette2) {
                        listnbt4.add((Object)NBTUtil.func_190009_a((BlockState)blockstate1));
                    }
                    listnbt3.add((Object)listnbt4);
                }
                nbt.func_218657_a("palettes", (INBT)listnbt3);
            }
        }
        ListNBT listnbt = new ListNBT();
        for (EntityInfo template$entityinfo : this.field_186271_b) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            compoundnbt1.func_218657_a("pos", (INBT)this.func_186264_a(template$entityinfo.field_186247_a.field_72450_a, template$entityinfo.field_186247_a.field_72448_b, template$entityinfo.field_186247_a.field_72449_c));
            compoundnbt1.func_218657_a("blockPos", (INBT)this.func_186267_a(template$entityinfo.field_186248_b.func_177958_n(), template$entityinfo.field_186248_b.func_177956_o(), template$entityinfo.field_186248_b.func_177952_p()));
            if (template$entityinfo.field_186249_c != null) {
                compoundnbt1.func_218657_a("nbt", template$entityinfo.field_186249_c);
            }
            listnbt.add((Object)compoundnbt1);
        }
        nbt.func_218657_a("entities", (INBT)listnbt);
        nbt.func_218657_a("size", (INBT)this.func_186267_a(this.field_186272_c.func_177958_n(), this.field_186272_c.func_177956_o(), this.field_186272_c.func_177952_p()));
        nbt.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
        return nbt;
    }

    public void func_186256_b(CompoundNBT compound) {
        this.field_204769_a.clear();
        this.field_186271_b.clear();
        ListNBT listnbt = compound.func_150295_c("size", 3);
        this.field_186272_c = new BlockPos(listnbt.func_186858_c(0), listnbt.func_186858_c(1), listnbt.func_186858_c(2));
        ListNBT listnbt1 = compound.func_150295_c("blocks", 10);
        if (compound.func_150297_b("palettes", 9)) {
            ListNBT listnbt2 = compound.func_150295_c("palettes", 9);
            for (int i = 0; i < listnbt2.size(); ++i) {
                this.func_204768_a(listnbt2.func_202169_e(i), listnbt1);
            }
        } else {
            this.func_204768_a(compound.func_150295_c("palette", 10), listnbt1);
        }
        ListNBT listnbt5 = compound.func_150295_c("entities", 10);
        for (int j = 0; j < listnbt5.size(); ++j) {
            CompoundNBT compoundnbt = listnbt5.func_150305_b(j);
            ListNBT listnbt3 = compoundnbt.func_150295_c("pos", 6);
            Vec3d vec3d = new Vec3d(listnbt3.func_150309_d(0), listnbt3.func_150309_d(1), listnbt3.func_150309_d(2));
            ListNBT listnbt4 = compoundnbt.func_150295_c("blockPos", 3);
            BlockPos blockpos = new BlockPos(listnbt4.func_186858_c(0), listnbt4.func_186858_c(1), listnbt4.func_186858_c(2));
            if (!compoundnbt.func_74764_b("nbt")) continue;
            CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("nbt");
            this.field_186271_b.add(new EntityInfo(vec3d, blockpos, compoundnbt1));
        }
    }

    private void func_204768_a(ListNBT p_204768_1_, ListNBT p_204768_2_) {
        BasicPalette template$basicpalette = new BasicPalette();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < p_204768_1_.size(); ++i) {
            template$basicpalette.func_189956_a(NBTUtil.func_190008_d((CompoundNBT)p_204768_1_.func_150305_b(i)), i);
        }
        for (int j = 0; j < p_204768_2_.size(); ++j) {
            CompoundNBT compoundnbt = p_204768_2_.func_150305_b(j);
            ListNBT listnbt = compoundnbt.func_150295_c("pos", 3);
            BlockPos blockpos = new BlockPos(listnbt.func_186858_c(0), listnbt.func_186858_c(1), listnbt.func_186858_c(2));
            BlockState blockstate = template$basicpalette.func_189955_a(compoundnbt.func_74762_e("state"));
            CompoundNBT compoundnbt1 = compoundnbt.func_74764_b("nbt") ? compoundnbt.func_74775_l("nbt") : null;
            list.add(new BlockInfo(blockpos, blockstate, compoundnbt1));
        }
        list.sort(Comparator.comparingInt(p_215384_0_ -> p_215384_0_.field_186242_a.func_177956_o()));
        this.field_204769_a.add(list);
    }

    private ListNBT func_186267_a(int ... values) {
        ListNBT listnbt = new ListNBT();
        for (int i : values) {
            listnbt.add((Object)IntNBT.func_229692_a_((int)i));
        }
        return listnbt;
    }

    private ListNBT func_186264_a(double ... values) {
        ListNBT listnbt = new ListNBT();
        for (double d0 : values) {
            listnbt.add((Object)DoubleNBT.func_229684_a_((double)d0));
        }
        return listnbt;
    }

    public static class EntityInfo {
        public final Vec3d field_186247_a;
        public final BlockPos field_186248_b;
        public final CompoundNBT field_186249_c;

        public EntityInfo(Vec3d vecIn, BlockPos posIn, CompoundNBT nbt) {
            this.field_186247_a = vecIn;
            this.field_186248_b = posIn;
            this.field_186249_c = nbt;
        }
    }

    public static class BlockInfo {
        public final BlockPos field_186242_a;
        public final BlockState field_186243_b;
        public final CompoundNBT field_186244_c;

        public BlockInfo(BlockPos pos, BlockState state, @Nullable CompoundNBT nbt) {
            this.field_186242_a = pos;
            this.field_186243_b = state;
            this.field_186244_c = nbt;
        }

        public String toString() {
            return String.format("<StructureBlockInfo | %s | %s | %s>", new Object[]{this.field_186242_a, this.field_186243_b, this.field_186244_c});
        }
    }

    static class BasicPalette
    implements Iterable<BlockState> {
        public static final BlockState field_189957_a = Blocks.field_150350_a.func_176223_P();
        private final ObjectIntIdentityMap<BlockState> field_189958_b = new ObjectIntIdentityMap(16);
        private int field_189959_c;

        private BasicPalette() {
        }

        public int func_189954_a(BlockState state) {
            int i = this.field_189958_b.func_148747_b((Object)state);
            if (i == -1) {
                i = this.field_189959_c++;
                this.field_189958_b.func_148746_a((Object)state, i);
            }
            return i;
        }

        @Nullable
        public BlockState func_189955_a(int id) {
            BlockState blockstate = (BlockState)((Object)this.field_189958_b.func_148745_a(id));
            return blockstate == null ? field_189957_a : blockstate;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.field_189958_b.iterator();
        }

        public void func_189956_a(BlockState p_189956_1_, int p_189956_2_) {
            this.field_189958_b.func_148746_a((Object)p_189956_1_, p_189956_2_);
        }
    }
}

